/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.axiom.evalex.functions.trigonometric;

import com.ezylang.axiom.evalex.EvaluationException;
import com.ezylang.axiom.evalex.Expression;
import com.ezylang.axiom.evalex.data.EvaluationValue;
import com.ezylang.axiom.evalex.functions.AbstractFunction;
import com.ezylang.axiom.evalex.functions.FunctionParameter;
import com.ezylang.axiom.evalex.parser.Token;
import java.math.BigDecimal;

@FunctionParameter(name="value")
public class AsinRFunction
extends AbstractFunction {
    private static final BigDecimal MINUS_ONE = BigDecimal.valueOf(-1L);

    @Override
    public EvaluationValue evaluate(Expression expression, Token functionToken, EvaluationValue ... parameterValues) throws EvaluationException {
        BigDecimal parameterValue = parameterValues[0].getNumberValue();
        if (parameterValue.compareTo(BigDecimal.ONE) > 0) {
            throw new EvaluationException(functionToken, "Illegal asinr(x) for x > 1: x = " + parameterValue);
        }
        if (parameterValue.compareTo(MINUS_ONE) < 0) {
            throw new EvaluationException(functionToken, "Illegal asinr(x) for x < -1: x = " + parameterValue);
        }
        return expression.convertDoubleValue(Math.asin(parameterValues[0].getNumberValue().doubleValue()));
    }
}

