/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.axiom.databind.ser.std;

import com.fasterxml.jackson.axiom.core.JsonGenerator;
import com.fasterxml.jackson.axiom.core.JsonToken;
import com.fasterxml.jackson.axiom.core.type.WritableTypeId;
import com.fasterxml.jackson.axiom.databind.JavaType;
import com.fasterxml.jackson.axiom.databind.JsonMappingException;
import com.fasterxml.jackson.axiom.databind.JsonNode;
import com.fasterxml.jackson.axiom.databind.SerializerProvider;
import com.fasterxml.jackson.axiom.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.axiom.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.axiom.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

public class RawSerializer<T>
extends StdSerializer<T> {
    public RawSerializer(Class<?> cls) {
        super(cls, false);
    }

    @Override
    public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeRawValue(value.toString());
    }

    @Override
    public void serializeWithType(T value, JsonGenerator g2, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
        this.serialize(value, g2, provider);
        typeSer.writeTypeSuffix(g2, typeIdDef);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }
}

