/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.annotations;

import com.moulberry.axiom.annotations.AnnotationUpdateAction;
import com.moulberry.axiom.annotations.data.AnnotationData;
import java.util.List;
import java.util.UUID;

public record AnnotationHistoryElement(List<AnnotationUpdateAction> undo, List<AnnotationUpdateAction> redo) {
    public AnnotationHistoryElement(AnnotationUpdateAction undo, AnnotationUpdateAction redo) {
        this(List.of(undo), List.of(redo));
    }

    public AnnotationUpdateAction singleUndo() {
        if (this.undo.size() == 1) {
            return this.undo.get(0);
        }
        return null;
    }

    public AnnotationUpdateAction singleRedo() {
        if (this.redo.size() == 1) {
            return this.redo.get(0);
        }
        return null;
    }

    public static AnnotationHistoryElement makeDeleteAnnotation(UUID uuid, AnnotationData annotation) {
        return new AnnotationHistoryElement(List.of(new AnnotationUpdateAction.CreateAnnotation(uuid, annotation)), List.of(new AnnotationUpdateAction.DeleteAnnotation(uuid)));
    }
}

