/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.blueprint;

import com.moulberry.axiom.AxiomServer;
import com.moulberry.axiom.blueprint.BlueprintIo;
import com.moulberry.axiom.blueprint.RawBlueprint;
import com.moulberry.axiom.blueprint.ServerBlueprintRegistry;
import com.moulberry.axiom.packets.blueprint.AxiomClientboundBlueprintManifest;
import com.moulberry.axiom.restrictions.AxiomPermission;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_3222;

public class ServerBlueprintManager {
    private static ServerBlueprintRegistry registry = null;

    public static void initialize(Path blueprintDirectory) {
        HashMap<String, RawBlueprint> map = new HashMap<String, RawBlueprint>();
        ServerBlueprintManager.loadRegistryFromFolder(map, blueprintDirectory, "/");
        registry = new ServerBlueprintRegistry(map);
    }

    public static void sendManifest(List<class_3222> serverPlayers) {
        if (registry != null) {
            ArrayList<class_3222> sendTo = new ArrayList<class_3222>();
            for (class_3222 serverPlayer : serverPlayers) {
                if (!AxiomServer.canUseAxiom(serverPlayer, AxiomPermission.BLUEPRINT_MANIFEST)) continue;
                sendTo.add(serverPlayer);
            }
            AxiomClientboundBlueprintManifest.sendMulti(sendTo, registry);
        }
    }

    public static ServerBlueprintRegistry getRegistry() {
        return registry;
    }

    private static void loadRegistryFromFolder(Map<String, RawBlueprint> map, Path folder, String location) {
        if (!Files.isDirectory(folder, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(folder);){
            for (Path path : directoryStream) {
                String filename = path.getFileName().toString();
                if (filename.endsWith(".bp")) {
                    try {
                        RawBlueprint rawBlueprint = BlueprintIo.readRawBlueprint(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])));
                        String newLocation = location + filename.substring(0, filename.length() - 3);
                        map.put(newLocation, rawBlueprint);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                String newLocation = location + filename + "/";
                ServerBlueprintManager.loadRegistryFromFolder(map, path, newLocation);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

