/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.brush_shapes;

import com.moulberry.axiom.brush_shapes.BrushShape;
import com.moulberry.axiom.utils.Box;

public interface CubeBrushShape
extends BrushShape {
    public static CubeBrushShape create(int radius) {
        return new SimpleCubeBrushShape(radius);
    }

    public static CubeBrushShape create(int radiusX, int radiusY, int radiusZ) {
        if (radiusX == radiusY && radiusX == radiusZ) {
            return CubeBrushShape.create(radiusX);
        }
        return new SeparateCubeBrushShape(radiusX, radiusY, radiusZ);
    }

    public static final class SimpleCubeBrushShape
    implements CubeBrushShape {
        private final int size;
        private final float invSize;
        private final float invSizeSq;
        private final Box boundingBox;

        public SimpleCubeBrushShape(int size) {
            this.size = size;
            this.invSize = 1.0f / (float)size;
            this.invSizeSq = 1.0f / (float)(size * size);
            this.boundingBox = new Box(-size, -size, -size, size, size, size);
        }

        @Override
        public Box boundingBox() {
            return this.boundingBox;
        }

        @Override
        public boolean isInsideShape(int x, int y, int z) {
            return Math.abs(x) <= this.size && Math.abs(y) <= this.size && Math.abs(z) <= this.size;
        }

        @Override
        public float sdfSq(int x, int y, int z) {
            return (float)Math.max(x * x, Math.max(y * y, z * z)) * this.invSizeSq;
        }

        @Override
        public float sdf(int x, int y, int z) {
            return (float)Math.max(Math.abs(x), Math.max(Math.abs(y), Math.abs(z))) * this.invSize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleCubeBrushShape that = (SimpleCubeBrushShape)o;
            return this.size == that.size;
        }

        public int hashCode() {
            return this.size;
        }
    }

    public static final class SeparateCubeBrushShape
    implements CubeBrushShape {
        private final int radiusX;
        private final int radiusY;
        private final int radiusZ;
        private final float invRadiusX;
        private final float invRadiusY;
        private final float invRadiusZ;
        private final Box boundingBox;

        public SeparateCubeBrushShape(int radiusX, int radiusY, int radiusZ) {
            this.radiusX = radiusX;
            this.radiusY = radiusY;
            this.radiusZ = radiusZ;
            this.boundingBox = new Box(-radiusX, -radiusY, -radiusZ, radiusX, radiusY, radiusZ);
            float invRadiusX = 1.0f / (float)this.radiusX;
            float invRadiusY = 1.0f / (float)this.radiusY;
            float invRadiusZ = 1.0f / (float)this.radiusZ;
            if (!Float.isFinite(invRadiusX)) {
                invRadiusX = Float.MAX_VALUE;
            }
            if (!Float.isFinite(invRadiusY)) {
                invRadiusY = Float.MAX_VALUE;
            }
            if (!Float.isFinite(invRadiusZ)) {
                invRadiusZ = Float.MAX_VALUE;
            }
            this.invRadiusX = invRadiusX;
            this.invRadiusY = invRadiusY;
            this.invRadiusZ = invRadiusZ;
        }

        @Override
        public Box boundingBox() {
            return this.boundingBox;
        }

        @Override
        public boolean isInsideShape(int x, int y, int z) {
            return Math.abs(x) <= this.radiusX && Math.abs(y) <= this.radiusY && Math.abs(z) <= this.radiusZ;
        }

        @Override
        public float sdfSq(int x, int y, int z) {
            return Math.max((float)(x * x) * this.invRadiusX * this.invRadiusX, Math.max((float)(y * y) * this.invRadiusY * this.invRadiusY, (float)(z * z) * this.invRadiusZ * this.invRadiusZ));
        }

        @Override
        public float sdf(int x, int y, int z) {
            return Math.max((float)Math.abs(x) * this.invRadiusX, Math.max((float)Math.abs(y) * this.invRadiusY, (float)Math.abs(z) * this.invRadiusZ));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SeparateCubeBrushShape that = (SeparateCubeBrushShape)o;
            if (this.radiusX != that.radiusX) {
                return false;
            }
            if (this.radiusY != that.radiusY) {
                return false;
            }
            return this.radiusZ == that.radiusZ;
        }

        public int hashCode() {
            int result = this.radiusX;
            result = 31 * result + this.radiusY;
            result = 31 * result + this.radiusZ;
            return result;
        }
    }
}

