/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.buildertools;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.Dummy;
import com.moulberry.axiom.VersionUtilsClient;
import com.moulberry.axiom.buildertools.BuilderToolSelectionState;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.render.EffectRenderer;
import com.moulberry.axiom.render.Shapes;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.restrictions.ClientRestrictions;
import com.moulberry.axiom.utils.Box;
import com.moulberry.axiom.utils.IntMatrix;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiom.utils.RenderHelper;
import com.moulberry.axiom.world_modification.BlockBuffer;
import com.moulberry.axiom.world_modification.HistoryEntry;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Matrix4f;
import org.lwjgl.glfw.GLFW;

public interface BuilderTool {
    public static final class_2960 MOUSE_LEFT = class_2960.method_60654((String)"axiom:mouse/left.png");
    public static final class_2960 MOUSE_RIGHT = class_2960.method_60654((String)"axiom:mouse/right.png");
    public static final class_2960 MOUSE_SCROLL = class_2960.method_60654((String)"axiom:mouse/scroll.png");

    public void renderScreen(class_332 var1, int var2, int var3, float var4);

    public void renderWorld(class_4184 var1, long var2, class_4587 var4, Matrix4f var5);

    public void leftClick(class_239 var1);

    public void rightClick(class_239 var1);

    default public void middleClick(class_239 hitResult) {
    }

    default public boolean setPos1(class_2338 position) {
        return false;
    }

    default public boolean setPos2(class_2338 position) {
        return false;
    }

    public boolean scroll(int var1);

    public boolean shouldRenderBlockOutline(class_2338 var1);

    public String getName();

    default public List<String> getKeyHints() {
        return List.of();
    }

    default public boolean canBeReset() {
        return false;
    }

    public void reset(boolean var1);

    default public void handleInput(boolean nudgeForwards, boolean nudgeBackwards, boolean delete) {
    }

    default public BuilderToolSelectionState.Restore getSelectionRestore() {
        return null;
    }

    default public void applySelectionRestore(BuilderToolSelectionState.Restore restore) {
    }

    public EnumSet<AxiomPermission> requiredPermissions();

    public static boolean shouldEntityByCopied(class_1297 entity) {
        return entity.method_5805() && !entity.method_5765() && !(entity instanceof class_1657);
    }

    public static void renderKeybindHelp(class_332 guiGraphics, int screenWidth, int screenHeight, String text, class_304 mapping, int index) {
        class_310 mc = class_310.method_1551();
        int n = screenHeight / 2;
        Objects.requireNonNull(mc.field_1772);
        int y = n + (9 + 4) * (1 + index);
        int value = mapping.field_1655.method_1444();
        if (mapping.field_1655.method_1442() == class_3675.class_307.field_1672 && (value == 0 || value == 1 || value == 2)) {
            class_2960 mouse = value == 0 ? MOUSE_LEFT : (value == 1 ? MOUSE_RIGHT : MOUSE_SCROLL);
            int width = mc.field_1772.method_1727((String)text);
            guiGraphics.method_25303(mc.field_1772, (String)text, screenWidth / 2 - width / 2, y, -2130706433);
            RenderHelper.tryFlush(guiGraphics);
            guiGraphics.method_25291(VersionUtilsClient.pipelineToLegacyFunction(Dummy.GUI_TEXTURED), mouse, screenWidth / 2 - width / 2 - 16, y - 4, 0.0f, 0.0f, 16, 16, 16, 16, -2130706433);
            RenderHelper.tryFlush(guiGraphics);
            return;
        }
        String key = mapping.field_1655.method_27445().getString();
        text = "[" + key + "] " + (String)text;
        int width = mc.field_1772.method_1727((String)text);
        guiGraphics.method_25303(mc.field_1772, (String)text, screenWidth / 2 - width / 2, y, -2130706433);
        RenderHelper.tryFlush(guiGraphics);
    }

    public static boolean applyLimitBounds(class_2338.class_2339 one, class_2338.class_2339 two) {
        Box globalBounds = ClientRestrictions.restrictions.globalBounds;
        if (globalBounds != null) {
            if (Math.max(one.method_10263(), two.method_10263()) < globalBounds.pos1().method_10263()) {
                return false;
            }
            if (Math.max(one.method_10264(), two.method_10264()) < globalBounds.pos1().method_10264()) {
                return false;
            }
            if (Math.max(one.method_10260(), two.method_10260()) < globalBounds.pos1().method_10260()) {
                return false;
            }
            if (Math.min(one.method_10263(), two.method_10263()) > globalBounds.pos2().method_10263()) {
                return false;
            }
            if (Math.min(one.method_10264(), two.method_10264()) > globalBounds.pos2().method_10264()) {
                return false;
            }
            if (Math.min(one.method_10260(), two.method_10260()) > globalBounds.pos2().method_10260()) {
                return false;
            }
            one.method_33097(Math.min(Math.max(one.method_10263(), globalBounds.pos1().method_10263()), globalBounds.pos2().method_10263()));
            one.method_33098(Math.min(Math.max(one.method_10264(), globalBounds.pos1().method_10264()), globalBounds.pos2().method_10264()));
            one.method_33099(Math.min(Math.max(one.method_10260(), globalBounds.pos1().method_10260()), globalBounds.pos2().method_10260()));
            two.method_33097(Math.min(Math.max(two.method_10263(), globalBounds.pos1().method_10263()), globalBounds.pos2().method_10263()));
            two.method_33098(Math.min(Math.max(two.method_10264(), globalBounds.pos1().method_10264()), globalBounds.pos2().method_10264()));
            two.method_33099(Math.min(Math.max(two.method_10260(), globalBounds.pos1().method_10260()), globalBounds.pos2().method_10260()));
        }
        return true;
    }

    public static void setOffsetFromBlock(class_3965 hitResult, class_2338.class_2339 offset, class_2338 pos1, class_2338 pos2) {
        class_2350.class_2351 axis = hitResult.method_17780().method_10166();
        int pos1Axis = pos1.method_30558(axis);
        int pos2Axis = pos2.method_30558(axis);
        int max2 = Math.max(pos1Axis, pos2Axis);
        int min2 = Math.min(pos1Axis, pos2Axis);
        int count = (max2 - min2 + 1) / 2 + 1;
        if (Math.abs(max2 - min2) % 2 == 1) {
            class_2350.class_2352 biasDirection;
            class_2350.class_2352 class_23522 = biasDirection = Math.abs(max2) > Math.abs(min2) ? class_2350.class_2352.field_11056 : class_2350.class_2352.field_11060;
            if (biasDirection == hitResult.method_17780().method_10171()) {
                --count;
            }
        }
        offset.method_10101((class_2382)hitResult.method_17777().method_10079(hitResult.method_17780(), count));
    }

    public static void delete(class_2338 one, class_2338 two) {
        int minX = Math.min(one.method_10263(), two.method_10263());
        int minY = Math.min(one.method_10264(), two.method_10264());
        int minZ = Math.min(one.method_10260(), two.method_10260());
        int maxX = Math.max(one.method_10263(), two.method_10263());
        int maxY = Math.max(one.method_10264(), two.method_10264());
        int maxZ = Math.max(one.method_10260(), two.method_10260());
        class_638 level = class_310.method_1551().field_1687;
        BlockBuffer setOperation = new BlockBuffer();
        BlockBuffer previousBlocksForUndo = new BlockBuffer();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        int changeCount = 0;
        class_2680 air = class_2246.field_10124.method_9564();
        Long2ObjectOpenHashMap nbtMap = new Long2ObjectOpenHashMap();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 oldState = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                    if (oldState.method_26215()) continue;
                    setOperation.set(x, y, z, air);
                    previousBlocksForUndo.set(x, y, z, oldState);
                    if (oldState.method_31709()) {
                        long pos = class_2338.method_10064((int)x, (int)y, (int)z);
                        ((List)nbtMap.computeIfAbsent(pos, k -> new ArrayList())).add(new RegionHelper.NbtTarget(false, x, y, z));
                    }
                    ++changeCount;
                }
            }
        }
        class_2338 center = new class_2338((minX + maxX) / 2, (minY + maxY) / 2, (minZ + maxZ) / 2);
        String countString = NumberFormat.getInstance().format(changeCount);
        String historyDescription = AxiomI18n.get("axiom.history_description.deleted", countString);
        RegionHelper.pushBlockBufferChangeWithNBT((class_1937)level, setOperation, previousBlocksForUndo, center, historyDescription, HistoryEntry.MODIFIER_CAN_BE_UNDONE_INGAME, (Long2ObjectMap<List<RegionHelper.NbtTarget>>)nbtMap, true);
    }

    public static void renderScrollHelp(class_332 guiGraphics, int screenWidth, int screenHeight, String text, int index) {
        class_310 mc = class_310.method_1551();
        int n = screenHeight / 2;
        Objects.requireNonNull(mc.field_1772);
        int y = n + (9 + 4) * (1 + index);
        int width = mc.field_1772.method_1727(text);
        guiGraphics.method_25303(mc.field_1772, text, screenWidth / 2 - width / 2, y, -2130706433);
        RenderHelper.tryFlush(guiGraphics);
        guiGraphics.method_25291(VersionUtilsClient.pipelineToLegacyFunction(Dummy.GUI_TEXTURED), MOUSE_SCROLL, screenWidth / 2 - width / 2 - 16, y - 4, 0.0f, 0.0f, 16, 16, 16, 16, -2130706433);
        RenderHelper.tryFlush(guiGraphics);
    }

    public static class_2350 calculateDirection() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return class_2350.field_11036;
        }
        class_2350[] directions = class_2350.method_10159((class_1297)player);
        if (Axiom.configuration.builderTools.directionLock) {
            if (GLFW.glfwGetKey((long)class_310.method_1551().method_22683().method_4490(), (int)88) != 0) {
                for (class_2350 direction : directions) {
                    if (direction.method_10166() != class_2350.class_2351.field_11048) continue;
                    return direction;
                }
            }
            if (GLFW.glfwGetKey((long)class_310.method_1551().method_22683().method_4490(), (int)89) != 0) {
                for (class_2350 direction : directions) {
                    if (direction.method_10166() != class_2350.class_2351.field_11052) continue;
                    return direction;
                }
            }
            if (GLFW.glfwGetKey((long)class_310.method_1551().method_22683().method_4490(), (int)90) != 0) {
                for (class_2350 direction : directions) {
                    if (direction.method_10166() != class_2350.class_2351.field_11051) continue;
                    return direction;
                }
            }
        }
        return directions[0];
    }

    public static ChunkedBlockRegion handleMoveableBlockBuffer(class_4184 camera, long time, class_4587 matrices, Matrix4f projection, ChunkedBlockRegion blockRegion, class_2338 regionOffset, IntMatrix matrix, boolean rotatePressed, boolean flipPressed) {
        class_2350 direction = BuilderTool.calculateDirection();
        if (rotatePressed) {
            blockRegion = blockRegion.rotate(class_2350.class_2351.field_11052, -1);
            matrix.rotateY(-1);
        }
        if (flipPressed) {
            blockRegion = blockRegion.flip(direction.method_10166());
            matrix.flip(direction.method_10166());
        }
        class_2338 min2 = blockRegion.min();
        class_2338 max2 = blockRegion.max();
        int minX = Math.min(min2.method_10263(), max2.method_10263());
        int minY = Math.min(min2.method_10264(), max2.method_10264());
        int minZ = Math.min(min2.method_10260(), max2.method_10260());
        int maxX = Math.max(min2.method_10263(), max2.method_10263());
        int maxY = Math.max(min2.method_10264(), max2.method_10264());
        int maxZ = Math.max(min2.method_10260(), max2.method_10260());
        class_243 blockOffset = class_243.method_24954((class_2382)regionOffset);
        float partialX = (float)((maxX - minX) % 2) / 2.0f;
        float partialY = (float)((maxY - minY) % 2) / 2.0f;
        float partialZ = (float)((maxZ - minZ) % 2) / 2.0f;
        int shiftX = (int)(-Math.floor(matrix.transformDoubleX(partialX, partialY, partialZ)));
        int shiftY = (int)(-Math.floor(matrix.transformDoubleY(partialX, partialY, partialZ)));
        int shiftZ = (int)(-Math.floor(matrix.transformDoubleZ(partialX, partialY, partialZ)));
        blockOffset = blockOffset.method_1031((double)shiftX, (double)shiftY, (double)shiftZ);
        minX += shiftX;
        maxX += shiftX;
        minY += shiftY;
        maxY += shiftY;
        minZ += shiftZ;
        maxZ += shiftZ;
        blockRegion.render(camera, blockOffset, matrices, projection, 0.75f, 0.0f);
        BuilderTool.renderBoxWithArrow(direction, camera, time, matrices, projection, minX += regionOffset.method_10263(), minY += regionOffset.method_10264(), minZ += regionOffset.method_10260(), maxX += regionOffset.method_10263(), maxY += regionOffset.method_10264(), maxZ += regionOffset.method_10260());
        return blockRegion;
    }

    public static void extend(class_2338 to, class_2338.class_2339 pos1, class_2338.class_2339 pos2) {
        if (pos1.method_10263() < pos2.method_10263()) {
            if (to.method_10263() < pos1.method_10263()) {
                pos1.method_33097(to.method_10263());
            }
            if (to.method_10263() > pos2.method_10263()) {
                pos2.method_33097(to.method_10263());
            }
        } else {
            if (to.method_10263() < pos2.method_10263()) {
                pos2.method_33097(to.method_10263());
            }
            if (to.method_10263() > pos1.method_10263()) {
                pos1.method_33097(to.method_10263());
            }
        }
        if (pos1.method_10264() < pos2.method_10264()) {
            if (to.method_10264() < pos1.method_10264()) {
                pos1.method_33098(to.method_10264());
            }
            if (to.method_10264() > pos2.method_10264()) {
                pos2.method_33098(to.method_10264());
            }
        } else {
            if (to.method_10264() < pos2.method_10264()) {
                pos2.method_33098(to.method_10264());
            }
            if (to.method_10264() > pos1.method_10264()) {
                pos1.method_33098(to.method_10264());
            }
        }
        if (pos1.method_10260() < pos2.method_10260()) {
            if (to.method_10260() < pos1.method_10260()) {
                pos1.method_33099(to.method_10260());
            }
            if (to.method_10260() > pos2.method_10260()) {
                pos2.method_33099(to.method_10260());
            }
        } else {
            if (to.method_10260() < pos2.method_10260()) {
                pos2.method_33099(to.method_10260());
            }
            if (to.method_10260() > pos1.method_10260()) {
                pos1.method_33099(to.method_10260());
            }
        }
    }

    public static void renderBoxWithArrow(class_2350 dir, class_4184 camera, long time, class_4587 matrices, Matrix4f projection, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        EffectRenderer.renderBoundingBox(camera, time, matrices, new class_243((double)minX - 0.01, (double)minY - 0.01, (double)minZ - 0.01), new class_243((double)maxX + 1.01, (double)maxY + 1.01, (double)maxZ + 1.01), 3);
        if (dir == null) {
            return;
        }
        float mX = 0.0f;
        float mY = 0.0f;
        float mZ = 0.0f;
        switch (dir) {
            case field_11033: {
                mY = -1.0f;
                break;
            }
            case field_11036: {
                mY = 1.0f;
                break;
            }
            case field_11043: {
                mZ = -1.0f;
                break;
            }
            case field_11035: {
                mZ = 1.0f;
                break;
            }
            case field_11039: {
                mX = -1.0f;
                break;
            }
            case field_11034: {
                mX = 1.0f;
            }
        }
        int colour = switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033, class_2350.field_11036 -> 48896;
            case class_2350.field_11043, class_2350.field_11035 -> 191;
            case class_2350.field_11039, class_2350.field_11034 -> 0xBF0000;
        };
        double arrowX = (double)(minX + maxX + 1) / 2.0 + (double)(maxX + 1 - minX) / 2.0 * (double)mX;
        double arrowY = (double)(minY + maxY + 1) / 2.0 + (double)(maxY + 1 - minY) / 2.0 * (double)mY;
        double arrowZ = (double)(minZ + maxZ + 1) / 2.0 + (double)(maxZ + 1 - minZ) / 2.0 * (double)mZ;
        matrices.method_22903();
        matrices.method_22904(arrowX - camera.method_19326().field_1352, arrowY - camera.method_19326().field_1351, arrowZ - camera.method_19326().field_1350);
        float distanceMultiplier = (float)Math.sqrt(player.method_5707(new class_243(arrowX, arrowY, arrowZ))) / 20.0f;
        if (distanceMultiplier < 0.5f) {
            distanceMultiplier = 0.5f;
        }
        float axisLen = 4.0f * distanceMultiplier;
        float coneLen = axisLen / 5.0f;
        float coneRadius = coneLen / 3.0f;
        VertexConsumerProvider provider = VertexConsumerProvider.shared();
        class_4587.class_4665 pose = matrices.method_23760();
        Matrix4f matrix4f = pose.method_23761();
        Shapes.drawCone(provider, matrix4f, new class_243((double)(mX * axisLen), (double)(mY * axisLen), (double)(mZ * axisLen)), new class_243((double)(mX * (axisLen + coneLen)), (double)(mY * (axisLen + coneLen)), (double)(mZ * (axisLen + coneLen))), mX != 0.0f ? 0 : (mY != 0.0f ? 1 : 2), coneRadius, 0x40000000 | colour, AxiomRenderPipelines.POSITION_COLOR_IGNORE_DEPTH);
        class_287 bufferBuilder = provider.begin(class_293.class_5596.field_27377, class_290.field_29337);
        VersionUtilsClient.legacySetLineWidthIgnored(bufferBuilder.method_22918(matrix4f, 0.0f, 0.0f, 0.0f).method_39415(0x40000000 | colour).method_60831(pose, mX, mY, mZ), RenderHelper.baseLineWidth);
        VersionUtilsClient.legacySetLineWidthIgnored(bufferBuilder.method_22918(matrix4f, mX * axisLen, mY * axisLen, mZ * axisLen).method_39415(0x40000000 | colour).method_60831(pose, mX, mY, mZ), RenderHelper.baseLineWidth);
        AxiomRenderPipelines.LINES_IGNORE_DEPTH.render(provider.build());
        Shapes.drawCone(provider, matrix4f, new class_243((double)(mX * axisLen), (double)(mY * axisLen), (double)(mZ * axisLen)), new class_243((double)(mX * (axisLen + coneLen)), (double)(mY * (axisLen + coneLen)), (double)(mZ * (axisLen + coneLen))), mX != 0.0f ? 0 : (mY != 0.0f ? 1 : 2), coneRadius, 0xAA000000 | colour, AxiomRenderPipelines.POSITION_COLOR_WITHOUT_WRITE_DEPTH);
        bufferBuilder = provider.begin(class_293.class_5596.field_27377, class_290.field_29337);
        VersionUtilsClient.legacySetLineWidthIgnored(bufferBuilder.method_22918(matrix4f, 0.0f, 0.0f, 0.0f).method_39415(0xAA000000 | colour).method_60831(pose, mX, mY, mZ), RenderHelper.baseLineWidth);
        VersionUtilsClient.legacySetLineWidthIgnored(bufferBuilder.method_22918(matrix4f, mX * axisLen, mY * axisLen, mZ * axisLen).method_39415(0xAA000000 | colour).method_60831(pose, mX, mY, mZ), RenderHelper.baseLineWidth);
        AxiomRenderPipelines.LINES_WITHOUT_WRITE_DEPTH.render(provider.build());
        matrices.method_22909();
    }
}

