/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.clipboard;

import com.moulberry.axiom.blueprint.Blueprint;
import com.moulberry.axiom.core_rendering.AxiomGpuTexture;
import com.moulberry.axiom.editor.BlueprintPreview;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.utils.AutoCleaningDynamicTexture;
import com.moulberry.axiom.utils.DynamicTextureSupplier;
import com.moulberry.axiom.utils.EntityDataUtils;
import com.moulberry.axiom.utils.IntMatrix;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;

public interface ClipboardObject {
    public ChunkedBlockRegion blockRegion();

    public Long2ObjectMap<CompressedBlockEntity> blockEntities();

    public List<class_2487> entities();

    public String name();

    public float preferredYaw();

    public boolean containsAir();

    public String placementDescription();

    public int thumbnailTextureId();

    public static ClipboardObject rotate(ClipboardObject clipboardObject, class_2350.class_2351 axis, int amount) {
        if (clipboardObject == null) {
            return null;
        }
        ChunkedBlockRegion chunkedBlockRegion = clipboardObject.blockRegion().rotate(axis, amount);
        IntMatrix matrix = new IntMatrix();
        matrix.rotate(axis, amount);
        Long2ObjectMap<CompressedBlockEntity> blockEntities = ClipboardObject.applyMatrixToBlockEntities(matrix, clipboardObject.blockEntities());
        List<class_2487> entities = ClipboardObject.applyMatrixToEntities(matrix, clipboardObject.entities());
        return new Anonymous(chunkedBlockRegion, blockEntities, entities, clipboardObject.name(), clipboardObject.preferredYaw(), clipboardObject.containsAir());
    }

    public static ClipboardObject flip(ClipboardObject clipboardObject, class_2350.class_2351 axis) {
        if (clipboardObject == null) {
            return null;
        }
        ChunkedBlockRegion chunkedBlockRegion = clipboardObject.blockRegion().flip(axis);
        IntMatrix matrix = new IntMatrix();
        matrix.flip(axis);
        Long2ObjectMap<CompressedBlockEntity> blockEntities = ClipboardObject.applyMatrixToBlockEntities(matrix, clipboardObject.blockEntities());
        List<class_2487> entities = ClipboardObject.applyMatrixToEntities(matrix, clipboardObject.entities());
        return new Anonymous(chunkedBlockRegion, blockEntities, entities, clipboardObject.name(), clipboardObject.preferredYaw(), clipboardObject.containsAir());
    }

    private static Long2ObjectMap<CompressedBlockEntity> applyMatrixToBlockEntities(IntMatrix matrix, Long2ObjectMap<CompressedBlockEntity> blockEntities) {
        Long2ObjectOpenHashMap rotatedBlockEntites = new Long2ObjectOpenHashMap();
        if (blockEntities == null || blockEntities.isEmpty()) {
            return rotatedBlockEntites;
        }
        for (Long2ObjectMap.Entry entry : blockEntities.long2ObjectEntrySet()) {
            long pos = entry.getLongKey();
            int x = class_2338.method_10061((long)pos);
            int y = class_2338.method_10071((long)pos);
            int z = class_2338.method_10083((long)pos);
            int nx = matrix.transformX(x, y, z);
            int ny = matrix.transformY(x, y, z);
            int nz = matrix.transformZ(x, y, z);
            long newPos = class_2338.method_10064((int)nx, (int)ny, (int)nz);
            rotatedBlockEntites.put(newPos, (Object)((CompressedBlockEntity)entry.getValue()));
        }
        return rotatedBlockEntites;
    }

    private static List<class_2487> applyMatrixToEntities(IntMatrix matrix, List<class_2487> entities) {
        ArrayList<class_2487> rotatedEntities = new ArrayList<class_2487>();
        if (entities == null || entities.isEmpty()) {
            return rotatedEntities;
        }
        for (class_2487 entity : entities) {
            class_2487 copied = entity.method_10553();
            EntityDataUtils.applyMatrixToEntity(copied, matrix);
            rotatedEntities.add(copied);
        }
        return rotatedEntities;
    }

    public static class Anonymous
    implements ClipboardObject {
        private final ChunkedBlockRegion blockRegion;
        private final Long2ObjectMap<CompressedBlockEntity> blockEntities;
        private final List<class_2487> entities;
        private final String name;
        private final float preferredYaw;
        private final boolean containsAir;
        private CompletableFuture<class_1011> future = null;
        public AutoCleaningDynamicTexture texture = null;
        @Nullable
        private final class_2487 additionalSchematicData;

        public Anonymous(ChunkedBlockRegion blockRegion, Long2ObjectMap<CompressedBlockEntity> blockEntities, List<class_2487> entities, String name, float preferredYaw, boolean containsAir) {
            this(blockRegion, blockEntities, entities, name, preferredYaw, containsAir, null);
        }

        public Anonymous(ChunkedBlockRegion blockRegion, Long2ObjectMap<CompressedBlockEntity> blockEntities, List<class_2487> entities, String name, float preferredYaw, boolean containsAir, @Nullable class_2487 additionalSchematicData) {
            this.blockRegion = blockRegion;
            this.blockEntities = blockEntities;
            this.entities = entities;
            this.name = name;
            this.preferredYaw = preferredYaw;
            this.additionalSchematicData = additionalSchematicData;
            this.containsAir = containsAir;
        }

        @Override
        public ChunkedBlockRegion blockRegion() {
            return this.blockRegion;
        }

        @Override
        public Long2ObjectMap<CompressedBlockEntity> blockEntities() {
            return this.blockEntities;
        }

        @Override
        public List<class_2487> entities() {
            return this.entities;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public float preferredYaw() {
            return this.preferredYaw;
        }

        @Override
        public boolean containsAir() {
            return this.containsAir;
        }

        @Nullable
        public class_2487 additionalSchematicData() {
            return this.additionalSchematicData;
        }

        @Override
        public String placementDescription() {
            String formattedCount = NumberFormat.getInstance().format(this.blockRegion.count());
            return AxiomI18n.get("axiom.history_description.placed", formattedCount);
        }

        @Override
        public int thumbnailTextureId() {
            if (this.blockRegion.count() >= 0x1000000) {
                return -1;
            }
            if (this.texture == null && this.future == null) {
                BlueprintPreview blueprintPreview = new BlueprintPreview();
                blueprintPreview.setBlockRegion(this.blockRegion);
                blueprintPreview.setYaw(this.preferredYaw, true);
                blueprintPreview.render(960, false, false);
                this.future = blueprintPreview.toNativeImage(96, true);
            }
            if (this.future != null) {
                if (this.future.isDone()) {
                    class_1011 nativeImage = this.future.join();
                    this.future = null;
                    this.texture = new AutoCleaningDynamicTexture(nativeImage);
                    return new AxiomGpuTexture(this.texture.method_4624()).glId();
                }
                return -1;
            }
            return new AxiomGpuTexture(this.texture.method_4624()).glId();
        }
    }

    public record FromBlueprint(Blueprint blueprint) implements ClipboardObject
    {
        @Override
        public ChunkedBlockRegion blockRegion() {
            return this.blueprint.blockRegion();
        }

        @Override
        public Long2ObjectMap<CompressedBlockEntity> blockEntities() {
            return this.blueprint.blockEntities();
        }

        @Override
        public List<class_2487> entities() {
            return this.blueprint.entities();
        }

        @Override
        public String name() {
            return this.blueprint.header().name();
        }

        @Override
        public float preferredYaw() {
            return this.blueprint.header().thumbnailYaw();
        }

        @Override
        public boolean containsAir() {
            return this.blueprint.header().containsAir();
        }

        @Override
        public String placementDescription() {
            return AxiomI18n.get("axiom.history_description.placed_blueprint", this.name());
        }

        @Override
        public int thumbnailTextureId() {
            DynamicTextureSupplier supplier = this.blueprint.thumbnail();
            if (supplier == null) {
                return 0;
            }
            class_1043 texture = supplier.get();
            if (texture == null) {
                return 0;
            }
            return new AxiomGpuTexture(texture.method_4624()).glId();
        }
    }
}

