/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.clipboard;

import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.utils.BooleanWrapper;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import net.minecraft.class_2338;

public class SelectionSerialization {
    public static void writeSelection(BufferedWriter writer, SelectionBuffer buffer) throws IOException {
        StringBuilder line = new StringBuilder();
        if (buffer instanceof SelectionBuffer.AABB) {
            SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)buffer;
            class_2338 min2 = aabb.min();
            class_2338 max2 = aabb.max();
            if (min2 == null || max2 == null) {
                return;
            }
            line.append(min2.method_10263()).append(',').append(min2.method_10264()).append(',').append(min2.method_10260()).append(',').append(max2.method_10263()).append(',').append(max2.method_10264()).append(',').append(max2.method_10260());
            writer.write(line.toString());
        } else if (buffer instanceof SelectionBuffer.Set) {
            SelectionBuffer.Set set = (SelectionBuffer.Set)buffer;
            Long2ObjectMap<short[]> map = set.selectionRegion.unsafeGetPositionSet().unsafeGetRawMap();
            for (Long2ObjectMap.Entry entry : map.long2ObjectEntrySet()) {
                int cx = class_2338.method_10061((long)entry.getLongKey());
                int cy = class_2338.method_10071((long)entry.getLongKey());
                int cz = class_2338.method_10083((long)entry.getLongKey());
                boolean fullSection = true;
                for (short value : (short[])entry.getValue()) {
                    if (value == -1) continue;
                    fullSection = false;
                    break;
                }
                int minX = cx << 4;
                int minY = cy << 4;
                int minZ = cz << 4;
                if (fullSection) {
                    line.setLength(0);
                    line.append(minX).append(',').append(minY).append(',').append(minZ).append(',').append(minX + 15).append(',').append(minY + 15).append(',').append(minZ + 15);
                    writer.write(line.append('\n').toString());
                    continue;
                }
                int index = 0;
                for (int z = 0; z < 16; ++z) {
                    int minRowY = -1;
                    int rowMin = 0;
                    int rowMax = 0;
                    for (int y = 0; y < 16; ++y) {
                        short v = ((short[])entry.getValue())[index++];
                        int low = Integer.numberOfTrailingZeros(v & 0xFFFF);
                        int high = 31 - Integer.numberOfLeadingZeros(v & 0xFFFF);
                        if (Integer.bitCount(v & 0xFFFF) == high - low + 1) {
                            if (minRowY == -1) {
                                minRowY = y;
                                rowMin = low;
                                rowMax = high;
                                continue;
                            }
                            if (rowMin == low && rowMax == high) continue;
                            line.setLength(0);
                            line.append(minX + rowMin).append(',').append(minY + minRowY).append(',').append(minZ + z).append(',').append(minX + rowMax).append(',').append(minY + y - 1).append(',').append(minZ + z);
                            writer.write(line.append('\n').toString());
                            minRowY = y;
                            rowMin = low;
                            rowMax = high;
                            continue;
                        }
                        if (minRowY != -1) {
                            line.setLength(0);
                            line.append(minX + rowMin).append(',').append(minY + minRowY).append(',').append(minZ + z).append(',').append(minX + rowMax).append(',').append(minY + y - 1).append(',').append(minZ + z);
                            writer.write(line.append('\n').toString());
                            minRowY = -1;
                        }
                        if (v == 0) continue;
                        for (int x = 0; x < 16; ++x) {
                            if ((v & 1 << x) == 0) continue;
                            line.setLength(0);
                            line.append(minX + x).append(',').append(minY + y).append(',').append(minZ + z);
                            writer.write(line.append('\n').toString());
                        }
                    }
                    if (minRowY == -1) continue;
                    line.setLength(0);
                    line.append(minX + rowMin).append(',').append(minY + minRowY).append(',').append(minZ + z).append(',').append(minX + rowMax).append(',').append(minY + 15).append(',').append(minZ + z);
                    writer.write(line.append('\n').toString());
                }
            }
        }
    }

    public static SelectionBuffer loadSelection(BufferedReader reader, BooleanWrapper malformed) throws IOException {
        int initialZ1;
        int initialZ2;
        int initialY1;
        int initialY2;
        int initialX1;
        int initialX2;
        String line;
        while (true) {
            if ((line = reader.readLine()) == null) {
                return SelectionBuffer.EMPTY;
            }
            if (line.isEmpty()) continue;
            String[] split = line.split(",");
            if (split.length == 3) {
                initialX1 = initialX2 = Integer.parseInt(split[0]);
                initialY1 = initialY2 = Integer.parseInt(split[1]);
                initialZ1 = initialZ2 = Integer.parseInt(split[2]);
                break;
            }
            if (split.length == 6) {
                initialX1 = Integer.parseInt(split[0]);
                initialY1 = Integer.parseInt(split[1]);
                initialZ1 = Integer.parseInt(split[2]);
                initialX2 = Integer.parseInt(split[3]);
                initialY2 = Integer.parseInt(split[4]);
                initialZ2 = Integer.parseInt(split[5]);
                break;
            }
            malformed.value = true;
        }
        PositionSet set = null;
        block1: while (true) {
            String[] split;
            if ((line = reader.readLine()) == null) {
                if (set == null) {
                    return new SelectionBuffer.AABB(new class_2338(initialX1, initialY1, initialZ1), new class_2338(initialX2, initialY2, initialZ2));
                }
                return new SelectionBuffer.Set(new ChunkedBooleanRegion(set));
            }
            if (line.isEmpty()) continue;
            if (set == null) {
                set = new PositionSet();
                for (int x = initialX1; x <= initialX2; ++x) {
                    for (int y = initialY1; y <= initialY2; ++y) {
                        for (int z = initialZ1; z <= initialZ2; ++z) {
                            set.add(x, y, z);
                        }
                    }
                }
            }
            if ((split = line.split(",")).length == 3) {
                set.add(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
                continue;
            }
            if (split.length == 6) {
                int fromX = Integer.parseInt(split[0]);
                int fromY = Integer.parseInt(split[1]);
                int fromZ = Integer.parseInt(split[2]);
                int toX = Integer.parseInt(split[3]);
                int toY = Integer.parseInt(split[4]);
                int toZ = Integer.parseInt(split[5]);
                int x = fromX;
                while (true) {
                    if (x > toX) continue block1;
                    for (int y = fromY; y <= toY; ++y) {
                        for (int z = fromZ; z <= toZ; ++z) {
                            set.add(x, y, z);
                        }
                    }
                    ++x;
                }
            }
            malformed.value = true;
        }
    }
}

