/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.collections;

import com.moulberry.axiom.exceptions.FaultyImplementationError;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class FlowCache<T, U> {
    private final int minCapacity;
    private final int minAge;
    private final int inflowPerTick;
    private final int outflowPerTick;
    private final boolean cleanAutoCloseables;
    private final Function<T, U> function;
    private final Map<T, Slot> map = new HashMap<T, Slot>();
    private final Set<T> pending = new HashSet<T>();
    private Slot head;
    private Slot tail;
    private long currentTick = 0L;

    public FlowCache(int minCapacity, int minAge, int inflowPerTick, int outflowPerTick, boolean cleanAutoCloseables, Function<T, U> function) {
        this.minCapacity = minCapacity;
        this.minAge = minAge;
        this.inflowPerTick = inflowPerTick;
        this.outflowPerTick = outflowPerTick;
        this.cleanAutoCloseables = cleanAutoCloseables;
        this.function = function;
    }

    public void clear() {
        this.map.clear();
        this.pending.clear();
        this.head = null;
        this.tail = null;
        this.currentTick = 0L;
    }

    public U remove(T t2) {
        this.pending.remove(t2);
        Slot slot = this.map.remove(t2);
        if (slot != null) {
            slot.unlink();
            return slot.value;
        }
        return null;
    }

    public U get(T t2) {
        Slot slot = this.map.get(t2);
        if (slot == null) {
            if (this.pending.size() >= this.inflowPerTick) {
                return null;
            }
            this.pending.add(t2);
            return null;
        }
        slot.lastRequestedTick = this.currentTick;
        if (slot != this.head) {
            slot.unlink();
            slot.next = this.head;
            this.head.previous = slot;
            this.head = slot;
        }
        return slot.value;
    }

    public void tick() {
        ++this.currentTick;
        this.pending.forEach(key -> {
            U value = this.function.apply(key);
            Slot slot = new Slot(key, value, this.currentTick);
            if (this.head == null) {
                this.head = slot;
                this.tail = slot;
            } else {
                this.head.previous = slot;
                slot.next = this.head;
                this.head = slot;
            }
            this.map.put(key, slot);
        });
        this.pending.clear();
        for (int outflow = 0; outflow < this.outflowPerTick && this.map.size() > this.minCapacity; ++outflow) {
            Slot toRemove = this.tail;
            long age = this.currentTick - toRemove.lastRequestedTick;
            if (age >= -10L && age <= (long)this.minAge) break;
            toRemove.unlink();
            Slot removedSlot = this.map.remove(toRemove.key);
            if (removedSlot == toRemove) continue;
            throw new FaultyImplementationError();
        }
    }

    private class Slot {
        private Slot previous;
        private Slot next;
        private final T key;
        private final U value;
        private long lastRequestedTick;

        public Slot(T key, U value, long lastRequestedTick) {
            this.key = key;
            this.value = value;
            this.lastRequestedTick = lastRequestedTick;
        }

        private void unlink() {
            if (this == FlowCache.this.head && this == FlowCache.this.tail) {
                FlowCache.this.head = null;
                FlowCache.this.tail = null;
            } else if (this == FlowCache.this.head) {
                this.next.previous = null;
                FlowCache.this.head = this.next;
            } else if (this == FlowCache.this.tail) {
                this.previous.next = null;
                FlowCache.this.tail = this.previous;
            } else {
                this.next.previous = this.previous;
                this.previous.next = this.next;
            }
            this.previous = null;
            this.next = null;
        }
    }
}

