/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.collections;

import com.moulberry.axiom.funcinterfaces.IntIntFloatConsumer;
import com.moulberry.axiom.utils.PositionUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.function.LongFunction;
import net.minecraft.class_1923;

public class Position2dToFloatMap {
    private final float defaultValue;
    private final LongFunction<float[]> defaultFunction;
    private final Long2ObjectMap<float[]> map;
    private long lastChunkPos = PositionUtils.MIN_POSITION_LONG;
    private float[] lastChunk = null;

    public Position2dToFloatMap() {
        this(0.0f);
    }

    public Position2dToFloatMap(float defaultValue) {
        this(defaultValue, (Long2ObjectMap<float[]>)new Long2ObjectOpenHashMap());
    }

    public Position2dToFloatMap(float defaultValue, Long2ObjectMap<float[]> map) {
        this.defaultValue = defaultValue;
        this.map = map;
        this.defaultFunction = defaultValue == 0.0f ? k -> new float[256] : k -> {
            float[] array = new float[256];
            Arrays.fill(array, defaultValue);
            return array;
        };
    }

    public void clear() {
        this.map.clear();
        this.lastChunkPos = PositionUtils.MIN_POSITION_LONG;
        this.lastChunk = null;
    }

    public Position2dToFloatMap copy() {
        Position2dToFloatMap copy = new Position2dToFloatMap(this.defaultValue);
        for (Long2ObjectMap.Entry entry : this.map.long2ObjectEntrySet()) {
            float[] array = (float[])entry.getValue();
            copy.map.put(entry.getLongKey(), (Object)Arrays.copyOf(array, array.length));
        }
        return copy;
    }

    @Deprecated
    public Long2ObjectMap<float[]> unsafeGetMap() {
        return this.map;
    }

    public float get(int x, int z) {
        int xC = x >> 4;
        int zC = z >> 4;
        float[] array = this.getChunk(xC, zC);
        if (array == null) {
            return this.defaultValue;
        }
        return array[(x & 0xF) + (z & 0xF) * 16];
    }

    public void put(int x, int z, float v) {
        int xC = x >> 4;
        int zC = z >> 4;
        float[] array = this.getOrCreateChunk(xC, zC);
        array[(x & 0xF) + (z & 0xF) * 16] = v;
    }

    public float add(int x, int z, float v) {
        if (v == 0.0f) {
            return this.get(x, z);
        }
        int xC = x >> 4;
        int zC = z >> 4;
        float[] array = this.getOrCreateChunk(xC, zC);
        int n = (x & 0xF) + (z & 0xF) * 16;
        float f = array[n] + v;
        array[n] = f;
        return f;
    }

    public boolean min(int x, int z, float v) {
        int index;
        int xC = x >> 4;
        int zC = z >> 4;
        float[] array = this.getOrCreateChunk(xC, zC);
        if (v < array[index = (x & 0xF) + (z & 0xF) * 16]) {
            array[index] = v;
            return true;
        }
        return false;
    }

    public boolean max(int x, int z, float v) {
        int index;
        int xC = x >> 4;
        int zC = z >> 4;
        float[] array = this.getOrCreateChunk(xC, zC);
        if (v > array[index = (x & 0xF) + (z & 0xF) * 16]) {
            array[index] = v;
            return true;
        }
        return false;
    }

    public void forEachEntry(IntIntFloatConsumer consumer) {
        for (Long2ObjectMap.Entry entry : this.map.long2ObjectEntrySet()) {
            int cx = class_1923.method_8325((long)entry.getLongKey()) * 16;
            int cz = class_1923.method_8332((long)entry.getLongKey()) * 16;
            int index = 0;
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    float v = ((float[])entry.getValue())[index++];
                    if (v == this.defaultValue) continue;
                    consumer.accept(cx + x, cz + z, v);
                }
            }
        }
    }

    public class_1923 getLastChunk() {
        if (this.lastChunk != null && this.lastChunkPos != PositionUtils.MIN_POSITION_LONG) {
            return new class_1923(this.lastChunkPos);
        }
        if (!this.map.isEmpty()) {
            return new class_1923(this.map.keySet().iterator().nextLong());
        }
        return new class_1923(0, 0);
    }

    public float[] getChunk(int xC, int zC) {
        return this.getChunk(class_1923.method_8331((int)xC, (int)zC));
    }

    public float[] getChunk(long pos) {
        if (this.lastChunkPos != pos) {
            float[] chunk = (float[])this.map.get(pos);
            this.lastChunkPos = pos;
            this.lastChunk = chunk;
        }
        return this.lastChunk;
    }

    public float[] getOrCreateChunk(int xC, int zC) {
        return this.getOrCreateChunk(class_1923.method_8331((int)xC, (int)zC));
    }

    public float[] getOrCreateChunk(long pos) {
        if (this.lastChunk == null || this.lastChunkPos != pos) {
            float[] chunk = (float[])this.map.computeIfAbsent(pos, this.defaultFunction);
            this.lastChunkPos = pos;
            this.lastChunk = chunk;
        }
        return this.lastChunk;
    }
}

