/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.collections.list;

import com.moulberry.axiom.BuildConfig;
import com.moulberry.axiom.collections.list.IntrusiveLinkedElement;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import java.util.AbstractCollection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

public class IntrusiveLinkedList<E extends IntrusiveLinkedElement<E>>
extends AbstractCollection<E> {
    private int modCount = 0;
    private int size = 0;
    private E head;
    private E tail;

    public E first() {
        return this.head;
    }

    @Override
    public boolean add(E e) {
        if (((IntrusiveLinkedElement)e).prev != null || ((IntrusiveLinkedElement)e).next != null) {
            throw new IllegalStateException();
        }
        if (BuildConfig.DEBUG && this.head == null != (this.tail == null)) {
            throw new FaultyImplementationError();
        }
        if (this.head == null) {
            this.tail = e;
            this.head = this.tail;
        } else {
            ((IntrusiveLinkedElement)this.tail).next = e;
            ((IntrusiveLinkedElement)e).prev = this.tail;
            this.tail = e;
        }
        ++this.size;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof IntrusiveLinkedElement) {
            IntrusiveLinkedElement e = (IntrusiveLinkedElement)o;
            Object next2 = e.next;
            Object prev = e.prev;
            if (prev == null && e != this.head || next2 == null && e != this.tail) {
                throw new IllegalStateException("Tried to remove IntrusiveLinkedElement from list that doesn't contain it");
            }
            if (prev == null) {
                this.head = next2;
            } else {
                ((IntrusiveLinkedElement)prev).next = next2;
                e.prev = null;
            }
            if (next2 == null) {
                this.tail = prev;
            } else {
                ((IntrusiveLinkedElement)next2).prev = prev;
                e.next = null;
            }
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException("Contains is not supported. Too expensive.");
    }

    @Override
    public void clear() {
        this.size = 0;
        this.head = null;
        this.tail = null;
        ++this.modCount;
    }

    public void sort(Comparator<E> c) {
        E newHead = this.head;
        int size = 1;
        while (true) {
            int merges = 0;
            E p = newHead;
            Object newTail = null;
            while (p != null) {
                ++merges;
                E q = p;
                int psize = 0;
                for (int i = 0; i < size; ++i) {
                    ++psize;
                    q = ((IntrusiveLinkedElement)q).next;
                    if (q == null) break;
                }
                int qsize = size;
                while (psize > 0 || qsize > 0 && q != null) {
                    E e;
                    if (psize > 0 && (qsize == 0 || q == null || c.compare(p, q) <= 0)) {
                        e = p;
                        p = ((IntrusiveLinkedElement)p).next;
                        --psize;
                    } else {
                        e = q;
                        q = ((IntrusiveLinkedElement)q).next;
                        --qsize;
                    }
                    if (newTail != null) {
                        newTail.next = e;
                        ((IntrusiveLinkedElement)e).prev = newTail;
                    } else {
                        newHead = e;
                        ((IntrusiveLinkedElement)e).prev = null;
                    }
                    newTail = e;
                }
                p = q;
            }
            if (newTail != null) {
                newTail.next = null;
            }
            if (merges <= 1) {
                this.head = newHead;
                this.tail = newTail;
                ++this.modCount;
                if (BuildConfig.DEBUG) {
                    // empty if block
                }
                return;
            }
            size *= 2;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private E lastReturned = null;
            private E next;
            private int expectedModCount;
            {
                this.next = IntrusiveLinkedList.this.head;
                this.expectedModCount = IntrusiveLinkedList.this.modCount;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public E next() {
                this.checkForComodification();
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.next;
                this.next = ((IntrusiveLinkedElement)this.next).next;
                return this.lastReturned;
            }

            @Override
            public void remove() {
                this.checkForComodification();
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                IntrusiveLinkedList.this.remove(this.lastReturned);
                ++this.expectedModCount;
                this.lastReturned = null;
            }

            private void checkForComodification() {
                if (IntrusiveLinkedList.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    public void mergeSplitPosition(IntrusiveLinkedList<E> other, Comparator<E> c, int oldSplit, int newSplit, Consumer<E> headSplit, Consumer<E> tailSplit) {
        Object newHead = null;
        Object newTail = null;
        int newSize = 0;
        E thisCurrent = this.head;
        E otherCurrent = other.head;
        int psize = this.size;
        int qsize = other.size;
        while (psize > 0 || qsize > 0) {
            E e;
            if (psize > 0 && (qsize == 0 || c.compare(thisCurrent, otherCurrent) <= 0)) {
                boolean headSide;
                if (this.size - psize < oldSplit != (headSide = newSize < newSplit)) {
                    if (headSide) {
                        headSplit.accept(thisCurrent);
                    } else {
                        tailSplit.accept(thisCurrent);
                    }
                }
                e = thisCurrent;
                thisCurrent = ((IntrusiveLinkedElement)thisCurrent).next;
                --psize;
            } else {
                if (newSize < newSplit) {
                    headSplit.accept(otherCurrent);
                } else {
                    tailSplit.accept(otherCurrent);
                }
                e = otherCurrent;
                otherCurrent = ((IntrusiveLinkedElement)otherCurrent).next;
                --qsize;
            }
            if (newTail != null) {
                newTail.next = e;
                ((IntrusiveLinkedElement)e).prev = newTail;
            } else {
                newHead = e;
                ((IntrusiveLinkedElement)e).prev = null;
            }
            ++newSize;
            newTail = e;
        }
        if (newTail != null) {
            newTail.next = null;
        }
        if (BuildConfig.DEBUG && newSize != this.size + other.size) {
            throw new FaultyImplementationError();
        }
        this.head = newHead;
        this.tail = newTail;
        this.size = newSize;
        ++this.modCount;
        other.clear();
    }
}

