/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.core_rendering;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.core_rendering.AxiomBufferUsage;
import com.moulberry.axiom.core_rendering.AxiomDraw;
import com.moulberry.axiom.core_rendering.AxiomDrawBuffer;
import com.moulberry.axiom.core_rendering.AxiomGpuTexture;
import com.moulberry.axiom.core_rendering.AxiomRenderPipeline;
import com.moulberry.axiom.render.ShaderManager;
import com.moulberry.axiom.utils.RenderHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1041;
import net.minecraft.class_276;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5944;
import net.minecraft.class_9801;
import org.lwjgl.opengl.GL11;

public class AxiomRenderer {
    private static final Map<class_293, class_291> availableImmediateBuffers = new HashMap<class_293, class_291>();
    private static final Map<class_9801, class_291> rememberedVertexBuffers = new HashMap<class_9801, class_291>();

    public static void setMainTexture(class_2960 resourceLocation) {
        RenderSystem.setShaderTexture((int)0, (class_2960)resourceLocation);
    }

    public static void setMainTexture(AxiomGpuTexture axiomGpuTexture) {
        RenderSystem.setShaderTexture((int)0, (int)axiomGpuTexture.glId());
    }

    public static void dirtyDynamicUniforms() {
    }

    public static void setShaderColour(float r, float g2, float b, float a) {
        RenderSystem.setShaderColor((float)r, (float)g2, (float)b, (float)a);
    }

    public static void enableScissor(int x, int y, int width, int height) {
        RenderSystem.enableScissor((int)x, (int)y, (int)width, (int)height);
    }

    public static void setLineWidthLegacy(float f) {
        RenderSystem.lineWidth((float)f);
    }

    public static void disableScissor() {
        RenderSystem.disableScissor();
    }

    public static void forgetRememberedVertexBuffers() {
        for (Map.Entry<class_9801, class_291> entry : rememberedVertexBuffers.entrySet()) {
            class_293 format = entry.getKey().method_60822().comp_749();
            if (!availableImmediateBuffers.containsKey(format)) {
                availableImmediateBuffers.put(format, entry.getValue());
                continue;
            }
            entry.getValue().close();
        }
        rememberedVertexBuffers.clear();
    }

    public static void renderPipeline(AxiomRenderPipeline pipeline, class_276 target, class_9801 meshData, boolean closeMeshData) {
        class_291 vertexBuffer;
        if (meshData == null) {
            return;
        }
        boolean rememberMeshData = !closeMeshData;
        class_293 format = meshData.method_60822().comp_749();
        int lastFbo = GL11.glGetInteger((int)36006);
        class_5944 shader = AxiomRenderer.setupPipeline(pipeline);
        if (target != null && target != class_310.method_1551().method_1522()) {
            target.method_1235(true);
        }
        boolean usingImmediate = false;
        boolean usingRemembered = false;
        if (rememberedVertexBuffers.containsKey(meshData)) {
            vertexBuffer = rememberedVertexBuffers.remove(meshData);
            usingRemembered = true;
        } else if (!rememberMeshData) {
            vertexBuffer = format.method_43446();
            usingImmediate = true;
        } else {
            vertexBuffer = availableImmediateBuffers.containsKey(format) ? availableImmediateBuffers.remove(format) : new class_291(AxiomBufferUsage.STREAM_WRITE.bufferUsage());
        }
        vertexBuffer.method_1353();
        if (!usingRemembered) {
            vertexBuffer.method_1352(meshData);
        }
        vertexBuffer.method_35665();
        class_291.method_1354();
        AxiomRenderer.finish(pipeline, shader);
        if (!usingImmediate) {
            if (rememberMeshData) {
                rememberedVertexBuffers.put(meshData, vertexBuffer);
            } else if (!availableImmediateBuffers.containsKey(format)) {
                availableImmediateBuffers.put(format, vertexBuffer);
            } else {
                vertexBuffer.close();
            }
        }
        GlStateManager._glBindFramebuffer((int)36160, (int)lastFbo);
    }

    public static void renderPipeline(AxiomRenderPipeline pipeline, class_276 target, AxiomDrawBuffer axiomDrawBuffer) {
        if (axiomDrawBuffer.vertexBuffer == null) {
            return;
        }
        int lastFbo = GL11.glGetInteger((int)36006);
        class_5944 shader = AxiomRenderer.setupPipeline(pipeline);
        if (target != null && target != class_310.method_1551().method_1522()) {
            target.method_1235(true);
        }
        axiomDrawBuffer.draw();
        AxiomRenderer.finish(pipeline, shader);
        GlStateManager._glBindFramebuffer((int)36160, (int)lastFbo);
    }

    public static void renderPipeline(AxiomRenderPipeline pipeline, class_276 target, List<AxiomDraw> axiomDraws) {
        if (axiomDraws.isEmpty()) {
            return;
        }
        int lastFbo = GL11.glGetInteger((int)36006);
        class_5944 shader = AxiomRenderer.setupPipeline(pipeline);
        if (target != null && target != class_310.method_1551().method_1522()) {
            target.method_1235(true);
        }
        for (AxiomDraw axiomDraw : axiomDraws) {
            if (axiomDraw.modelViewMatrix() != null && shader.field_29470 != null) {
                shader.field_29470.method_1250(axiomDraw.modelViewMatrix());
                shader.field_29470.method_1300();
            }
            if (axiomDraw.modelOffset() != null && shader.field_53139 != null) {
                shader.field_53139.method_34413(axiomDraw.modelOffset());
                shader.field_53139.method_1300();
            }
            axiomDraw.drawBuffer().draw();
        }
        AxiomRenderer.finish(pipeline, shader);
        if (shader.field_53139 != null) {
            shader.field_53139.method_1249(0.0f, 0.0f, 0.0f);
        }
        GlStateManager._glBindFramebuffer((int)36160, (int)lastFbo);
    }

    private static class_5944 setupPipeline(AxiomRenderPipeline pipeline) {
        class_5944 shaderProgram;
        pipeline.shader.setupRenderState();
        switch (pipeline.shader) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case BLIT_SCREEN_OLD: {
                class_5944 shader = ShaderManager.enableBlitScreenOldShader();
                GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                class_5944 class_59442 = shader;
                break;
            }
            case LINES: {
                class_5944 class_59442 = ShaderManager.enableLinesShader();
                break;
            }
            case AXIOM_BLOCK: {
                class_5944 class_59442 = ShaderManager.enableAxiomBlockShader();
                break;
            }
            case POSITION_COLOR: {
                class_5944 class_59442 = ShaderManager.enablePositionColorShader();
                break;
            }
            case POSITION_TEX_COLOR: {
                class_5944 class_59442 = ShaderManager.enablePositionTexColorShader();
                break;
            }
            case POSITION_TEX: {
                class_5944 class_59442 = ShaderManager.enablePositionTexShader();
                break;
            }
            case TERRAIN_SOLID: {
                class_5944 class_59442 = ShaderManager.enableRendertypeSolidShader();
                break;
            }
            case TERRAIN_CUTOUT: {
                class_5944 class_59442 = ShaderManager.enableRendertypeCutoutShader();
                break;
            }
            case TERRAIN_CUTOUT_MIPPED: {
                class_5944 class_59442 = ShaderManager.enableRendertypeCutoutMippedShader();
                break;
            }
            case TERRAIN_TRANSLUCENT: {
                class_5944 class_59442 = ShaderManager.enableRendertypeTranslucentShader();
                break;
            }
            case TERRAIN_TRIPWIRE: {
                class_5944 class_59442 = ShaderManager.enableRendertypeTripwireShader();
                break;
            }
            case POSITION_COLOR_NO_VERTEX_COLOR: {
                class_5944 class_59442 = ShaderManager.enablePositionColorNoVertexColorShader();
                break;
            }
            case BIOME_OVERLAY: {
                class_5944 class_59442 = ShaderManager.enableBorderShader();
                break;
            }
            case COLLISION_MESH_OVERLAY: {
                class_5944 class_59442 = ShaderManager.enableCollisionMeshShader();
                break;
            }
            case BRIGHTEN_LIGHT_TEXTURE: {
                class_5944 class_59442 = shaderProgram = ShaderManager.enableBrightenLightmapShader();
            }
        }
        if (pipeline.polygonOffset != 0.0f) {
            RenderSystem.enablePolygonOffset();
            RenderSystem.polygonOffset((float)pipeline.polygonOffset, (float)pipeline.polygonOffset);
        }
        if (pipeline.blend) {
            RenderSystem.enableBlend();
            switch (pipeline.blendFunction) {
                case DEFAULT: {
                    RenderSystem.defaultBlendFunc();
                    break;
                }
                case ONE_ZERO: {
                    RenderSystem.blendFuncSeparate((int)1, (int)0, (int)1, (int)0);
                    break;
                }
                case ONE_ONE_MINUS_SRC_ALPHA: {
                    RenderSystem.blendFuncSeparate((int)1, (int)771, (int)1, (int)771);
                }
            }
        } else {
            RenderSystem.disableBlend();
        }
        if (pipeline.depthTest) {
            RenderSystem.enableDepthTest();
            RenderSystem.depthFunc((int)pipeline.depthFunc);
        } else {
            RenderSystem.disableDepthTest();
        }
        RenderSystem.depthMask((boolean)pipeline.depthWrite);
        if (pipeline.cull) {
            RenderSystem.enableCull();
        } else {
            RenderSystem.disableCull();
        }
        if ((double)pipeline.lineWidthMultiplier != 0.0) {
            AxiomRenderer.setLineWidthLegacy(RenderHelper.baseLineWidth * pipeline.lineWidthMultiplier);
        }
        if (pipeline.disableFog) {
            RenderHelper.pushDisableFog();
        }
        if (pipeline.useLightLayer) {
            class_310.method_1551().field_1773.method_22974().method_3316();
        }
        GL11.glCullFace((int)pipeline.cullFace);
        class_1041 window = class_310.method_1551().method_22683();
        RenderHelper.setupShader(shaderProgram, RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix(), window.method_4489(), window.method_4506());
        return shaderProgram;
    }

    private static void finish(AxiomRenderPipeline pipeline, class_5944 shader) {
        RenderHelper.finishShader(shader);
        pipeline.shader.clearRenderState();
        if (pipeline.disableFog) {
            RenderHelper.popDisableFog();
        }
        if (pipeline.useLightLayer) {
            class_310.method_1551().field_1773.method_22974().method_3315();
        }
        if ((double)pipeline.polygonOffset != 0.0) {
            RenderSystem.disablePolygonOffset();
        }
        if (!pipeline.blend) {
            RenderSystem.enableBlend();
        }
        if (!pipeline.depthTest) {
            RenderSystem.enableDepthTest();
        }
        if (!pipeline.cull) {
            RenderSystem.enableCull();
        }
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.depthFunc((int)515);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glCullFace((int)1029);
    }
}

