/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor;

import com.moulberry.axiom.editor.EditorUI;
import imgui.ImDrawData;
import imgui.ImFontAtlas;
import imgui.ImGui;
import imgui.ImGuiIO;
import imgui.ImGuiViewport;
import imgui.ImVec2;
import imgui.ImVec4;
import imgui.callback.ImPlatformFuncViewport;
import imgui.type.ImInt;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GL33C;

public final class CustomImGuiImplGl3 {
    private int glVersion = 0;
    private String glslVersion = "";
    private int gFontTexture = -1;
    private int gShaderHandle = 0;
    private int gVertHandle = 0;
    private int gFragHandle = 0;
    private int gAttribLocationTex = 0;
    private int gAttribLocationProjMtx = 0;
    private int gAttribLocationVtxPos = 0;
    private int gAttribLocationVtxUV = 0;
    private int gAttribLocationVtxColor = 0;
    private int gVboHandle = 0;
    private int gElementsHandle = 0;
    private int gVertexArrayObjectHandle = 0;
    private final ImVec2 displaySize = new ImVec2();
    private final ImVec2 framebufferScale = new ImVec2();
    private final ImVec2 displayPos = new ImVec2();
    private final ImVec4 clipRect = new ImVec4();
    private final float[] orthoProjMatrix = new float[16];
    private final int[] lastActiveTexture = new int[1];
    private final int[] lastProgram = new int[1];
    private final int[] lastTexture = new int[1];
    private final int[] lastArrayBuffer = new int[1];
    private final int[] lastVertexArrayObject = new int[1];
    private final int[] lastFramebuffer = new int[1];
    private final int[] lastViewport = new int[4];
    private final int[] lastScissorBox = new int[4];
    private final int[] lastBlendSrcRgb = new int[1];
    private final int[] lastBlendDstRgb = new int[1];
    private final int[] lastBlendSrcAlpha = new int[1];
    private final int[] lastBlendDstAlpha = new int[1];
    private final int[] lastBlendEquationRgb = new int[1];
    private final int[] lastBlendEquationAlpha = new int[1];
    private boolean lastEnableBlend = false;
    private boolean lastEnableCullFace = false;
    private boolean lastEnableDepthTest = false;
    private boolean lastEnableStencilTest = false;
    private boolean lastEnableScissorTest = false;

    public void init() {
        this.init(null);
    }

    public void init(String glslVersion) {
        this.readGlVersion();
        this.setupBackendCapabilitiesFlags();
        this.glslVersion = glslVersion == null ? "#version 130" : glslVersion;
        this.createDeviceObjects();
        if (EditorUI.getIO().hasConfigFlags(1024)) {
            this.initPlatformInterface();
        }
    }

    public void renderDrawData(ImDrawData drawData) {
        if (drawData.getCmdListsCount() <= 0) {
            return;
        }
        drawData.getDisplaySize(this.displaySize);
        drawData.getDisplayPos(this.displayPos);
        drawData.getFramebufferScale(this.framebufferScale);
        float clipOffX = this.displayPos.x;
        float clipOffY = this.displayPos.y;
        float clipScaleX = this.framebufferScale.x;
        float clipScaleY = this.framebufferScale.y;
        int fbWidth = (int)(this.displaySize.x * this.framebufferScale.x);
        int fbHeight = (int)(this.displaySize.y * this.framebufferScale.y);
        if (fbWidth <= 0 || fbHeight <= 0) {
            return;
        }
        this.backupGlState();
        this.bind(fbWidth, fbHeight);
        for (int cmdListIdx = 0; cmdListIdx < drawData.getCmdListsCount(); ++cmdListIdx) {
            GL32.glBufferData((int)34962, (ByteBuffer)drawData.getCmdListVtxBufferData(cmdListIdx), (int)35040);
            GL32.glBufferData((int)34963, (ByteBuffer)drawData.getCmdListIdxBufferData(cmdListIdx), (int)35040);
            for (int cmdBufferIdx = 0; cmdBufferIdx < drawData.getCmdListCmdBufferSize(cmdListIdx); ++cmdBufferIdx) {
                drawData.getCmdListCmdBufferClipRect(cmdListIdx, cmdBufferIdx, this.clipRect);
                float clipMinX = (this.clipRect.x - clipOffX) * clipScaleX;
                float clipMinY = (this.clipRect.y - clipOffY) * clipScaleY;
                float clipMaxX = (this.clipRect.z - clipOffX) * clipScaleX;
                float clipMaxY = (this.clipRect.w - clipOffY) * clipScaleY;
                if (clipMaxX <= clipMinX || clipMaxY <= clipMinY) continue;
                GL32.glScissor((int)((int)clipMinX), (int)((int)((float)fbHeight - clipMaxY)), (int)((int)(clipMaxX - clipMinX)), (int)((int)(clipMaxY - clipMinY)));
                int textureId = drawData.getCmdListCmdBufferTextureId(cmdListIdx, cmdBufferIdx);
                int elemCount = drawData.getCmdListCmdBufferElemCount(cmdListIdx, cmdBufferIdx);
                int idxBufferOffset = drawData.getCmdListCmdBufferIdxOffset(cmdListIdx, cmdBufferIdx);
                int vtxBufferOffset = drawData.getCmdListCmdBufferVtxOffset(cmdListIdx, cmdBufferIdx);
                int indices = idxBufferOffset * 2;
                GL32.glBindTexture((int)3553, (int)textureId);
                if (this.glVersion >= 320) {
                    GL32.glDrawElementsBaseVertex((int)4, (int)elemCount, (int)5123, (long)indices, (int)vtxBufferOffset);
                    continue;
                }
                GL32.glDrawElements((int)4, (int)elemCount, (int)5123, (long)indices);
            }
        }
        this.unbind();
        this.restoreModifiedGlState();
    }

    public void dispose() {
        GL32.glDeleteBuffers((int)this.gVboHandle);
        GL32.glDeleteBuffers((int)this.gElementsHandle);
        GL32.glDetachShader((int)this.gShaderHandle, (int)this.gVertHandle);
        GL32.glDetachShader((int)this.gShaderHandle, (int)this.gFragHandle);
        GL32.glDeleteProgram((int)this.gShaderHandle);
        GL32.glDeleteTextures((int)this.gFontTexture);
        this.shutdownPlatformInterface();
    }

    public void updateFontsTexture() {
        if (this.gFontTexture != -1) {
            GL32.glDeleteTextures((int)this.gFontTexture);
        }
        ImFontAtlas fontAtlas = EditorUI.getIO().getFonts();
        ImInt width = new ImInt();
        ImInt height = new ImInt();
        ByteBuffer buffer = fontAtlas.getTexDataAsRGBA32(width, height);
        int previousTexture = GL32.glGetInteger((int)32873);
        this.gFontTexture = GL32.glGenTextures();
        GL32.glActiveTexture((int)33984);
        GL32.glBindTexture((int)3553, (int)this.gFontTexture);
        GL32.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL32.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL32.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL32.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL32.glPixelStorei((int)3317, (int)1);
        GL32.glPixelStorei((int)3314, (int)0);
        GL32.glPixelStorei((int)3316, (int)0);
        GL32.glPixelStorei((int)3315, (int)0);
        GL32.glTexImage2D((int)3553, (int)0, (int)6408, (int)width.get(), (int)height.get(), (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        fontAtlas.setTexID(this.gFontTexture);
        GL32.glBindTexture((int)3553, (int)previousTexture);
    }

    private void readGlVersion() {
        int[] major = new int[1];
        int[] minor = new int[1];
        GL32.glGetIntegerv((int)33307, (int[])major);
        GL32.glGetIntegerv((int)33308, (int[])minor);
        this.glVersion = major[0] * 100 + minor[0] * 10;
    }

    private void setupBackendCapabilitiesFlags() {
        ImGuiIO io = EditorUI.getIO();
        io.setBackendRendererName("imgui_java_impl_opengl3");
        if (this.glVersion >= 320) {
            io.addBackendFlags(8);
        }
        io.addBackendFlags(4096);
    }

    private void createDeviceObjects() {
        int[] lastTexture = new int[1];
        int[] lastArrayBuffer = new int[1];
        int[] lastVertexArray = new int[1];
        GL32.glGetIntegerv((int)32873, (int[])lastTexture);
        GL32.glGetIntegerv((int)34964, (int[])lastArrayBuffer);
        GL32.glGetIntegerv((int)34229, (int[])lastVertexArray);
        this.createShaders();
        this.gAttribLocationTex = GL32.glGetUniformLocation((int)this.gShaderHandle, (CharSequence)"Texture");
        this.gAttribLocationProjMtx = GL32.glGetUniformLocation((int)this.gShaderHandle, (CharSequence)"ProjMtx");
        this.gAttribLocationVtxPos = GL32.glGetAttribLocation((int)this.gShaderHandle, (CharSequence)"Position");
        this.gAttribLocationVtxUV = GL32.glGetAttribLocation((int)this.gShaderHandle, (CharSequence)"UV");
        this.gAttribLocationVtxColor = GL32.glGetAttribLocation((int)this.gShaderHandle, (CharSequence)"Color");
        this.gVboHandle = GL32.glGenBuffers();
        this.gElementsHandle = GL32.glGenBuffers();
        this.updateFontsTexture();
        GL32.glBindTexture((int)3553, (int)lastTexture[0]);
        GL32.glBindBuffer((int)34962, (int)lastArrayBuffer[0]);
        GL32.glBindVertexArray((int)lastVertexArray[0]);
    }

    private void createShaders() {
        String fragShaderSource;
        String vertShaderSource;
        int glslVersionValue = this.parseGlslVersionString();
        if (glslVersionValue < 130) {
            vertShaderSource = this.getVertexShaderGlsl120();
            fragShaderSource = this.getFragmentShaderGlsl120();
        } else if (glslVersionValue == 300) {
            vertShaderSource = this.getVertexShaderGlsl300es();
            fragShaderSource = this.getFragmentShaderGlsl300es();
        } else if (glslVersionValue >= 410) {
            vertShaderSource = this.getVertexShaderGlsl410Core();
            fragShaderSource = this.getFragmentShaderGlsl410Core();
        } else {
            vertShaderSource = this.getVertexShaderGlsl130();
            fragShaderSource = this.getFragmentShaderGlsl130();
        }
        this.gVertHandle = this.createAndCompileShader(35633, vertShaderSource);
        this.gFragHandle = this.createAndCompileShader(35632, fragShaderSource);
        this.gShaderHandle = GL32.glCreateProgram();
        GL32.glAttachShader((int)this.gShaderHandle, (int)this.gVertHandle);
        GL32.glAttachShader((int)this.gShaderHandle, (int)this.gFragHandle);
        GL32.glLinkProgram((int)this.gShaderHandle);
        if (GL32.glGetProgrami((int)this.gShaderHandle, (int)35714) == 0) {
            throw new IllegalStateException("Failed to link shader program:\n" + GL32.glGetProgramInfoLog((int)this.gShaderHandle));
        }
    }

    private int parseGlslVersionString() {
        Pattern p = Pattern.compile("\\d+");
        Matcher m4 = p.matcher(this.glslVersion);
        if (m4.find()) {
            return Integer.parseInt(m4.group());
        }
        throw new IllegalArgumentException("Invalid GLSL version string: " + this.glslVersion);
    }

    private void backupGlState() {
        GL32.glGetIntegerv((int)34016, (int[])this.lastActiveTexture);
        GL32.glActiveTexture((int)33984);
        GL32.glGetIntegerv((int)35725, (int[])this.lastProgram);
        GL32.glGetIntegerv((int)32873, (int[])this.lastTexture);
        GL32.glGetIntegerv((int)34964, (int[])this.lastArrayBuffer);
        GL32.glGetIntegerv((int)34229, (int[])this.lastVertexArrayObject);
        GL32.glGetIntegerv((int)36006, (int[])this.lastFramebuffer);
        GL32.glGetIntegerv((int)2978, (int[])this.lastViewport);
        GL32.glGetIntegerv((int)3088, (int[])this.lastScissorBox);
        GL32.glGetIntegerv((int)32969, (int[])this.lastBlendSrcRgb);
        GL32.glGetIntegerv((int)32968, (int[])this.lastBlendDstRgb);
        GL32.glGetIntegerv((int)32971, (int[])this.lastBlendSrcAlpha);
        GL32.glGetIntegerv((int)32970, (int[])this.lastBlendDstAlpha);
        GL32.glGetIntegerv((int)32777, (int[])this.lastBlendEquationRgb);
        GL32.glGetIntegerv((int)34877, (int[])this.lastBlendEquationAlpha);
        this.lastEnableBlend = GL32.glIsEnabled((int)3042);
        this.lastEnableCullFace = GL32.glIsEnabled((int)2884);
        this.lastEnableDepthTest = GL32.glIsEnabled((int)2929);
        this.lastEnableStencilTest = GL32.glIsEnabled((int)2960);
        this.lastEnableScissorTest = GL32.glIsEnabled((int)3089);
    }

    private void restoreModifiedGlState() {
        GL32.glUseProgram((int)this.lastProgram[0]);
        GL32.glBindTexture((int)3553, (int)this.lastTexture[0]);
        GL32.glActiveTexture((int)this.lastActiveTexture[0]);
        GL32.glBindVertexArray((int)this.lastVertexArrayObject[0]);
        GL32.glBindFramebuffer((int)36160, (int)this.lastFramebuffer[0]);
        GL32.glBindBuffer((int)34962, (int)this.lastArrayBuffer[0]);
        GL32.glBlendEquationSeparate((int)this.lastBlendEquationRgb[0], (int)this.lastBlendEquationAlpha[0]);
        GL32.glBlendFuncSeparate((int)this.lastBlendSrcRgb[0], (int)this.lastBlendDstRgb[0], (int)this.lastBlendSrcAlpha[0], (int)this.lastBlendDstAlpha[0]);
        if (this.lastEnableBlend) {
            GL32.glEnable((int)3042);
        } else {
            GL32.glDisable((int)3042);
        }
        if (this.lastEnableCullFace) {
            GL32.glEnable((int)2884);
        } else {
            GL32.glDisable((int)2884);
        }
        if (this.lastEnableDepthTest) {
            GL32.glEnable((int)2929);
        } else {
            GL32.glDisable((int)2929);
        }
        if (this.lastEnableStencilTest) {
            GL32.glEnable((int)2960);
        } else {
            GL32.glDisable((int)2960);
        }
        if (this.lastEnableScissorTest) {
            GL32.glEnable((int)3089);
        } else {
            GL32.glDisable((int)3089);
        }
        GL32.glViewport((int)this.lastViewport[0], (int)this.lastViewport[1], (int)this.lastViewport[2], (int)this.lastViewport[3]);
        GL32.glScissor((int)this.lastScissorBox[0], (int)this.lastScissorBox[1], (int)this.lastScissorBox[2], (int)this.lastScissorBox[3]);
    }

    private void bind(int fbWidth, int fbHeight) {
        this.gVertexArrayObjectHandle = GL32.glGenVertexArrays();
        GL32.glEnable((int)3042);
        GL32.glBlendEquation((int)32774);
        GL32.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        GL32.glDisable((int)2884);
        GL32.glDisable((int)2929);
        GL32.glDisable((int)2960);
        GL32.glEnable((int)3089);
        GL33C.glBindSampler((int)0, (int)0);
        GL32.glViewport((int)0, (int)0, (int)fbWidth, (int)fbHeight);
        float left = this.displayPos.x;
        float right = this.displayPos.x + this.displaySize.x;
        float top = this.displayPos.y;
        float bottom = this.displayPos.y + this.displaySize.y;
        this.orthoProjMatrix[0] = 2.0f / (right - left);
        this.orthoProjMatrix[5] = 2.0f / (top - bottom);
        this.orthoProjMatrix[10] = -1.0f;
        this.orthoProjMatrix[12] = (right + left) / (left - right);
        this.orthoProjMatrix[13] = (top + bottom) / (bottom - top);
        this.orthoProjMatrix[15] = 1.0f;
        GL32.glUseProgram((int)this.gShaderHandle);
        GL32.glUniform1i((int)this.gAttribLocationTex, (int)0);
        GL32.glUniformMatrix4fv((int)this.gAttribLocationProjMtx, (boolean)false, (float[])this.orthoProjMatrix);
        GL32.glBindVertexArray((int)this.gVertexArrayObjectHandle);
        GL32.glBindFramebuffer((int)36160, (int)0);
        GL32.glBindBuffer((int)34962, (int)this.gVboHandle);
        GL32.glBindBuffer((int)34963, (int)this.gElementsHandle);
        GL32.glEnableVertexAttribArray((int)this.gAttribLocationVtxPos);
        GL32.glEnableVertexAttribArray((int)this.gAttribLocationVtxUV);
        GL32.glEnableVertexAttribArray((int)this.gAttribLocationVtxColor);
        GL32.glVertexAttribPointer((int)this.gAttribLocationVtxPos, (int)2, (int)5126, (boolean)false, (int)20, (long)0L);
        GL32.glVertexAttribPointer((int)this.gAttribLocationVtxUV, (int)2, (int)5126, (boolean)false, (int)20, (long)8L);
        GL32.glVertexAttribPointer((int)this.gAttribLocationVtxColor, (int)4, (int)5121, (boolean)true, (int)20, (long)16L);
    }

    private void unbind() {
        GL32.glDeleteVertexArrays((int)this.gVertexArrayObjectHandle);
    }

    private void initPlatformInterface() {
        ImGui.getPlatformIO().setRendererRenderWindow(new ImPlatformFuncViewport(){

            @Override
            public void accept(ImGuiViewport vp) {
                if (!vp.hasFlags(256)) {
                    GL32.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                    GL32.glClear((int)16384);
                }
                CustomImGuiImplGl3.this.renderDrawData(vp.getDrawData());
            }
        });
    }

    private void shutdownPlatformInterface() {
        ImGui.destroyPlatformWindows();
    }

    private int createAndCompileShader(int type2, CharSequence source) {
        int id = GL32.glCreateShader((int)type2);
        GL32.glShaderSource((int)id, (CharSequence)source);
        GL32.glCompileShader((int)id);
        if (GL32.glGetShaderi((int)id, (int)35713) == 0) {
            throw new IllegalStateException("Failed to compile shader:\n" + GL32.glGetShaderInfoLog((int)id));
        }
        return id;
    }

    private String getVertexShaderGlsl120() {
        return this.glslVersion + "\nuniform mat4 ProjMtx;\nattribute vec2 Position;\nattribute vec2 UV;\nattribute vec4 Color;\nvarying vec2 Frag_UV;\nvarying vec4 Frag_Color;\nvoid main()\n{\n    Frag_UV = UV;\n    Frag_Color = Color;\n    gl_Position = ProjMtx * vec4(Position.xy,0,1);\n}\n";
    }

    private String getVertexShaderGlsl130() {
        return this.glslVersion + "\nuniform mat4 ProjMtx;\nin vec2 Position;\nin vec2 UV;\nin vec4 Color;\nout vec2 Frag_UV;\nout vec4 Frag_Color;\nvoid main()\n{\n    Frag_UV = UV;\n    Frag_Color = Color;\n    gl_Position = ProjMtx * vec4(Position.xy,0,1);\n}\n";
    }

    private String getVertexShaderGlsl300es() {
        return this.glslVersion + "\nprecision highp float;\nlayout (location = 0) in vec2 Position;\nlayout (location = 1) in vec2 UV;\nlayout (location = 2) in vec4 Color;\nuniform mat4 ProjMtx;\nout vec2 Frag_UV;\nout vec4 Frag_Color;\nvoid main()\n{\n    Frag_UV = UV;\n    Frag_Color = Color;\n    gl_Position = ProjMtx * vec4(Position.xy,0,1);\n}\n";
    }

    private String getVertexShaderGlsl410Core() {
        return this.glslVersion + "\nlayout (location = 0) in vec2 Position;\nlayout (location = 1) in vec2 UV;\nlayout (location = 2) in vec4 Color;\nuniform mat4 ProjMtx;\nout vec2 Frag_UV;\nout vec4 Frag_Color;\nvoid main()\n{\n    Frag_UV = UV;\n    Frag_Color = Color;\n    gl_Position = ProjMtx * vec4(Position.xy,0,1);\n}\n";
    }

    private String getFragmentShaderGlsl120() {
        return this.glslVersion + "\n#ifdef GL_ES\n    precision mediump float;\n#endif\nuniform sampler2D Texture;\nvarying vec2 Frag_UV;\nvarying vec4 Frag_Color;\nvoid main()\n{\n    gl_FragColor = Frag_Color * texture2D(Texture, Frag_UV.st);\n}\n";
    }

    private String getFragmentShaderGlsl130() {
        return this.glslVersion + "\nuniform sampler2D Texture;\nin vec2 Frag_UV;\nin vec4 Frag_Color;\nout vec4 Out_Color;\nvoid main()\n{\n    Out_Color = Frag_Color * texture(Texture, Frag_UV.st);\n}\n";
    }

    private String getFragmentShaderGlsl300es() {
        return this.glslVersion + "\nprecision mediump float;\nuniform sampler2D Texture;\nin vec2 Frag_UV;\nin vec4 Frag_Color;\nlayout (location = 0) out vec4 Out_Color;\nvoid main()\n{\n    Out_Color = Frag_Color * texture(Texture, Frag_UV.st);\n}\n";
    }

    private String getFragmentShaderGlsl410Core() {
        return this.glslVersion + "\nin vec2 Frag_UV;\nin vec4 Frag_Color;\nuniform sampler2D Texture;\nlayout (location = 0) out vec4 Out_Color;\nvoid main()\n{\n    Out_Color = Frag_Color * texture(Texture, Frag_UV.st);\n}\n";
    }
}

