/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows;

import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.tutorial.Tutorial;
import com.moulberry.axiom.editor.tutorial.TutorialManager;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.ToolManager;
import imgui.ImGui;
import imgui.ImGuiViewport;

public class ToolOptionsWindow {
    public static void render() {
        boolean showTutorial;
        boolean bl = showTutorial = TutorialManager.getCurrentStageLinkedWindow() == EditorWindowType.TOOL_OPTIONS;
        if (!EditorWindowType.TOOL_OPTIONS.isOpen() && !showTutorial) {
            return;
        }
        ImGuiViewport viewport = ImGui.getMainViewport();
        ImGui.setNextWindowSize(200.0f, viewport.getSizeY() / 3.0f, 4);
        ImGui.setNextWindowPos(viewport.getPosX() + 20.0f, viewport.getPosY() + viewport.getSizeY() * 5.0f / 9.0f, 4);
        if (EditorWindowType.TOOL_OPTIONS.begin("###Tool Options", true)) {
            ImGui.setScrollX(0.0f);
            if (ToolManager.isToolActive()) {
                Tool tool = ToolManager.getCurrentTool();
                Tutorial tutorial = tool.getTutorial();
                if (tutorial != null) {
                    tutorial.initiateIfNotCompleted();
                }
                ImGui.pushID(ToolManager.getCurrentToolIndex());
                tool.displayImguiOptions();
                ImGui.popID();
            } else {
                ImGui.textDisabled(AxiomI18n.get("axiom.editorui.window.tool_options.no_active_tool"));
            }
            if (showTutorial) {
                TutorialManager.getCurrentStage().render(ImGui.getWindowPos(), ImGui.getWindowSize());
            }
        } else if (showTutorial) {
            TutorialManager.nextTutorialStage();
        }
        EditorWindowType.TOOL_OPTIONS.end();
    }
}

