/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows;

import com.moulberry.axiom.AxiomClient;
import com.moulberry.axiom.editor.ButtonSpacingSpec;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.keybinds.Keybind;
import com.moulberry.axiom.editor.tutorial.TutorialManager;
import com.moulberry.axiom.editor.tutorial.TutorialStage;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.ToolManager;
import imgui.ImFont;
import imgui.ImGui;
import imgui.ImGuiViewport;

public class ToolsWindow {
    public static void render(ImFont icons) {
        boolean showTutorial;
        boolean bl = showTutorial = TutorialManager.getCurrentStage() == TutorialStage.TOOLS_WINDOW;
        if (!EditorWindowType.TOOLS.isOpen() && !showTutorial) {
            return;
        }
        ImGuiViewport viewport = ImGui.getMainViewport();
        ImGui.setNextWindowSize(200.0f, viewport.getSizeY() / 3.0f, 4);
        ImGui.setNextWindowPos(viewport.getPosX() + 20.0f, viewport.getPosY() + viewport.getSizeY() / 9.0f, 4);
        if (EditorWindowType.TOOLS.begin("###Tools", true)) {
            float available = ImGui.getWindowSizeX();
            float toolButtonSizeX = (32.0f + ImGui.getStyle().getFramePaddingX() * 2.0f) * EditorUI.getUiScale();
            float toolButtonSizeY = (32.0f + ImGui.getStyle().getFramePaddingY() * 2.0f) * EditorUI.getUiScale();
            ButtonSpacingSpec spec = ButtonSpacingSpec.calculate(available, toolButtonSizeX, ToolManager.getTools().size(), 8.0f, true);
            boolean removeBackground = spec.buttonsPerRow() == 1 && spec.spacingX() <= 1.0f;
            int buttonsInRow = 0;
            float currentX = spec.spacingX();
            float currentY = ImGui.getCursorPosY() - ImGui.getStyle().getWindowPaddingY() + spec.spacingY();
            int buttonHoveredCol = ImGui.getColorU32(22);
            int buttonActiveCol = ImGui.getColorU32(23);
            ImGui.pushFont(icons);
            if (removeBackground) {
                ImGuiHelper.pushStyleColor(21, 0);
                ImGuiHelper.pushStyleColor(22, 0);
                ImGuiHelper.pushStyleColor(23, 0);
            }
            int activeTool = ToolManager.isToolActive() ? ToolManager.getCurrentToolIndex() : -1;
            for (int i = 0; i < ToolManager.getTools().size(); ++i) {
                ImGui.setCursorPos(currentX, currentY);
                if (!removeBackground && i == activeTool) {
                    ImGuiHelper.pushStyleColor(21, buttonActiveCol);
                }
                Tool tool = ToolManager.getTools().get(i);
                char icon = tool.iconChar();
                boolean disabled = !AxiomClient.hasPermissions(tool.requiredPermissions());
                ImGui.pushID(i);
                if (disabled) {
                    ImGui.beginDisabled();
                }
                if (ImGui.button(String.valueOf(icon), toolButtonSizeX, toolButtonSizeY)) {
                    if (i == activeTool) {
                        ToolManager.setToolSelected(false);
                    } else {
                        ToolManager.setCurrentToolIndex(i);
                        ToolManager.setToolSelected(true);
                    }
                }
                if (disabled) {
                    ImGui.endDisabled();
                    ImGui.popFont();
                    ImGuiHelper.tooltip("Server hasn't given you permission to use this tool", 512);
                    ImGui.pushFont(icons);
                }
                ImGui.popID();
                if (!removeBackground && i == activeTool) {
                    ImGuiHelper.popStyleColor();
                }
                if (removeBackground && (i == activeTool || ImGui.isItemHovered())) {
                    ImGui.setCursorPos(currentX + ImGui.getStyle().getFramePaddingX(), currentY + ImGui.getStyle().getFramePaddingY());
                    ImGui.textColored(i == activeTool || ImGui.isItemActive() ? buttonActiveCol : buttonHoveredCol, String.valueOf(icon));
                }
                if (ImGui.isItemHovered()) {
                    ImGui.popFont();
                    Object text = tool.name();
                    Keybind keybind = ToolManager.keybindMap.get(tool);
                    if (keybind != null && keybind.getKey() != 0) {
                        text = (String)text + " (" + keybind.longKeyIdentifier() + ")";
                    }
                    ImGui.beginTooltip();
                    ImGui.text((String)text);
                    ImGui.endTooltip();
                    ImGui.pushFont(icons);
                }
                if (buttonsInRow + 1 >= spec.buttonsPerRow()) {
                    currentX = spec.spacingX();
                    currentY += toolButtonSizeY + spec.spacingY();
                    buttonsInRow = 0;
                    continue;
                }
                currentX += toolButtonSizeX + spec.spacingX();
                ++buttonsInRow;
            }
            if (removeBackground) {
                ImGuiHelper.popStyleColor(3);
            }
            ImGui.popFont();
            if (showTutorial) {
                TutorialStage.TOOLS_WINDOW.render(ImGui.getWindowPos(), ImGui.getWindowSize());
            }
        } else if (showTutorial) {
            TutorialManager.nextTutorialStage();
        }
        EditorWindowType.TOOLS.end();
    }
}

