/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.operations;

import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.utils.BlockVoxelShapeUtils;
import com.moulberry.axiom.utils.IntWrapper;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiom.world_modification.BlockBuffer;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import java.text.NumberFormat;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class HollowOperation {
    public static void hollow() {
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        if (selectionBuffer instanceof SelectionBuffer.AABB) {
            SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)selectionBuffer;
            HollowOperation.hollowOrFillGapsAABB(aabb, HollowReplacement.NONAIR, class_2246.field_10124.method_9564());
        } else if (selectionBuffer instanceof SelectionBuffer.Set) {
            SelectionBuffer.Set set = (SelectionBuffer.Set)selectionBuffer;
            HollowOperation.hollowOrFillGapsSet(set, HollowReplacement.NONAIR, class_2246.field_10124.method_9564());
        }
    }

    public static void fillGaps(class_2680 blockState) {
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        if (selectionBuffer instanceof SelectionBuffer.AABB) {
            SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)selectionBuffer;
            HollowOperation.hollowOrFillGapsAABB(aabb, HollowReplacement.AIR, blockState);
        } else if (selectionBuffer instanceof SelectionBuffer.Set) {
            SelectionBuffer.Set set = (SelectionBuffer.Set)selectionBuffer;
            HollowOperation.hollowOrFillGapsSet(set, HollowReplacement.AIR, blockState);
        }
    }

    public static void fillUnreachable(class_2680 blockState) {
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        if (selectionBuffer instanceof SelectionBuffer.AABB) {
            SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)selectionBuffer;
            HollowOperation.hollowOrFillGapsAABB(aabb, HollowReplacement.NONAIR, blockState);
        } else if (selectionBuffer instanceof SelectionBuffer.Set) {
            SelectionBuffer.Set set = (SelectionBuffer.Set)selectionBuffer;
            HollowOperation.hollowOrFillGapsSet(set, HollowReplacement.NONAIR, blockState);
        }
    }

    private static void hollowOrFillGapsAABB(SelectionBuffer.AABB aabb, HollowReplacement replacement, class_2680 replaceWith) {
        int y;
        int z;
        int x;
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        int minX = aabb.min().method_10263();
        int minY = aabb.min().method_10264();
        int minZ = aabb.min().method_10260();
        int maxX = aabb.max().method_10263();
        int maxY = aabb.max().method_10264();
        int maxZ = aabb.max().method_10260();
        minY = Math.max(world.method_31607(), minY);
        maxY = Math.min(world.method_31600(), maxY);
        LongArrayFIFOQueue queue = new LongArrayFIFOQueue();
        PositionSet visited = new PositionSet();
        PositionSet visible = new PositionSet();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (x = minX; x <= maxX; ++x) {
            for (z = minZ; z <= maxZ; ++z) {
                HollowOperation.propagateInitial((class_1937)world, mutableBlockPos.method_10103(x, maxY + 1, z), class_2350.field_11033, queue, visible, visited);
                HollowOperation.propagateInitial((class_1937)world, mutableBlockPos.method_10103(x, minY - 1, z), class_2350.field_11036, queue, visible, visited);
            }
        }
        for (x = minX; x <= maxX; ++x) {
            for (y = minY; y <= maxY; ++y) {
                HollowOperation.propagateInitial((class_1937)world, mutableBlockPos.method_10103(x, y, maxZ + 1), class_2350.field_11043, queue, visible, visited);
                HollowOperation.propagateInitial((class_1937)world, mutableBlockPos.method_10103(x, y, minZ - 1), class_2350.field_11035, queue, visible, visited);
            }
        }
        for (int y2 = minY; y2 <= maxY; ++y2) {
            for (z = minZ; z <= maxZ; ++z) {
                HollowOperation.propagateInitial((class_1937)world, mutableBlockPos.method_10103(maxX + 1, y2, z), class_2350.field_11039, queue, visible, visited);
                HollowOperation.propagateInitial((class_1937)world, mutableBlockPos.method_10103(minX - 1, y2, z), class_2350.field_11034, queue, visible, visited);
            }
        }
        if (replacement == HollowReplacement.NONAIR && !replaceWith.method_26215()) {
            for (x = minX; x <= maxX; ++x) {
                for (y = minY; y <= maxY; ++y) {
                    for (int z2 = minZ; z2 <= maxZ; ++z2) {
                        class_2680 block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z2));
                        if (block.method_26204() == class_2246.field_10243 || !block.method_26215()) continue;
                        queue.enqueue(mutableBlockPos.method_10063());
                        visited.add(x, y, z2);
                    }
                }
            }
        }
        class_2680 directions = class_2350.values();
        while (!queue.isEmpty()) {
            long pos = queue.dequeueLong();
            for (class_2350 direction : directions) {
                mutableBlockPos.method_16363(pos);
                int neighborX = mutableBlockPos.method_10263() + direction.method_10148();
                int neighborY = mutableBlockPos.method_10264() + direction.method_10164();
                int neighborZ = mutableBlockPos.method_10260() + direction.method_10165();
                if (neighborX < minX || neighborY < minY || neighborZ < minZ || neighborX > maxX || neighborY > maxY || neighborZ > maxZ || visited.contains(neighborX, neighborY, neighborZ)) continue;
                HollowOperation.propagate((class_1937)world, mutableBlockPos, direction, queue, visible, visited);
            }
        }
        BlockBuffer setOperation = new BlockBuffer();
        BlockBuffer previousBlocksForUndo = new BlockBuffer();
        int changeCount = 0;
        for (int x2 = minX; x2 <= maxX; ++x2) {
            for (int y3 = minY; y3 <= maxY; ++y3) {
                for (int z3 = minZ; z3 <= maxZ; ++z3) {
                    class_2680 block = world.method_8320((class_2338)mutableBlockPos.method_10103(x2, y3, z3));
                    if (block.method_26204() == class_2246.field_10243 || !replacement.shouldReplace(block) || visible.contains(x2, y3, z3) || visited.contains(x2, y3, z3)) continue;
                    ++changeCount;
                    setOperation.set(x2, y3, z3, replaceWith);
                    previousBlocksForUndo.set(x2, y3, z3, block);
                }
            }
        }
        String desc = switch (replacement.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> "axiom.history_description.filled_gaps";
            case 1 -> replaceWith.method_26215() ? "axiom.history_description.hollowed" : "axiom.history_description.filled_unreachable";
        };
        String countString = NumberFormat.getInstance().format(changeCount);
        String historyDescription = AxiomI18n.get(desc, countString);
        RegionHelper.pushBlockBufferChange(setOperation, aabb.center(), historyDescription, null);
    }

    private static void hollowOrFillGapsSet(SelectionBuffer.Set set, HollowReplacement replacement, class_2680 replaceWith) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        ChunkedBooleanRegion region = set.selectionRegion;
        LongArrayFIFOQueue queue = new LongArrayFIFOQueue();
        PositionSet visited = new PositionSet();
        PositionSet visible = new PositionSet();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        region.forEach((x, y, z) -> {
            class_2680 block;
            if (!region.contains(x + 1, y, z)) {
                HollowOperation.propagateInitial((class_1937)world, mutableBlockPos.method_10103(x + 1, y, z), class_2350.field_11039, queue, visible, visited);
            }
            if (!region.contains(x - 1, y, z)) {
                HollowOperation.propagateInitial((class_1937)world, mutableBlockPos.method_10103(x - 1, y, z), class_2350.field_11034, queue, visible, visited);
            }
            if (!region.contains(x, y + 1, z)) {
                HollowOperation.propagateInitial((class_1937)world, mutableBlockPos.method_10103(x, y + 1, z), class_2350.field_11033, queue, visible, visited);
            }
            if (!region.contains(x, y - 1, z)) {
                HollowOperation.propagateInitial((class_1937)world, mutableBlockPos.method_10103(x, y - 1, z), class_2350.field_11036, queue, visible, visited);
            }
            if (!region.contains(x, y, z + 1)) {
                HollowOperation.propagateInitial((class_1937)world, mutableBlockPos.method_10103(x, y, z + 1), class_2350.field_11043, queue, visible, visited);
            }
            if (!region.contains(x, y, z - 1)) {
                HollowOperation.propagateInitial((class_1937)world, mutableBlockPos.method_10103(x, y, z - 1), class_2350.field_11035, queue, visible, visited);
            }
            if (replacement == HollowReplacement.NONAIR && !replaceWith.method_26215() && (block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z))).method_26204() != class_2246.field_10243 && block.method_26215()) {
                queue.enqueue(mutableBlockPos.method_10063());
                visited.add(x, y, z);
            }
        });
        class_2350[] directions = class_2350.values();
        while (!queue.isEmpty()) {
            long pos = queue.dequeueLong();
            for (class_2350 direction : directions) {
                mutableBlockPos.method_16363(pos);
                int neighborX = mutableBlockPos.method_10263() + direction.method_10148();
                int neighborY = mutableBlockPos.method_10264() + direction.method_10164();
                int neighborZ = mutableBlockPos.method_10260() + direction.method_10165();
                if (!region.contains(neighborX, neighborY, neighborZ) || visited.contains(neighborX, neighborY, neighborZ)) continue;
                HollowOperation.propagate((class_1937)world, mutableBlockPos, direction, queue, visible, visited);
            }
        }
        BlockBuffer setOperation = new BlockBuffer();
        BlockBuffer previousBlocksForUndo = new BlockBuffer();
        IntWrapper changeCount = new IntWrapper();
        region.forEach((x, y, z) -> {
            class_2680 block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
            if (block.method_26204() == class_2246.field_10243) {
                return;
            }
            if (!replacement.shouldReplace(block)) {
                return;
            }
            if (visible.contains(x, y, z) || visited.contains(x, y, z)) {
                return;
            }
            ++changeCount.value;
            setOperation.set(x, y, z, replaceWith);
            previousBlocksForUndo.set(x, y, z, block);
        });
        String desc = switch (replacement.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> "axiom.history_description.filled_gaps";
            case 1 -> replaceWith.method_26215() ? "axiom.history_description.hollowed" : "axiom.history_description.filled_unreachable";
        };
        String countString = NumberFormat.getInstance().format(changeCount.value);
        String historyDescription = AxiomI18n.get(desc, countString);
        RegionHelper.pushBlockBufferChange(setOperation, set.center(), historyDescription, null);
    }

    private static void propagateInitial(class_1937 level, class_2338.class_2339 pos, class_2350 direction, LongArrayFIFOQueue queue, PositionSet visible, PositionSet visited) {
        class_265 toShape;
        class_2680 fromBlock = level.method_8320((class_2338)pos);
        class_265 fromShape = fromBlock.method_26173(direction);
        if (!fromBlock.method_26225() || !BlockVoxelShapeUtils.firstCompletelyOverlapsSecond(fromShape, class_259.method_1077())) {
            visited.add(pos.method_10263(), pos.method_10264(), pos.method_10260());
        }
        pos.method_10098(direction);
        class_2680 toBlock = level.method_8320((class_2338)pos);
        if (fromBlock.method_26225() && class_259.method_20713((class_265)fromShape, (class_265)(toShape = toBlock.method_26173(direction.method_10153())))) {
            if (!BlockVoxelShapeUtils.firstCompletelyOverlapsSecond(fromShape, class_259.method_1077())) {
                visible.add(pos.method_10263(), pos.method_10264(), pos.method_10260());
            }
            return;
        }
        queue.enqueue(pos.method_10063());
        visited.add(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    private static void propagate(class_1937 level, class_2338.class_2339 pos, class_2350 direction, LongArrayFIFOQueue queue, PositionSet visible, PositionSet visited) {
        class_265 toShape;
        class_2680 fromBlock = level.method_8320((class_2338)pos);
        class_265 fromShape = fromBlock.method_26173(direction);
        pos.method_10098(direction);
        class_2680 toBlock = level.method_8320((class_2338)pos);
        if (fromBlock.method_26225() && class_259.method_20713((class_265)fromShape, (class_265)(toShape = toBlock.method_26173(direction.method_10153())))) {
            if (!BlockVoxelShapeUtils.firstCompletelyOverlapsSecond(fromShape, class_259.method_1077())) {
                visible.add(pos.method_10263(), pos.method_10264(), pos.method_10260());
            }
            return;
        }
        queue.enqueue(pos.method_10063());
        visited.add(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    private static enum HollowReplacement {
        AIR,
        NONAIR;


        public boolean shouldReplace(class_2680 blockState) {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> blockState.method_26215();
                case 1 -> !blockState.method_26215();
            };
        }
    }
}

