/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools;

import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.utils.AutoCleaningDynamicTexture;
import imgui.ImGui;
import imgui.ImGuiListClipper;
import imgui.ImVec2;
import imgui.callback.ImListClipperCallback;
import imgui.type.ImString;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1011;
import org.jetbrains.annotations.Nullable;

public class ServerHeightmaps {
    private static String lastSearch = "";
    private static final ImString search = ImGuiHelper.createResizableString(32);
    private static final List<NamedImage> allHeightmaps = new ArrayList<NamedImage>();
    private static List<NamedImage> filteredHeightmaps = new ArrayList<NamedImage>();
    private static boolean addedNewHeightmap = false;
    private static final int ICON_SIZE = 100;

    public static void clear() {
        allHeightmaps.clear();
        filteredHeightmaps.clear();
        search.clear();
        lastSearch = "";
    }

    public static boolean hasHeightmaps() {
        return !allHeightmaps.isEmpty();
    }

    public static void add(String name, BufferedImage image) {
        if ((name = name.trim()).isEmpty()) {
            return;
        }
        String lowerName = name.toLowerCase(Locale.ROOT);
        allHeightmaps.removeIf(namedImage -> namedImage.name.toLowerCase(Locale.ROOT).equals(lowerName));
        allHeightmaps.add(new NamedImage(name, image));
        addedNewHeightmap = true;
    }

    public static void openHeightmapModal() {
        ImGui.openPopup("Server Heightmaps##ChooseServerHeightmap");
    }

    @Nullable
    public static BufferedImage showHeightmapModalIfOpen() {
        final AtomicReference result = new AtomicReference();
        ImGui.setNextWindowSizeConstraints(510.0f, 350.0f, 5000.0f, 3000.0f);
        if (ImGuiHelper.beginPopupModalCloseable("Server Heightmaps##ChooseServerHeightmap")) {
            ImGui.inputText("Search", search);
            String newSearch = ImGuiHelper.getString(search).toLowerCase(Locale.ROOT);
            if (newSearch.isBlank()) {
                lastSearch = newSearch;
                filteredHeightmaps = allHeightmaps;
            } else if (!newSearch.equals(lastSearch) || addedNewHeightmap) {
                lastSearch = newSearch;
                filteredHeightmaps = new ArrayList<NamedImage>();
                ArrayList<NamedImage> contains = new ArrayList<NamedImage>();
                for (NamedImage namedImage : allHeightmaps) {
                    String lowerName = namedImage.name.toLowerCase(Locale.ROOT);
                    if (lowerName.startsWith(newSearch)) {
                        filteredHeightmaps.add(namedImage);
                        continue;
                    }
                    if (!lowerName.contains(newSearch)) continue;
                    contains.add(namedImage);
                }
                filteredHeightmaps.addAll(contains);
            }
            addedNewHeightmap = false;
            if (ImGui.beginChild("Browser")) {
                final int countPerRow = Math.max(1, (int)Math.floor((ImGui.getContentRegionAvailX() + ImGui.getStyle().getItemSpacingX() + 2.0f) / (100.0f + ImGui.getStyle().getItemSpacingX())));
                float itemHeightWithSpacing = 100.0f + ImGui.getTextLineHeightWithSpacing() * 2.0f + 7.0f + ImGui.getStyle().getItemSpacingY();
                int vcount = (int)Math.ceil((float)filteredHeightmaps.size() / (float)countPerRow);
                ImGuiListClipper.forEach(vcount, (int)itemHeightWithSpacing, new ImListClipperCallback(){

                    @Override
                    public void accept(int index) {
                        int from = index * countPerRow;
                        int to = Math.min(from + countPerRow, filteredHeightmaps.size());
                        for (int i = from; i < to; ++i) {
                            NamedImage namedImage = filteredHeightmaps.get(i);
                            ImGui.pushID(i);
                            if (ServerHeightmaps.renderItem(namedImage, i == to - 1)) {
                                result.set(namedImage.bufferedImage);
                            }
                            ImGui.popID();
                            if (i >= to - 1) continue;
                            ImGui.sameLine();
                        }
                    }
                });
            }
            ImGui.endChild();
            if (result.get() != null) {
                ImGui.closeCurrentPopup();
            }
            ImGuiHelper.endPopupModalCloseable();
        }
        return (BufferedImage)result.get();
    }

    private static boolean renderItem(NamedImage namedImage, boolean last) {
        String textToRender = namedImage.name.trim();
        if (textToRender.isBlank()) {
            textToRender = "Unnamed Heightmap";
        }
        ImVec2 textSize = new ImVec2();
        ImGui.calcTextSize(textSize, textToRender, 100.0f);
        float childHeight = 100.0f + ImGui.getTextLineHeightWithSpacing() * 2.0f + 7.0f;
        boolean opened = false;
        if (ImGui.beginChild("", 100.0f, childHeight, false, 59)) {
            ImGuiHelper.pushStyleVar(11, 0.0f, 0.0f);
            opened = ImGui.imageButton(namedImage.texture.method_4624(), 96.0f, 96.0f, 0.0f, 0.0f, 1.0f, 1.0f, 2);
            ImVec2 cursorPos = ImGui.getCursorPos();
            ImGui.setCursorPos(cursorPos.x + (100.0f - textSize.x) / 2.0f, cursorPos.y);
            ImGui.pushTextWrapPos(100.0f);
            ImGui.text(textToRender);
            ImGui.popTextWrapPos();
            if (textSize.y > ImGui.getTextLineHeight() + ImGui.getTextLineHeightWithSpacing() && ImGui.isItemHovered()) {
                ImGui.beginTooltip();
                ImGui.pushTextWrapPos((float)ImGui.getFontSize() * 20.0f);
                ImGui.textUnformatted(textToRender);
                ImGui.popTextWrapPos();
                ImGui.endTooltip();
            }
            ImGuiHelper.popStyleVar();
        }
        ImGui.endChild();
        return opened;
    }

    private record NamedImage(String name, BufferedImage bufferedImage, AutoCleaningDynamicTexture texture) {
        public NamedImage(String name, BufferedImage bufferedImage) {
            this(name, bufferedImage, NamedImage.createFromBufferedImage(bufferedImage));
        }

        private static AutoCleaningDynamicTexture createFromBufferedImage(BufferedImage bufferedImage) {
            int width = bufferedImage.getWidth();
            int height = bufferedImage.getHeight();
            class_1011 nativeImage = new class_1011(width, height, true);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int argb = bufferedImage.getRGB(x, y);
                    nativeImage.method_61941(x, y, argb);
                }
            }
            return new AutoCleaningDynamicTexture(nativeImage);
        }
    }
}

