/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.modify;

import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.funcinterfaces.TriIntPredicate;
import com.moulberry.axiom.rasterization.Rasterization2D;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.utils.BlockHelper;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2680;

public class ModifyRevolve {
    public static ChunkedBlockRegion revolve(class_1937 level, SelectionBuffer selectionBuffer, class_2338 point, double angle, int axis, class_2338 translation, TriIntPredicate mask) {
        if (selectionBuffer instanceof SelectionBuffer.AABB) {
            SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)selectionBuffer;
            return ModifyRevolve.revolveAABB(level, aabb, point, angle, axis, translation, mask);
        }
        if (selectionBuffer instanceof SelectionBuffer.Set) {
            SelectionBuffer.Set set = (SelectionBuffer.Set)selectionBuffer;
            return ModifyRevolve.revolveSet(level, set, point, angle, axis, translation, mask);
        }
        return new ChunkedBlockRegion();
    }

    private static ChunkedBlockRegion revolveAABB(class_1937 level, SelectionBuffer.AABB aabb, class_2338 point, double angle, int axis, class_2338 translation, TriIntPredicate mask) {
        int minX = aabb.min().method_10263();
        int minY = aabb.min().method_10264();
        int minZ = aabb.min().method_10260();
        int maxX = aabb.max().method_10263();
        int maxY = aabb.max().method_10264();
        int maxZ = aabb.max().method_10260();
        int revolveX = point.method_10263();
        int revolveY = point.method_10264();
        int revolveZ = point.method_10260();
        ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
        int negativeMult = angle < 0.0 ? -1 : 1;
        angle = Math.abs(angle);
        boolean translate = !translation.equals((Object)class_2338.field_10980);
        int duplicates = 0;
        while (Math.toDegrees(angle) > 360.5) {
            angle -= Math.PI * 2;
            ++duplicates;
        }
        int duplicatesF = translate ? duplicates : 0;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    int dx;
                    double toAngle;
                    double fromAngle;
                    int radius;
                    int dz;
                    class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                    if (blockState.method_26215()) continue;
                    if (axis == 0) {
                        int dy = y - revolveY;
                        dz = z - revolveZ;
                        int finalX = x;
                        radius = (int)Math.round(Math.sqrt(dy * dy + dz * dz));
                        fromAngle = (double)negativeMult * Math.atan2(dy, dz);
                        toAngle = fromAngle + angle;
                        Rasterization2D.ddaCircle(radius, (y1, z1) -> {
                            double blockAngle = (double)negativeMult * Math.atan2(y1, z1);
                            if (blockAngle <= fromAngle) {
                                blockAngle += Math.PI * 2;
                            }
                            class_2470 rotation = BlockHelper.rotationFromRadians(blockAngle - fromAngle);
                            class_2680 rotated = BlockHelper.rotateX(blockState, rotation);
                            for (int i = 0; i <= duplicatesF; ++i) {
                                if (i == duplicatesF && blockAngle > toAngle + 1.0E-5) {
                                    return;
                                }
                                int x1 = 0;
                                if (translate) {
                                    double percentage = (blockAngle + (double)i * Math.PI * 2.0 - fromAngle) / (toAngle + (double)duplicatesF * Math.PI * 2.0 - fromAngle);
                                    x1 += (int)Math.round((double)translation.method_10263() * percentage);
                                    y1 += (int)Math.round((double)translation.method_10264() * percentage);
                                    z1 += (int)Math.round((double)translation.method_10260() * percentage);
                                }
                                if (!mask.test(finalX + x1, revolveY + y1, revolveZ + z1)) continue;
                                chunkedBlockRegion.addBlockWithoutDirty(finalX + x1, revolveY + y1, revolveZ + z1, rotated);
                            }
                        });
                        continue;
                    }
                    if (axis == 1) {
                        dx = x - revolveX;
                        dz = z - revolveZ;
                        int finalY = y;
                        radius = (int)Math.round(Math.sqrt(dx * dx + dz * dz));
                        fromAngle = (double)negativeMult * Math.atan2(dx, -dz);
                        toAngle = fromAngle + angle;
                        Rasterization2D.ddaCircle(radius, (x1, z1) -> {
                            double blockAngle = (double)negativeMult * Math.atan2(x1, -z1);
                            if (blockAngle <= fromAngle) {
                                blockAngle += Math.PI * 2;
                            }
                            class_2470 rotation = BlockHelper.rotationFromRadians(blockAngle - fromAngle);
                            class_2680 rotated = BlockHelper.rotateY(blockState, rotation);
                            for (int i = 0; i <= duplicatesF; ++i) {
                                if (i == duplicatesF && blockAngle > toAngle + 1.0E-5) {
                                    return;
                                }
                                int y1 = 0;
                                if (translate) {
                                    double percentage = (blockAngle + (double)i * Math.PI * 2.0 - fromAngle) / (toAngle + (double)duplicatesF * Math.PI * 2.0 - fromAngle);
                                    x1 += (int)Math.round((double)translation.method_10263() * percentage);
                                    y1 += (int)Math.round((double)translation.method_10264() * percentage);
                                    z1 += (int)Math.round((double)translation.method_10260() * percentage);
                                }
                                if (!mask.test(revolveX + x1, finalY + y1, revolveZ + z1)) continue;
                                chunkedBlockRegion.addBlockWithoutDirty(revolveX + x1, finalY + y1, revolveZ + z1, rotated);
                            }
                        });
                        continue;
                    }
                    if (axis != 2) continue;
                    dx = x - revolveX;
                    int dy = y - revolveY;
                    int finalZ = z;
                    radius = (int)Math.round(Math.sqrt(dx * dx + dy * dy));
                    fromAngle = (double)negativeMult * Math.atan2(dx, dy);
                    toAngle = fromAngle + angle;
                    Rasterization2D.ddaCircle(radius, (x1, y1) -> {
                        double blockAngle = (double)negativeMult * Math.atan2(x1, y1);
                        if (blockAngle <= fromAngle) {
                            blockAngle += Math.PI * 2;
                        }
                        class_2470 rotation = BlockHelper.rotationFromRadians(blockAngle - fromAngle);
                        class_2680 rotated = BlockHelper.rotateZ(blockState, rotation);
                        for (int i = 0; i <= duplicatesF; ++i) {
                            if (i == duplicatesF && blockAngle > toAngle + 1.0E-5) {
                                return;
                            }
                            int z1 = 0;
                            if (translate) {
                                double percentage = (blockAngle + (double)i * Math.PI * 2.0 - fromAngle) / (toAngle + (double)duplicatesF * Math.PI * 2.0 - fromAngle);
                                x1 += (int)Math.round((double)translation.method_10263() * percentage);
                                y1 += (int)Math.round((double)translation.method_10264() * percentage);
                                z1 += (int)Math.round((double)translation.method_10260() * percentage);
                            }
                            if (!mask.test(revolveX + x1, revolveY + y1, finalZ + z1)) continue;
                            chunkedBlockRegion.addBlockWithoutDirty(revolveX + x1, revolveY + y1, finalZ + z1, rotated);
                        }
                    });
                }
            }
        }
        return chunkedBlockRegion;
    }

    private static ChunkedBlockRegion revolveSet(class_1937 level, SelectionBuffer.Set set, class_2338 point, double angle, int axis, class_2338 translation, TriIntPredicate mask) {
        int revolveX = point.method_10263();
        int revolveY = point.method_10264();
        int revolveZ = point.method_10260();
        ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
        angle = Math.abs(angle);
        boolean translate = !translation.equals((Object)class_2338.field_10980);
        int duplicates = 0;
        while (Math.toDegrees(angle) > 360.5) {
            angle -= Math.PI * 2;
            ++duplicates;
        }
        double angleF = angle;
        int duplicatesF = translate ? duplicates : 0;
        class_2470[] rotations = class_2470.values();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        set.forEach((x, y, z) -> {
            class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
            if (blockState.method_26215()) {
                return;
            }
            if (axis == 0) {
                int dy = y - revolveY;
                int dz = z - revolveZ;
                int finalX = x;
                int radius = (int)Math.round(Math.sqrt(dy * dy + dz * dz));
                double fromAngle = Math.atan2(dy, dz);
                double toAngle = fromAngle + angleF;
                Rasterization2D.ddaCircle(radius, (y1, z1) -> {
                    double blockAngle = Math.atan2(y1, z1);
                    if (blockAngle <= fromAngle) {
                        blockAngle += Math.PI * 2;
                    }
                    for (int i = 0; i <= duplicatesF; ++i) {
                        if (i == duplicatesF && blockAngle > toAngle + 1.0E-5) {
                            return;
                        }
                        int x1 = 0;
                        if (translate) {
                            double percentage = (blockAngle + (double)i * Math.PI * 2.0 - fromAngle) / (toAngle + (double)duplicatesF * Math.PI * 2.0 - fromAngle);
                            x1 += (int)Math.round((double)translation.method_10263() * percentage);
                            y1 += (int)Math.round((double)translation.method_10264() * percentage);
                            z1 += (int)Math.round((double)translation.method_10260() * percentage);
                        }
                        if (!mask.test(finalX + x1, revolveY + y1, revolveZ + z1)) continue;
                        chunkedBlockRegion.addBlockWithoutDirty(finalX + x1, revolveY + y1, revolveZ + z1, blockState);
                    }
                });
            } else if (axis == 1) {
                int dx = x - revolveX;
                int dz = z - revolveZ;
                int finalY = y;
                int radius = (int)Math.round(Math.sqrt(dx * dx + dz * dz));
                double fromAngle = Math.atan2(dx, -dz);
                double toAngle = fromAngle + angleF;
                Rasterization2D.ddaCircle(radius, (x1, z1) -> {
                    double blockAngle = Math.atan2(x1, -z1);
                    if (blockAngle <= fromAngle) {
                        blockAngle += Math.PI * 2;
                    }
                    int rotationCount = (int)Math.round((blockAngle - fromAngle) / 1.5707963267948966);
                    if ((rotationCount %= 4) < 0) {
                        rotationCount += 4;
                    }
                    class_2680 rotated = BlockHelper.rotateY(blockState, rotations[rotationCount]);
                    for (int i = 0; i <= duplicatesF; ++i) {
                        if (i == duplicatesF && blockAngle > toAngle + 1.0E-5) {
                            return;
                        }
                        int y1 = 0;
                        if (translate) {
                            double percentage = (blockAngle + (double)i * Math.PI * 2.0 - fromAngle) / (toAngle + (double)duplicatesF * Math.PI * 2.0 - fromAngle);
                            x1 += (int)Math.round((double)translation.method_10263() * percentage);
                            y1 += (int)Math.round((double)translation.method_10264() * percentage);
                            z1 += (int)Math.round((double)translation.method_10260() * percentage);
                        }
                        if (!mask.test(revolveX + x1, finalY + y1, revolveZ + z1)) continue;
                        chunkedBlockRegion.addBlockWithoutDirty(revolveX + x1, finalY + y1, revolveZ + z1, rotated);
                    }
                });
            } else if (axis == 2) {
                int dx = x - revolveX;
                int dy = y - revolveY;
                int finalZ = z;
                int radius = (int)Math.round(Math.sqrt(dx * dx + dy * dy));
                double fromAngle = Math.atan2(dx, dy);
                double toAngle = fromAngle + angleF;
                Rasterization2D.ddaCircle(radius, (x1, y1) -> {
                    float blockAngle = (float)Math.atan2(x1, y1);
                    if ((double)blockAngle <= fromAngle) {
                        blockAngle = (float)((double)blockAngle + Math.PI * 2);
                    }
                    for (int i = 0; i <= duplicatesF; ++i) {
                        if (i == duplicatesF && (double)blockAngle > toAngle + 1.0E-5) {
                            return;
                        }
                        int z1 = 0;
                        if (translate) {
                            double percentage = ((double)blockAngle + (double)i * Math.PI * 2.0 - fromAngle) / (toAngle + (double)duplicatesF * Math.PI * 2.0 - fromAngle);
                            x1 += (int)Math.round((double)translation.method_10263() * percentage);
                            y1 += (int)Math.round((double)translation.method_10264() * percentage);
                            z1 += (int)Math.round((double)translation.method_10260() * percentage);
                        }
                        if (!mask.test(revolveX + x1, revolveY + y1, finalZ + z1)) continue;
                        chunkedBlockRegion.addBlockWithoutDirty(revolveX + x1, revolveY + y1, finalZ + z1, blockState);
                    }
                });
            }
        });
        return chunkedBlockRegion;
    }
}

