/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.terraform.terrain;

import com.moulberry.axiom.collections.Position2ByteMap;
import com.moulberry.axiom.tools.terraform.ClentaminatorPaintjob;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2680;

public class DirtGroundTerrainPaintjob
implements ClentaminatorPaintjob {
    private static final class_2680 COARSE_DIRT = class_2246.field_10253.method_9564();
    private static final class_2680 DIRT = class_2246.field_10566.method_9564();
    private static final class_2680 PACKED_MUD = class_2246.field_37556.method_9564();
    private final Position2ByteMap wave = new Position2ByteMap(3);

    @Override
    public class_2680 paint(class_1922 blockGetter, class_2680 current, int x, int y, int z) {
        byte waveValue = this.wave.get(x, y, z);
        if (waveValue == 0) {
            return DIRT;
        }
        if (waveValue == 1) {
            if (ThreadLocalRandom.current().nextBoolean()) {
                this.propagate(x, y, z, (byte)1);
                return PACKED_MUD;
            }
            return DIRT;
        }
        if (waveValue == 2) {
            if (ThreadLocalRandom.current().nextBoolean()) {
                this.propagate(x, y, z, (byte)2);
                return COARSE_DIRT;
            }
            return DIRT;
        }
        int random2 = ThreadLocalRandom.current().nextInt(4);
        if (random2 == 0) {
            this.propagate(x, y, z, (byte)1);
            return PACKED_MUD;
        }
        if (random2 == 1) {
            this.propagate(x, y, z, (byte)2);
            return COARSE_DIRT;
        }
        return DIRT;
    }

    private void propagate(int x, int y, int z, byte v) {
        for (int xo = -1; xo <= 1; ++xo) {
            for (int yo = -1; yo <= 1; ++yo) {
                for (int zo = -1; zo <= 1; ++zo) {
                    if (xo != 0 && zo != 0) continue;
                    this.wave.binaryAnd(x + xo, y + yo, z + zo, v);
                }
            }
        }
    }
}

