/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.utils;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.editor.DragDropPayloads;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.palette.CustomBlockStateOrTombstone;
import com.moulberry.axiom.editor.palette.EditorPalette;
import com.moulberry.axiom.editor.widgets.BlockStateWidget;
import com.moulberry.axiom.editor.widgets.SelectBlockWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.utils.BlockManipulation;
import imgui.ImGui;
import imgui.ImVec2;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;

public record BlockWithFloat(CustomBlockState blockState, float[] percentage, @Nullable Set<class_2769<?>> randomProperties) {
    private static DragDropPayloads.NoisePainterBlock DRAG_DROP_PAYLOAD = null;
    private static final List<class_2680> DEFAULT_BLOCKS = List.of(class_2246.field_10340.method_9564(), class_2246.field_10474.method_9564(), class_2246.field_10508.method_9564(), class_2246.field_10115.method_9564(), class_2246.field_10566.method_9564());
    private static final LoadingCache<BlockWithFloat, CustomBlockState> RANDOMIZED_STATE_CACHE = Caffeine.newBuilder().expireAfterWrite(250L, TimeUnit.MILLISECONDS).build(blockWithFloat -> BlockManipulation.applyRandomProperties(blockWithFloat.blockState, blockWithFloat.randomProperties));

    public static boolean ensureFilledToMinimum(List<BlockWithFloat> blockWithFloats, int min2) {
        boolean changed = false;
        while (blockWithFloats.size() < min2) {
            BlockWithFloat.addNew(blockWithFloats, (CustomBlockState)DEFAULT_BLOCKS.get(blockWithFloats.size() % DEFAULT_BLOCKS.size()));
            changed = true;
        }
        return changed;
    }

    public static boolean renderList(List<BlockWithFloat> blockThresholds, SelectBlockWidget selectBlockWidget, ExtraRenderType extraRenderType, int min2, boolean allowRandomProperties) {
        CustomBlockState dragDropped;
        boolean changed = BlockWithFloat.ensureFilledToMinimum(blockThresholds, min2);
        float itemWidth = ImGui.calcItemWidth();
        int scaledSize = (int)(32.0f * EditorUI.getUiScale());
        int removeBlockThreshold = -1;
        float spacingY = ImGui.getStyle().getItemSpacingY();
        boolean canRemoveABlockThreshold = blockThresholds.size() > min2;
        ImVec2 startPosition = ImGui.getCursorScreenPos();
        for (int i = 0; i < blockThresholds.size(); ++i) {
            String text;
            CustomBlockState dragDropped2;
            DragDropPayloads.NoisePainterBlock noisePainterBlock;
            ImGui.pushID(i);
            BlockWithFloat blockWithFloat = blockThresholds.get(i);
            boolean hasNoisePainterBlockDragDropTarget = false;
            ImVec2 position = ImGui.getCursorScreenPos();
            ImGui.setCursorScreenPos(ImGui.getWindowPosX(), position.y - spacingY);
            ImGui.dummy(itemWidth, (float)scaledSize / 2.0f + spacingY);
            if (ImGui.beginDragDropTarget()) {
                noisePainterBlock = (DragDropPayloads.NoisePainterBlock)ImGui.acceptDragDropPayload("NoisePainterBlock", 3072);
                if (noisePainterBlock != null) {
                    hasNoisePainterBlockDragDropTarget = true;
                    if (noisePainterBlock.index() != i - 1 && noisePainterBlock.index() != i) {
                        ImGui.getWindowDrawList().addRectFilled(position.x, position.y - spacingY / 2.0f - 1.0f, position.x + ImGui.getContentRegionAvailX(), position.y - spacingY / 2.0f + 1.0f, ImGui.getColorU32(50));
                        if (ImGui.isMouseReleased(0)) {
                            if (noisePainterBlock.index() < blockThresholds.size()) {
                                blockThresholds.remove(noisePainterBlock.index());
                            }
                            if (i > 0 && i > noisePainterBlock.index()) {
                                blockThresholds.add(i - 1, noisePainterBlock.block());
                            } else {
                                blockThresholds.add(i, noisePainterBlock.block());
                            }
                        }
                    }
                }
                ImGui.endDragDropTarget();
            }
            if (!hasNoisePainterBlockDragDropTarget) {
                ImGui.setCursorScreenPos(ImGui.getWindowPosX(), position.y + (float)scaledSize / 2.0f);
                ImGui.dummy(itemWidth, (float)scaledSize / 2.0f);
                if (ImGui.beginDragDropTarget()) {
                    noisePainterBlock = (DragDropPayloads.NoisePainterBlock)ImGui.acceptDragDropPayload("NoisePainterBlock", 3072);
                    if (noisePainterBlock != null) {
                        hasNoisePainterBlockDragDropTarget = true;
                        if (noisePainterBlock.index() != i && noisePainterBlock.index() != i + 1) {
                            ImGui.getWindowDrawList().addRectFilled(position.x, position.y + (float)scaledSize + spacingY / 2.0f - 1.0f, position.x + ImGui.getContentRegionAvailX(), position.y + (float)scaledSize + spacingY / 2.0f + 1.0f, ImGui.getColorU32(50));
                            if (ImGui.isMouseReleased(0)) {
                                if (noisePainterBlock.index() < blockThresholds.size()) {
                                    blockThresholds.remove(noisePainterBlock.index());
                                }
                                if (i + 1 > noisePainterBlock.index()) {
                                    blockThresholds.add(i, noisePainterBlock.block());
                                } else {
                                    blockThresholds.add(i + 1, noisePainterBlock.block());
                                }
                            }
                        }
                    }
                    ImGui.endDragDropTarget();
                }
            }
            ImGui.setCursorScreenPos(position.x, position.y);
            CustomBlockState visualBlockState = blockWithFloat.randomProperties != null ? RANDOMIZED_STATE_CACHE.get(blockWithFloat) : blockWithFloat.blockState;
            int blockButtonClick = ImGuiHelper.blockStateButtonLeftOrRightClick(visualBlockState, i, scaledSize);
            if (!blockWithFloat.blockState.getProperties().isEmpty()) {
                ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.block_list.right_click_to_edit_properties"));
                if ((blockButtonClick & 2) != 0) {
                    ImGui.openPopup("##Properties");
                }
                if (ImGui.beginPopup("##Properties")) {
                    Set<class_2769<?>> newRandomProperties;
                    BlockStateWidget blockStateWidget = new BlockStateWidget(blockWithFloat.blockState);
                    blockStateWidget.allowRandomProperties = allowRandomProperties;
                    blockStateWidget.setRandomizedProperties(blockWithFloat.randomProperties);
                    ImGui.textDisabled(AxiomI18n.get("axiom.widget.block_properties"));
                    blockStateWidget.renderPropertySettings("BlockListProperties", false);
                    CustomBlockState newState = blockStateWidget.getBlockState();
                    Set<class_2769<?>> set = newRandomProperties = allowRandomProperties ? blockStateWidget.getRandomProperties() : null;
                    if (newState != blockWithFloat.blockState || !Objects.equals(newRandomProperties, blockWithFloat.randomProperties)) {
                        changed = true;
                        blockThresholds.set(i, new BlockWithFloat(newState, blockWithFloat.percentage(), blockStateWidget.getRandomProperties()));
                    }
                    ImGui.endPopup();
                }
            }
            if (!hasNoisePainterBlockDragDropTarget && (dragDropped2 = ImGuiHelper.blockStateDragDropTarget()) != null) {
                blockThresholds.set(i, new BlockWithFloat(dragDropped2, blockWithFloat.percentage(), null));
            }
            if (ImGui.isItemHovered()) {
                ImGui.setMouseCursor(7);
            }
            if (ImGui.beginDragDropSource()) {
                DRAG_DROP_PAYLOAD = new DragDropPayloads.NoisePainterBlock(i, blockWithFloat);
                ImGui.setDragDropPayload("NoisePainterBlock", DRAG_DROP_PAYLOAD);
                ImVec2 originalPos = ImGui.getCursorScreenPos();
                ImGuiHelper.drawBlockState(ImGui.getForegroundDrawList(), DRAG_DROP_PAYLOAD.block().blockState(), ImGui.getCursorScreenPosX(), ImGui.getCursorScreenPosY(), scaledSize);
                text = switch (extraRenderType.ordinal()) {
                    default -> throw new IncompatibleClassChangeError();
                    case 0 -> String.format("%.1f%%", Float.valueOf(DRAG_DROP_PAYLOAD.block().percentage()[0]));
                    case 1 -> String.format("%.3f", Float.valueOf(DRAG_DROP_PAYLOAD.block().percentage()[0] / 100.0f));
                    case 2 -> DRAG_DROP_PAYLOAD.block().blockState().getCustomBlock().axiom$getIdentifier().toString();
                };
                ImGui.getWindowDrawList().addText(originalPos.x + (float)scaledSize + ImGui.getStyle().getItemSpacingX(), originalPos.y + ((float)scaledSize - ImGui.getTextLineHeight()) / 2.0f, ImGui.getColorU32(0), text);
                ImGui.dummy((float)scaledSize + ImGui.getStyle().getItemSpacingX() + ImGuiHelper.calcTextWidth(text), scaledSize);
                ImGui.endDragDropSource();
            }
            ImGui.sameLine();
            ImGuiHelper.pushStyleVar(11, 4.0f, 8.0f * EditorUI.getUiScale());
            float sliderSize = Math.min(ImGui.getContentRegionAvailX(), itemWidth) - (float)scaledSize - 4.0f;
            switch (extraRenderType.ordinal()) {
                case 0: {
                    ImGui.setNextItemWidth(sliderSize);
                    changed |= ImGui.sliderFloat("##BlockThreshold" + i, blockWithFloat.percentage(), 0.0f, 100.0f, "%.1f%%", 16);
                    break;
                }
                case 1: {
                    float[] threshold = new float[]{blockWithFloat.percentage()[0] / 100.0f};
                    ImGui.setNextItemWidth(sliderSize);
                    changed |= ImGui.sliderFloat("##BlockThreshold" + i, threshold, 0.0f, 1.0f, "%.3f", 16);
                    blockWithFloat.percentage()[0] = threshold[0] * 100.0f;
                    break;
                }
                case 2: {
                    text = blockWithFloat.blockState().getCustomBlock().axiom$getIdentifier().toString();
                    ImGui.getWindowDrawList().addText(position.x + (float)scaledSize + ImGui.getStyle().getItemSpacingX(), position.y + ((float)scaledSize - ImGui.getTextLineHeight()) / 2.0f, ImGui.getColorU32(0), text);
                    ImGui.dummy(sliderSize, 0.0f);
                }
            }
            ImGuiHelper.popStyleVar();
            if (canRemoveABlockThreshold) {
                float previousY = ImGui.getCursorPosY();
                ImGui.sameLine();
                if (ImGui.button("-##RemoveBlock" + i, scaledSize, scaledSize)) {
                    removeBlockThreshold = i;
                }
                ImGui.setCursorPosY(previousY);
            }
            if ((blockButtonClick & 1) != 0) {
                selectBlockWidget.open(i);
            }
            selectBlockWidget.render(AxiomI18n.get("axiom.widget.select_block"), EditorUI.getBlockList(), i);
            CustomBlockState result = selectBlockWidget.getResultState();
            if (result != null) {
                blockThresholds.set(i, new BlockWithFloat(result, blockWithFloat.percentage(), null));
                changed = true;
            }
            ImGui.popID();
        }
        if (removeBlockThreshold >= 0) {
            blockThresholds.remove(removeBlockThreshold);
            changed = true;
        }
        ImVec2 beforePos = ImGui.getCursorScreenPos();
        ImGui.setCursorScreenPos(beforePos.x, startPosition.y);
        ImGui.dummy(ImGui.getContentRegionAvailX(), beforePos.y - startPosition.y - ImGui.getStyle().getItemSpacingY());
        if (ImGui.beginDragDropTarget()) {
            EditorPalette droppedPalette = ImGui.acceptDragDropPayload(EditorPalette.class);
            if (droppedPalette != null) {
                ArrayList<CustomBlockState> customBlockStates = new ArrayList<CustomBlockState>();
                for (CustomBlockStateOrTombstone block : droppedPalette.getBlocks()) {
                    if (!(block instanceof CustomBlockState)) continue;
                    CustomBlockState customBlockState = (CustomBlockState)block;
                    customBlockStates.add(customBlockState);
                }
                if (!customBlockStates.isEmpty()) {
                    blockThresholds.clear();
                    float amount = 100.0f / (float)customBlockStates.size();
                    for (CustomBlockState customBlockState : customBlockStates) {
                        blockThresholds.add(new BlockWithFloat(customBlockState, new float[]{amount}, null));
                    }
                }
            }
            ImGui.endDragDropTarget();
        }
        ImGui.setCursorScreenPos(beforePos.x, beforePos.y);
        if (ImGui.button("+##AddBlock", scaledSize, scaledSize)) {
            BlockWithFloat.addNew(blockThresholds, (CustomBlockState)DEFAULT_BLOCKS.get(blockThresholds.size() % DEFAULT_BLOCKS.size()));
            changed = true;
        }
        if ((dragDropped = ImGuiHelper.blockStateDragDropTarget()) != null) {
            BlockWithFloat.addNew(blockThresholds, dragDropped);
            changed = true;
        }
        return changed;
    }

    public static void addNew(List<BlockWithFloat> list, CustomBlockState blockState) {
        float total = 0.0f;
        for (BlockWithFloat blockWithFloat : list) {
            total += blockWithFloat.percentage[0];
        }
        if (total < 99.0f) {
            list.add(new BlockWithFloat(blockState, new float[]{100.0f - total}, null));
            return;
        }
        float factor = (float)list.size() / (float)(list.size() + 1);
        for (BlockWithFloat blockWithFloat : list) {
            blockWithFloat.percentage[0] = blockWithFloat.percentage[0] * factor;
        }
        list.add(new BlockWithFloat(blockState, new float[]{100.0f / (float)(list.size() + 1)}, null));
    }

    public static enum ExtraRenderType {
        PERCENTAGE,
        FLOAT,
        BLOCKNAME;

    }
}

