/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.utils;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.ServerConfig;
import com.moulberry.axiom.collections.Position2ObjectMap;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.world_modification.BlockBuffer;
import com.moulberry.axiom.world_modification.BlockOrBiomeBuffer;
import com.moulberry.axiom.world_modification.ClientBlockEntitySerializer;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiom.world_modification.HistoryEntry;
import com.moulberry.axiom.world_modification.undo.AdditionalUndoOperation;
import it.unimi.dsi.fastutil.longs.Long2LongFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_7225;

public class RegionHelper {
    public static void pushBlockRegionChange(ChunkedBlockRegion blockRegion, String historyDescription) {
        RegionHelper.pushBlockRegionChange(blockRegion, historyDescription, 0);
    }

    public static void pushBlockRegionChange(ChunkedBlockRegion blockRegion, String historyDescription, int modifiers) {
        RegionHelper.pushBlockRegionChange(blockRegion, null, historyDescription, modifiers);
    }

    public static void pushBlockRegionChange(ChunkedBlockRegion blockRegion, Long2ObjectMap<CompressedBlockEntity> blockEntities, String historyDescription, int modifiers) {
        RegionHelper.pushBlockRegionChange(blockRegion, blockEntities, historyDescription, modifiers, null);
    }

    public static void pushBlockRegionChange(ChunkedBlockRegion blockRegion, Long2ObjectMap<CompressedBlockEntity> blockEntities, String historyDescription, int modifiers, AdditionalUndoOperation additionalUndoOperation) {
        boolean keepExisting;
        if (blockRegion.isEmpty()) {
            return;
        }
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        class_2338 center = blockRegion.getCenter();
        LongOpenHashSet needNbt = new LongOpenHashSet();
        LongOpenHashSet needChunks = new LongOpenHashSet();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        BlockBuffer forwards = new BlockBuffer();
        BlockBuffer backwards = new BlockBuffer();
        boolean bl = keepExisting = (modifiers & HistoryEntry.MODIFIER_KEEP_EXISTING) != 0;
        if (keepExisting) {
            modifiers &= ~HistoryEntry.MODIFIER_KEEP_EXISTING;
        }
        int modifiersFinal = modifiers;
        Long2ObjectOpenHashMap containers = new Long2ObjectOpenHashMap();
        LongIterator longIterator = blockRegion.chunkKeySet().longIterator();
        while (longIterator.hasNext()) {
            long pos = longIterator.nextLong();
            int cx = class_2338.method_10061((long)pos);
            int cy = class_2338.method_10071((long)pos);
            int cz = class_2338.method_10083((long)pos);
            int sectionIndex = world.method_31603(cy);
            if (sectionIndex < 0 || sectionIndex >= world.method_32890()) continue;
            class_2818 chunk = (class_2818)world.method_8402(cx, cz, class_2806.field_12803, false);
            if (chunk == null) {
                needChunks.add(pos);
                continue;
            }
            class_2826 section = chunk.method_38259(sectionIndex);
            containers.put(pos, (Object)section.method_12265());
        }
        ServerConfig serverConfig = Axiom.getInstance().serverConfig;
        containers.forEach((arg_0, arg_1) -> RegionHelper.lambda$pushBlockRegionChange$0(blockRegion, forwards, backwards, keepExisting, serverConfig, (LongSet)needNbt, world, mutable, baos, arg_0, arg_1));
        if (needNbt.isEmpty() && needChunks.isEmpty()) {
            if (blockEntities != null) {
                for (Long2ObjectMap.Entry entry : blockEntities.long2ObjectEntrySet()) {
                    int z;
                    int y;
                    long pos = entry.getLongKey();
                    int x = class_2338.method_10061((long)pos);
                    if (forwards.get(x, y = class_2338.method_10071((long)pos), z = class_2338.method_10083((long)pos)) == BlockBuffer.EMPTY_STATE) continue;
                    forwards.putBlockEntity(x, y, z, (CompressedBlockEntity)entry.getValue());
                }
            }
            Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(forwards, backwards, center, historyDescription, modifiers, additionalUndoOperation));
        } else {
            Position2ObjectMap<class_2680> copiedBlocks = blockRegion.copyBlockData();
            Dispatcher.requestChunkData((LongSet)needNbt, (LongSet)needChunks, true, (compressedBlockEntities, chunkSections) -> {
                class_2680 air = class_2246.field_10124.method_9564();
                Long2ObjectOpenHashMap copiedBlockEntities = blockEntities == null ? null : new Long2ObjectOpenHashMap(blockEntities);
                chunkSections.forEach((cpos, container) -> {
                    int cz;
                    int cy;
                    int cx = class_2338.method_10061((long)cpos);
                    class_2680[] blocks = (class_2680[])copiedBlocks.getChunk(cx, cy = class_2338.method_10071((long)cpos), cz = class_2338.method_10083((long)cpos));
                    if (blocks == null) {
                        return;
                    }
                    class_2841<class_2680> forwardsContainer = forwards.getOrCreateSection((long)cpos);
                    class_2841<class_2680> backwardsContainer = backwards.getOrCreateSection((long)cpos);
                    int index = 0;
                    for (int z = 0; z < 16; ++z) {
                        for (int y = 0; y < 16; ++y) {
                            for (int x = 0; x < 16; ++x) {
                                class_2680 existingState;
                                class_2680 pasteState;
                                if ((pasteState = blocks[index++]) == null) continue;
                                class_2680 class_26802 = existingState = container == null ? air : (class_2680)container.method_12321(x, y, z);
                                if (keepExisting && !existingState.method_26215()) continue;
                                forwardsContainer.method_16678(x, y, z, (Object)pasteState);
                                backwardsContainer.method_16678(x, y, z, (Object)existingState);
                            }
                        }
                    }
                });
                compressedBlockEntities.forEach((pos, compressedBlockEntity) -> {
                    int z;
                    int y;
                    int x = class_2338.method_10061((long)pos);
                    if (backwards.get(x, y = class_2338.method_10071((long)pos), z = class_2338.method_10083((long)pos)) != BlockBuffer.EMPTY_STATE) {
                        backwards.putBlockEntity(x, y, z, (CompressedBlockEntity)compressedBlockEntity);
                    }
                });
                if (copiedBlockEntities != null) {
                    for (Long2ObjectMap.Entry entry : copiedBlockEntities.long2ObjectEntrySet()) {
                        int z;
                        int y;
                        long pos2 = entry.getLongKey();
                        int x = class_2338.method_10061((long)pos2);
                        if (forwards.get(x, y = class_2338.method_10071((long)pos2), z = class_2338.method_10083((long)pos2)) == BlockBuffer.EMPTY_STATE) continue;
                        forwards.putBlockEntity(x, y, z, (CompressedBlockEntity)entry.getValue());
                    }
                }
                Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(forwards, backwards, center, historyDescription, modifiersFinal, additionalUndoOperation));
            });
        }
    }

    public static void pushBlockBufferChange(BlockBuffer forwards, class_2338 center, String historyDescription, AdditionalUndoOperation additionalUndoOperation) {
        RegionHelper.pushBlockBufferChange(forwards, center, historyDescription, 0, additionalUndoOperation);
    }

    public static void pushBlockBufferChange(BlockBuffer forwards, class_2338 center, String historyDescription, int modifiers, AdditionalUndoOperation additionalUndoOperation) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        LongOpenHashSet needNbt = new LongOpenHashSet();
        LongOpenHashSet needChunks = new LongOpenHashSet();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        BlockBuffer backwards = new BlockBuffer();
        Long2ObjectOpenHashMap containers = new Long2ObjectOpenHashMap();
        LongIterator longIterator = forwards.keySet().longIterator();
        while (longIterator.hasNext()) {
            long pos = longIterator.nextLong();
            int cx = class_2338.method_10061((long)pos);
            int cy = class_2338.method_10071((long)pos);
            int cz = class_2338.method_10083((long)pos);
            int sectionIndex = world.method_31603(cy);
            if (sectionIndex < 0 || sectionIndex >= world.method_32890()) continue;
            class_2818 chunk = (class_2818)world.method_8402(cx, cz, class_2806.field_12803, false);
            if (chunk == null) {
                needChunks.add(pos);
                continue;
            }
            class_2826 section = chunk.method_38259(sectionIndex);
            containers.put(pos, (Object)section.method_12265());
        }
        ServerConfig serverConfig = Axiom.getInstance().serverConfig;
        containers.forEach((arg_0, arg_1) -> RegionHelper.lambda$pushBlockBufferChange$4(forwards, backwards, serverConfig, (LongSet)needNbt, world, mutable, baos, arg_0, arg_1));
        if (needNbt.isEmpty() && needChunks.isEmpty()) {
            Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(forwards, backwards, center, historyDescription, modifiers, additionalUndoOperation));
        } else {
            Dispatcher.requestChunkData((LongSet)needNbt, (LongSet)needChunks, true, (compressedBlockEntities, chunkSections) -> {
                class_2680 air = class_2246.field_10124.method_9564();
                chunkSections.forEach((cpos, container) -> {
                    int cz;
                    int cy;
                    int cx = class_2338.method_10061((long)cpos);
                    class_2841<class_2680> blocks = forwards.getSection(cx, cy = class_2338.method_10071((long)cpos), cz = class_2338.method_10083((long)cpos));
                    if (blocks == null) {
                        return;
                    }
                    class_2841<class_2680> backwardsContainer = backwards.getOrCreateSection((long)cpos);
                    for (int z = 0; z < 16; ++z) {
                        for (int y = 0; y < 16; ++y) {
                            for (int x = 0; x < 16; ++x) {
                                class_2680 pasteState = (class_2680)blocks.method_12321(x, y, z);
                                if (pasteState == BlockBuffer.EMPTY_STATE) continue;
                                class_2680 existingState = container == null ? air : (class_2680)container.method_12321(x, y, z);
                                backwardsContainer.method_16678(x, y, z, (Object)existingState);
                            }
                        }
                    }
                });
                compressedBlockEntities.forEach((pos, compressedBlockEntity) -> {
                    int z;
                    int y;
                    int x = class_2338.method_10061((long)pos);
                    if (backwards.get(x, y = class_2338.method_10071((long)pos), z = class_2338.method_10083((long)pos)) != BlockBuffer.EMPTY_STATE) {
                        backwards.putBlockEntity(x, y, z, (CompressedBlockEntity)compressedBlockEntity);
                    }
                });
                Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(forwards, backwards, center, historyDescription, modifiers, additionalUndoOperation));
            });
        }
    }

    public static void pushBlockRegionChangeOffset(ChunkedBlockRegion blockRegion, class_2338 offset, String historyDescription, int modifiers) {
        RegionHelper.pushBlockRegionChangeOffset(blockRegion, null, offset, historyDescription, modifiers);
    }

    public static void pushBlockRegionChangeOffset(ChunkedBlockRegion blockRegion, Long2ObjectMap<CompressedBlockEntity> blockEntities, class_2338 offset, String historyDescription, int modifiers) {
        RegionHelper.pushBlockRegionChangeOffset(blockRegion, blockEntities, offset, historyDescription, modifiers, null);
    }

    public static void pushBlockRegionChangeOffset(ChunkedBlockRegion blockRegion, Long2ObjectMap<CompressedBlockEntity> blockEntities, class_2338 offset, String historyDescription, int modifiers, AdditionalUndoOperation additionalUndoOperation) {
        boolean keepExisting;
        if (blockRegion.isEmpty()) {
            return;
        }
        if (offset.method_10263() == 0 && offset.method_10264() == 0 && offset.method_10260() == 0) {
            RegionHelper.pushBlockRegionChange(blockRegion, blockEntities, historyDescription, modifiers, additionalUndoOperation);
            return;
        }
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        class_2338 center = blockRegion.getCenter();
        int minX = blockRegion.min().method_10263();
        int minY = blockRegion.min().method_10264();
        int minZ = blockRegion.min().method_10260();
        int maxX = blockRegion.max().method_10263();
        int maxY = blockRegion.max().method_10264();
        int maxZ = blockRegion.max().method_10260();
        int worldMinX = minX + offset.method_10263();
        int worldMinY = minY + offset.method_10264();
        int worldMinZ = minZ + offset.method_10260();
        int worldMaxX = maxX + offset.method_10263();
        int worldMaxY = maxY + offset.method_10264();
        int worldMaxZ = maxZ + offset.method_10260();
        LongOpenHashSet needNbt = new LongOpenHashSet();
        LongOpenHashSet needChunks = new LongOpenHashSet();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        BlockBuffer forwards = new BlockBuffer();
        BlockBuffer backwards = new BlockBuffer();
        boolean bl = keepExisting = (modifiers & HistoryEntry.MODIFIER_KEEP_EXISTING) != 0;
        if (keepExisting) {
            modifiers &= ~HistoryEntry.MODIFIER_KEEP_EXISTING;
        }
        int modifiersFinal = modifiers;
        Long2ObjectOpenHashMap containers = new Long2ObjectOpenHashMap();
        int chunkOffsetX = offset.method_10263() >> 4;
        int chunkOffsetY = offset.method_10264() >> 4;
        int chunkOffsetZ = offset.method_10260() >> 4;
        LongIterator longIterator = blockRegion.chunkKeySet().longIterator();
        while (longIterator.hasNext()) {
            long regionPos = longIterator.nextLong();
            int cx = class_2338.method_10061((long)regionPos) + chunkOffsetX;
            int cy = class_2338.method_10071((long)regionPos) + chunkOffsetY;
            int cz = class_2338.method_10083((long)regionPos) + chunkOffsetZ;
            for (int cxo = 0; cxo <= 1; ++cxo) {
                for (int cyo = 0; cyo <= 1; ++cyo) {
                    for (int czo = 0; czo <= 1; ++czo) {
                        int sectionIndex;
                        int ncx = cx + cxo;
                        int ncy = cy + cyo;
                        int ncz = cz + czo;
                        long chunkPos = class_2338.method_10064((int)ncx, (int)ncy, (int)ncz);
                        if (containers.containsKey(chunkPos) || needChunks.contains(chunkPos) || ncx * 16 + 15 < worldMinX || ncy * 16 + 15 < worldMinY || ncz * 16 + 15 < worldMinZ || ncx * 16 > worldMaxX || ncy * 16 > worldMaxY || ncz * 16 > worldMaxZ || (sectionIndex = world.method_31603(ncy)) < 0 || sectionIndex >= world.method_32890()) continue;
                        class_2818 chunk = (class_2818)world.method_8402(ncx, ncz, class_2806.field_12803, false);
                        if (chunk == null) {
                            needChunks.add(chunkPos);
                            continue;
                        }
                        class_2826 section = chunk.method_38259(sectionIndex);
                        containers.put(chunkPos, (Object)section.method_12265());
                    }
                }
            }
        }
        ServerConfig serverConfig = Axiom.getInstance().serverConfig;
        containers.forEach((arg_0, arg_1) -> RegionHelper.lambda$pushBlockRegionChangeOffset$8(offset, forwards, backwards, blockRegion, keepExisting, serverConfig, (LongSet)needNbt, world, mutable, baos, arg_0, arg_1));
        if (needNbt.isEmpty() && needChunks.isEmpty()) {
            if (blockEntities != null) {
                for (Long2ObjectMap.Entry entry : blockEntities.long2ObjectEntrySet()) {
                    long pos = entry.getLongKey();
                    int x = class_2338.method_10061((long)pos);
                    int y = class_2338.method_10071((long)pos);
                    int z = class_2338.method_10083((long)pos);
                    if (forwards.get(x + offset.method_10263(), y + offset.method_10264(), z + offset.method_10260()) == BlockBuffer.EMPTY_STATE) continue;
                    forwards.putBlockEntity(x + offset.method_10263(), y + offset.method_10264(), z + offset.method_10260(), (CompressedBlockEntity)entry.getValue());
                }
            }
            Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(forwards, backwards, center.method_10081((class_2382)offset), historyDescription, modifiers, additionalUndoOperation));
        } else {
            Position2ObjectMap<class_2680> copiedBlocks = blockRegion.copyBlockData();
            Long2ObjectOpenHashMap copiedBlockEntities = blockEntities == null ? null : new Long2ObjectOpenHashMap(blockEntities);
            Dispatcher.requestChunkData((LongSet)needNbt, (LongSet)needChunks, true, (arg_0, arg_1) -> RegionHelper.lambda$pushBlockRegionChangeOffset$11(offset, forwards, backwards, copiedBlocks, keepExisting, (Long2ObjectMap)copiedBlockEntities, center, historyDescription, modifiersFinal, additionalUndoOperation, arg_0, arg_1));
        }
    }

    public static void pushBlockRegionChangeWithNBT(ChunkedBlockRegion blockRegion, String historyDescription, int modifiers, Long2LongFunction nbtLocationFunction) {
        RegionHelper.pushBlockRegionChangeWithNBT(blockRegion, historyDescription, modifiers, nbtLocationFunction, null);
    }

    public static void pushBlockRegionChangeWithNBT(ChunkedBlockRegion blockRegion, String historyDescription, int modifiers, Long2LongFunction nbtLocationFunction, AdditionalUndoOperation additionalUndoOperation) {
        boolean keepExisting;
        if (blockRegion.isEmpty()) {
            return;
        }
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        class_2338 center = blockRegion.getCenter();
        BlockBuffer setOperation = new BlockBuffer();
        BlockBuffer previousBlocksForUndo = new BlockBuffer();
        Long2ObjectOpenHashMap nbtMap = new Long2ObjectOpenHashMap();
        boolean bl = keepExisting = (modifiers & HistoryEntry.MODIFIER_KEEP_EXISTING) != 0;
        if (keepExisting) {
            modifiers &= ~HistoryEntry.MODIFIER_KEEP_EXISTING;
        }
        blockRegion.forEachChunk((arg_0, arg_1, arg_2, arg_3) -> RegionHelper.lambda$pushBlockRegionChangeWithNBT$14(world, keepExisting, setOperation, previousBlocksForUndo, (Long2ObjectMap)nbtMap, nbtLocationFunction, arg_0, arg_1, arg_2, arg_3));
        RegionHelper.pushBlockBufferChangeWithNBT((class_1937)world, setOperation, previousBlocksForUndo, center, historyDescription, modifiers, (Long2ObjectMap<List<NbtTarget>>)nbtMap, true, additionalUndoOperation);
    }

    public static void pushBlockBufferChangeWithNBT(class_1937 world, BlockBuffer forwards, BlockBuffer backwards, class_2338 center, String historyDescription, int modifiers, Long2ObjectMap<List<NbtTarget>> nbtMap, boolean tryResolve) {
        RegionHelper.pushBlockBufferChangeWithNBT(world, forwards, backwards, center, historyDescription, modifiers, nbtMap, tryResolve, null);
    }

    public static void pushBlockBufferChangeWithNBT(class_1937 world, BlockBuffer forwards, BlockBuffer backwards, class_2338 center, String historyDescription, int modifiers, Long2ObjectMap<List<NbtTarget>> nbtMap, boolean tryResolve, AdditionalUndoOperation additionalUndoOperation) {
        if (tryResolve) {
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectIterator iterator = nbtMap.long2ObjectEntrySet().iterator();
            while (iterator.hasNext()) {
                class_2487 nbt;
                Long2ObjectMap.Entry element = (Long2ObjectMap.Entry)iterator.next();
                long pos = element.getLongKey();
                mutableBlockPos.method_16363(pos);
                class_2586 blockEntity = world.method_8500((class_2338)mutableBlockPos).method_12201((class_2338)mutableBlockPos, class_2818.class_2819.field_12859);
                if (blockEntity == null || (nbt = ClientBlockEntitySerializer.serialize(blockEntity, (class_7225.class_7874)world.method_30349())) == null) continue;
                if (!nbt.method_33133()) {
                    CompressedBlockEntity compressedBlockEntity = CompressedBlockEntity.compress(nbt, baos);
                    for (NbtTarget target : (List)element.getValue()) {
                        if (target.forwards) {
                            if (forwards.get(target.x, target.y, target.z) == BlockBuffer.EMPTY_STATE) continue;
                            forwards.putBlockEntity(target.x, target.y, target.z, compressedBlockEntity);
                            continue;
                        }
                        if (backwards.get(target.x, target.y, target.z) == BlockBuffer.EMPTY_STATE) continue;
                        backwards.putBlockEntity(target.x, target.y, target.z, compressedBlockEntity);
                    }
                }
                iterator.remove();
            }
        }
        if (nbtMap.isEmpty()) {
            Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(forwards, backwards, center, historyDescription, modifiers, additionalUndoOperation));
        } else {
            Dispatcher.requestChunkData(nbtMap.keySet(), null, false, (compressedBlockEntities, chunkSections) -> {
                try {
                    for (Long2ObjectMap.Entry entry : compressedBlockEntities.long2ObjectEntrySet()) {
                        List targets = (List)nbtMap.get(entry.getLongKey());
                        if (targets == null) continue;
                        for (NbtTarget target : targets) {
                            if (target.forwards) {
                                if (forwards.get(target.x, target.y, target.z) == BlockBuffer.EMPTY_STATE) continue;
                                forwards.putBlockEntity(target.x, target.y, target.z, (CompressedBlockEntity)entry.getValue());
                                continue;
                            }
                            if (backwards.get(target.x, target.y, target.z) == BlockBuffer.EMPTY_STATE) continue;
                            backwards.putBlockEntity(target.x, target.y, target.z, (CompressedBlockEntity)entry.getValue());
                        }
                    }
                    Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(forwards, backwards, center, historyDescription, modifiers, additionalUndoOperation));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    public static void pushBooleanRegionChange(ChunkedBooleanRegion booleanRegion, class_2680 fillState, String historyDescription) {
        RegionHelper.pushPositionSetRegionChange(booleanRegion.unsafeGetPositionSet(), fillState, booleanRegion.getCenter(), historyDescription, 0);
    }

    public static void pushPositionSetRegionChange(PositionSet positionSet, class_2680 fillState, class_2338 center, String historyDescription, int modifiers) {
        boolean keepExisting;
        if (positionSet.count() <= 0) {
            return;
        }
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Long2ObjectOpenHashMap nbtMap = new Long2ObjectOpenHashMap();
        BlockBuffer forwards = new BlockBuffer();
        BlockBuffer backwards = new BlockBuffer();
        boolean bl = keepExisting = (modifiers & HistoryEntry.MODIFIER_KEEP_EXISTING) != 0;
        if (keepExisting) {
            modifiers &= ~HistoryEntry.MODIFIER_KEEP_EXISTING;
        }
        positionSet.forEachChunk((arg_0, arg_1, arg_2, arg_3) -> RegionHelper.lambda$pushPositionSetRegionChange$17(world, keepExisting, forwards, fillState, backwards, mutableBlockPos, baos, (Long2ObjectMap)nbtMap, arg_0, arg_1, arg_2, arg_3));
        RegionHelper.pushBlockBufferChangeWithNBT((class_1937)world, forwards, backwards, center, historyDescription, modifiers, (Long2ObjectMap<List<NbtTarget>>)nbtMap, false);
    }

    public static void pushPositionSetRegionChangeWithNBT(PositionSet positionSet, class_2680 fillState, class_2338 center, String historyDescription, int modifiers, Long2LongFunction nbtLocationFunction) {
        if (positionSet.count() <= 0) {
            return;
        }
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        BlockBuffer setOperation = new BlockBuffer();
        BlockBuffer previousBlocksForUndo = new BlockBuffer();
        Long2ObjectOpenHashMap nbtMap = new Long2ObjectOpenHashMap();
        positionSet.forEachChunk((arg_0, arg_1, arg_2, arg_3) -> RegionHelper.lambda$pushPositionSetRegionChangeWithNBT$20(world, setOperation, fillState, previousBlocksForUndo, (Long2ObjectMap)nbtMap, nbtLocationFunction, arg_0, arg_1, arg_2, arg_3));
        RegionHelper.pushBlockBufferChangeWithNBT((class_1937)world, setOperation, previousBlocksForUndo, center, historyDescription, modifiers, (Long2ObjectMap<List<NbtTarget>>)nbtMap, true);
    }

    private static /* synthetic */ void lambda$pushPositionSetRegionChangeWithNBT$20(class_638 world, BlockBuffer setOperation, class_2680 fillState, BlockBuffer previousBlocksForUndo, Long2ObjectMap nbtMap, Long2LongFunction nbtLocationFunction, int cx, int cy, int cz, short[] data) {
        if (cy < world.method_32891() || cy > world.method_31597()) {
            return;
        }
        class_2818 chunk = (class_2818)world.method_8402(cx, cz, class_2806.field_12803, false);
        if (chunk == null) {
            return;
        }
        class_2826 section = chunk.method_38259(world.method_31603(cy));
        class_2841 container = section.method_12265();
        int wcx = cx * 16;
        int wcy = cy * 16;
        int wcz = cz * 16;
        int index = 0;
        for (int z = 0; z < 16; ++z) {
            for (int y = 0; y < 16; ++y) {
                short line;
                if ((line = data[index++]) == 0) continue;
                for (int x = 0; x < 16; ++x) {
                    if ((line & 1 << x) == 0) continue;
                    class_2680 oldState = (class_2680)container.method_12321(x, y, z);
                    setOperation.set(wcx + x, wcy + y, wcz + z, fillState);
                    previousBlocksForUndo.set(wcx + x, wcy + y, wcz + z, oldState);
                    long pos = class_2338.method_10064((int)(wcx + x), (int)(wcy + y), (int)(wcz + z));
                    if (oldState.method_31709()) {
                        ((List)nbtMap.computeIfAbsent(pos, k -> new ArrayList())).add(new NbtTarget(false, wcx + x, wcy + y, wcz + z));
                    }
                    if (!fillState.method_31709() || nbtLocationFunction == null) continue;
                    long fromPos = nbtLocationFunction.applyAsLong(pos);
                    ((List)nbtMap.computeIfAbsent(fromPos, k -> new ArrayList())).add(new NbtTarget(true, wcx + x, wcy + y, wcz + z));
                }
            }
        }
    }

    private static /* synthetic */ void lambda$pushPositionSetRegionChange$17(class_638 world, boolean keepExisting, BlockBuffer forwards, class_2680 fillState, BlockBuffer backwards, class_2338.class_2339 mutableBlockPos, ByteArrayOutputStream baos, Long2ObjectMap nbtMap, int cx, int cy, int cz, short[] data) {
        if (cy < world.method_32891() || cy > world.method_31597()) {
            return;
        }
        class_2818 chunk = (class_2818)world.method_8402(cx, cz, class_2806.field_12803, false);
        if (chunk == null) {
            return;
        }
        class_2826 section = chunk.method_38259(world.method_31603(cy));
        class_2841 container = section.method_12265();
        int wcx = cx * 16;
        int wcy = cy * 16;
        int wcz = cz * 16;
        int index = 0;
        for (int z = 0; z < 16; ++z) {
            for (int y = 0; y < 16; ++y) {
                short line;
                if ((line = data[index++]) == 0) continue;
                for (int x = 0; x < 16; ++x) {
                    if ((line & 1 << x) == 0) continue;
                    class_2680 oldState = (class_2680)container.method_12321(x, y, z);
                    if (keepExisting && !oldState.method_26215()) continue;
                    forwards.set(wcx + x, wcy + y, wcz + z, fillState);
                    backwards.set(wcx + x, wcy + y, wcz + z, oldState);
                    if (!oldState.method_31709()) continue;
                    mutableBlockPos.method_10103(wcx + x, wcy + y, wcz + z);
                    class_2586 blockEntity = chunk.method_12201((class_2338)mutableBlockPos, class_2818.class_2819.field_12859);
                    if (blockEntity == null) continue;
                    class_2487 nbt = ClientBlockEntitySerializer.serialize(blockEntity, (class_7225.class_7874)world.method_30349());
                    if (nbt != null) {
                        if (nbt.method_33133()) continue;
                        CompressedBlockEntity compressedBlockEntity = CompressedBlockEntity.compress(nbt, baos);
                        backwards.putBlockEntity(wcx + x, wcy + y, wcz + z, compressedBlockEntity);
                        continue;
                    }
                    ((List)nbtMap.computeIfAbsent(mutableBlockPos.method_10063(), k -> new ArrayList())).add(new NbtTarget(false, wcx + x, wcy + y, wcz + z));
                }
            }
        }
    }

    private static /* synthetic */ void lambda$pushBlockRegionChangeWithNBT$14(class_638 world, boolean keepExisting, BlockBuffer setOperation, BlockBuffer previousBlocksForUndo, Long2ObjectMap nbtMap, Long2LongFunction nbtLocationFunction, int cx, int cy, int cz, class_2680[] data) {
        if (cy < world.method_32891() || cy > world.method_31597()) {
            return;
        }
        class_2818 chunk = (class_2818)world.method_8402(cx, cz, class_2806.field_12803, false);
        if (chunk == null) {
            return;
        }
        class_2826 section = chunk.method_38259(chunk.method_31603(cy));
        class_2841 container = section.method_12265();
        int wcx = cx * 16;
        int wcy = cy * 16;
        int wcz = cz * 16;
        int index = 0;
        for (int z = 0; z < 16; ++z) {
            for (int y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    class_2680 state;
                    if ((state = data[index++]) == null) continue;
                    class_2680 oldState = (class_2680)container.method_12321(x, y, z);
                    if (keepExisting && !oldState.method_26215()) continue;
                    setOperation.set(wcx + x, wcy + y, wcz + z, state);
                    previousBlocksForUndo.set(wcx + x, wcy + y, wcz + z, oldState);
                    long pos = class_2338.method_10064((int)(wcx + x), (int)(wcy + y), (int)(wcz + z));
                    if (oldState.method_31709()) {
                        ((List)nbtMap.computeIfAbsent(pos, k -> new ArrayList())).add(new NbtTarget(false, wcx + x, wcy + y, wcz + z));
                    }
                    if (!state.method_31709() || nbtLocationFunction == null) continue;
                    long fromPos = nbtLocationFunction.applyAsLong(pos);
                    ((List)nbtMap.computeIfAbsent(fromPos, k -> new ArrayList())).add(new NbtTarget(true, wcx + x, wcy + y, wcz + z));
                }
            }
        }
    }

    private static /* synthetic */ void lambda$pushBlockRegionChangeOffset$11(class_2338 offset, BlockBuffer forwards, BlockBuffer backwards, Position2ObjectMap copiedBlocks, boolean keepExisting, Long2ObjectMap copiedBlockEntities, class_2338 center, String historyDescription, int modifiersFinal, AdditionalUndoOperation additionalUndoOperation, Long2ObjectMap compressedBlockEntities, Long2ObjectMap chunkSections) {
        class_2680 air = class_2246.field_10124.method_9564();
        chunkSections.forEach((cpos, container) -> {
            int cx = class_2338.method_10061((long)cpos);
            int cy = class_2338.method_10071((long)cpos);
            int cz = class_2338.method_10083((long)cpos);
            int xo = cx * 16 - offset.method_10263();
            int yo = cy * 16 - offset.method_10264();
            int zo = cz * 16 - offset.method_10260();
            class_2841<class_2680> forwardsContainer = forwards.getOrCreateSection((long)cpos);
            class_2841<class_2680> backwardsContainer = backwards.getOrCreateSection((long)cpos);
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 16; ++y) {
                    for (int x = 0; x < 16; ++x) {
                        class_2680 existingState;
                        class_2680 pasteState = (class_2680)copiedBlocks.get(x + xo, y + yo, z + zo);
                        if (pasteState == null) continue;
                        class_2680 class_26802 = existingState = container == null ? air : (class_2680)container.method_12321(x, y, z);
                        if (keepExisting && !existingState.method_26215()) continue;
                        forwardsContainer.method_16678(x, y, z, (Object)pasteState);
                        backwardsContainer.method_16678(x, y, z, (Object)existingState);
                    }
                }
            }
        });
        compressedBlockEntities.forEach((pos, compressedBlockEntity) -> {
            int z;
            int y;
            int x = class_2338.method_10061((long)pos);
            if (backwards.get(x, y = class_2338.method_10071((long)pos), z = class_2338.method_10083((long)pos)) != BlockBuffer.EMPTY_STATE) {
                backwards.putBlockEntity(x, y, z, (CompressedBlockEntity)compressedBlockEntity);
            }
        });
        if (copiedBlockEntities != null) {
            for (Long2ObjectMap.Entry entry : copiedBlockEntities.long2ObjectEntrySet()) {
                long pos2 = entry.getLongKey();
                int x = class_2338.method_10061((long)pos2);
                int y = class_2338.method_10071((long)pos2);
                int z = class_2338.method_10083((long)pos2);
                if (forwards.get(x + offset.method_10263(), y + offset.method_10264(), z + offset.method_10260()) == BlockBuffer.EMPTY_STATE) continue;
                forwards.putBlockEntity(x + offset.method_10263(), y + offset.method_10264(), z + offset.method_10260(), (CompressedBlockEntity)entry.getValue());
            }
        }
        Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(forwards, backwards, center.method_10081((class_2382)offset), historyDescription, modifiersFinal, additionalUndoOperation));
    }

    private static /* synthetic */ void lambda$pushBlockRegionChangeOffset$8(class_2338 offset, BlockBuffer forwards, BlockBuffer backwards, ChunkedBlockRegion blockRegion, boolean keepExisting, ServerConfig serverConfig, LongSet needNbt, class_638 world, class_2338.class_2339 mutable, ByteArrayOutputStream baos, Long cpos, class_2841 container) {
        int cx = class_2338.method_10061((long)cpos);
        int cy = class_2338.method_10071((long)cpos);
        int cz = class_2338.method_10083((long)cpos);
        int xo = cx * 16 - offset.method_10263();
        int yo = cy * 16 - offset.method_10264();
        int zo = cz * 16 - offset.method_10260();
        class_2841<class_2680> forwardsContainer = forwards.getOrCreateSection(cpos);
        class_2841<class_2680> backwardsContainer = backwards.getOrCreateSection(cpos);
        for (int z = 0; z < 16; ++z) {
            for (int y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    class_2586 blockEntity;
                    class_2680 pasteState = blockRegion.getBlockStateOrNull(x + xo, y + yo, z + zo);
                    if (pasteState == null) continue;
                    class_2680 existingState = (class_2680)container.method_12321(x, y, z);
                    if (keepExisting && !existingState.method_26215()) continue;
                    int toX = x + cx * 16;
                    int toY = y + cy * 16;
                    int toZ = z + cz * 16;
                    forwardsContainer.method_16678(x, y, z, (Object)pasteState);
                    backwardsContainer.method_16678(x, y, z, (Object)existingState);
                    if (serverConfig.blocksWithCustomData().contains(existingState.method_26204())) {
                        needNbt.add(class_2338.method_10064((int)toX, (int)toY, (int)toZ));
                        continue;
                    }
                    if (!existingState.method_31709() || (blockEntity = world.method_8321((class_2338)mutable.method_10103(toX, toY, toZ))) == null) continue;
                    class_2487 nbt = ClientBlockEntitySerializer.serialize(blockEntity, (class_7225.class_7874)world.method_30349());
                    if (nbt != null) {
                        if (nbt.method_33133()) continue;
                        CompressedBlockEntity compressedBlockEntity = CompressedBlockEntity.compress(nbt, baos);
                        backwards.putBlockEntity(toX, toY, toZ, compressedBlockEntity);
                        continue;
                    }
                    needNbt.add(mutable.method_10063());
                }
            }
        }
    }

    private static /* synthetic */ void lambda$pushBlockBufferChange$4(BlockBuffer forwards, BlockBuffer backwards, ServerConfig serverConfig, LongSet needNbt, class_638 world, class_2338.class_2339 mutable, ByteArrayOutputStream baos, Long cpos, class_2841 container) {
        int cz;
        int cy;
        int cx = class_2338.method_10061((long)cpos);
        class_2841<class_2680> blocks = forwards.getSection(cx, cy = class_2338.method_10071((long)cpos), cz = class_2338.method_10083((long)cpos));
        if (blocks == null) {
            return;
        }
        class_2841<class_2680> backwardsContainer = backwards.getOrCreateSection(cpos);
        for (int z = 0; z < 16; ++z) {
            for (int y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    class_2586 blockEntity;
                    class_2680 pasteState = (class_2680)blocks.method_12321(x, y, z);
                    if (pasteState == BlockBuffer.EMPTY_STATE) continue;
                    class_2680 existingState = (class_2680)container.method_12321(x, y, z);
                    int toX = x + cx * 16;
                    int toY = y + cy * 16;
                    int toZ = z + cz * 16;
                    backwardsContainer.method_16678(x, y, z, (Object)existingState);
                    if (serverConfig.blocksWithCustomData().contains(existingState.method_26204())) {
                        needNbt.add(class_2338.method_10064((int)toX, (int)toY, (int)toZ));
                        continue;
                    }
                    if (!existingState.method_31709() || (blockEntity = world.method_8321((class_2338)mutable.method_10103(toX, toY, toZ))) == null) continue;
                    class_2487 nbt = ClientBlockEntitySerializer.serialize(blockEntity, (class_7225.class_7874)world.method_30349());
                    if (nbt != null) {
                        if (nbt.method_33133()) continue;
                        CompressedBlockEntity compressedBlockEntity = CompressedBlockEntity.compress(nbt, baos);
                        backwards.putBlockEntity(toX, toY, toZ, compressedBlockEntity);
                        continue;
                    }
                    needNbt.add(mutable.method_10063());
                }
            }
        }
    }

    private static /* synthetic */ void lambda$pushBlockRegionChange$0(ChunkedBlockRegion blockRegion, BlockBuffer forwards, BlockBuffer backwards, boolean keepExisting, ServerConfig serverConfig, LongSet needNbt, class_638 world, class_2338.class_2339 mutable, ByteArrayOutputStream baos, Long cpos, class_2841 container) {
        int cz;
        int cy;
        int cx = class_2338.method_10061((long)cpos);
        class_2680[] blocks = blockRegion.getChunk(cx, cy = class_2338.method_10071((long)cpos), cz = class_2338.method_10083((long)cpos));
        if (blocks == null) {
            return;
        }
        class_2841<class_2680> forwardsContainer = forwards.getOrCreateSection(cpos);
        class_2841<class_2680> backwardsContainer = backwards.getOrCreateSection(cpos);
        int index = 0;
        for (int z = 0; z < 16; ++z) {
            for (int y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    class_2586 blockEntity;
                    class_2680 pasteState;
                    if ((pasteState = blocks[index++]) == null) continue;
                    class_2680 existingState = (class_2680)container.method_12321(x, y, z);
                    if (keepExisting && !existingState.method_26215()) continue;
                    int toX = x + cx * 16;
                    int toY = y + cy * 16;
                    int toZ = z + cz * 16;
                    forwardsContainer.method_16678(x, y, z, (Object)pasteState);
                    backwardsContainer.method_16678(x, y, z, (Object)existingState);
                    if (serverConfig.blocksWithCustomData().contains(existingState.method_26204())) {
                        needNbt.add(class_2338.method_10064((int)toX, (int)toY, (int)toZ));
                        continue;
                    }
                    if (!existingState.method_31709() || (blockEntity = world.method_8321((class_2338)mutable.method_10103(toX, toY, toZ))) == null) continue;
                    class_2487 nbt = ClientBlockEntitySerializer.serialize(blockEntity, (class_7225.class_7874)world.method_30349());
                    if (nbt != null) {
                        if (nbt.method_33133()) continue;
                        CompressedBlockEntity compressedBlockEntity = CompressedBlockEntity.compress(nbt, baos);
                        backwards.putBlockEntity(toX, toY, toZ, compressedBlockEntity);
                        continue;
                    }
                    needNbt.add(mutable.method_10063());
                }
            }
        }
    }

    public record NbtTarget(boolean forwards, int x, int y, int z) {
    }
}

