/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.core_rendering.AxiomGpuTexture;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import net.minecraft.class_10366;
import net.minecraft.class_1041;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5944;
import net.minecraft.class_9958;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class RenderHelper {
    public static float baseLineWidth = 2.5f;
    private static class_9958 previousFogParameters = null;

    public static void updateBaseLineWidth(class_1041 window) {
        double screenScaleFactor = (double)(window.field_5181 * window.field_5196) / 2073600.0;
        baseLineWidth = Math.max(2.5f, (float)(Math.sqrt(screenScaleFactor) * 2.5));
    }

    public static void tryApplyModelViewMatrix() {
        AxiomRenderer.dirtyDynamicUniforms();
    }

    public static void tryFlush(class_332 guiGraphics) {
        guiGraphics.method_51452();
    }

    public static void setOrthoProjectionMatrix(float width, float height) {
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(0.0f, width, height, 0.0f, 1000.0f, 3000.0f), (class_10366)class_10366.field_54954);
    }

    public static void setPerspectiveProjectionMatrix(Matrix4f matrix4f) {
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (class_10366)class_10366.field_54953);
    }

    public static void setupShader(class_5944 shaderInstance, Matrix4f modelViewMatrix, Matrix4f projectionMatrix) {
        class_1041 window = class_310.method_1551().method_22683();
        RenderHelper.setupShader(shaderInstance, modelViewMatrix, projectionMatrix, window.method_4489(), window.method_4506());
    }

    public static void setupShader(class_5944 shaderInstance, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, float screenWidth, float screenHeight) {
        RenderSystem.assertOnRenderThread();
        for (int index = 0; index < 12; ++index) {
            shaderInstance.method_62899("Sampler" + index, new AxiomGpuTexture(RenderSystem.getShaderTexture((int)index)).glId());
        }
        if (shaderInstance.field_29470 != null) {
            shaderInstance.field_29470.method_1250(modelViewMatrix);
        }
        if (shaderInstance.field_29471 != null) {
            shaderInstance.field_29471.method_1250(projectionMatrix);
        }
        if (shaderInstance.field_29474 != null) {
            shaderInstance.field_29474.method_1253(RenderSystem.getShaderColor());
        }
        if (shaderInstance.field_42231 != null) {
            shaderInstance.field_42231.method_1251(RenderSystem.getShaderGlintAlpha());
        }
        class_9958 fogParameters = RenderSystem.getShaderFog();
        if (shaderInstance.field_29477 != null) {
            shaderInstance.field_29477.method_1251(fogParameters.comp_3009());
        }
        if (shaderInstance.field_29478 != null) {
            shaderInstance.field_29478.method_1251(fogParameters.comp_3010());
        }
        if (shaderInstance.field_29479 != null) {
            shaderInstance.field_29479.method_1254(fogParameters.comp_3012(), fogParameters.comp_3013(), fogParameters.comp_3014(), fogParameters.comp_3015());
        }
        if (shaderInstance.field_36373 != null) {
            shaderInstance.field_36373.method_35649(fogParameters.comp_3011().method_40036());
        }
        if (shaderInstance.field_29472 != null) {
            shaderInstance.field_29472.method_1250(RenderSystem.getTextureMatrix());
        }
        if (shaderInstance.field_29481 != null) {
            shaderInstance.field_29481.method_1251(RenderSystem.getShaderGameTime());
        }
        if (shaderInstance.field_29473 != null) {
            shaderInstance.field_29473.method_1255(screenWidth, screenHeight);
        }
        if (shaderInstance.field_29480 != null) {
            shaderInstance.field_29480.method_1251(RenderSystem.getShaderLineWidth());
        }
        RenderSystem.setupShaderLights((class_5944)shaderInstance);
        shaderInstance.method_34586();
    }

    public static void finishShader(class_5944 shaderInstance) {
        shaderInstance.method_34585();
    }

    public static void pushDisableFog() {
        if (previousFogParameters != null && Axiom.enableAssertions) {
            throw new IllegalStateException("Fog disable was pushed twice");
        }
        previousFogParameters = RenderSystem.getShaderFog();
        RenderSystem.setShaderFog((class_9958)class_9958.field_53065);
    }

    public static void popDisableFog() {
        if (previousFogParameters == null) {
            if (Axiom.enableAssertions) {
                throw new IllegalStateException("Fog disable was popped without being pushed");
            }
            return;
        }
        RenderSystem.setShaderFog((class_9958)previousFogParameters);
        previousFogParameters = null;
    }

    public static void pushModelViewMatrix(Matrix4f matrix4f) {
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.set((Matrix4fc)matrix4f);
        RenderHelper.tryApplyModelViewMatrix();
    }

    public static void pushModelViewStackWithIdentity() {
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.identity();
        RenderHelper.tryApplyModelViewMatrix();
    }

    public static void popModelViewStack() {
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.popMatrix();
        RenderHelper.tryApplyModelViewMatrix();
    }

    public static void setupFlatLighting() {
        RenderSystem.setShaderLights((Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f));
    }

    public static void setup3DLighting() {
        class_308.method_24211();
    }
}

