/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.widgets;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.brush_shapes.BrushShape;
import com.moulberry.axiom.brush_shapes.CapsuleBrushShape;
import com.moulberry.axiom.brush_shapes.ConeBrushShape;
import com.moulberry.axiom.brush_shapes.CubeBrushShape;
import com.moulberry.axiom.brush_shapes.CylinderBrushShape;
import com.moulberry.axiom.brush_shapes.OctahedronBrushShape;
import com.moulberry.axiom.brush_shapes.SphereBrushShape;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.render.SharedBrushPreviewRenderer;
import com.moulberry.axiom.tools.Tool;
import imgui.ImDrawList;
import imgui.ImGui;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Matrix4f;

public class BrushWidget {
    private static final int MAX_RADIUS = 50;
    private final int[] shape = new int[]{0};
    private final int[] radius = new int[]{5};
    private final int[] height = new int[]{5};
    private final float[] coneRounding = new float[]{0.0f};
    private final int[] coneDirection = new int[]{0};
    private boolean dirty = false;
    private BrushShape brushShape = null;
    private static final int SHAPE_SPHERE = 0;
    private static final int SHAPE_CUBE = 1;
    private static final int SHAPE_OCTAHEDRON = 2;
    private static final int SHAPE_CYLINDER = 3;
    private static final int SHAPE_ELLIPSOID = 4;
    private static final int SHAPE_CUBOID = 5;
    private static final int SHAPE_CAPSULE = 6;
    private static final int SHAPE_CONE = 7;
    private float baseHeightAdjustment = 0.0f;
    private float baseRadiusAdjustment = 0.0f;
    private float raycastDistance = 16.0f;

    public boolean displayImgui() {
        boolean changed = ImGuiHelper.combo(AxiomI18n.get("axiom.tool.generic.brush_shape"), this.shape, new String[]{AxiomI18n.get("axiom.tool.shape.sphere"), AxiomI18n.get("axiom.tool.shape.cube"), AxiomI18n.get("axiom.tool.shape.octahedron"), AxiomI18n.get("axiom.tool.shape.cylinder"), AxiomI18n.get("axiom.tool.generic.brush_shape.ellipsoid"), AxiomI18n.get("axiom.tool.generic.brush_shape.cuboid"), AxiomI18n.get("axiom.tool.generic.brush_shape.capsule"), AxiomI18n.get("axiom.tool.generic.brush_shape.cone")});
        changed |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.generic.brush_radius"), this.radius, 0, 50);
        ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
        if (BrushWidget.hasHeight(this.shape[0])) {
            changed |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.generic.brush_height"), this.height, 0, 50);
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
        }
        if (this.shape[0] == 7) {
            changed |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.shape.cone.rounding"), this.coneRounding, 0.0f, 1.0f);
            changed |= ImGuiHelper.combo("Direction", this.coneDirection, new String[]{"Both", "Up", "Down"});
        }
        this.dirty |= changed;
        return changed;
    }

    public void writeSettings(class_2487 tag) {
        String shapeString = switch (this.shape[0]) {
            case 0 -> "Sphere";
            case 1 -> "Cube";
            case 2 -> "Octahedron";
            case 3 -> "Cylinder";
            case 4 -> "Ellipsoid";
            case 5 -> "Cuboid";
            case 6 -> "Capsule";
            case 7 -> "Bicone";
            default -> throw new FaultyImplementationError();
        };
        tag.method_10582("BrushShape", shapeString);
        tag.method_10569("BrushRadius", this.radius[0]);
        if (BrushWidget.hasHeight(this.shape[0])) {
            tag.method_10569("BrushHeight", this.height[0]);
        }
        if (this.shape[0] == 7) {
            tag.method_10548("ConeRounding", this.coneRounding[0]);
            tag.method_10569("ConeDirection", this.coneDirection[0]);
        }
    }

    public void loadSettings(class_2487 tag) {
        String brushShape;
        this.shape[0] = switch (brushShape = tag.method_68564("BrushShape", "Sphere")) {
            default -> 0;
            case "Cube" -> 1;
            case "Octahedron" -> 2;
            case "Cylinder" -> 3;
            case "Ellipsoid" -> 4;
            case "Cuboid" -> 5;
            case "Capsule" -> 6;
            case "Bicone" -> 7;
        };
        this.radius[0] = tag.method_68083("BrushRadius", 5);
        this.height[0] = tag.method_68083("BrushHeight", 5);
        if (this.shape[0] == 7) {
            this.coneRounding[0] = tag.method_66563("ConeRounding", 0.0f);
            this.coneDirection[0] = tag.method_68083("ConeDirection", 0);
        }
        this.dirty = true;
    }

    private static boolean hasHeight(int shapeType) {
        return switch (shapeType) {
            case 0, 1, 2 -> false;
            case 3, 4, 5, 6, 7 -> true;
            default -> throw new UnsupportedOperationException();
        };
    }

    public BrushShape createBrushShapeWithAdditional(int extra) {
        int extraSqrt3 = (int)Math.ceil((double)extra * Math.sqrt(3.0));
        return switch (this.shape[0]) {
            case 0 -> SphereBrushShape.create(this.radius[0] + extraSqrt3);
            case 1 -> CubeBrushShape.create(this.radius[0] + extra);
            case 2 -> OctahedronBrushShape.create(this.radius[0] + extraSqrt3);
            case 3 -> CylinderBrushShape.create(this.radius[0] + extraSqrt3, this.height[0] + extra);
            case 4 -> SphereBrushShape.create(this.radius[0] + extraSqrt3, this.height[0] + extraSqrt3, this.radius[0] + extraSqrt3);
            case 5 -> CubeBrushShape.create(this.radius[0] + extra, this.height[0] + extra, this.radius[0] + extra);
            case 6 -> CapsuleBrushShape.create(this.radius[0] + extraSqrt3, this.height[0] + extra);
            case 7 -> ConeBrushShape.create(this.radius[0] + extraSqrt3, this.height[0] + extraSqrt3, this.coneRounding[0], this.coneDirection[0]);
            default -> throw new FaultyImplementationError();
        };
    }

    public BrushShape getBrushShape() {
        if (this.brushShape == null || this.dirty) {
            this.brushShape = switch (this.shape[0]) {
                case 0 -> SphereBrushShape.create(this.radius[0]);
                case 1 -> CubeBrushShape.create(this.radius[0]);
                case 2 -> OctahedronBrushShape.create(this.radius[0]);
                case 3 -> CylinderBrushShape.create(this.radius[0], this.height[0]);
                case 4 -> SphereBrushShape.create(this.radius[0], this.height[0], this.radius[0]);
                case 5 -> CubeBrushShape.create(this.radius[0], this.height[0], this.radius[0]);
                case 6 -> CapsuleBrushShape.create(this.radius[0], this.height[0]);
                case 7 -> ConeBrushShape.create(this.radius[0], this.height[0], this.coneRounding[0], this.coneDirection[0]);
                default -> throw new FaultyImplementationError();
            };
            this.dirty = false;
        }
        return this.brushShape;
    }

    public void renderPreview(class_4184 camera, class_243 translation, class_4587 matrix, Matrix4f projection, long time, int effects) {
        SharedBrushPreviewRenderer.render(this.getBrushShape(), camera, translation, matrix, projection, time, effects);
    }

    public boolean initiateAdjustment() {
        RayCaster.RaycastResult result = Tool.raycastBlock();
        if (result == null) {
            return false;
        }
        this.raycastDistance = (float)result.getLocation().method_1022(class_310.method_1551().field_1724.method_33571());
        float m11 = EditorUI.lastProjectionMatrix.m11();
        this.baseRadiusAdjustment = (float)this.radius[0] / this.raycastDistance / 2.0f * m11 * ImGui.getMainViewport().getSizeY();
        if (BrushWidget.hasHeight(this.shape[0])) {
            int height = this.height[0];
            if (this.shape[0] == 6) {
                height += this.radius[0];
            }
            this.baseHeightAdjustment = (float)height / this.raycastDistance / 2.0f * m11 * ImGui.getMainViewport().getSizeY();
            float r = this.baseRadiusAdjustment;
            float h2 = this.baseHeightAdjustment;
            if (r > h2) {
                this.baseHeightAdjustment = r / (float)Math.sqrt(r / h2 * r / h2 + 1.0f);
                this.baseRadiusAdjustment = (float)Math.sqrt(r * r - this.baseHeightAdjustment * this.baseHeightAdjustment);
            } else {
                this.baseRadiusAdjustment = h2 / (float)Math.sqrt(h2 / r * h2 / r + 1.0f);
                this.baseHeightAdjustment = (float)Math.sqrt(h2 * h2 - this.baseRadiusAdjustment * this.baseRadiusAdjustment);
            }
        } else {
            this.baseHeightAdjustment = 0.0f;
        }
        return true;
    }

    public class_241 renderAdjustment(float mouseX, float mouseY, class_241 mouseDelta) {
        int newHeight;
        int newRadius;
        float deltaX = mouseDelta.field_1343 + this.baseRadiusAdjustment;
        float deltaY = mouseDelta.field_1342 - this.baseHeightAdjustment;
        float actualLength = (float)Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        float factor = actualLength / Math.max(Math.abs(deltaX), Math.abs(deltaY));
        float m11 = EditorUI.lastProjectionMatrix.m11();
        if (BrushWidget.hasHeight(this.shape[0])) {
            int maxVolume;
            float lengthForHeight = Math.abs(deltaY * factor);
            float lengthForRadius = Math.abs(deltaX * factor);
            newRadius = Math.round(lengthForRadius / ImGui.getMainViewport().getSizeY() * this.raycastDistance * 2.0f / m11);
            newHeight = Math.round(lengthForHeight / ImGui.getMainViewport().getSizeY() * this.raycastDistance * 2.0f / m11);
            if (newRadius < 0) {
                newRadius = 0;
            }
            if (newRadius > 200) {
                newRadius = 200;
            }
            if (newHeight < 0) {
                newHeight = 0;
            }
            if (newHeight > 200) {
                newHeight = 200;
            }
            if (this.shape[0] == 6 && newHeight < newRadius) {
                newHeight = newRadius;
            }
            if (newRadius * newHeight > (maxVolume = 2500)) {
                float scaleDown = (float)Math.sqrt((float)maxVolume / (float)(newRadius * newHeight));
                newRadius = Math.round((float)newRadius * scaleDown);
                newHeight = Math.round((float)newHeight * scaleDown);
            }
            if (this.shape[0] == 6) {
                newHeight = Math.max(0, newHeight - newRadius);
            }
        } else {
            newRadius = Math.round(actualLength / ImGui.getMainViewport().getSizeY() * this.raycastDistance * 2.0f / m11);
            newHeight = this.height[0];
            if (newRadius < 0) {
                newRadius = 0;
            }
            if (newRadius > 50) {
                newRadius = 50;
            }
        }
        if (this.radius[0] != newRadius) {
            this.radius[0] = newRadius;
            this.dirty = true;
        }
        if (this.height[0] != newHeight) {
            this.height[0] = newHeight;
            this.dirty = true;
        }
        if (deltaX != 0.0f || deltaY != 0.0f) {
            ImDrawList drawList = ImGui.getForegroundDrawList();
            float targetLength = 6.0f;
            float divisions = actualLength / targetLength;
            if (divisions < 1.0f) {
                divisions = 1.0f;
            }
            if (divisions > 100.0f) {
                divisions = 100.0f;
            }
            int i = 1;
            while ((float)i < divisions) {
                float x1 = deltaX - deltaX * (float)i / divisions;
                float y1 = deltaY - deltaY * (float)i / divisions;
                float x2 = deltaX - deltaX * Math.min(1.0f, (float)(i + 1) / divisions);
                float y2 = deltaY - deltaY * Math.min(1.0f, (float)(i + 1) / divisions);
                drawList.addLine(mouseX + x1, mouseY + y1, mouseX + x2, mouseY + y2, -16777216, 1.0f);
                i += 2;
            }
            float angle = (float)Math.atan2(deltaX, deltaY);
            float arrowMainX = class_3532.method_15374((float)angle);
            float arrowMainY = class_3532.method_15362((float)angle);
            float arrowLeftX = class_3532.method_15374((float)(angle + 2.3561945f));
            float arrowLeftY = class_3532.method_15362((float)(angle + 2.3561945f));
            float arrowRightX = class_3532.method_15374((float)(angle - 2.3561945f));
            float arrowRightY = class_3532.method_15362((float)(angle - 2.3561945f));
            drawList.addLine(mouseX + deltaX + arrowMainX * 4.0f, mouseY + deltaY + arrowMainY * 4.0f, mouseX + deltaX + arrowMainX * 15.0f, mouseY + deltaY + arrowMainY * 15.0f, -16777216, 2.0f);
            drawList.addLine(mouseX + deltaX + arrowMainX * 15.0f - arrowLeftX, mouseY + deltaY + arrowMainY * 15.0f - arrowLeftY, mouseX + deltaX + arrowMainX * 15.0f + arrowLeftX * 7.0f, mouseY + deltaY + arrowMainY * 15.0f + arrowLeftY * 7.0f, -16777216, 2.0f);
            drawList.addLine(mouseX + deltaX + arrowMainX * 15.0f - arrowRightX, mouseY + deltaY + arrowMainY * 15.0f - arrowRightY, mouseX + deltaX + arrowMainX * 15.0f + arrowRightX * 7.0f, mouseY + deltaY + arrowMainY * 15.0f + arrowRightY * 7.0f, -16777216, 2.0f);
            drawList.addLine(mouseX + deltaX - arrowMainX * 4.0f, mouseY + deltaY - arrowMainY * 4.0f, mouseX + deltaX - arrowMainX * 15.0f, mouseY + deltaY - arrowMainY * 15.0f, -16777216, 2.0f);
            drawList.addLine(mouseX + deltaX - arrowMainX * 15.0f + arrowLeftX, mouseY + deltaY - arrowMainY * 15.0f + arrowLeftY, mouseX + deltaX - arrowMainX * 15.0f - arrowLeftX * 7.0f, mouseY + deltaY - arrowMainY * 15.0f - arrowLeftY * 7.0f, -16777216, 2.0f);
            drawList.addLine(mouseX + deltaX - arrowMainX * 15.0f + arrowRightX, mouseY + deltaY - arrowMainY * 15.0f + arrowRightY, mouseX + deltaX - arrowMainX * 15.0f - arrowRightX * 7.0f, mouseY + deltaY - arrowMainY * 15.0f - arrowRightY * 7.0f, -16777216, 2.0f);
        }
        return mouseDelta;
    }
}

