/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.mixin.world_properties;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.annotations.ServerAnnotations;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.hooks.ServerLevelExt;
import com.moulberry.axiom.hooks.ThreadedLevelLightEngineExt;
import com.moulberry.axiom.marker.MarkerData;
import com.moulberry.axiom.packets.AxiomClientboundMarkerData;
import com.moulberry.axiom.utils.StarlightHelper;
import com.moulberry.axiom.world_properties.server.ServerWorldPropertiesRegistry;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2672;
import net.minecraft.class_2676;
import net.minecraft.class_2818;
import net.minecraft.class_2874;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3227;
import net.minecraft.class_3230;
import net.minecraft.class_3695;
import net.minecraft.class_3898;
import net.minecraft.class_5250;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5577;
import net.minecraft.class_6335;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3218.class})
public abstract class MixinServerLevel
extends class_1937
implements ServerLevelExt {
    @Shadow
    @Final
    private List<class_3222> field_18261;
    @Unique
    private ServerWorldPropertiesRegistry worldPropertiesRegistry;
    @Unique
    private final Map<UUID, MarkerData> previousMarkerData = new HashMap<UUID, MarkerData>();
    @Unique
    private final LongSet pendingChunksToSend = new LongOpenHashSet();
    @Unique
    private final Long2ObjectMap<short[][]> pendingLightSectionUpdates = new Long2ObjectOpenHashMap();
    @Unique
    private final LongSet pendingLightChunks = new LongOpenHashSet();
    @Unique
    private final List<CompletableFuture<?>> waitForPendingLightTasks = new ArrayList();
    @Unique
    private final LongSet starlightRelightChunks = new LongOpenHashSet();
    private static boolean promptedForStarlightInstall = false;
    @Unique
    private int totalLightUpdates = 0;
    @Unique
    private int completedLightUpdates = 0;
    @Unique
    private int ticksSinceLightUpdate = 0;
    private static final class_3230 RELIGHT = new class_3230(300L, false, class_3230.class_10558.field_55601);

    protected MixinServerLevel(class_5269 writableLevelData, class_5321<class_1937> resourceKey, class_5455 registryAccess, class_6880<class_2874> holder, Supplier<class_3695> supplier, boolean bl, boolean bl2, long l, int i) {
        super(null, null, null, null, false, false, 0L, 0);
    }

    @Shadow
    public abstract class_3215 method_14178();

    @Shadow
    public abstract List<class_3222> method_18456();

    @Shadow
    protected abstract class_5577<class_1297> method_31592();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void afterInit(CallbackInfo ci) {
        this.worldPropertiesRegistry = new ServerWorldPropertiesRegistry((class_3218)this);
    }

    @Override
    public ServerWorldPropertiesRegistry axiom$getWorldProperties() {
        return this.worldPropertiesRegistry;
    }

    @Inject(method={"addPlayer"}, at={@At(value="HEAD")})
    public void onPlayerJoinedWorld(class_3222 serverPlayer, CallbackInfo ci) {
        this.worldPropertiesRegistry.registerFor(serverPlayer);
        if (!this.previousMarkerData.isEmpty()) {
            ArrayList<MarkerData> markerData = new ArrayList<MarkerData>(this.previousMarkerData.values());
            new AxiomClientboundMarkerData(markerData, Set.of()).send(serverPlayer);
        }
        ServerAnnotations.sendAll((class_3218)this, serverPlayer);
    }

    @Override
    public void axiom$processTasks() {
        this.updateMarkerEntities();
        this.updateLighting();
    }

    @Unique
    private void updateMarkerEntities() {
        ArrayList<MarkerData> changedData = new ArrayList<MarkerData>();
        HashSet<UUID> allMarkers = new HashSet<UUID>();
        for (class_1297 entity : this.method_31592().method_31803()) {
            MarkerData previousData;
            if (!(entity instanceof class_6335)) continue;
            class_6335 marker = (class_6335)entity;
            MarkerData currentData = MarkerData.createFrom(marker);
            if (!Objects.equals(currentData, previousData = this.previousMarkerData.get(marker.method_5667()))) {
                this.previousMarkerData.put(marker.method_5667(), currentData);
                changedData.add(currentData);
            }
            allMarkers.add(marker.method_5667());
        }
        HashSet<UUID> oldUuids = new HashSet<UUID>(this.previousMarkerData.keySet());
        oldUuids.removeAll(allMarkers);
        this.previousMarkerData.keySet().removeAll(oldUuids);
        if (!changedData.isEmpty() || !oldUuids.isEmpty()) {
            AxiomClientboundMarkerData dataPacket = new AxiomClientboundMarkerData(changedData, oldUuids);
            for (class_3222 player : this.field_18261) {
                dataPacket.send(player);
            }
        }
    }

    @Override
    public void axiom$markChunkDirty(int cx, int cz) {
        this.pendingChunksToSend.add(class_1923.method_8331((int)cx, (int)cz));
    }

    @Override
    public short[] axiom$getPendingLightUpdates(int cx, int cy, int cz) {
        short[][] allUpdates = (short[][])this.pendingLightSectionUpdates.computeIfAbsent(class_1923.method_8331((int)cx, (int)cz), k -> new short[this.method_32890()][]);
        short[] section = allUpdates[cy - this.method_32891()];
        if (section == null) {
            section = new short[256];
            allUpdates[cy - this.method_32891()] = section;
            ++this.totalLightUpdates;
        }
        return section;
    }

    @Override
    public void axiom$relightChunkStarlight(int cx, int cz) {
        this.starlightRelightChunks.add(class_1923.method_8331((int)cx, (int)cz));
    }

    @Unique
    private void updateLighting() {
        class_3898 chunkMap = this.method_14178().field_17254;
        LongIterator longIterator = this.pendingChunksToSend.longIterator();
        while (longIterator.hasNext()) {
            class_1923 chunkPos2 = new class_1923(longIterator.nextLong());
            List players = chunkMap.method_17210(chunkPos2, false);
            if (players.isEmpty()) continue;
            class_2818 chunk = this.method_8497(chunkPos2.field_9181, chunkPos2.field_9180);
            class_2672 packet = new class_2672(chunk, this.method_22336(), null, null);
            for (class_3222 player : players) {
                player.field_13987.method_14364((class_2596)packet);
            }
        }
        this.pendingChunksToSend.clear();
        this.waitForPendingLightTasks.removeIf(CompletableFuture::isDone);
        if (!this.waitForPendingLightTasks.isEmpty()) {
            ++this.ticksSinceLightUpdate;
        } else if (!this.pendingLightSectionUpdates.isEmpty() || !this.starlightRelightChunks.isEmpty()) {
            ++this.ticksSinceLightUpdate;
            class_3227 lightEngine = this.method_14178().method_17293();
            boolean hasStarlight = Axiom.hasStarlight();
            if (hasStarlight) {
                if (!this.pendingLightSectionUpdates.isEmpty()) {
                    throw new FaultyImplementationError();
                }
                HashSet<class_1923> chunksToRelight = new HashSet<class_1923>();
                iterator = this.starlightRelightChunks.iterator();
                while (iterator.hasNext()) {
                    long pos = iterator.nextLong();
                    class_1923 chunkPos3 = new class_1923(pos);
                    chunksToRelight.add(chunkPos3);
                    if (!this.pendingLightChunks.add(pos)) continue;
                    this.method_14178().method_66009(RELIGHT, chunkPos3, 1);
                }
                this.starlightRelightChunks.clear();
                CompletableFuture future = new CompletableFuture();
                this.waitForPendingLightTasks.add(future);
                StarlightHelper.relightChunks(lightEngine, chunksToRelight, chunkPos -> {}, num -> future.complete(null));
            } else {
                if (!this.starlightRelightChunks.isEmpty()) {
                    throw new FaultyImplementationError();
                }
                int doTaskCount = Math.max((this.totalLightUpdates - this.completedLightUpdates) / 100, 8);
                iterator = this.pendingLightSectionUpdates.long2ObjectEntrySet().iterator();
                while (iterator.hasNext()) {
                    Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
                    long pos = entry.getLongKey();
                    short[][] all = (short[][])entry.getValue();
                    int cx = class_1923.method_8325((long)pos);
                    int cz = class_1923.method_8332((long)pos);
                    boolean allEmpty = true;
                    boolean finished = false;
                    for (int i = all.length - 1; i >= 0; --i) {
                        short[] array;
                        if (i == 0) {
                            finished = true;
                        }
                        if ((array = all[i]) == null) continue;
                        all[i] = null;
                        boolean empty = true;
                        for (short v : array) {
                            if (v == 0) continue;
                            empty = false;
                            allEmpty = false;
                            break;
                        }
                        ++this.completedLightUpdates;
                        if (empty) continue;
                        ((ThreadedLevelLightEngineExt)lightEngine).axiom$checkSectionBlocks(cx, i + this.method_32891(), cz, array);
                        if (--doTaskCount <= 0) break;
                    }
                    if (!allEmpty) {
                        if (this.pendingLightChunks.add(class_1923.method_8331((int)cx, (int)cz))) {
                            class_1923 chunkPos4 = new class_1923(cx, cz);
                            this.method_14178().method_66009(RELIGHT, chunkPos4, 1);
                        }
                        CompletableFuture<?> future = ((ThreadedLevelLightEngineExt)lightEngine).axiom$waitForPendingTasks(cx, cz);
                        this.waitForPendingLightTasks.add(future);
                    }
                    if (finished) {
                        iterator.remove();
                    }
                    if (doTaskCount != 0) continue;
                    break;
                }
            }
            lightEngine.method_17303();
            if (this.totalLightUpdates > 64 && this.ticksSinceLightUpdate > 20) {
                int percentage = 100 * this.completedLightUpdates / this.totalLightUpdates;
                String text = "Lighting: " + this.completedLightUpdates + "/" + this.totalLightUpdates + " (" + percentage + "%)";
                class_5250 component = class_2561.method_43470((String)text).method_27692(class_124.field_1054);
                for (class_3222 player : this.field_18261) {
                    if (!player.method_7325()) continue;
                    player.method_7353((class_2561)component, true);
                }
            }
        } else {
            this.completedLightUpdates = 0;
            this.totalLightUpdates = 0;
            this.ticksSinceLightUpdate = 0;
            if (!this.pendingLightChunks.isEmpty()) {
                LongOpenHashSet sentLitChunks = new LongOpenHashSet();
                longIterator = this.pendingLightChunks.longIterator();
                while (longIterator.hasNext()) {
                    class_1923 centerChunkPos = new class_1923(longIterator.nextLong());
                    this.method_14178().method_66010(RELIGHT, centerChunkPos, 1);
                    for (int x = -1; x <= 1; ++x) {
                        for (int z = -1; z <= 1; ++z) {
                            List players;
                            class_1923 chunkPos5 = new class_1923(centerChunkPos.field_9181 + x, centerChunkPos.field_9180 + z);
                            if (!sentLitChunks.add(chunkPos5.method_8324()) || (players = chunkMap.method_17210(chunkPos5, false)).isEmpty()) continue;
                            class_2676 packet = new class_2676(chunkPos5, this.method_22336(), null, null);
                            for (class_3222 player : players) {
                                player.field_13987.method_14364((class_2596)packet);
                            }
                        }
                    }
                }
                this.pendingLightChunks.clear();
            }
        }
    }
}

