/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.render;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.buffers.Std140Builder;
import com.mojang.blaze3d.buffers.Std140SizeCalculator;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.utils.FramebufferUtils;
import com.moulberry.axiom.utils.ProjectionMatrixBackup;
import com.moulberry.axiom.utils.RenderHelper;
import java.nio.ByteBuffer;
import java.util.OptionalInt;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1041;
import net.minecraft.class_10789;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_5944;
import net.minecraft.class_6367;
import net.minecraft.class_9801;
import org.lwjgl.system.MemoryStack;

public class ShaderManager
implements SimpleSynchronousResourceReloadListener {
    public static final ShaderManager INSTANCE = new ShaderManager();
    private static Object blockShader = null;
    private static Object borderShader = null;
    private static Object brightenLightmapShader = null;
    private static Object selectionOutlineShader = null;
    private static Object collisionMeshShader = null;
    private static Object positionColorNoVertexColorShader = null;
    private static Object instancedBlockShader = null;
    private static Object instancedLineShader = null;
    private static Object blitScreenOldShader = null;
    private static boolean selectionOutlineCleared = false;
    private static boolean selectionOutlineRenderedTo = false;
    private static boolean selectionOutlineCopiedDepth = false;
    private static class_276 selectionOutlineTarget;
    private static final RenderPipeline SELECTION_BLIT;
    private static final int IN_OUT_UBO_SIZE;
    private static GpuBuffer inOutUboBuffer;
    private static GpuBufferSlice inOutUboBufferSlice;
    private static int lastInWidth;
    private static int lastInHeight;
    private static int lastOutWidth;
    private static int lastOutHeight;

    public class_2960 getFabricId() {
        return class_2960.method_60654((String)"axiom:shaders");
    }

    public static void preCopySelectionOutlineTarget() {
        if (!selectionOutlineCleared) {
            FramebufferUtils.clear(selectionOutlineTarget, 0);
            selectionOutlineCleared = true;
        }
        if (!selectionOutlineCopiedDepth) {
            FramebufferUtils.copyDepth(class_310.method_1551().method_1522(), selectionOutlineTarget);
            selectionOutlineCopiedDepth = true;
        }
    }

    public static class_276 getSelectionOutlineTarget(boolean copyDepth) {
        if (!selectionOutlineCleared) {
            selectionOutlineCleared = true;
            FramebufferUtils.clear(selectionOutlineTarget, 0);
        }
        if (copyDepth && !selectionOutlineCopiedDepth) {
            FramebufferUtils.copyDepth(class_310.method_1551().method_1522(), selectionOutlineTarget);
            selectionOutlineCopiedDepth = true;
        }
        selectionOutlineRenderedTo = true;
        return selectionOutlineTarget;
    }

    public static void blitSelectionOutlineTarget() {
        if (selectionOutlineRenderedTo) {
            if (inOutUboBuffer == null) {
                GpuDevice gpuDevice = RenderSystem.getDevice();
                inOutUboBuffer = gpuDevice.createBuffer(() -> "AxiomSelectionInOutUBO ", 136, IN_OUT_UBO_SIZE);
                inOutUboBufferSlice = inOutUboBuffer.slice(0, IN_OUT_UBO_SIZE);
            }
            class_276 outTarget = class_310.method_1551().method_1522();
            RenderSystem.class_5590 autoStorageIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
            GpuBuffer gpuBuffer = autoStorageIndexBuffer.method_68274(6);
            VertexConsumerProvider provider = VertexConsumerProvider.shared();
            class_287 bufferBuilder = provider.begin(VertexFormat.class_5596.field_27382, class_290.field_1592);
            bufferBuilder.method_22912(0.0f, 0.0f, 2000.0f);
            bufferBuilder.method_22912(0.0f, (float)outTarget.field_1481, 2000.0f);
            bufferBuilder.method_22912((float)outTarget.field_1482, (float)outTarget.field_1481, 2000.0f);
            bufferBuilder.method_22912((float)outTarget.field_1482, 0.0f, 2000.0f);
            try (class_9801 meshData = bufferBuilder.method_60794();){
                GpuBuffer vertexBuffer = class_290.field_1592.uploadImmediateVertexBuffer(meshData.method_60818());
                ProjectionMatrixBackup backup = ProjectionMatrixBackup.create();
                RenderHelper.setOrthoProjectionMatrix(outTarget.field_1482, outTarget.field_1481);
                if (lastInWidth != ShaderManager.selectionOutlineTarget.field_1482 || lastInHeight != ShaderManager.selectionOutlineTarget.field_1481 || lastOutWidth != outTarget.field_1482 || lastOutHeight != outTarget.field_1481) {
                    lastInWidth = ShaderManager.selectionOutlineTarget.field_1482;
                    lastInHeight = ShaderManager.selectionOutlineTarget.field_1481;
                    lastOutWidth = outTarget.field_1482;
                    lastOutHeight = outTarget.field_1481;
                    try (MemoryStack memoryStack = MemoryStack.stackPush();){
                        ByteBuffer byteBuffer = Std140Builder.onStack((MemoryStack)memoryStack, (int)IN_OUT_UBO_SIZE).putVec2((float)ShaderManager.selectionOutlineTarget.field_1482, (float)ShaderManager.selectionOutlineTarget.field_1481).putVec2((float)outTarget.field_1482, (float)outTarget.field_1481).get();
                        RenderSystem.getDevice().createCommandEncoder().writeToBuffer(inOutUboBufferSlice, byteBuffer);
                    }
                }
                try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Axiom Selection Outline", outTarget.method_71639(), OptionalInt.empty());){
                    renderPass.setPipeline(SELECTION_BLIT);
                    renderPass.setVertexBuffer(0, vertexBuffer);
                    renderPass.setIndexBuffer(gpuBuffer, autoStorageIndexBuffer.method_31924());
                    RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
                    renderPass.setUniform("InOutSize", inOutUboBufferSlice);
                    renderPass.bindSampler("InSampler", selectionOutlineTarget.method_71639());
                    renderPass.drawIndexed(0, 0, 6, 1);
                }
                backup.restore();
            }
        }
        selectionOutlineCleared = false;
        selectionOutlineRenderedTo = false;
        selectionOutlineCopiedDepth = false;
    }

    public void register() {
    }

    public void method_14491(class_3300 resourceManager) {
        if (selectionOutlineTarget != null) {
            selectionOutlineTarget.method_1238();
        }
        class_1041 window = class_310.method_1551().method_22683();
        selectionOutlineTarget = new class_6367(null, window.method_4489(), window.method_4506(), true);
    }

    public void onResolutionChanged(int width, int height) {
        if (selectionOutlineTarget != null) {
            selectionOutlineTarget.method_1234(width, height);
        }
    }

    public static class_5944 enableLinesShader() {
        throw new UnsupportedOperationException();
    }

    public static class_5944 enablePositionColorShader() {
        throw new UnsupportedOperationException();
    }

    public static class_5944 enablePositionTexShader() {
        throw new UnsupportedOperationException();
    }

    public static class_5944 enablePositionTexColorShader() {
        throw new UnsupportedOperationException();
    }

    public static class_5944 enableRendertypeSolidShader() {
        throw new UnsupportedOperationException();
    }

    public static class_5944 enableRendertypeCutoutShader() {
        throw new UnsupportedOperationException();
    }

    public static class_5944 enableRendertypeCutoutMippedShader() {
        throw new UnsupportedOperationException();
    }

    public static class_5944 enableRendertypeTranslucentShader() {
        throw new UnsupportedOperationException();
    }

    public static class_5944 enableRendertypeTripwireShader() {
        throw new UnsupportedOperationException();
    }

    public static class_5944 enableAxiomBlockShader() {
        throw new UnsupportedOperationException();
    }

    public static class_5944 enableBorderShader() {
        throw new UnsupportedOperationException();
    }

    public static class_5944 enableBrightenLightmapShader() {
        throw new UnsupportedOperationException();
    }

    public static class_5944 enableSelectionOutlineShader() {
        throw new UnsupportedOperationException();
    }

    public static class_5944 enableCollisionMeshShader() {
        throw new UnsupportedOperationException();
    }

    public static class_5944 enablePositionColorNoVertexColorShader() {
        throw new UnsupportedOperationException();
    }

    public static class_5944 enableBlitScreenOldShader() {
        throw new UnsupportedOperationException();
    }

    static {
        SELECTION_BLIT = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[0]).withLocation(class_2960.method_60654((String)"axiom:pipeline/selection_outline_blit")).withVertexShader(class_2960.method_60654((String)"axiom:core/selection_outline")).withFragmentShader(class_2960.method_60654((String)"axiom:core/selection_outline")).withSampler("InSampler").withUniform("InOutSize", class_10789.field_60031).withUniform("Projection", class_10789.field_60031).withBlend(BlendFunction.ENTITY_OUTLINE_BLIT).withDepthWrite(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).withColorWrite(true, false).withVertexFormat(class_290.field_1592, VertexFormat.class_5596.field_27382).build();
        IN_OUT_UBO_SIZE = new Std140SizeCalculator().putVec2().putVec2().get();
        inOutUboBuffer = null;
        inOutUboBufferSlice = null;
        lastInWidth = -1;
        lastInHeight = -1;
        lastOutWidth = -1;
        lastOutHeight = -1;
    }
}

