/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.render.regions;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.moulberry.axiom.GlobalCleaner;
import com.moulberry.axiom.collections.Position2ByteMap;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.collections.list.IntrusiveLinkedElement;
import com.moulberry.axiom.collections.list.IntrusiveLinkedList;
import com.moulberry.axiom.core_rendering.AxiomBufferUsage;
import com.moulberry.axiom.core_rendering.AxiomDraw;
import com.moulberry.axiom.core_rendering.AxiomDrawBuffer;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.render.EffectRenderer;
import com.moulberry.axiom.render.MeshDataHelper;
import com.moulberry.axiom.render.SortStateWrapper;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.render.regions.InvertedVertexSorting;
import com.moulberry.axiom.utils.ExpandOffsets;
import com.moulberry.axiom.utils.FramebufferUtils;
import com.moulberry.axiomclientapi.funcinterfaces.TriIntConsumer;
import com.moulberry.axiomclientapi.pathers.BallShape;
import com.moulberry.axiomclientapi.regions.BooleanRegion;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class ChunkedBooleanRegion
implements BooleanRegion {
    private boolean closed = false;
    private GlobalCleaner.LeakChecker leakChecker;
    private PositionSet positionSet;
    private final class_2338.class_2339 min = new class_2338.class_2339();
    private final class_2338.class_2339 max = new class_2338.class_2339();
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float scaleZ = 1.0f;
    private final Long2ObjectMap<ChunkData> chunkData = new Long2ObjectOpenHashMap();
    private LongSet dirtyChunks = new LongOpenHashSet();
    private boolean clearChunkData = false;
    private long lastSortMillis;
    private float lastSortX;
    private float lastSortY;
    private float lastSortZ;
    private int lastSortChunkX;
    private int lastSortChunkY;
    private int lastSortChunkZ;
    private final IntrusiveLinkedList<ChunkData> sortedChunkData = new IntrusiveLinkedList();
    private static class_276 copiedDepth = null;
    private static final float EPS = 1.0E-5f;
    private static final int SHADE_X = 178;
    private static final int SHADE_PLUS_Y = 255;
    private static final int SHADE_MINUS_Y = 153;
    private static final int SHADE_Z = 222;

    public ChunkedBooleanRegion() {
        this(new PositionSet());
    }

    public ChunkedBooleanRegion(PositionSet positionSet) {
        this.positionSet = positionSet.copy();
        if (!positionSet.isEmpty()) {
            this.updateBoundingMinMax(true, true, true, true, true, true);
            this.positionSet.forEachChunk((cx, cy, cz, array) -> {
                this.dirtyChunks.add(class_2338.method_10064((int)cx, (int)cy, (int)cz));
                this.dirtyChunks.add(class_2338.method_10064((int)(cx - 1), (int)cy, (int)cz));
                this.dirtyChunks.add(class_2338.method_10064((int)(cx + 1), (int)cy, (int)cz));
                this.dirtyChunks.add(class_2338.method_10064((int)cx, (int)(cy - 1), (int)cz));
                this.dirtyChunks.add(class_2338.method_10064((int)cx, (int)(cy + 1), (int)cz));
                this.dirtyChunks.add(class_2338.method_10064((int)cx, (int)cy, (int)(cz - 1)));
                this.dirtyChunks.add(class_2338.method_10064((int)cx, (int)cy, (int)(cz + 1)));
            });
        }
    }

    public void render(class_4184 camera, class_243 translation, class_4587 matrix, Matrix4f projection, long time, int effects) {
        class_276 renderTarget;
        this.uploadDirty(camera, translation);
        if (this.sortedChunkData.isEmpty()) {
            return;
        }
        class_276 mainRenderTarget = class_310.method_1551().method_1522();
        int width = mainRenderTarget.field_1482;
        int height = mainRenderTarget.field_1481;
        class_276 particlesTarget = class_310.method_1551().field_1769.method_29362();
        if (particlesTarget != null) {
            renderTarget = particlesTarget;
            if (copiedDepth != null) {
                copiedDepth.method_1238();
                copiedDepth = null;
            }
        } else {
            copiedDepth = FramebufferUtils.resizeOrCreateFramebuffer(copiedDepth, width, height);
            FramebufferUtils.clear(copiedDepth, 0);
            FramebufferUtils.copyDepth(mainRenderTarget, copiedDepth);
            renderTarget = mainRenderTarget;
        }
        ArrayList<AxiomDraw> axiomDraws = new ArrayList<AxiomDraw>(this.sortedChunkData.size());
        ChunkData firstChunkData = this.sortedChunkData.first();
        double originX = firstChunkData.offsetX;
        double originY = firstChunkData.offsetY;
        double originZ = firstChunkData.offsetZ;
        Matrix4d initialTransform = new Matrix4d();
        if (camera != null) {
            initialTransform.translate(-camera.method_19326().field_1352, -camera.method_19326().field_1351, -camera.method_19326().field_1350);
        }
        initialTransform.translate(translation.field_1352, translation.field_1351, translation.field_1350);
        initialTransform.scale((double)this.scaleX, (double)this.scaleY, (double)this.scaleZ);
        initialTransform.translate(originX, originY, originZ);
        matrix.method_22903();
        matrix.method_34425((Matrix4fc)new Matrix4f((Matrix4dc)initialTransform));
        Matrix4f modelViewMatrix = matrix.method_23760().method_23761();
        for (ChunkData data : this.sortedChunkData) {
            Matrix4f matrix4f = new Matrix4f((Matrix4fc)modelViewMatrix);
            matrix4f.translate((float)((double)data.offsetX - originX), (float)((double)data.offsetY - originY), (float)((double)data.offsetZ - originZ));
            axiomDraws.add(new AxiomDraw(data.buffer, matrix4f, null));
        }
        EffectRenderer.render((pipeline, target) -> AxiomRenderer.renderPipeline(pipeline, target != null ? target : renderTarget, axiomDraws), time, effects);
        AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
        if (copiedDepth != null) {
            FramebufferUtils.copyDepth(copiedDepth, mainRenderTarget);
        }
        matrix.method_22909();
    }

    private void uploadDirty(class_4184 camera, class_243 translation) {
        RenderSystem.assertOnRenderThread();
        if (this.clearChunkData) {
            this.clearChunkData = false;
            for (ChunkData chunkDatum : this.chunkData.values()) {
                chunkDatum.buffer.close();
            }
            this.chunkData.clear();
            this.sortedChunkData.clear();
        }
        LongSet chunksToUpload = this.dirtyChunks;
        this.dirtyChunks = new LongOpenHashSet();
        VertexConsumerProvider provider = VertexConsumerProvider.shared();
        float sortX = (float)((camera != null ? camera.method_19326().field_1352 : 0.0) - translation.field_1352) / this.scaleX;
        float sortY = (float)((camera != null ? camera.method_19326().field_1351 : 0.0) - translation.field_1351) / this.scaleY;
        float sortZ = (float)((camera != null ? camera.method_19326().field_1350 : 0.0) - translation.field_1350) / this.scaleZ;
        boolean addedNewChunk = false;
        LongIterator longIterator = chunksToUpload.iterator();
        while (longIterator.hasNext()) {
            ChunkData chunkData;
            long pos = (Long)longIterator.next();
            int chunkX = class_2338.method_10061((long)pos);
            int chunkY = class_2338.method_10071((long)pos);
            int chunkZ = class_2338.method_10083((long)pos);
            class_287 bufferBuilder = null;
            short[] chunk = this.positionSet.getChunk(pos);
            if (chunk != null) {
                short[] up = this.positionSet.getChunk(class_2338.method_10064((int)chunkX, (int)(chunkY + 1), (int)chunkZ));
                short[] down = this.positionSet.getChunk(class_2338.method_10064((int)chunkX, (int)(chunkY - 1), (int)chunkZ));
                short[] north = this.positionSet.getChunk(class_2338.method_10064((int)chunkX, (int)chunkY, (int)(chunkZ - 1)));
                short[] south = this.positionSet.getChunk(class_2338.method_10064((int)chunkX, (int)chunkY, (int)(chunkZ + 1)));
                short[] east = this.positionSet.getChunk(class_2338.method_10064((int)(chunkX - 1), (int)chunkY, (int)chunkZ));
                short[] west = this.positionSet.getChunk(class_2338.method_10064((int)(chunkX + 1), (int)chunkY, (int)chunkZ));
                bufferBuilder = ChunkedBooleanRegion.buildChunkVanilla(provider, chunk, up, down, north, south, east, west);
            }
            if (bufferBuilder != null && bufferBuilder.field_1554 > 0) {
                MeshDataHelper.MeshDataAndSortState meshDataAndSortState;
                chunkData = (ChunkData)this.chunkData.get(pos);
                if (chunkData == null) {
                    chunkData = new ChunkData(chunkX * 16, chunkY * 16, chunkZ * 16);
                    this.chunkData.put(pos, (Object)chunkData);
                    float dx = this.lastSortChunkX * 16 - chunkData.offsetX;
                    float dy = this.lastSortChunkY * 16 - chunkData.offsetY;
                    float dz = this.lastSortChunkZ * 16 - chunkData.offsetZ;
                    chunkData.distanceSqToCamera = dx * dx + dy * dy + dz * dz;
                    this.sortedChunkData.add(chunkData);
                    addedNewChunk = true;
                }
                if ((meshDataAndSortState = MeshDataHelper.buildAndSort(bufferBuilder, InvertedVertexSorting.byDistance(sortX - (float)chunkData.offsetX, sortY - (float)chunkData.offsetY, sortZ - (float)chunkData.offsetZ))) == null) continue;
                chunkData.buffer.upload(meshDataAndSortState.meshData());
                chunkData.sortState = meshDataAndSortState.sortStateWrapper();
                continue;
            }
            if (bufferBuilder != null) {
                MeshDataHelper.discard(bufferBuilder.method_60794());
            }
            if ((chunkData = (ChunkData)this.chunkData.remove(pos)) == null) continue;
            this.sortedChunkData.remove(chunkData);
            chunkData.buffer.close();
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastSortMillis < 250L) {
            if (addedNewChunk) {
                this.sortedChunkData.sort(Comparator.comparingDouble(c -> c.distanceSqToCamera));
            }
            return;
        }
        double dX = sortX - this.lastSortX;
        double dY = sortY - this.lastSortY;
        double dZ = sortZ - this.lastSortZ;
        if (dX * dX + dY * dY + dZ * dZ < 1.0) {
            if (addedNewChunk) {
                this.sortedChunkData.sort(Comparator.comparingDouble(c -> c.distanceSqToCamera));
            }
            return;
        }
        this.lastSortX = sortX;
        this.lastSortY = sortY;
        this.lastSortZ = sortZ;
        this.lastSortMillis = currentTime;
        int chunkX = class_4076.method_32204((double)sortX);
        int chunkY = class_4076.method_32204((double)sortY);
        int chunkZ = class_4076.method_32204((double)sortZ);
        boolean resortChunkList = chunkX != this.lastSortChunkX || chunkY != this.lastSortChunkY || chunkZ != this.lastSortChunkZ;
        for (ChunkData chunkData : this.sortedChunkData) {
            class_287 bufferBuilder = provider.begin(VertexFormat.class_5596.field_27382, class_290.field_1576);
            chunkData.sortState = MeshDataHelper.resort(bufferBuilder, chunkData.sortState, chunkData.buffer, InvertedVertexSorting.byDistance(sortX - (float)chunkData.offsetX, sortY - (float)chunkData.offsetY, sortZ - (float)chunkData.offsetZ));
            if (!resortChunkList) continue;
            float dx = chunkX * 16 - chunkData.offsetX;
            float dy = chunkY * 16 - chunkData.offsetY;
            float dz = chunkZ * 16 - chunkData.offsetZ;
            chunkData.distanceSqToCamera = dx * dx + dy * dy + dz * dz;
        }
        if (resortChunkList) {
            this.lastSortChunkX = chunkX;
            this.lastSortChunkY = chunkY;
            this.lastSortChunkZ = chunkZ;
            this.sortedChunkData.sort(Comparator.comparingDouble(c -> c.distanceSqToCamera));
        } else if (addedNewChunk) {
            this.sortedChunkData.sort(Comparator.comparingDouble(c -> c.distanceSqToCamera));
        }
    }

    @Nullable
    private static class_287 buildChunkVanilla(VertexConsumerProvider provider, short[] chunk, short[] up, short[] down, short[] north, short[] south, short[] east, short[] west) {
        class_287 bufferBuilder = null;
        int index = 0;
        for (int z = 0; z < 16; ++z) {
            for (int y = 0; y < 16; ++y) {
                short v;
                if ((v = chunk[index++]) == 0) continue;
                if (bufferBuilder == null) {
                    bufferBuilder = provider.begin(VertexFormat.class_5596.field_27382, class_290.field_1576);
                }
                for (int x = 0; x < 16; ++x) {
                    boolean minusZ;
                    boolean plusZ;
                    boolean minusY;
                    boolean plusY;
                    boolean minusX;
                    boolean plusX;
                    if ((v & 1 << x) == 0) continue;
                    if (x == 0) {
                        plusX = (v & 2) == 0;
                        minusX = east == null || (east[y + z * 16] & 0x8000) == 0;
                    } else if (x == 15) {
                        plusX = west == null || (west[y + z * 16] & 1) == 0;
                        minusX = (v & 0x4000) == 0;
                    } else {
                        plusX = (v & 1 << x + 1) == 0;
                        boolean bl = minusX = (v & 1 << x - 1) == 0;
                    }
                    if (plusX) {
                        bufferBuilder.method_22912((float)(x + 1) + 1.0E-5f, (float)y, (float)z).method_1336(178, 178, 178, 255);
                        bufferBuilder.method_22912((float)(x + 1) + 1.0E-5f, (float)(y + 1), (float)z).method_1336(178, 178, 178, 255);
                        bufferBuilder.method_22912((float)(x + 1) + 1.0E-5f, (float)(y + 1), (float)(z + 1)).method_1336(178, 178, 178, 255);
                        bufferBuilder.method_22912((float)(x + 1) + 1.0E-5f, (float)y, (float)(z + 1)).method_1336(178, 178, 178, 255);
                    }
                    if (minusX) {
                        bufferBuilder.method_22912((float)x - 1.0E-5f, (float)y, (float)(z + 1)).method_1336(178, 178, 178, 255);
                        bufferBuilder.method_22912((float)x - 1.0E-5f, (float)(y + 1), (float)(z + 1)).method_1336(178, 178, 178, 255);
                        bufferBuilder.method_22912((float)x - 1.0E-5f, (float)(y + 1), (float)z).method_1336(178, 178, 178, 255);
                        bufferBuilder.method_22912((float)x - 1.0E-5f, (float)y, (float)z).method_1336(178, 178, 178, 255);
                    }
                    if (y == 0) {
                        plusY = (chunk[1 + z * 16] & 1 << x) == 0;
                        minusY = down == null || (down[15 + z * 16] & 1 << x) == 0;
                    } else if (y == 15) {
                        plusY = up == null || (up[z * 16] & 1 << x) == 0;
                        minusY = (chunk[14 + z * 16] & 1 << x) == 0;
                    } else {
                        plusY = (chunk[y + 1 + z * 16] & 1 << x) == 0;
                        boolean bl = minusY = (chunk[y - 1 + z * 16] & 1 << x) == 0;
                    }
                    if (plusY) {
                        bufferBuilder.method_22912((float)x, (float)(y + 1) + 1.0E-5f, (float)(z + 1)).method_1336(255, 255, 255, 255);
                        bufferBuilder.method_22912((float)(x + 1), (float)(y + 1) + 1.0E-5f, (float)(z + 1)).method_1336(255, 255, 255, 255);
                        bufferBuilder.method_22912((float)(x + 1), (float)(y + 1) + 1.0E-5f, (float)z).method_1336(255, 255, 255, 255);
                        bufferBuilder.method_22912((float)x, (float)(y + 1) + 1.0E-5f, (float)z).method_1336(255, 255, 255, 255);
                    }
                    if (minusY) {
                        bufferBuilder.method_22912((float)x, (float)y - 1.0E-5f, (float)z).method_1336(153, 153, 153, 255);
                        bufferBuilder.method_22912((float)(x + 1), (float)y - 1.0E-5f, (float)z).method_1336(153, 153, 153, 255);
                        bufferBuilder.method_22912((float)(x + 1), (float)y - 1.0E-5f, (float)(z + 1)).method_1336(153, 153, 153, 255);
                        bufferBuilder.method_22912((float)x, (float)y - 1.0E-5f, (float)(z + 1)).method_1336(153, 153, 153, 255);
                    }
                    if (z == 0) {
                        plusZ = (chunk[y + 16] & 1 << x) == 0;
                        minusZ = north == null || (north[y + 240] & 1 << x) == 0;
                    } else if (z == 15) {
                        plusZ = south == null || (south[y] & 1 << x) == 0;
                        minusZ = (chunk[y + 224] & 1 << x) == 0;
                    } else {
                        plusZ = (chunk[y + (z + 1) * 16] & 1 << x) == 0;
                        boolean bl = minusZ = (chunk[y + (z - 1) * 16] & 1 << x) == 0;
                    }
                    if (plusZ) {
                        bufferBuilder.method_22912((float)x, (float)y, (float)(z + 1) + 1.0E-5f).method_1336(222, 222, 222, 255);
                        bufferBuilder.method_22912((float)(x + 1), (float)y, (float)(z + 1) + 1.0E-5f).method_1336(222, 222, 222, 255);
                        bufferBuilder.method_22912((float)(x + 1), (float)(y + 1), (float)(z + 1) + 1.0E-5f).method_1336(222, 222, 222, 255);
                        bufferBuilder.method_22912((float)x, (float)(y + 1), (float)(z + 1) + 1.0E-5f).method_1336(222, 222, 222, 255);
                    }
                    if (!minusZ) continue;
                    bufferBuilder.method_22912((float)x, (float)(y + 1), (float)z - 1.0E-5f).method_1336(222, 222, 222, 255);
                    bufferBuilder.method_22912((float)(x + 1), (float)(y + 1), (float)z - 1.0E-5f).method_1336(222, 222, 222, 255);
                    bufferBuilder.method_22912((float)(x + 1), (float)y, (float)z - 1.0E-5f).method_1336(222, 222, 222, 255);
                    bufferBuilder.method_22912((float)x, (float)y, (float)z - 1.0E-5f).method_1336(222, 222, 222, 255);
                }
            }
        }
        return bufferBuilder;
    }

    public class_2338 min() {
        return this.min;
    }

    public class_2338 max() {
        return this.max;
    }

    public int count() {
        return this.positionSet.count();
    }

    public class_2338 getCenter() {
        return new class_2338((this.min.method_10263() + this.max.method_10263()) / 2, this.min.method_10264(), (this.min.method_10260() + this.max.method_10260()) / 2);
    }

    public void setScale(float scaleX, float scaleY, float scaleZ) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaleZ = scaleZ;
    }

    @Deprecated
    public PositionSet unsafeGetPositionSet() {
        return this.positionSet;
    }

    public PositionSet copyPositionSet() {
        return this.positionSet.copy();
    }

    public void forEach(TriIntConsumer consumer) {
        this.positionSet.forEach(consumer);
    }

    public void forEachChunk(PositionSet.ChunkConsumer consumer) {
        this.positionSet.forEachChunk(consumer);
    }

    public void close() {
        if (this.closed) {
            throw new FaultyImplementationError();
        }
        this.closed = true;
        this.positionSet.clear();
        this.dirtyChunks.clear();
        for (ChunkData chunkDatum : this.chunkData.values()) {
            chunkDatum.buffer.close();
        }
        this.chunkData.clear();
        this.sortedChunkData.clear();
        if (this.leakChecker != null) {
            this.leakChecker.disarm();
        }
    }

    public void clear() {
        this.positionSet.clear();
        this.clearChunkData = true;
        this.dirtyChunks.clear();
        this.min.method_10103(0, 0, 0);
        this.max.method_10103(0, 0, 0);
    }

    public boolean contains(int x, int y, int z) {
        if (x < this.min.method_10263() || x > this.max.method_10263() || y < this.min.method_10264() || y > this.max.method_10264() || z < this.min.method_10260() || z > this.max.method_10260()) {
            return false;
        }
        return this.positionSet.contains(x, y, z);
    }

    public boolean subtractAABB(class_2338 min2, class_2338 max2) {
        if (this.positionSet.count() <= 0) {
            return false;
        }
        min2 = new class_2338(Math.max(min2.method_10263(), this.min.method_10263()), Math.max(min2.method_10264(), this.min.method_10264()), Math.max(min2.method_10260(), this.min.method_10260()));
        max2 = new class_2338(Math.min(max2.method_10263(), this.max.method_10263()), Math.min(max2.method_10264(), this.max.method_10264()), Math.min(max2.method_10260(), this.max.method_10260()));
        if (min2.method_10263() > max2.method_10263() || min2.method_10264() > max2.method_10264() || min2.method_10260() > max2.method_10260()) {
            return false;
        }
        int oldCount = this.positionSet.count();
        int minRemoveSectionX = min2.method_10263() >> 4;
        int minRemoveSectionY = min2.method_10264() >> 4;
        int minRemoveSectionZ = min2.method_10260() >> 4;
        int maxRemoveSectionX = max2.method_10263() >> 4;
        int maxRemoveSectionY = max2.method_10264() >> 4;
        int maxRemoveSectionZ = max2.method_10260() >> 4;
        for (int sx = minRemoveSectionX; sx <= maxRemoveSectionX; ++sx) {
            for (int sy = minRemoveSectionY; sy <= maxRemoveSectionY; ++sy) {
                for (int sz = minRemoveSectionZ; sz <= maxRemoveSectionZ; ++sz) {
                    long pos = class_2338.method_10064((int)sx, (int)sy, (int)sz);
                    int lx = Math.max(0, min2.method_10263() - sx * 16);
                    int ux = Math.min(15, max2.method_10263() - sx * 16);
                    int ly = Math.max(0, min2.method_10264() - sy * 16);
                    int uy = Math.min(15, max2.method_10264() - sy * 16);
                    int lz = Math.max(0, min2.method_10260() - sz * 16);
                    int uz = Math.min(15, max2.method_10260() - sz * 16);
                    if (lx == 0 && ux == 15 && ly == 0 && uy == 15 && lz == 0 && uz == 15) {
                        if (this.positionSet.removeChunk(pos) <= 0) continue;
                        this.dirtyChunks.add(pos);
                        if (sx == maxRemoveSectionX) {
                            this.dirtyChunks.add(class_2338.method_10064((int)(sx + 1), (int)sy, (int)sz));
                        }
                        if (sy == maxRemoveSectionY) {
                            this.dirtyChunks.add(class_2338.method_10064((int)sx, (int)(sy + 1), (int)sz));
                        }
                        if (sz == maxRemoveSectionZ) {
                            this.dirtyChunks.add(class_2338.method_10064((int)sx, (int)sy, (int)(sz + 1)));
                        }
                        if (sx == minRemoveSectionX) {
                            this.dirtyChunks.add(class_2338.method_10064((int)(sx - 1), (int)sy, (int)sz));
                        }
                        if (sy == minRemoveSectionY) {
                            this.dirtyChunks.add(class_2338.method_10064((int)sx, (int)(sy - 1), (int)sz));
                        }
                        if (sz != minRemoveSectionZ) continue;
                        this.dirtyChunks.add(class_2338.method_10064((int)sx, (int)sy, (int)(sz - 1)));
                        continue;
                    }
                    short[] section = this.positionSet.getChunk(pos);
                    if (section == null) continue;
                    int mask = (1 << ux - lx + 1) - 1 << lx;
                    int removedCount = 0;
                    for (int z = lz; z <= uz; ++z) {
                        for (int y = ly; y <= uy; ++y) {
                            short value = section[y + z * 16];
                            removedCount += Integer.bitCount(value & mask);
                            section[y + z * 16] = (short)(value & ~mask);
                        }
                    }
                    if (removedCount <= 0) continue;
                    this.positionSet.unsafeSetCount(this.positionSet.count() - removedCount);
                    this.dirtyChunks.add(pos);
                    if (ux == 15) {
                        this.dirtyChunks.add(class_2338.method_10064((int)(sx + 1), (int)sy, (int)sz));
                    }
                    if (uy == 15) {
                        this.dirtyChunks.add(class_2338.method_10064((int)sx, (int)(sy + 1), (int)sz));
                    }
                    if (uz == 15) {
                        this.dirtyChunks.add(class_2338.method_10064((int)sx, (int)sy, (int)(sz + 1)));
                    }
                    if (lx == 0) {
                        this.dirtyChunks.add(class_2338.method_10064((int)(sx - 1), (int)sy, (int)sz));
                    }
                    if (ly == 0) {
                        this.dirtyChunks.add(class_2338.method_10064((int)sx, (int)(sy - 1), (int)sz));
                    }
                    if (lz == 0) {
                        this.dirtyChunks.add(class_2338.method_10064((int)sx, (int)sy, (int)(sz - 1)));
                    }
                    boolean empty = true;
                    for (short s2 : this.positionSet.getChunk(pos)) {
                        if (s2 == 0) continue;
                        empty = false;
                        break;
                    }
                    if (!empty) continue;
                    this.positionSet.removeEmptyChunk(pos);
                }
            }
        }
        if (oldCount == this.positionSet.count()) {
            return false;
        }
        if (this.positionSet.count() <= 0) {
            this.clear();
            return true;
        }
        boolean removeCoversMinX = min2.method_10263() <= this.min.method_10263();
        boolean removeCoversMinY = min2.method_10264() <= this.min.method_10264();
        boolean removeCoversMinZ = min2.method_10260() <= this.min.method_10260();
        boolean removeCoversMaxX = max2.method_10263() >= this.max.method_10263();
        boolean removeCoversMaxY = max2.method_10264() >= this.max.method_10264();
        boolean removeCoversMaxZ = max2.method_10260() >= this.max.method_10260();
        this.updateBoundingMinMax(removeCoversMinX, removeCoversMinY, removeCoversMinZ, removeCoversMaxX, removeCoversMaxY, removeCoversMaxZ);
        return true;
    }

    public void updateBoundingMinMax(boolean updateMinX, boolean updateMinY, boolean updateMinZ, boolean updateMaxX, boolean updateMaxY, boolean updateMaxZ) {
        int y;
        int z;
        short value;
        int n;
        Iterator iterator;
        int sx;
        if (!(updateMinX || updateMinY || updateMinZ || updateMaxX || updateMaxY || updateMaxZ)) {
            return;
        }
        ArrayList<short[]> minXChunks = new ArrayList<short[]>();
        int minXChunk = updateMinX ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        ArrayList<short[]> minYChunks = new ArrayList<short[]>();
        int minYChunk = updateMinY ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        ArrayList<short[]> minZChunks = new ArrayList<short[]>();
        int minZChunk = updateMinZ ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        ArrayList<short[]> maxXChunks = new ArrayList<short[]>();
        int maxXChunk = updateMaxX ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        ArrayList<short[]> maxYChunks = new ArrayList<short[]>();
        int maxYChunk = updateMaxY ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        ArrayList<short[]> maxZChunks = new ArrayList<short[]>();
        int maxZChunk = updateMaxZ ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        for (Long2ObjectMap.Entry entry : this.positionSet.unsafeGetRawMap().long2ObjectEntrySet()) {
            long key = entry.getLongKey();
            sx = class_2338.method_10061((long)key);
            int sy = class_2338.method_10071((long)key);
            int sz = class_2338.method_10083((long)key);
            if (sx < minXChunk) {
                minXChunks.clear();
                minXChunks.add((short[])entry.getValue());
                minXChunk = sx;
            } else if (sx == minXChunk) {
                minXChunks.add((short[])entry.getValue());
            }
            if (sy < minYChunk) {
                minYChunks.clear();
                minYChunks.add((short[])entry.getValue());
                minYChunk = sy;
            } else if (sy == minYChunk) {
                minYChunks.add((short[])entry.getValue());
            }
            if (sz < minZChunk) {
                minZChunks.clear();
                minZChunks.add((short[])entry.getValue());
                minZChunk = sz;
            } else if (sz == minZChunk) {
                minZChunks.add((short[])entry.getValue());
            }
            if (sx > maxXChunk) {
                maxXChunks.clear();
                maxXChunks.add((short[])entry.getValue());
                maxXChunk = sx;
            } else if (sx == maxXChunk) {
                maxXChunks.add((short[])entry.getValue());
            }
            if (sy > maxYChunk) {
                maxYChunks.clear();
                maxYChunks.add((short[])entry.getValue());
                maxYChunk = sy;
            } else if (sy == maxYChunk) {
                maxYChunks.add((short[])entry.getValue());
            }
            if (sz > maxZChunk) {
                maxZChunks.clear();
                maxZChunks.add((short[])entry.getValue());
                maxZChunk = sz;
                continue;
            }
            if (sz != maxZChunk) continue;
            maxZChunks.add((short[])entry.getValue());
        }
        if (updateMinX) {
            int minXSectionRelative = 15;
            iterator = minXChunks.iterator();
            while (iterator.hasNext()) {
                short[] chunk;
                short[] sArray = chunk = (short[])iterator.next();
                sx = sArray.length;
                for (n = 0; n < sx; ++n) {
                    value = sArray[n];
                    minXSectionRelative = Math.min(minXSectionRelative, Integer.numberOfTrailingZeros(value & 0xFFFF));
                }
                if (minXSectionRelative != 0) continue;
                break;
            }
            this.min.method_33097(minXChunk * 16 + minXSectionRelative);
        }
        if (updateMinY) {
            int minYSectionRelative = 15;
            for (short[] chunk : minYChunks) {
                block4: for (int y2 = 0; y2 < minYSectionRelative; ++y2) {
                    for (z = 0; z < 16; ++z) {
                        if (chunk[y2 + z * 16] == 0) continue;
                        minYSectionRelative = y2;
                        continue block4;
                    }
                }
                if (minYSectionRelative != 0) continue;
                break;
            }
            this.min.method_33098(minYChunk * 16 + minYSectionRelative);
        }
        if (updateMinZ) {
            int minZSectionRelative = 15;
            for (short[] chunk : minZChunks) {
                block7: for (int z2 = 0; z2 < minZSectionRelative; ++z2) {
                    for (y = 0; y < 16; ++y) {
                        if (chunk[y + z2 * 16] == 0) continue;
                        minZSectionRelative = z2;
                        continue block7;
                    }
                }
                if (minZSectionRelative != 0) continue;
                break;
            }
            this.min.method_33099(minZChunk * 16 + minZSectionRelative);
        }
        if (updateMaxX) {
            int maxXSectionRelative = 0;
            iterator = maxXChunks.iterator();
            while (iterator.hasNext()) {
                short[] chunk;
                short[] z2 = chunk = (short[])iterator.next();
                y = z2.length;
                for (n = 0; n < y; ++n) {
                    value = z2[n];
                    maxXSectionRelative = Math.max(maxXSectionRelative, 31 - Integer.numberOfLeadingZeros(value & 0xFFFF));
                }
                if (maxXSectionRelative != 15) continue;
                break;
            }
            this.max.method_33097(maxXChunk * 16 + maxXSectionRelative);
        }
        if (updateMaxY) {
            int maxYSectionRelative = 0;
            for (short[] chunk : maxYChunks) {
                block12: for (int y3 = 15; y3 > maxYSectionRelative; --y3) {
                    for (z = 0; z < 16; ++z) {
                        if (chunk[y3 + z * 16] == 0) continue;
                        maxYSectionRelative = y3;
                        continue block12;
                    }
                }
                if (maxYSectionRelative != 15) continue;
                break;
            }
            this.max.method_33098(maxYChunk * 16 + maxYSectionRelative);
        }
        if (updateMaxZ) {
            int maxZSectionRelative = 0;
            for (short[] chunk : maxZChunks) {
                block15: for (int z3 = 15; z3 > maxZSectionRelative; --z3) {
                    for (y = 0; y < 16; ++y) {
                        if (chunk[y + z3 * 16] == 0) continue;
                        maxZSectionRelative = z3;
                        continue block15;
                    }
                }
                if (maxZSectionRelative != 15) continue;
                break;
            }
            this.max.method_33099(maxZChunk * 16 + maxZSectionRelative);
        }
    }

    public boolean intersectAABB(class_2338 min2, class_2338 max2) {
        if (this.positionSet.count() <= 0) {
            return false;
        }
        min2 = new class_2338(Math.max(min2.method_10263(), this.min.method_10263()), Math.max(min2.method_10264(), this.min.method_10264()), Math.max(min2.method_10260(), this.min.method_10260()));
        max2 = new class_2338(Math.min(max2.method_10263(), this.max.method_10263()), Math.min(max2.method_10264(), this.max.method_10264()), Math.min(max2.method_10260(), this.max.method_10260()));
        if (min2.method_10263() > max2.method_10263() || min2.method_10264() > max2.method_10264() || min2.method_10260() > max2.method_10260()) {
            this.clear();
            return true;
        }
        if (min2.method_10263() == this.min.method_10263() && min2.method_10264() == this.min.method_10264() && min2.method_10260() == this.min.method_10260() && max2.method_10263() == this.max.method_10263() && max2.method_10264() == this.max.method_10264() && max2.method_10260() == this.max.method_10260()) {
            return false;
        }
        int minSectionX = min2.method_10263() >> 4;
        int minSectionY = min2.method_10264() >> 4;
        int minSectionZ = min2.method_10260() >> 4;
        int maxSectionX = max2.method_10263() >> 4;
        int maxSectionY = max2.method_10264() >> 4;
        int maxSectionZ = max2.method_10260() >> 4;
        this.dirtyChunks.clear();
        this.clearChunkData = true;
        int oldCount = this.positionSet.count();
        int newCount = 0;
        PositionSet oldPositionSet = this.positionSet;
        this.positionSet = new PositionSet();
        Long2ObjectMap<short[]> newPositionSetMap = this.positionSet.unsafeGetRawMap();
        for (int sx = minSectionX; sx <= maxSectionX; ++sx) {
            for (int sy = minSectionY; sy <= maxSectionY; ++sy) {
                for (int sz = minSectionZ; sz <= maxSectionZ; ++sz) {
                    long pos = class_2338.method_10064((int)sx, (int)sy, (int)sz);
                    short[] chunk = oldPositionSet.getChunk(pos);
                    if (chunk == null) continue;
                    int lx = Math.max(0, min2.method_10263() - sx * 16);
                    int ux = Math.min(15, max2.method_10263() - sx * 16);
                    int ly = Math.max(0, min2.method_10264() - sy * 16);
                    int uy = Math.min(15, max2.method_10264() - sy * 16);
                    int lz = Math.max(0, min2.method_10260() - sz * 16);
                    int uz = Math.min(15, max2.method_10260() - sz * 16);
                    if (lx == 0 && ux == 15 && ly == 0 && uy == 15 && lz == 0 && uz == 15) {
                        for (short s2 : chunk) {
                            newCount += Integer.bitCount(s2 & 0xFFFF);
                        }
                    } else {
                        int y;
                        int mask = (1 << ux - lx + 1) - 1 << lx;
                        for (int z = 0; z < 16; ++z) {
                            for (y = 0; y < ly; ++y) {
                                chunk[y + z * 16] = 0;
                            }
                            for (y = uy + 1; y < 16; ++y) {
                                chunk[y + z * 16] = 0;
                            }
                        }
                        boolean empty = true;
                        for (y = ly; y <= uy; ++y) {
                            int z;
                            for (z = 0; z < lz; ++z) {
                                chunk[y + z * 16] = 0;
                            }
                            for (z = uz + 1; z < 16; ++z) {
                                chunk[y + z * 16] = 0;
                            }
                            for (z = lz; z <= uz; ++z) {
                                int masked = chunk[y + z * 16] & mask;
                                if (masked != 0) {
                                    empty = false;
                                    newCount += Integer.bitCount(masked);
                                }
                                chunk[y + z * 16] = (short)masked;
                            }
                        }
                        if (empty) continue;
                    }
                    newPositionSetMap.put(pos, (Object)chunk);
                    this.dirtyChunks.add(pos);
                }
            }
        }
        boolean removeCoversMinX = min2.method_10263() <= this.min.method_10263();
        boolean removeCoversMinY = min2.method_10264() <= this.min.method_10264();
        boolean removeCoversMinZ = min2.method_10260() <= this.min.method_10260();
        boolean removeCoversMaxX = max2.method_10263() >= this.max.method_10263();
        boolean removeCoversMaxY = max2.method_10264() >= this.max.method_10264();
        boolean removeCoversMaxZ = max2.method_10260() >= this.max.method_10260();
        boolean updateMinX = !removeCoversMinX || !removeCoversMinY || !removeCoversMaxY || !removeCoversMinZ || !removeCoversMaxZ;
        boolean updateMinY = !removeCoversMinX || !removeCoversMaxX || !removeCoversMinY || !removeCoversMinZ || !removeCoversMaxZ;
        boolean updateMinZ = !removeCoversMinX || !removeCoversMaxX || !removeCoversMinY || !removeCoversMaxY || !removeCoversMinZ;
        boolean updateMaxX = !removeCoversMaxX || !removeCoversMinY || !removeCoversMaxY || !removeCoversMinZ || !removeCoversMaxZ;
        boolean updateMaxY = !removeCoversMinX || !removeCoversMaxX || !removeCoversMaxY || !removeCoversMinZ || !removeCoversMaxZ;
        boolean updateMaxZ = !removeCoversMinX || !removeCoversMaxX || !removeCoversMinY || !removeCoversMaxY || !removeCoversMaxZ;
        this.updateBoundingMinMax(updateMinX, updateMinY, updateMinZ, updateMaxX, updateMaxY, updateMaxZ);
        if (oldCount <= newCount) {
            throw new FaultyImplementationError("Count should have decreased. Was " + oldCount + ", now " + newCount);
        }
        this.positionSet.unsafeSetCount(newCount);
        return true;
    }

    private void validateNoEmpty() {
        for (short[] chunk : this.positionSet.unsafeGetRawMap().values()) {
            boolean empty = true;
            for (short value : chunk) {
                if (value == 0) continue;
                empty = false;
                break;
            }
            if (!empty) continue;
            throw new FaultyImplementationError("Empty chunk");
        }
    }

    private void validateMinMax() {
        this.positionSet.forEach((x, y, z) -> {
            if (x < this.min.method_10263()) {
                throw new FaultyImplementationError("MinX: " + this.min.method_10263() + ", contained x: " + x);
            }
            if (y < this.min.method_10264()) {
                throw new FaultyImplementationError("MinY: " + this.min.method_10264() + ", contained y: " + y);
            }
            if (z < this.min.method_10260()) {
                throw new FaultyImplementationError("MinZ: " + this.min.method_10260() + ", contained z: " + z);
            }
            if (x > this.max.method_10263()) {
                throw new FaultyImplementationError("MaxX: " + this.max.method_10263() + ", contained x: " + x);
            }
            if (y > this.max.method_10264()) {
                throw new FaultyImplementationError("MaxY: " + this.max.method_10264() + ", contained y: " + y);
            }
            if (z > this.max.method_10260()) {
                throw new FaultyImplementationError("MaxZ: " + this.max.method_10260() + ", contained z: " + z);
            }
        });
    }

    public void expand(BallShape ballShape, int amount) {
        if (amount <= 0) {
            return;
        }
        if (this.positionSet.isEmpty()) {
            return;
        }
        this.min.method_33097(this.min.method_10263() - amount);
        this.min.method_33098(this.min.method_10264() - amount);
        this.min.method_33099(this.min.method_10260() - amount);
        this.max.method_33097(this.max.method_10263() + amount);
        this.max.method_33098(this.max.method_10264() + amount);
        this.max.method_33099(this.max.method_10260() + amount);
        int[][] allOffsets = ExpandOffsets.create(ballShape, amount);
        PositionSet copied = this.positionSet.copy();
        copied.forEach((x, y, z) -> {
            int offsetIndex = 63;
            if (copied.contains(x - 1, y, z)) {
                --offsetIndex;
            }
            if (copied.contains(x, y - 1, z)) {
                offsetIndex -= 2;
            }
            if (copied.contains(x, y, z - 1)) {
                offsetIndex -= 4;
            }
            if (copied.contains(x + 1, y, z)) {
                offsetIndex -= 8;
            }
            if (copied.contains(x, y + 1, z)) {
                offsetIndex -= 16;
            }
            if (copied.contains(x, y, z + 1)) {
                offsetIndex -= 32;
            }
            int[] offsets = allOffsets[offsetIndex];
            for (int i = 0; i < offsets.length; i += 3) {
                this.addSkipMinMax(x + offsets[i], y + offsets[i + 1], z + offsets[i + 2]);
            }
        });
    }

    public void shrink(BallShape ballShape, int amount) {
        if (amount <= 0) {
            return;
        }
        if (this.positionSet.isEmpty()) {
            return;
        }
        int radiusSquared = amount * amount;
        class_2338[][] offsets = new class_2338[64][];
        for (int index = 0; index < 64; ++index) {
            int minRadiusX = (index & 1) == 0 ? 0 : -amount;
            int minRadiusY = (index & 2) == 0 ? 0 : -amount;
            int minRadiusZ = (index & 4) == 0 ? 0 : -amount;
            int maxRadiusX = (index & 8) == 0 ? 0 : amount;
            int maxRadiusY = (index & 0x10) == 0 ? 0 : amount;
            int maxRadiusZ = (index & 0x20) == 0 ? 0 : amount;
            ArrayList<class_2338> off = new ArrayList<class_2338>();
            for (int xo = minRadiusX; xo <= maxRadiusX; ++xo) {
                for (int yo = minRadiusY; yo <= maxRadiusY; ++yo) {
                    for (int zo = minRadiusZ; zo <= maxRadiusZ; ++zo) {
                        if (xo == 0 && yo == 0 && zo == 0 || !(ballShape.distanceSq(xo, yo, zo) <= (float)radiusSquared)) continue;
                        off.add(new class_2338(xo, yo, zo));
                    }
                }
            }
            offsets[index] = off.toArray(new class_2338[0]);
        }
        Position2ByteMap edges = new Position2ByteMap();
        this.positionSet.forEach((x, y, z) -> {
            if (!this.positionSet.contains(x + 1, y, z)) {
                edges.add(x + 1, y, z, (byte)1);
            }
            if (!this.positionSet.contains(x - 1, y, z)) {
                edges.add(x - 1, y, z, (byte)8);
            }
            if (!this.positionSet.contains(x, y + 1, z)) {
                edges.add(x, y + 1, z, (byte)2);
            }
            if (!this.positionSet.contains(x, y - 1, z)) {
                edges.add(x, y - 1, z, (byte)16);
            }
            if (!this.positionSet.contains(x, y, z + 1)) {
                edges.add(x, y, z + 1, (byte)4);
            }
            if (!this.positionSet.contains(x, y, z - 1)) {
                edges.add(x, y, z - 1, (byte)32);
            }
        });
        PositionSet removedFromChunks = new PositionSet();
        edges.forEachEntry((x, y, z, v) -> {
            for (class_2338 offset : offsets[v]) {
                int bz;
                int by;
                int bx = x + offset.method_10263();
                if (!this.positionSet.remove(bx, by = y + offset.method_10264(), bz = z + offset.method_10260())) continue;
                removedFromChunks.add(bx >> 4, by >> 4, bz >> 4);
            }
        });
        if (this.positionSet.isEmpty()) {
            this.clear();
        } else {
            Long2ObjectMap<short[]> map = this.positionSet.unsafeGetRawMap();
            removedFromChunks.forEach((sx, sy, sz) -> {
                short[] array;
                long key = class_2338.method_10064((int)sx, (int)sy, (int)sz);
                this.dirtyChunks.add(key);
                for (short s2 : array = (short[])map.get(key)) {
                    if (s2 == 0) continue;
                    return;
                }
                map.remove(key);
            });
            this.updateBoundingMinMax(true, true, true, true, true, true);
        }
    }

    public void addAll(PositionSet set) {
        set.forEach(this::add);
    }

    private void addSkipMinMax(int x, int y, int z) {
        if (this.positionSet.add(x, y, z)) {
            boolean onNegZBorder;
            int chunkX = x >> 4;
            int chunkY = y >> 4;
            int chunkZ = z >> 4;
            boolean onNegXBorder = (x & 0xF) == 0;
            boolean onNegYBorder = (y & 0xF) == 0;
            boolean bl = onNegZBorder = (z & 0xF) == 0;
            if (onNegXBorder) {
                this.dirtyChunks.add(class_2338.method_10064((int)(chunkX - 1), (int)chunkY, (int)chunkZ));
                if (onNegYBorder) {
                    this.dirtyChunks.add(class_2338.method_10064((int)(chunkX - 1), (int)(chunkY - 1), (int)chunkZ));
                }
                if (onNegZBorder) {
                    this.dirtyChunks.add(class_2338.method_10064((int)(chunkX - 1), (int)chunkY, (int)(chunkZ - 1)));
                }
            } else if ((x & 0xF) == 15) {
                this.dirtyChunks.add(class_2338.method_10064((int)(chunkX + 1), (int)chunkY, (int)chunkZ));
            }
            if (onNegYBorder) {
                this.dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)(chunkY - 1), (int)chunkZ));
                if (onNegZBorder) {
                    this.dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)(chunkY - 1), (int)(chunkZ - 1)));
                }
            } else if ((y & 0xF) == 15) {
                this.dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)(chunkY + 1), (int)chunkZ));
            }
            if (onNegZBorder) {
                this.dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)chunkY, (int)(chunkZ - 1)));
            } else if ((z & 0xF) == 15) {
                this.dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)chunkY, (int)(chunkZ + 1)));
            }
            this.dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)chunkY, (int)chunkZ));
        }
    }

    public boolean add(int x, int y, int z) {
        if (this.positionSet.add(x, y, z)) {
            boolean onNegZBorder;
            if (this.positionSet.count() == 1) {
                this.min.method_10103(x, y, z);
                this.max.method_10103(x, y, z);
            } else {
                if (x < this.min.method_10263()) {
                    this.min.method_33097(x);
                }
                if (y < this.min.method_10264()) {
                    this.min.method_33098(y);
                }
                if (z < this.min.method_10260()) {
                    this.min.method_33099(z);
                }
                if (x > this.max.method_10263()) {
                    this.max.method_33097(x);
                }
                if (y > this.max.method_10264()) {
                    this.max.method_33098(y);
                }
                if (z > this.max.method_10260()) {
                    this.max.method_33099(z);
                }
            }
            int chunkX = x >> 4;
            int chunkY = y >> 4;
            int chunkZ = z >> 4;
            boolean onNegXBorder = (x & 0xF) == 0;
            boolean onNegYBorder = (y & 0xF) == 0;
            boolean bl = onNegZBorder = (z & 0xF) == 0;
            if (onNegXBorder) {
                this.dirtyChunks.add(class_2338.method_10064((int)(chunkX - 1), (int)chunkY, (int)chunkZ));
                if (onNegYBorder) {
                    this.dirtyChunks.add(class_2338.method_10064((int)(chunkX - 1), (int)(chunkY - 1), (int)chunkZ));
                }
                if (onNegZBorder) {
                    this.dirtyChunks.add(class_2338.method_10064((int)(chunkX - 1), (int)chunkY, (int)(chunkZ - 1)));
                }
            } else if ((x & 0xF) == 15) {
                this.dirtyChunks.add(class_2338.method_10064((int)(chunkX + 1), (int)chunkY, (int)chunkZ));
            }
            if (onNegYBorder) {
                this.dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)(chunkY - 1), (int)chunkZ));
                if (onNegZBorder) {
                    this.dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)(chunkY - 1), (int)(chunkZ - 1)));
                }
            } else if ((y & 0xF) == 15) {
                this.dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)(chunkY + 1), (int)chunkZ));
            }
            if (onNegZBorder) {
                this.dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)chunkY, (int)(chunkZ - 1)));
            } else if ((z & 0xF) == 15) {
                this.dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)chunkY, (int)(chunkZ + 1)));
            }
            this.dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)chunkY, (int)chunkZ));
            return true;
        }
        return false;
    }

    private static final class ChunkData
    extends IntrusiveLinkedElement<ChunkData> {
        AxiomDrawBuffer buffer = new AxiomDrawBuffer(AxiomBufferUsage.STATIC_WRITE);
        SortStateWrapper sortState = null;
        int offsetX;
        int offsetY;
        int offsetZ;
        float distanceSqToCamera;

        public ChunkData(int offsetX, int offsetY, int offsetZ) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
        }
    }
}

