/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.sculpt_draw;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.collections.Position2FloatMap;
import com.moulberry.axiom.collections.Position2ObjectMap;
import com.moulberry.axiom.collections.SimpleBlockWeightTracker;
import com.moulberry.axiom.editor.GenericRadiusAdjustment;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.tutorial.Tutorial;
import com.moulberry.axiom.editor.widgets.PresetWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.pather.ToolPatherPoint;
import com.moulberry.axiom.rasterization.Rasterization3D;
import com.moulberry.axiom.render.ChunkRenderOverrider;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.GaussianBlurTable;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiomclientapi.pathers.BallShape;
import com.moulberry.axiomclientapi.regions.BooleanRegion;
import imgui.ImGui;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class SculptDrawTool
implements Tool {
    private final ChunkedBooleanRegion removeRegion = new ChunkedBooleanRegion();
    private final ChunkedBlockRegion blockRegion = new ChunkedBlockRegion();
    private final ChunkedBooleanRegion previewSphere = new ChunkedBooleanRegion();
    private final Position2ObjectMap<SimpleBlockWeightTracker> influenceMap = SimpleBlockWeightTracker.createMap();
    private final Position2FloatMap floatInfluenceMap = new Position2FloatMap();
    private int oldRadius = -1;
    private int oldBrushShape = -1;
    private ToolPatherPoint toolPather = null;
    private int[] offsets = null;
    private boolean usingTool = false;
    private final int[] radius = new int[]{5};
    private final GenericRadiusAdjustment radiusAdjustment = new GenericRadiusAdjustment(32);
    private final float[] strength = new float[]{0.5f};
    private boolean invert = false;
    private boolean maskY = false;
    private boolean denoise = true;
    private final PresetWidget presetWidget = new PresetWidget(this, "sculpt_draw");

    @Override
    public void reset() {
        if (this.usingTool) {
            ChunkRenderOverrider.release("Sculpt Draw Tool");
            this.usingTool = false;
        }
        this.previewSphere.clear();
        this.removeRegion.clear();
        this.blockRegion.clear();
        this.influenceMap.clear();
        this.floatInfluenceMap.clear();
        this.toolPather = null;
        this.oldRadius = -1;
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                this.reset();
                if (!this.usingTool) {
                    ChunkRenderOverrider.acquire("Sculpt Draw Tool");
                    this.usingTool = true;
                }
                BallShape shape = BallShape.SPHERE;
                this.toolPather = new ToolPatherPoint();
                int radius = this.radius[0];
                IntArrayList offsets = new IntArrayList();
                float maxRadiusSq = ((float)radius + 0.5f) * ((float)radius + 0.5f);
                for (int x = -radius; x <= radius; ++x) {
                    for (int y = -radius; y <= radius; ++y) {
                        for (int z = -radius; z <= radius; ++z) {
                            float radiusSq = shape.distanceSq(x, y, z);
                            if (!(radiusSq < maxRadiusSq)) continue;
                            offsets.add(x);
                            offsets.add(y);
                            offsets.add(z);
                        }
                    }
                }
                this.offsets = offsets.toIntArray();
                return UserAction.ActionResult.USED_STOP;
            }
            case ESCAPE: {
                if (!this.usingTool) break;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        if (!this.usingTool) {
            RayCaster.RaycastResult result = Tool.raycastBlock();
            if (result == null) {
                Selection.render(camera, time, matrices, projection, 7);
                return;
            }
            int radius = this.radius[0];
            int brushShape = 0;
            if (this.oldRadius != radius || this.oldBrushShape != brushShape) {
                this.oldRadius = radius;
                this.oldBrushShape = brushShape;
                this.previewSphere.clear();
                BallShape.getByIndex((int)brushShape).fillRegion((BooleanRegion)this.previewSphere, radius);
            }
            Selection.render(camera, time, matrices, projection, 4);
            this.previewSphere.render(camera, class_243.method_24954((class_2382)result.getBlockPos()), matrices, projection, time, 3);
        } else if (Tool.cancelUsing()) {
            this.reset();
        } else if (!Tool.isMouseDown(1)) {
            if (this.invert) {
                String countString = NumberFormat.getInstance().format(this.removeRegion.count());
                String historyDescription = AxiomI18n.get("axiom.history_description.sculpt_draw_tool", countString);
                RegionHelper.pushBooleanRegionChange(this.removeRegion, class_2246.field_10124.method_9564(), historyDescription);
            } else {
                String countString = NumberFormat.getInstance().format(this.blockRegion.count());
                String historyDescription = AxiomI18n.get("axiom.history_description.sculpt_draw_tool", countString);
                RegionHelper.pushBlockRegionChange(this.blockRegion, historyDescription);
            }
            this.reset();
        } else {
            class Normals {
                long totalX = 0L;
                long totalY = 0L;
                long totalZ = 0L;

                Normals() {
                }
            }
            int radius = this.radius[0];
            float maxRadius = (float)radius + 0.5f;
            float maxRadiusSq = maxRadius * maxRadius;
            GaussianBlurTable gaussianBlur = new GaussianBlurTable(this.denoise ? 0.5f : 0.0f, 0.1f);
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                return;
            }
            Selection.render(camera, time, matrices, projection, 4);
            MaskElement sourceMaskElement = MaskManager.getSourceMask();
            MaskElement destMaskElement = MaskManager.getDestMask();
            MaskContext maskContext = new MaskContext((class_1937)level);
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            if (!this.invert) {
                Position2ObjectMap<SimpleBlockWeightTracker> map = SimpleBlockWeightTracker.createMap();
                this.toolPather.update((x, y, z) -> {
                    Normals normal = new Normals();
                    record PositionDistanceBlock(int x, int y, int z, float distanceSq, class_2680 blockState) {
                    }
                    ArrayList<PositionDistanceBlock> list = new ArrayList<PositionDistanceBlock>();
                    for (int i = 0; i < this.offsets.length; i += 3) {
                        int xo = this.offsets[i];
                        int yo = this.offsets[i + 1];
                        int zo = this.offsets[i + 2];
                        if (!sourceMaskElement.test(maskContext.reset(), x + xo, y + yo, z + zo)) {
                            normal.totalX -= (long)xo;
                            normal.totalY -= (long)yo;
                            normal.totalZ -= (long)zo;
                            continue;
                        }
                        class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x + xo, y + yo, z + zo));
                        if (!blockState.method_51366()) continue;
                        list.add(new PositionDistanceBlock(x + xo, y + yo, z + zo, xo * xo + yo * yo + zo * zo, blockState));
                        normal.totalX -= (long)xo;
                        normal.totalY -= (long)yo;
                        normal.totalZ -= (long)zo;
                    }
                    if (!list.isEmpty()) {
                        double totalLength = Math.sqrt(normal.totalX * normal.totalX + normal.totalY * normal.totalY + normal.totalZ * normal.totalZ);
                        float normalY = (float)((double)normal.totalY / totalLength);
                        float normalX = this.maskY ? 0.0f : (float)((double)normal.totalX / totalLength);
                        float normalZ = this.maskY ? 0.0f : (float)((double)normal.totalZ / totalLength);
                        for (PositionDistanceBlock positionDistanceBlock : list) {
                            float inverseDistance = (float)Math.sqrt(maxRadiusSq - positionDistanceBlock.distanceSq);
                            Vector3f from = new Vector3f((float)positionDistanceBlock.x + 0.5f, (float)positionDistanceBlock.y + 0.5f, (float)positionDistanceBlock.z + 0.5f);
                            Vector3f to = from.add(normalX * (inverseDistance *= this.strength[0]), normalY * inverseDistance, normalZ * inverseDistance, new Vector3f());
                            Rasterization3D.xiaolinWu(from, to, (x2, y2, z2, v) -> {
                                if ((double)v < 0.01) {
                                    return;
                                }
                                float traveledX = positionDistanceBlock.x - x2;
                                float traveledY = positionDistanceBlock.y - y2;
                                float traveledZ = positionDistanceBlock.z - z2;
                                float traveledSq = traveledX * traveledX + traveledY * traveledY + traveledZ * traveledZ;
                                SimpleBlockWeightTracker tracker = (SimpleBlockWeightTracker)map.getOrCreate(x2, y2, z2);
                                tracker.addWeight(positionDistanceBlock.blockState, v, v / (traveledSq + 0.25f));
                            });
                        }
                    }
                });
                float[] table = gaussianBlur.getTable();
                float threshold = 0.08f + table[table.length / 2] * 0.87f;
                gaussianBlur.applyBlurCheckThreshold(map, this.influenceMap, threshold, (pos, block) -> {
                    maskContext.reset();
                    if (!destMaskElement.test(maskContext, pos.method_10263(), pos.method_10264(), pos.method_10260())) {
                        return;
                    }
                    this.blockRegion.addBlock(pos, block);
                });
                float opacity = (float)Math.sin((float)time / 1000000.0f / 50.0f / 8.0f);
                this.blockRegion.render(camera, class_243.field_1353, matrices, projection, 0.75f + opacity * 0.25f, 0.3f - opacity * 0.2f);
            } else {
                this.toolPather.update((x, y, z) -> {
                    Normals normal = new Normals();
                    record PositionDistance(int x, int y, int z, float distanceSq) {
                    }
                    ArrayList<PositionDistance> list = new ArrayList<PositionDistance>();
                    for (int i = 0; i < this.offsets.length; i += 3) {
                        int xo = this.offsets[i];
                        int yo = this.offsets[i + 1];
                        int zo = this.offsets[i + 2];
                        if (sourceMaskElement.test(maskContext.reset(), x + xo, y + yo, z + zo) && level.method_8320((class_2338)mutableBlockPos.method_10103(x + xo, y + yo, z + zo)).method_51366()) continue;
                        list.add(new PositionDistance(x + xo, y + yo, z + zo, xo * xo + yo * yo + zo * zo));
                        normal.totalX -= (long)xo;
                        normal.totalY -= (long)yo;
                        normal.totalZ -= (long)zo;
                    }
                    if (!list.isEmpty()) {
                        double totalLength = Math.sqrt(normal.totalX * normal.totalX + normal.totalY * normal.totalY + normal.totalZ * normal.totalZ);
                        float normalY = (float)((double)normal.totalY / totalLength);
                        float normalX = this.maskY ? 0.0f : (float)((double)normal.totalX / totalLength);
                        float normalZ = this.maskY ? 0.0f : (float)((double)normal.totalZ / totalLength);
                        Position2FloatMap position2FloatMap = new Position2FloatMap();
                        for (PositionDistance positionDistanceBlock : list) {
                            float inverseDistance = (float)Math.sqrt(maxRadiusSq - positionDistanceBlock.distanceSq);
                            Vector3f from = new Vector3f((float)positionDistanceBlock.x + 0.5f, (float)positionDistanceBlock.y + 0.5f, (float)positionDistanceBlock.z + 0.5f);
                            Vector3f to = from.add(normalX * (inverseDistance *= this.strength[0]), normalY * inverseDistance, normalZ * inverseDistance, new Vector3f());
                            Rasterization3D.xiaolinWu(from, to, (x2, y2, z2, v) -> {
                                if ((double)v < 0.01) {
                                    return;
                                }
                                position2FloatMap.add(x2, y2, z2, v);
                            });
                        }
                        float[] table = gaussianBlur.getTable();
                        float threshold = 0.08f + table[table.length / 2] * 0.87f;
                        gaussianBlur.applyBlurCheckThreshold(position2FloatMap, this.floatInfluenceMap, threshold, (x2, y2, z2) -> {
                            if (!destMaskElement.test(maskContext.reset(), x2, y2, z2)) {
                                return;
                            }
                            ChunkRenderOverrider.setBlock(x2, y2, z2, class_2246.field_10124.method_9564());
                            this.removeRegion.add(x2, y2, z2);
                        });
                    }
                });
                this.removeRegion.render(camera, class_243.field_1353, matrices, projection, time, 8);
            }
        }
    }

    @Override
    public void displayImguiOptions() {
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.brush"));
        boolean changed = ImGui.sliderInt(AxiomI18n.get("axiom.tool.generic.brush_radius"), this.radius, 1, 32);
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.sculpt_draw"));
        changed |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.sculpt_draw.strength"), this.strength, 0.1f, 5.0f, "%.3f", 32);
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.sculpt_draw.invert"), this.invert)) {
            this.invert = !this.invert;
            changed = true;
        }
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.sculpt_draw.mask_y"), this.maskY)) {
            this.maskY = !this.maskY;
            changed = true;
        }
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.sculpt_draw.denoise"), this.denoise)) {
            this.denoise = !this.denoise;
            changed = true;
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.presets"));
        this.presetWidget.displayImgui(changed);
    }

    @Override
    public String listenForEsc() {
        if (!this.usingTool) {
            return null;
        }
        return AxiomI18n.get("axiom.widget.cancel");
    }

    @Override
    public boolean initiateAdjustment() {
        return this.radiusAdjustment.initiateAdjustment(this.radius[0], -1);
    }

    @Override
    public class_241 renderAdjustment(float mouseX, float mouseY, class_241 mouseDelta) {
        GenericRadiusAdjustment.Result result = this.radiusAdjustment.renderAdjustment(mouseX, mouseY, mouseDelta);
        this.radius[0] = result.radius();
        return result.mouseDelta();
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.sculpt_draw");
    }

    @Override
    public Tutorial getTutorial() {
        return Tutorial.SCULPT_DRAW_TOOL;
    }

    @Override
    public void writeSettings(class_2487 tag) {
        tag.method_10569("BrushRadius", this.radius[0]);
        tag.method_10548("Strength", this.strength[0]);
        tag.method_10556("Invert", this.invert);
        tag.method_10556("MaskY", this.maskY);
        tag.method_10556("Denoise", this.denoise);
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.radius[0] = tag.method_68083("BrushRadius", 5);
        this.strength[0] = tag.method_66563("Strength", 0.5f);
        this.invert = tag.method_68566("Invert", false);
        this.maskY = tag.method_68566("MaskY", false);
        this.denoise = tag.method_68566("Denoise", true);
    }

    @Override
    public char iconChar() {
        return '\ue90a';
    }

    @Override
    public String keybindId() {
        return "sculpt_draw";
    }

    @Override
    public EnumSet<AxiomPermission> requiredPermissions() {
        return EnumSet.of(AxiomPermission.TOOL_SCULPTDRAW, AxiomPermission.BUILD_SECTION);
    }
}

