/*
 * Decompiled with CFR 0.152.
 */
package com.mortennobel.imagescaling;

import java.awt.Dimension;

public class DimensionConstrain {
    protected DimensionConstrain() {
    }

    public Dimension getDimension(Dimension dimension) {
        return dimension;
    }

    public static DimensionConstrain createAbsolutionDimension(final int width, final int height) {
        assert (width > 0 && height > 0) : "Dimension must be a positive integer";
        return new DimensionConstrain(){

            public Dimension getDimension(Dimension dimension) {
                return new Dimension(width, height);
            }
        };
    }

    public static DimensionConstrain createRelativeDimension(float fraction) {
        return DimensionConstrain.createRelativeDimension(fraction, fraction);
    }

    public static DimensionConstrain createRelativeDimension(final float fractionWidth, final float fractionHeight) {
        assert (fractionHeight > 0.0f && fractionWidth > 0.0f) : "Fractions must be larger than 0.0";
        return new DimensionConstrain(){

            public Dimension getDimension(Dimension dimension) {
                int width = Math.max(1, Math.round(fractionWidth * (float)dimension.width));
                int height = Math.max(1, Math.round(fractionHeight * (float)dimension.height));
                return new Dimension(width, height);
            }
        };
    }

    public static DimensionConstrain createMaxDimension(int width, int height) {
        return DimensionConstrain.createMaxDimension(width, height, false);
    }

    public static DimensionConstrain createMaxDimension(final int width, final int height, final boolean neverEnlargeImage) {
        assert (width > 0 && height > 0) : "Dimension must be larger that 0";
        final double scaleFactor = (double)width / (double)height;
        return new DimensionConstrain(){

            public Dimension getDimension(Dimension dimension) {
                double srcScaleFactor = (double)dimension.width / (double)dimension.height;
                double scale = srcScaleFactor > scaleFactor ? (double)width / (double)dimension.width : (double)height / (double)dimension.height;
                if (neverEnlargeImage) {
                    scale = Math.min(scale, 1.0);
                }
                int dstWidth = (int)Math.round((double)dimension.width * scale);
                int dstHeight = (int)Math.round((double)dimension.height * scale);
                return new Dimension(dstWidth, dstHeight);
            }
        };
    }

    public static DimensionConstrain createMaxDimensionNoOrientation(int length1, int length2) {
        return DimensionConstrain.createMaxDimensionNoOrientation(length1, length2, false);
    }

    public static DimensionConstrain createMaxDimensionNoOrientation(final int length1, final int length2, final boolean neverEnlargeImage) {
        assert (length1 > 0 && length2 > 0) : "Dimension must be larger that 0";
        final double scaleFactor = (double)length1 / (double)length2;
        return new DimensionConstrain(){

            public Dimension getDimension(Dimension dimension) {
                int height;
                int width;
                double srcScaleFactor = (double)dimension.width / (double)dimension.height;
                if (srcScaleFactor > scaleFactor) {
                    width = length1;
                    height = length2;
                } else {
                    width = length2;
                    height = length1;
                }
                double scaleFactor2 = (double)width / (double)height;
                double scale = srcScaleFactor > scaleFactor2 ? (double)width / (double)dimension.width : (double)height / (double)dimension.height;
                if (neverEnlargeImage) {
                    scale = Math.min(scale, 1.0);
                }
                int dstWidth = (int)Math.round((double)dimension.width * scale);
                int dstHeight = (int)Math.round((double)dimension.height * scale);
                return new Dimension(dstWidth, dstHeight);
            }
        };
    }
}

