/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.views;

import com.moulberry.axiom.editor.views.ViewManager;
import com.moulberry.axiom.packets.AxiomServerboundTeleport;
import com.moulberry.axiom.utils.NbtHelper;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public final class View {
    public String name;
    public final UUID uuid;
    public boolean pinLevel = false;
    public boolean pinLocation = false;
    private class_5321<class_1937> level = null;
    private class_243 position = null;
    private float yaw;
    private float pitch;
    private boolean active = false;

    public View(String name, UUID uuid, @Nullable class_1657 player) {
        this.name = name;
        this.uuid = uuid;
        if (player != null) {
            this.position = player.method_19538();
            this.yaw = player.method_36454();
            this.pitch = player.method_36455();
            this.level = player.method_37908().method_27983();
        }
    }

    public void teleportPinned(class_1657 player) {
        if (player != null && this.level == null) {
            this.level = player.method_37908().method_27983();
        }
        if (this.position != null && this.level != null && this.pinLevel && this.pinLocation) {
            new AxiomServerboundTeleport(this.level, this.position.field_1352, this.position.field_1351, this.position.field_1350, this.yaw, this.pitch).send();
        }
    }

    public void markInactive() {
        if (this.active) {
            this.active = false;
        }
    }

    public void markActive(class_1657 player) {
        if (this.active) {
            if (!this.uuid.equals(ViewManager.activeView)) {
                ViewManager.activeView = this.uuid;
                ViewManager.activeFrames = 0;
                ViewManager.dirty();
            } else if (ViewManager.activeFrames < 5) {
                ++ViewManager.activeFrames;
            } else {
                if (player == null) {
                    return;
                }
                class_5321 currentDimension = player.method_37908().method_27983();
                if (!this.pinLevel || this.level == null) {
                    this.level = currentDimension;
                }
                if (!(this.pinLevel && this.pinLocation && this.position != null || !currentDimension.equals(this.level) && this.position != null)) {
                    this.position = player.method_19538();
                    this.yaw = player.method_36454();
                    this.pitch = player.method_36455();
                }
            }
        } else {
            this.active = true;
            if (!this.uuid.equals(ViewManager.activeView)) {
                ViewManager.activeView = this.uuid;
                ViewManager.activeFrames = 0;
                ViewManager.dirty();
                if (player != null && this.level == null) {
                    this.level = player.method_37908().method_27983();
                }
                if (this.position != null && this.level != null) {
                    new AxiomServerboundTeleport(this.level, this.position.field_1352, this.position.field_1351, this.position.field_1350, this.yaw, this.pitch).send();
                }
            }
        }
    }

    public class_2487 save() {
        class_2487 tag = new class_2487();
        tag.method_10582("Name", this.name);
        NbtHelper.putUUID(tag, "UUID", this.uuid);
        tag.method_10556("PinLevel", this.pinLevel);
        if (this.pinLevel && this.level != null) {
            tag.method_10582("Level", this.level.method_29177().toString());
        }
        tag.method_10556("PinLocation", this.pinLocation);
        if (this.position != null) {
            tag.method_10549("X", this.position.field_1352);
            tag.method_10549("Y", this.position.field_1351);
            tag.method_10549("Z", this.position.field_1350);
            tag.method_10549("Yaw", (double)this.yaw);
            tag.method_10549("Pitch", (double)this.pitch);
        }
        return tag;
    }

    public static View load(class_2487 tag) {
        String name = tag.method_68564("Name", "");
        UUID uuid = NbtHelper.getUUID(tag, "UUID");
        View view = new View(name, uuid, null);
        view.pinLevel = tag.method_68566("PinLevel", false);
        String level = tag.method_68564("Level", "");
        if (level.isEmpty()) {
            view.level = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)level));
        }
        view.pinLocation = tag.method_68566("PinLocation", false);
        if (tag.method_10545("X") && tag.method_10545("Y") && tag.method_10545("Z")) {
            double x = tag.method_68563("X", 0.0);
            double y = tag.method_68563("Y", 0.0);
            double z = tag.method_68563("Z", 0.0);
            view.position = new class_243(x, y, z);
            view.yaw = tag.method_66563("Yaw", 0.0f);
            view.pitch = tag.method_66563("Pitch", 0.0f);
        }
        return view;
    }
}

