/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.hooks;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.AxiomClient;
import com.moulberry.axiom.ContextMenuManager;
import com.moulberry.axiom.KeyPressOverlay;
import com.moulberry.axiom.Toasts;
import com.moulberry.axiom.VersionUtilsClient;
import com.moulberry.axiom.buildertools.BuilderToolManager;
import com.moulberry.axiom.displayentity.DisplayEntityManipulator;
import com.moulberry.axiom.marker.MarkerEntityManipulator;
import com.moulberry.axiom.render.BlockRenderCache;
import com.moulberry.axiom.screen.SwitchBuilderToolScreen;
import com.moulberry.axiom.utils.RenderHelper;
import com.moulberry.axiom.world_modification.Dispatcher;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_10799;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import org.joml.Matrix3x2fStack;

public class ScreenRenderHook {
    private static final class_2960 HOTBAR_SELECTION_SPRITE = class_2960.method_60654((String)"hud/hotbar_selection");
    private static final class_2960 HOTBAR_OFFHAND_LEFT_SPRITE = class_2960.method_60654((String)"hud/hotbar_offhand_left");
    private static final class_2960 HOTBAR_OFFHAND_RIGHT_SPRITE = class_2960.method_60654((String)"hud/hotbar_offhand_right");
    private static final class_2960 TOOL_SWAPPER_LOCATION = class_2960.method_60654((String)"axiom:gui/tool_swapper.png");
    private static int waitingForServerToGiveDispatchSendsTimer = 0;
    private static class_2561 overlayText;
    private static int overlayTextTicks;

    public static void render(class_332 guiGraphics, int scaledWidth, int scaledHeight, float tickDelta) {
        int alpha;
        if (!AxiomClient.isAxiomActive()) {
            return;
        }
        boolean hadDeferredTooltip = guiGraphics.field_60305 != null;
        class_310 mc = class_310.method_1551();
        BlockRenderCache.renderTick(guiGraphics);
        if (mc.field_1755 == null) {
            if (ContextMenuManager.getInstance().isActive()) {
                ContextMenuManager.getInstance().render(guiGraphics, scaledWidth, scaledHeight, tickDelta);
            } else if (BuilderToolManager.isToolSlotActive()) {
                BuilderToolManager.renderScreen(guiGraphics, scaledWidth, scaledHeight, tickDelta);
            }
            if (Axiom.configuration.visuals.showKeyHints) {
                List<Object> keyHints = List.of();
                if (BuilderToolManager.isToolSlotActive()) {
                    keyHints = BuilderToolManager.getKeyHints();
                } else if (DisplayEntityManipulator.hasActiveGizmo()) {
                    keyHints = DisplayEntityManipulator.getKeyHints();
                } else if (MarkerEntityManipulator.hasActiveGizmo()) {
                    keyHints = MarkerEntityManipulator.getKeyHints();
                }
                if (!keyHints.isEmpty()) {
                    class_327 font = class_310.method_1551().field_1772;
                    int[] widths = new int[keyHints.size()];
                    int maxWidth = 0;
                    for (int i = 0; i < keyHints.size(); ++i) {
                        String keyHint = (String)keyHints.get(i);
                        int width = font.method_1727(keyHint);
                        if (width > maxWidth) {
                            maxWidth = width;
                        }
                        widths[i] = width;
                    }
                    class_1041 window = class_310.method_1551().method_22683();
                    double otherScale = 4 / window.method_4495();
                    Objects.requireNonNull(font);
                    int hintHeight = 9 * keyHints.size();
                    int padding = 2;
                    Objects.requireNonNull(mc.field_1772);
                    int y = scaledHeight - (int)(9.0 * otherScale) - hintHeight - 30 - padding + 1;
                    if (Toasts.isRenderingToast()) {
                        y -= 43;
                    }
                    guiGraphics.method_25294(scaledWidth - maxWidth - padding * 2, y - padding, scaledWidth, y + hintHeight + padding - 1, -1728053248);
                    for (int i = 0; i < keyHints.size(); ++i) {
                        String keyHint = (String)keyHints.get(i);
                        int n = scaledWidth - widths[i] - padding;
                        Objects.requireNonNull(font);
                        guiGraphics.method_25303(font, keyHint, n, y + 9 * i, -1);
                    }
                }
            }
        }
        Toasts.render(guiGraphics, scaledWidth, scaledHeight, tickDelta);
        if (Axiom.configuration.visuals.keypressOverlay) {
            ScreenRenderHook.renderKeypressOverlay(guiGraphics, scaledWidth, scaledHeight, mc);
        }
        class_327 font = class_310.method_1551().field_1772;
        if (waitingForServerToGiveDispatchSendsTimer > 10) {
            float timerWithPartial = (float)waitingForServerToGiveDispatchSendsTimer + tickDelta;
            float alphaFactor = timerWithPartial >= 20.0f ? 1.0f : (timerWithPartial - 10.0f) / 10.0f;
            alpha = (int)(255.0f * alphaFactor);
            guiGraphics.method_25300(font, "[Axiom] Waiting for server to process chunk changes...", scaledWidth / 2, scaledHeight - 90, alpha << 24 | 0xFFFF55);
        }
        if (overlayText != null && overlayTextTicks > 0) {
            float timerWithPartial = (float)overlayTextTicks - tickDelta;
            float alphaFactor = timerWithPartial >= 10.0f ? 1.0f : timerWithPartial / 10.0f;
            alpha = (int)(255.0f * alphaFactor);
            int width = font.method_27525((class_5348)overlayText);
            int x = scaledWidth / 2 - width / 2;
            int y = scaledHeight - 80;
            boolean background = Axiom.configuration.visuals.statusBackground;
            if (background) {
                Objects.requireNonNull(font);
                guiGraphics.method_25294(x - 2, y - 2, x + width + 1, y + 9 + 1, alpha / 2 << 24);
            }
            guiGraphics.method_51439(font, overlayText, x, y, alpha << 24 | 0xFFFFFF, !background);
        }
        if (!hadDeferredTooltip && guiGraphics.field_60305 != null) {
            guiGraphics.method_71279();
        }
        RenderHelper.tryFlush(guiGraphics);
    }

    public static void setOverlayText(class_2561 component) {
        overlayText = component;
        overlayTextTicks = 60;
    }

    public static void tick() {
        if (Dispatcher.exhaustedDispatchSends()) {
            if (waitingForServerToGiveDispatchSendsTimer < 30) {
                ++waitingForServerToGiveDispatchSendsTimer;
            }
        } else if (waitingForServerToGiveDispatchSendsTimer > 0) {
            --waitingForServerToGiveDispatchSendsTimer;
        }
        if (overlayTextTicks > 0) {
            --overlayTextTicks;
        }
    }

    private static void renderKeypressOverlay(class_332 guiGraphics, int screenWidth, int screenHeight, class_310 mc) {
        List<KeyPressOverlay.StringWithOpacity> strings = KeyPressOverlay.getStrings(mc.field_1772);
        if (!strings.isEmpty()) {
            class_1041 window = class_310.method_1551().method_22683();
            float scale = 4.0f / (float)window.method_4495();
            int width = 0;
            for (KeyPressOverlay.StringWithOpacity string : strings) {
                width += string.width();
            }
            int hotbarRight = screenWidth / 2 + 120;
            int centerX = (hotbarRight + screenWidth) / 2;
            int scaledWidth = (int)Math.ceil((float)width * scale);
            if (centerX + scaledWidth / 2 > screenWidth) {
                centerX = screenWidth - scaledWidth / 2;
            }
            int baseY = screenHeight - 24;
            Matrix3x2fStack pose = guiGraphics.method_51448();
            pose.pushMatrix();
            pose.translate((float)centerX, (float)baseY);
            pose.scale(scale);
            pose.translate((float)(-centerX), (float)(-baseY));
            int x = centerX - width / 2;
            Objects.requireNonNull(mc.field_1772);
            int y = baseY - 9;
            Objects.requireNonNull(mc.field_1772);
            guiGraphics.method_25294(x - 1, y - 1, x + width + 1, y + 9, -1728053248);
            for (KeyPressOverlay.StringWithOpacity string : strings) {
                guiGraphics.method_25303(mc.field_1772, string.string(), x, y, 0xFFFFFF | string.opacity() << 24);
                x += string.width();
            }
            pose.popMatrix();
        }
    }

    public static void renderHotbar(class_332 guiGraphics, int scaledWidth, int scaledHeight, float tickDelta) {
        class_1297 class_12972 = class_310.method_1551().field_1719;
        if (!(class_12972 instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)class_12972;
        if (ContextMenuManager.getInstance().getActiveScreen() instanceof SwitchBuilderToolScreen) {
            return;
        }
        if (!BuilderToolManager.isToolSlotActive() && !Axiom.configuration.builderTools.showBuilderToolSlot) {
            return;
        }
        int mid = scaledWidth / 2;
        class_1306 humanoidArm = player.method_6068();
        if (humanoidArm == class_1306.field_6182) {
            guiGraphics.method_52706(class_10799.field_56883, HOTBAR_OFFHAND_LEFT_SPRITE, mid - 91 - 29, scaledHeight - 23, 29, 24);
            if (BuilderToolManager.isToolSlotActive()) {
                guiGraphics.method_52706(class_10799.field_56883, HOTBAR_SELECTION_SPRITE, mid - 91 - 30, scaledHeight - 23 - 1, 24, 24);
            }
            VersionUtilsClient.blit256(guiGraphics, TOOL_SWAPPER_LOCATION, mid - 91 - 26, scaledHeight - 19, 46 + 16 * BuilderToolManager.getToolSlotSelected(), 0, 16, 16);
            if (!BuilderToolManager.canUseBuilderTools()) {
                guiGraphics.method_25294(mid - 91 - 26, scaledHeight - 19, mid - 91 - 26 + 16, scaledHeight - 19 + 16, -1442840576);
            }
        } else {
            guiGraphics.method_52706(class_10799.field_56883, HOTBAR_OFFHAND_RIGHT_SPRITE, mid + 91, scaledHeight - 23, 29, 24);
            if (BuilderToolManager.isToolSlotActive()) {
                guiGraphics.method_52706(class_10799.field_56883, HOTBAR_SELECTION_SPRITE, mid + 91 + 6, scaledHeight - 23 - 1, 24, 24);
            }
            VersionUtilsClient.blit256(guiGraphics, TOOL_SWAPPER_LOCATION, mid + 101, scaledHeight - 19, 46 + 16 * BuilderToolManager.getToolSlotSelected(), 0, 16, 16);
            if (!BuilderToolManager.canUseBuilderTools()) {
                guiGraphics.method_25294(mid + 101, scaledHeight - 19, mid + 101 + 16, scaledHeight - 19 + 16, -1442840576);
            }
        }
    }
}

