/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.mixin.render;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.buffers.Std140Builder;
import com.mojang.blaze3d.buffers.Std140SizeCalculator;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.AxiomClient;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.core_rendering.AxiomUniform;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.utils.AxiomVertexFormats;
import java.nio.ByteBuffer;
import java.util.Map;
import net.minecraft.class_287;
import net.minecraft.class_765;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_765.class})
public class MixinLightTexture {
    private static final int MIN_BRIGHTNESS_UBO_SIZE = new Std140SizeCalculator().putFloat().get();
    @Unique
    private float lastFactor = -1.0f;
    @Unique
    private GpuBuffer minBrightnessUboBuffer = null;
    @Unique
    private GpuBufferSlice minBrightnessBufferSlice = null;
    @Unique
    private GpuTextureView tempTextureView = null;
    @Shadow
    @Final
    private GpuTextureView field_60581;
    @Shadow
    @Final
    private GpuTexture field_57927;
    @Unique
    private GpuTexture tempTexture = null;

    @ModifyArg(method={"<init>"}, index=1, at=@At(value="INVOKE", remap=false, target="Lcom/mojang/blaze3d/systems/GpuDevice;createTexture(Ljava/lang/String;ILcom/mojang/blaze3d/textures/TextureFormat;IIII)Lcom/mojang/blaze3d/textures/GpuTexture;"))
    public int modifyUsageFlags(int usageFlags) {
        return usageFlags | 2;
    }

    @Inject(method={"updateLightTexture"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;pop()V", shift=At.Shift.BEFORE)})
    public void afterUpdateLightTexture(float f, CallbackInfo ci) {
        float sqr;
        float minBrightness;
        float factor;
        if (AxiomClient.isAxiomActive() && (factor = 0.2f * (minBrightness = (float)Axiom.configuration.visuals.minBrightness / 100.0f) + 0.8f * (sqr = minBrightness * minBrightness) * sqr) > 0.01f) {
            if (this.minBrightnessUboBuffer == null) {
                GpuDevice gpuDevice = RenderSystem.getDevice();
                this.minBrightnessUboBuffer = gpuDevice.createBuffer(() -> "AxiomSelectionInOutUBO ", 136, MIN_BRIGHTNESS_UBO_SIZE);
                this.minBrightnessBufferSlice = this.minBrightnessUboBuffer.slice(0, MIN_BRIGHTNESS_UBO_SIZE);
                this.lastFactor = -1.0f;
            }
            if (this.lastFactor != factor) {
                try (MemoryStack memoryStack = MemoryStack.stackPush();){
                    ByteBuffer byteBuffer = Std140Builder.onStack((MemoryStack)memoryStack, (int)MIN_BRIGHTNESS_UBO_SIZE).putFloat(factor).get();
                    RenderSystem.getDevice().createCommandEncoder().writeToBuffer(this.minBrightnessBufferSlice, byteBuffer);
                }
            }
            Map<String, AxiomUniform> uniforms = Map.of("MinBrightnessUBO", new AxiomUniform(this.minBrightnessBufferSlice));
            if (this.tempTexture == null) {
                this.tempTexture = RenderSystem.getDevice().createTexture("AxiomLightTexture", 13, this.field_57927.getFormat(), this.field_57927.getWidth(0), this.field_57927.getHeight(0), 1, this.field_57927.getMipLevels());
                this.tempTextureView = RenderSystem.getDevice().createTextureView(this.tempTexture);
            }
            RenderSystem.getDevice().createCommandEncoder().copyTextureToTexture(this.field_57927, this.tempTexture, 0, 0, 0, 0, 0, this.field_57927.getWidth(0), this.field_57927.getHeight(0));
            RenderSystem.setShaderTexture((int)0, (GpuTextureView)this.tempTextureView);
            VertexConsumerProvider provider = VertexConsumerProvider.shared();
            class_287 bufferBuilder = provider.begin(VertexFormat.class_5596.field_27382, AxiomVertexFormats.BLIT_SCREEN);
            bufferBuilder.method_22912(0.0f, 0.0f, 0.0f);
            bufferBuilder.method_22912(1.0f, 0.0f, 0.0f);
            bufferBuilder.method_22912(1.0f, 1.0f, 0.0f);
            bufferBuilder.method_22912(0.0f, 1.0f, 0.0f);
            AxiomRenderer.renderPipelineWithUniforms(AxiomRenderPipelines.BRIGHTEN_LIGHT_TEXTURE_PIPELINE, this.field_60581, null, bufferBuilder.method_60794(), true, uniforms);
        }
    }

    @Inject(method={"close"}, at={@At(value="RETURN")})
    public void close(CallbackInfo ci) {
        if (this.minBrightnessUboBuffer != null) {
            this.minBrightnessUboBuffer.close();
            this.minBrightnessUboBuffer = null;
            this.minBrightnessBufferSlice = null;
        }
        if (this.tempTextureView != null) {
            this.tempTextureView.close();
            this.tempTextureView = null;
        }
        if (this.tempTexture != null) {
            this.tempTexture.close();
            this.tempTexture = null;
        }
    }
}

