/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.vecmath;

import com.jhlabs.vecmath.AxisAngle4f;
import com.jhlabs.vecmath.Matrix4f;
import com.jhlabs.vecmath.Tuple4f;

public class Quat4f
extends Tuple4f {
    public Quat4f() {
        this(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Quat4f(float[] x) {
        this.x = x[0];
        this.y = x[1];
        this.z = x[2];
        this.w = x[3];
    }

    public Quat4f(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Quat4f(Quat4f t2) {
        this.x = t2.x;
        this.y = t2.y;
        this.z = t2.z;
        this.w = t2.w;
    }

    public Quat4f(Tuple4f t2) {
        this.x = t2.x;
        this.y = t2.y;
        this.z = t2.z;
        this.w = t2.w;
    }

    public void set(AxisAngle4f a) {
        float halfTheta = a.angle * 0.5f;
        float cosHalfTheta = (float)Math.cos(halfTheta);
        float sinHalfTheta = (float)Math.sin(halfTheta);
        this.x = a.x * sinHalfTheta;
        this.y = a.y * sinHalfTheta;
        this.z = a.z * sinHalfTheta;
        this.w = cosHalfTheta;
    }

    public void normalize() {
        float d = 1.0f / (this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        this.x *= d;
        this.y *= d;
        this.z *= d;
        this.w *= d;
    }

    public void set(Matrix4f m4) {
        float tr = m4.m00 + m4.m11 + m4.m22;
        if ((double)tr > 0.0) {
            float s2 = (float)Math.sqrt(tr + 1.0f);
            this.w = s2 / 2.0f;
            s2 = 0.5f / s2;
            this.x = (m4.m12 - m4.m21) * s2;
            this.y = (m4.m20 - m4.m02) * s2;
            this.z = (m4.m01 - m4.m10) * s2;
        } else {
            int i = 0;
            if (m4.m11 > m4.m00) {
                i = 1;
                if (m4.m22 > m4.m11) {
                    i = 2;
                }
            } else if (m4.m22 > m4.m00) {
                i = 2;
            }
            switch (i) {
                case 0: {
                    float s3 = (float)Math.sqrt(m4.m00 - (m4.m11 + m4.m22) + 1.0f);
                    this.x = s3 * 0.5f;
                    if ((double)s3 != 0.0) {
                        s3 = 0.5f / s3;
                    }
                    this.w = (m4.m12 - m4.m21) * s3;
                    this.y = (m4.m01 + m4.m10) * s3;
                    this.z = (m4.m02 + m4.m20) * s3;
                    break;
                }
                case 1: {
                    float s3 = (float)Math.sqrt(m4.m11 - (m4.m22 + m4.m00) + 1.0f);
                    this.y = s3 * 0.5f;
                    if ((double)s3 != 0.0) {
                        s3 = 0.5f / s3;
                    }
                    this.w = (m4.m20 - m4.m02) * s3;
                    this.z = (m4.m12 + m4.m21) * s3;
                    this.x = (m4.m10 + m4.m01) * s3;
                    break;
                }
                case 2: {
                    float s3 = (float)Math.sqrt(m4.m00 - (m4.m11 + m4.m22) + 1.0f);
                    this.z = s3 * 0.5f;
                    if ((double)s3 != 0.0) {
                        s3 = 0.5f / s3;
                    }
                    this.w = (m4.m01 - m4.m10) * s3;
                    this.x = (m4.m20 + m4.m02) * s3;
                    this.y = (m4.m21 + m4.m12) * s3;
                }
            }
        }
    }
}

