/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools;

import com.moulberry.axiom.collections.Position2dToIntMap;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.render.ChunkRenderOverrider;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.utils.BooleanWrapper;
import com.moulberry.axiomclientapi.funcinterfaces.TriIntConsumer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Arrays;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class HeightmapApplier {
    public ChunkedBlockRegion blockRegion = new ChunkedBlockRegion();
    public ChunkedBooleanRegion removeRegion = new ChunkedBooleanRegion();
    private final Position2dToIntMap originalHeights = new Position2dToIntMap(Integer.MIN_VALUE);
    private final Position2dToIntMap modifiedHeights = new Position2dToIntMap(Integer.MIN_VALUE);
    private Position2dToIntMap constrainedHeights = new Position2dToIntMap(Integer.MIN_VALUE);
    private final LongSet dirtyChunks = new LongOpenHashSet();
    private float smoothing;

    public void reset(float smoothing) {
        this.blockRegion.clear();
        this.removeRegion.clear();
        this.originalHeights.clear();
        this.modifiedHeights.clear();
        this.constrainedHeights.clear();
        this.smoothing = smoothing;
    }

    public void setOriginalY(int x, int z, int y) {
        this.originalHeights.put(x, z, y);
    }

    public void setModifiedY(int x, int z, int y) {
        this.modifiedHeights.put(x, z, y);
        this.dirtyChunks.add(class_1923.method_8331((int)(x >> 4), (int)(z >> 4)));
    }

    public int getOriginalY(int x, int z) {
        return this.originalHeights.get(x, z);
    }

    public int getModifiedY(int x, int z) {
        return this.modifiedHeights.get(x, z);
    }

    public int getConstrainedY(int x, int z) {
        return this.constrainedHeights.get(x, z);
    }

    public void iterateOriginalY(TriIntConsumer consumer) {
        this.originalHeights.forEachEntry(consumer);
    }

    public void update() {
        if (this.dirtyChunks.isEmpty()) {
            return;
        }
        LongOpenHashSet dirtyChunksAndNeighbors = new LongOpenHashSet();
        LongIterator longIterator = this.dirtyChunks.longIterator();
        while (longIterator.hasNext()) {
            long pos = longIterator.nextLong();
            int chunkX = class_1923.method_8325((long)pos);
            int chunkZ = class_1923.method_8332((long)pos);
            dirtyChunksAndNeighbors.add(class_1923.method_8331((int)(chunkX - 1), (int)(chunkZ - 1)));
            dirtyChunksAndNeighbors.add(class_1923.method_8331((int)chunkX, (int)(chunkZ - 1)));
            dirtyChunksAndNeighbors.add(class_1923.method_8331((int)(chunkX + 1), (int)(chunkZ - 1)));
            dirtyChunksAndNeighbors.add(class_1923.method_8331((int)(chunkX - 1), (int)chunkZ));
            dirtyChunksAndNeighbors.add(class_1923.method_8331((int)chunkX, (int)chunkZ));
            dirtyChunksAndNeighbors.add(class_1923.method_8331((int)(chunkX + 1), (int)chunkZ));
            dirtyChunksAndNeighbors.add(class_1923.method_8331((int)(chunkX - 1), (int)(chunkZ + 1)));
            dirtyChunksAndNeighbors.add(class_1923.method_8331((int)chunkX, (int)(chunkZ + 1)));
            dirtyChunksAndNeighbors.add(class_1923.method_8331((int)(chunkX + 1), (int)(chunkZ + 1)));
        }
        this.dirtyChunks.clear();
        if ((double)this.smoothing < 0.01) {
            this.updateRegion((LongSet)dirtyChunksAndNeighbors, this.modifiedHeights);
            return;
        }
        Long2ObjectOpenHashMap constrainedHeightsMap = new Long2ObjectOpenHashMap();
        Long2ObjectOpenHashMap baseHeightsMap = new Long2ObjectOpenHashMap();
        Long2ObjectMap<int[]> oldModifiedHeightsMap = this.modifiedHeights.unsafeGetMap();
        Long2ObjectMap<int[]> oldOriginalHeightsMap = this.originalHeights.unsafeGetMap();
        longIterator = dirtyChunksAndNeighbors.longIterator();
        while (longIterator.hasNext()) {
            long pos = longIterator.nextLong();
            int[] modifiedValues = (int[])oldModifiedHeightsMap.get(pos);
            int[] originalValues = (int[])oldOriginalHeightsMap.get(pos);
            if (modifiedValues == null || originalValues == null) continue;
            constrainedHeightsMap.put(pos, (Object)Arrays.copyOf(modifiedValues, modifiedValues.length));
            baseHeightsMap.put(pos, (Object)Arrays.copyOf(originalValues, originalValues.length));
        }
        Long2ObjectMap<int[]> oldConstrainedHeightsMap = this.constrainedHeights.unsafeGetMap();
        for (Long2ObjectMap.Entry entry : oldConstrainedHeightsMap.long2ObjectEntrySet()) {
            if (constrainedHeightsMap.containsKey(entry.getLongKey())) continue;
            constrainedHeightsMap.put(entry.getLongKey(), (Object)Arrays.copyOf((int[])entry.getValue(), ((int[])entry.getValue()).length));
        }
        Position2dToIntMap newConstrainedHeights = new Position2dToIntMap(Integer.MIN_VALUE, (Long2ObjectMap<int[]>)constrainedHeightsMap);
        Position2dToIntMap baseHeights = new Position2dToIntMap(Integer.MIN_VALUE, (Long2ObjectMap<int[]>)baseHeightsMap);
        int errorThreshold = 15 - (int)(this.smoothing * 15.0f);
        BooleanWrapper continueConstraining = new BooleanWrapper(true);
        while (continueConstraining.value) {
            continueConstraining.value = false;
            baseHeights.removeIf((x, z, baseHeight) -> {
                int modErr4;
                int modErr3;
                int modErr2;
                int modErr1;
                int oldError;
                int height4;
                int origErr4;
                int height3;
                int origErr3;
                int height2;
                int origErr2;
                int modifiedHeight = newConstrainedHeights.get(x, z);
                if (baseHeight == modifiedHeight) {
                    return true;
                }
                int constrainedHeight = baseHeight < modifiedHeight ? modifiedHeight - 1 : modifiedHeight + 1;
                int height1 = newConstrainedHeights.get(x + 1, z);
                int origErr1 = height1 - constrainedHeight;
                int newError = origErr1 * origErr1 + (origErr2 = (height2 = newConstrainedHeights.get(x - 1, z)) - constrainedHeight) * origErr2 + (origErr3 = (height3 = newConstrainedHeights.get(x, z + 1)) - constrainedHeight) * origErr3 + (origErr4 = (height4 = newConstrainedHeights.get(x, z - 1)) - constrainedHeight) * origErr4;
                if (newError + errorThreshold < (oldError = (modErr1 = height1 - modifiedHeight) * modErr1 + (modErr2 = height2 - modifiedHeight) * modErr2 + (modErr3 = height3 - modifiedHeight) * modErr3 + (modErr4 = height4 - modifiedHeight) * modErr4)) {
                    newConstrainedHeights.put(x, z, constrainedHeight);
                    continueConstraining.value = true;
                    return constrainedHeight == baseHeight;
                }
                return false;
            });
        }
        this.constrainedHeights = newConstrainedHeights;
        this.updateRegion((LongSet)dirtyChunksAndNeighbors, this.constrainedHeights);
    }

    private void updateRegion(LongSet dirtyChunksAndNeighbors, Position2dToIntMap constrained) {
        class_2680 dirt = class_2246.field_10566.method_9564();
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        MaskElement destMask = MaskManager.getDestMask();
        MaskContext maskContext = new MaskContext((class_1937)class_310.method_1551().field_1687);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        LongIterator longIterator = dirtyChunksAndNeighbors.longIterator();
        while (longIterator.hasNext()) {
            long pos = longIterator.nextLong();
            int[] heights = this.originalHeights.getChunk(pos);
            if (heights == null) continue;
            int cx = class_1923.method_8325((long)pos);
            int cz = class_1923.method_8332((long)pos);
            int wcx = cx * 16;
            int wcz = cz * 16;
            class_2791 chunk = level.method_8402(cx, cz, class_2806.field_12803, false);
            if (chunk == null) continue;
            int index = 0;
            for (int zo = 0; zo < 16; ++zo) {
                for (int xo = 0; xo < 16; ++xo) {
                    class_2680 aboveState;
                    int y;
                    int originalHeight;
                    if ((originalHeight = heights[index++]) == Integer.MIN_VALUE) continue;
                    int x = wcx + xo;
                    int z = wcz + zo;
                    int modifiedHeight = constrained.get(x, z);
                    if (modifiedHeight < originalHeight) {
                        class_2680 aboveState2;
                        for (y = originalHeight; y > modifiedHeight && destMask.test(maskContext.reset(), x, y, z); --y) {
                            this.blockRegion.addBlock(x, y, z, class_2246.field_10124.method_9564());
                            ChunkRenderOverrider.setBlock(x, y, z, class_2246.field_10124.method_9564());
                            this.removeRegion.add(x, y, z);
                        }
                        for (int i = 0; i < 8 && !(aboveState2 = chunk.method_8320((class_2338)mutableBlockPos.method_10103(x, originalHeight + i + 1, z))).method_26215() && !aboveState2.method_51366() && aboveState2.method_26227().method_15769(); ++i) {
                            this.blockRegion.addBlock(x, originalHeight + i + 1, z, class_2246.field_10124.method_9564());
                            ChunkRenderOverrider.setBlock(x, originalHeight + i + 1, z, class_2246.field_10124.method_9564());
                            this.removeRegion.add(x, originalHeight + i + 1, z);
                            this.blockRegion.addBlock(x, y + 1 + i, z, aboveState2);
                        }
                        continue;
                    }
                    if (modifiedHeight <= originalHeight) continue;
                    y = originalHeight;
                    class_2680 blockState = chunk.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                    if (blockState.method_26204() == class_2246.field_10219) {
                        while (y <= modifiedHeight && destMask.test(maskContext.reset(), x, y, z)) {
                            this.blockRegion.addBlock(x, y, z, dirt);
                            ++y;
                        }
                        if (y > originalHeight) {
                            this.blockRegion.addBlock(x, y - 1, z, class_2246.field_10219.method_9564());
                        }
                    } else {
                        while (y <= modifiedHeight && destMask.test(maskContext.reset(), x, y, z)) {
                            this.blockRegion.addBlock(x, y, z, blockState);
                            ++y;
                        }
                    }
                    for (int i = 0; i < 8 && !(aboveState = chunk.method_8320((class_2338)mutableBlockPos.method_10103(x, originalHeight + i + 1, z))).method_26215() && !aboveState.method_51366() && aboveState.method_26227().method_15769() && destMask.test(maskContext.reset(), x, y + i, z); ++i) {
                        this.blockRegion.addBlock(x, y + i, z, aboveState);
                    }
                }
            }
        }
    }
}

