/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.gradient_painter;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.VersionUtilsClient;
import com.moulberry.axiom.VersionUtilsNbt;
import com.moulberry.axiom.block_maps.FamilyMap;
import com.moulberry.axiom.brush_shapes.BrushShape;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.core_rendering.AxiomDrawBuffer;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.ServerCustomBlocks;
import com.moulberry.axiom.editor.EditorMovementControls;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.BrushWidget;
import com.moulberry.axiom.editor.widgets.PresetWidget;
import com.moulberry.axiom.editor.widgets.SelectBlockWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.noise.WhiteNoise;
import com.moulberry.axiom.pather.async.AsyncToolPathProvider;
import com.moulberry.axiom.pather.async.AsyncToolPather;
import com.moulberry.axiom.pather.async.AsyncToolPatherUnique;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.BezierOperator;
import com.moulberry.axiom.utils.BlockManipulation;
import com.moulberry.axiom.utils.BlockWithFloat;
import com.moulberry.axiom.utils.NbtHelper;
import com.moulberry.axiom.utils.ProjectedText;
import com.moulberry.axiom.utils.RegionHelper;
import imgui.ImGui;
import imgui.type.ImString;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.DoubleUnaryOperator;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2769;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class GradientPainterTool
implements Tool {
    private final ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
    private AxiomDrawBuffer gridBuffer = null;
    private boolean usingTool = false;
    private AsyncToolPathProvider pathProvider = null;
    private class_2338 pendingTargetPos = null;
    private class_243 pos1 = null;
    private class_243 pos2 = null;
    private class_243 direction = null;
    private final BrushWidget brushWidget = new BrushWidget();
    private boolean maskSurface = true;
    private final int[] gradientShape = new int[]{0};
    private final int[] gradientInterpolation = new int[]{0};
    private final int[] lockedGradient = new int[]{0};
    private boolean clampToEdge = false;
    private final ImString noiseSeed = new ImString();
    public final List<BlockWithFloat> blockPercentages = new ArrayList<BlockWithFloat>();
    private final SelectBlockWidget selectBlockWidget = new SelectBlockWidget(false);
    private boolean copyProperties = false;
    private boolean typeReplace = false;
    private final PresetWidget presetWidget = new PresetWidget(this, "gradient_painter");
    private final int defaultRandomValue = ThreadLocalRandom.current().nextInt();

    public GradientPainterTool() {
        this.blockPercentages.add(new BlockWithFloat((CustomBlockState)class_2246.field_10340.method_9564(), new float[]{50.0f}, null));
        this.blockPercentages.add(new BlockWithFloat((CustomBlockState)class_2246.field_10474.method_9564(), new float[]{50.0f}, null));
        this.noiseSeed.set(String.valueOf(this.defaultRandomValue), false);
    }

    @Override
    public void reset() {
        this.usingTool = false;
        this.chunkedBlockRegion.clear();
        this.pendingTargetPos = null;
        if (this.lockedGradient[0] == 0) {
            this.pos1 = null;
            this.pos2 = null;
            this.direction = null;
        } else if (this.lockedGradient[0] == 1 && this.pos1 != null) {
            this.pendingTargetPos = class_2338.method_49638((class_2374)this.pos1);
            this.pos1 = null;
            this.pos2 = null;
            this.direction = null;
        }
        if (this.gridBuffer != null) {
            this.gridBuffer.close();
            this.gridBuffer = null;
        }
        if (this.pathProvider != null) {
            this.pathProvider.close();
            this.pathProvider = null;
        }
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case ESCAPE: {
                if (this.usingTool || this.pendingTargetPos != null) {
                    this.reset();
                    return UserAction.ActionResult.USED_STOP;
                }
                if (this.lockedGradient[0] == 0) break;
                this.lockedGradient[0] = 0;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
            case UNDO: {
                if (this.usingTool) {
                    return UserAction.ActionResult.USED_STOP;
                }
                if (this.pos1 == null && this.pos2 == null && this.direction == null && this.pendingTargetPos == null) break;
                this.pos1 = null;
                this.pos2 = null;
                this.direction = null;
                this.pendingTargetPos = null;
                return UserAction.ActionResult.USED_STOP;
            }
            case RIGHT_MOUSE: {
                AsyncToolPather pather;
                RayCaster.RaycastResult result = Tool.raycastBlock(false, false, false);
                if (result == null) {
                    return UserAction.ActionResult.USED_STOP;
                }
                class_1297 cameraEntity = class_310.method_1551().field_1719;
                if (cameraEntity == null) {
                    return UserAction.ActionResult.USED_STOP;
                }
                if (this.lockedGradient[0] != 2 || this.pos1 == null || this.pos2 == null) {
                    if (this.pendingTargetPos == null) {
                        this.pendingTargetPos = result.blockPos();
                        return UserAction.ActionResult.USED_STOP;
                    }
                    class_2338 currentTargetPos = this.pendingTargetPos;
                    this.reset();
                    this.pos1 = class_243.method_24953((class_2382)currentTargetPos);
                    this.pos2 = class_243.method_24953((class_2382)result.blockPos());
                    this.direction = this.pos2.method_1020(this.pos1).method_1029();
                }
                if ((pather = this.createToolPather(this.brushWidget.getBrushShape())) == null) {
                    return UserAction.ActionResult.USED_STOP;
                }
                this.usingTool = true;
                this.pathProvider = new AsyncToolPathProvider(pather).includeNonSolid(false);
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        if (!this.usingTool) {
            RayCaster.RaycastResult result = Tool.raycastBlock();
            if (result == null) {
                if (EditorUI.movementControls == EditorMovementControls.none() && this.lockedGradient[0] == 0) {
                    this.pendingTargetPos = null;
                }
                Selection.render(camera, time, matrices, projection, 7);
                return;
            }
            Selection.render(camera, time, matrices, projection, 4);
            this.brushWidget.renderPreview(camera, class_243.method_24954((class_2382)result.getBlockPos()), matrices, projection, time, 3);
            if (this.pendingTargetPos != null) {
                this.renderTargetTrianglePreview(camera, matrices, projection, result);
            }
        } else if (Tool.cancelUsing()) {
            this.reset();
        } else if (!Tool.isMouseDown(1)) {
            this.pathProvider.finish();
            String countString = NumberFormat.getInstance().format(this.chunkedBlockRegion.count());
            String historyDescription = AxiomI18n.get("axiom.history_description.painted", countString);
            RegionHelper.pushBlockRegionChange(this.chunkedBlockRegion, historyDescription);
            this.reset();
        } else {
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                return;
            }
            this.pathProvider.update();
            float opacity = (float)Math.sin((float)time / 1000000.0f / 50.0f / 8.0f);
            this.chunkedBlockRegion.render(camera, class_243.field_1353, matrices, projection, 0.75f + opacity * 0.25f, 0.3f - opacity * 0.2f);
        }
        if (this.pos1 != null && this.pos2 != null && (this.usingTool || this.lockedGradient[0] == 2)) {
            class_243 offsetPos1 = this.pos1;
            class_243 offsetPos2 = this.pos2;
            double distance = offsetPos1.method_1022(offsetPos2);
            RayCaster.RaycastResult result = Tool.raycastBlock();
            if (result != null) {
                class_243 from = this.pos1;
                class_243 to = result.worldPos();
                class_243 mid = from.method_35590(to, 0.5);
                from = from.method_1020(mid);
                to = to.method_1020(mid);
                double dx = to.field_1352 - from.field_1352;
                double dy = to.field_1351 - from.field_1351;
                double dz = to.field_1350 - from.field_1350;
                double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
                float nx = (float)(dx / dist);
                float ny = (float)(dy / dist);
                float nz = (float)(dz / dist);
                matrices.method_22903();
                matrices.method_22904(mid.field_1352 - camera.method_19326().field_1352, mid.field_1351 - camera.method_19326().field_1351, mid.field_1350 - camera.method_19326().field_1350);
                class_4587.class_4665 pose = matrices.method_23760();
                VertexConsumerProvider provider = VertexConsumerProvider.shared();
                class_287 bufferBuilder = provider.begin(class_293.class_5596.field_27377, class_290.field_29337);
                VersionUtilsClient.helperOldAddVertex((class_4588)bufferBuilder, pose.method_23761(), (float)from.field_1352, (float)from.field_1351, (float)from.field_1350).method_39415(-16729344).method_23763(pose, nx, ny, nz);
                VersionUtilsClient.helperOldAddVertex((class_4588)bufferBuilder, pose.method_23761(), (float)to.field_1352, (float)to.field_1351, (float)to.field_1350).method_39415(-16729344).method_23763(pose, nx, ny, nz);
                AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
                AxiomRenderPipelines.LINES_IGNORE_DEPTH.render(VersionUtilsClient.helperOldBufferBuilderEndOrDiscard(bufferBuilder));
                int x = result.blockPos().method_10263();
                int y = result.blockPos().method_10264();
                int z = result.blockPos().method_10260();
                double amount = this.gradientShape[0] == 0 ? ((double)x + 0.5 - offsetPos1.field_1352) * this.direction.field_1352 + ((double)y + 0.5 - offsetPos1.field_1351) * this.direction.field_1351 + ((double)z + 0.5 - offsetPos1.field_1350) * this.direction.field_1350 : Math.sqrt(offsetPos1.method_1028((double)x + 0.5, (double)y + 0.5, (double)z + 0.5));
                amount /= distance;
                if (amount < 0.0) {
                    amount = 0.0;
                }
                if (amount > 1.0) {
                    amount = 1.0;
                }
                String text = (int)(amount * 100.0) + "%";
                this.renderInfoText(matrices, projection, text);
                matrices.method_22909();
            }
        }
    }

    @Nullable
    private AsyncToolPather createToolPather(BrushShape brushShape) {
        int seed;
        boolean typeReplace;
        DoubleUnaryOperator[] interpolationArray;
        boolean planeGradientShape;
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return null;
        }
        MaskElement solidDestMask = MaskManager.createSolidDestMask();
        MaskContext maskContext = new MaskContext((class_1937)level);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        class_243 pos1 = this.pos1;
        double distance = pos1.method_1022(this.pos2);
        boolean bl = planeGradientShape = this.gradientShape[0] == 0;
        if (this.gradientInterpolation[0] == 1) {
            interpolationArray = new DoubleUnaryOperator[this.blockPercentages.size() - 1];
            count = this.blockPercentages.size();
            for (i = 0; i < this.blockPercentages.size(); ++i) {
                if (i >= interpolationArray.length) continue;
                record LinearOperator(int index, int count) implements DoubleUnaryOperator
                {
                    @Override
                    public double applyAsDouble(double operand) {
                        if (this.index == 0 && operand * (double)this.count < 0.5) {
                            return 1.0;
                        }
                        return 1.0 - Math.abs((double)this.index + 0.5 - (double)this.count * operand);
                    }
                }
                interpolationArray[i] = new LinearOperator(i, count);
            }
        } else if (this.gradientInterpolation[0] == 2) {
            interpolationArray = new DoubleUnaryOperator[this.blockPercentages.size() - 1];
            count = this.blockPercentages.size();
            for (i = 0; i < this.blockPercentages.size(); ++i) {
                if (i >= interpolationArray.length) continue;
                interpolationArray[i] = new BezierOperator(i, count);
            }
        } else {
            interpolationArray = null;
        }
        boolean copyProperties = this.canCopyProperties() && this.copyProperties;
        boolean bl2 = typeReplace = this.canTypeReplace() && this.typeReplace;
        if (interpolationArray == null) {
            float totalAmount = 0.0f;
            for (BlockWithFloat blockPercentage : this.blockPercentages) {
                totalAmount += blockPercentage.percentage()[0] / 100.0f;
            }
            if (totalAmount <= 0.0f) {
                return null;
            }
            float totalAmountF = totalAmount;
            return new AsyncToolPatherUnique(brushShape, (x, y, z) -> {
                if (!solidDestMask.test(maskContext.reset(), x, y, z)) {
                    return;
                }
                if (this.maskSurface && level.method_8320((class_2338)mutableBlockPos.method_10103(x + 1, y, z)).method_51366() && level.method_8320((class_2338)mutableBlockPos.method_10103(x - 1, y, z)).method_51366() && level.method_8320((class_2338)mutableBlockPos.method_10103(x, y + 1, z)).method_51366() && level.method_8320((class_2338)mutableBlockPos.method_10103(x, y - 1, z)).method_51366() && level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z + 1)).method_51366() && level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z - 1)).method_51366()) {
                    return;
                }
                double amount = planeGradientShape ? ((double)x + 0.5 - pos1.field_1352) * this.direction.field_1352 + ((double)y + 0.5 - pos1.field_1351) * this.direction.field_1351 + ((double)z + 0.5 - pos1.field_1350) * this.direction.field_1350 : Math.sqrt(pos1.method_1028((double)x + 0.5, (double)y + 0.5, (double)z + 0.5));
                if ((amount /= distance) < 0.0) {
                    if (this.clampToEdge) {
                        return;
                    }
                    amount = 0.0;
                }
                if (amount > 1.0) {
                    if (this.clampToEdge) {
                        return;
                    }
                    amount = 1.0;
                }
                for (BlockWithFloat blockPercentage : this.blockPercentages) {
                    if (!((amount -= (double)(blockPercentage.percentage()[0] / 100.0f / totalAmountF)) < 0.0)) continue;
                    CustomBlockState blockState = blockPercentage.blockState();
                    BlockManipulation.setWithCopyPropertiesAndTypeReplace(this.chunkedBlockRegion, x, y, z, blockState, typeReplace, copyProperties, blockPercentage.randomProperties(), maskContext, mutableBlockPos);
                    return;
                }
                BlockWithFloat last = this.blockPercentages.get(this.blockPercentages.size() - 1);
                BlockManipulation.setWithCopyPropertiesAndTypeReplace(this.chunkedBlockRegion, x, y, z, last.blockState(), typeReplace, copyProperties, last.randomProperties(), maskContext, mutableBlockPos);
            });
        }
        String seedStr = ImGuiHelper.getString(this.noiseSeed).trim();
        if (seedStr.isEmpty()) {
            seed = this.defaultRandomValue;
        } else {
            try {
                seed = Integer.parseInt(seedStr);
            }
            catch (NumberFormatException numberFormatException) {
                seed = 0;
                for (char c : seedStr.toCharArray()) {
                    seed = 31 * seed + c;
                }
            }
        }
        WhiteNoise whiteNoise = new WhiteNoise(seed);
        return new AsyncToolPatherUnique(brushShape, (x, y, z) -> {
            if (!solidDestMask.test(maskContext.reset(), x, y, z)) {
                return;
            }
            if (this.maskSurface && level.method_8320((class_2338)mutableBlockPos.method_10103(x + 1, y, z)).method_51366() && level.method_8320((class_2338)mutableBlockPos.method_10103(x - 1, y, z)).method_51366() && level.method_8320((class_2338)mutableBlockPos.method_10103(x, y + 1, z)).method_51366() && level.method_8320((class_2338)mutableBlockPos.method_10103(x, y - 1, z)).method_51366() && level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z + 1)).method_51366() && level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z - 1)).method_51366()) {
                return;
            }
            double amount = planeGradientShape ? ((double)x + 0.5 - pos1.field_1352) * this.direction.field_1352 + ((double)y + 0.5 - pos1.field_1351) * this.direction.field_1351 + ((double)z + 0.5 - pos1.field_1350) * this.direction.field_1350 : Math.sqrt(pos1.method_1028((double)x + 0.5, (double)y + 0.5, (double)z + 0.5));
            if ((amount /= distance) < 0.0) {
                if (this.clampToEdge) {
                    return;
                }
                amount = 0.0;
            }
            if (amount > 1.0) {
                if (this.clampToEdge) {
                    return;
                }
                amount = 1.0;
            }
            double randomValue = whiteNoise.evaluate((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            int i = 0;
            for (DoubleUnaryOperator operator : interpolationArray) {
                if ((randomValue -= Math.max(0.0, operator.applyAsDouble(amount))) < 0.0) {
                    CustomBlockState blockState = this.blockPercentages.get(i).blockState();
                    Set<class_2769<?>> randomizedProperties = this.blockPercentages.get(i).randomProperties();
                    BlockManipulation.setWithCopyPropertiesAndTypeReplace(this.chunkedBlockRegion, x, y, z, blockState, typeReplace, copyProperties, randomizedProperties, maskContext, mutableBlockPos);
                    return;
                }
                ++i;
            }
            BlockWithFloat last = this.blockPercentages.get(this.blockPercentages.size() - 1);
            BlockManipulation.setWithCopyPropertiesAndTypeReplace(this.chunkedBlockRegion, x, y, z, last.blockState(), typeReplace, copyProperties, last.randomProperties(), maskContext, mutableBlockPos);
        });
    }

    private void renderTargetTrianglePreview(class_4184 camera, class_4587 matrix, Matrix4f projection, RayCaster.RaycastResult result) {
        class_243 from = class_243.method_24953((class_2382)this.pendingTargetPos);
        class_243 to = result.worldPos();
        class_243 mid = from.method_35590(to, 0.5);
        from = from.method_1020(mid);
        to = to.method_1020(mid);
        double dx = to.field_1352 - from.field_1352;
        double dy = to.field_1351 - from.field_1351;
        double dz = to.field_1350 - from.field_1350;
        double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
        float nx = (float)(dx / dist);
        float ny = (float)(dy / dist);
        float nz = (float)(dz / dist);
        matrix.method_22903();
        matrix.method_22904(mid.field_1352 - camera.method_19326().field_1352, mid.field_1351 - camera.method_19326().field_1351, mid.field_1350 - camera.method_19326().field_1350);
        class_4587.class_4665 pose = matrix.method_23760();
        VertexConsumerProvider provider = VertexConsumerProvider.shared();
        class_287 bufferBuilder = provider.begin(class_293.class_5596.field_27377, class_290.field_29337);
        VersionUtilsClient.helperOldAddVertex((class_4588)bufferBuilder, pose.method_23761(), (float)from.field_1352, (float)from.field_1351, (float)from.field_1350).method_39415(-7829249).method_23763(pose, nx, ny, nz);
        VersionUtilsClient.helperOldAddVertex((class_4588)bufferBuilder, pose.method_23761(), (float)to.field_1352, (float)to.field_1351, (float)to.field_1350).method_39415(-7829249).method_23763(pose, nx, ny, nz);
        AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
        AxiomRenderPipelines.LINES_IGNORE_DEPTH.render(provider.build());
        this.renderInfoText(matrix, projection, String.format("%.2f", dist));
        matrix.method_22909();
    }

    private void renderInfoText(class_4587 matrix, Matrix4f projection, String text) {
        ProjectedText.setupProjectedText();
        ProjectedText.renderProjectedText(text, matrix, projection, 0.0f, 0.0f, 0.0f);
        ProjectedText.finishProjectedText();
    }

    @Override
    public void displayImguiOptions() {
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.brush"));
        boolean changed = this.brushWidget.displayImgui();
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.generic.mask_surface"), this.maskSurface)) {
            this.maskSurface = !this.maskSurface;
            changed = true;
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.gradient_painter.gradient"));
        changed |= ImGuiHelper.radio(AxiomI18n.get("axiom.tool.gradient_painter.gradient_shape"), this.gradientShape, new String[]{AxiomI18n.get("axiom.tool.gradient_painter.gradient_shape_plane"), AxiomI18n.get("axiom.tool.gradient_painter.gradient_shape_sphere")});
        changed |= ImGuiHelper.radio(AxiomI18n.get("axiom.tool.gradient_painter.gradient_interpolation"), this.gradientInterpolation, new String[]{AxiomI18n.get("axiom.tool.gradient_painter.gradient_interpolation_nearest"), AxiomI18n.get("axiom.tool.gradient_painter.gradient_interpolation_linear"), AxiomI18n.get("axiom.tool.gradient_painter.gradient_interpolation_bezier")});
        if (ImGuiHelper.combo(AxiomI18n.get("axiom.tool.gradient_painter.locking"), this.lockedGradient, new String[]{AxiomI18n.get("axiom.tool.gradient_painter.lock_none"), AxiomI18n.get("axiom.tool.gradient_painter.lock_pos1"), AxiomI18n.get("axiom.tool.gradient_painter.lock_both")})) {
            changed = true;
            this.reset();
        }
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.gradient_painter.clamp_to_edge"), this.clampToEdge)) {
            this.clampToEdge = !this.clampToEdge;
            changed = true;
        }
        if (this.gradientInterpolation[0] != 0) {
            ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.noise"));
            changed |= ImGui.inputText(AxiomI18n.get("axiom.tool.generic.noise_seed"), this.noiseSeed);
            if (ImGui.button(AxiomI18n.get("axiom.tool.generic.noise_seed_do_randomize"))) {
                this.noiseSeed.set(String.valueOf(ThreadLocalRandom.current().nextInt()), false);
                changed = true;
            }
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.noise_painter.blocks"));
        BlockWithFloat.ExtraRenderType extraRenderType = this.gradientInterpolation[0] == 0 ? BlockWithFloat.ExtraRenderType.PERCENTAGE : BlockWithFloat.ExtraRenderType.BLOCKNAME;
        changed |= BlockWithFloat.renderList(this.blockPercentages, this.selectBlockWidget, extraRenderType, 2, true);
        if (this.canCopyProperties() && ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.replace.copy_properties"), this.copyProperties)) {
            boolean bl = this.copyProperties = !this.copyProperties;
        }
        if (this.canTypeReplace() && ImGui.checkbox(AxiomI18n.get("axiom.contextmenu.type_replace"), this.typeReplace)) {
            this.typeReplace = !this.typeReplace;
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.presets"));
        this.presetWidget.displayImgui(changed);
    }

    private boolean canCopyProperties() {
        for (BlockWithFloat blockThreshold : this.blockPercentages) {
            if (blockThreshold.blockState().getProperties().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean canTypeReplace() {
        for (BlockWithFloat blockThreshold : this.blockPercentages) {
            if (FamilyMap.getFamilyForBase(blockThreshold.blockState().getVanillaState().method_26204()) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public String listenForEsc() {
        if (this.usingTool || this.pendingTargetPos != null) {
            return AxiomI18n.get("axiom.widget.cancel");
        }
        if (this.lockedGradient[0] != 0) {
            return "Unlock";
        }
        return null;
    }

    @Override
    public boolean initiateAdjustment() {
        return this.brushWidget.initiateAdjustment();
    }

    @Override
    public class_241 renderAdjustment(float mouseX, float mouseY, class_241 mouseDelta) {
        return this.brushWidget.renderAdjustment(mouseX, mouseY, mouseDelta);
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.gradient_painter");
    }

    @Override
    public void writeSettings(class_2487 tag) {
        this.brushWidget.writeSettings(tag);
        tag.method_10556("MaskSurface", this.maskSurface);
        tag.method_10569("GradientShape", this.gradientShape[0]);
        tag.method_10569("GradientInterpolation", this.gradientInterpolation[0]);
        tag.method_10556("ClampToEdge", this.clampToEdge);
        tag.method_10582("NoiseSeed", ImGuiHelper.getString(this.noiseSeed));
        class_2499 blockPercentages = new class_2499();
        for (BlockWithFloat blockWithFloat : this.blockPercentages) {
            class_2487 blockWithFloatTag = new class_2487();
            blockWithFloatTag.method_10582("Block", ServerCustomBlocks.serialize(blockWithFloat.blockState()));
            blockWithFloatTag.method_10548("Percentage", blockWithFloat.percentage()[0]);
            blockPercentages.add((Object)blockWithFloatTag);
        }
        tag.method_10566("BlockPercentages", (class_2520)blockPercentages);
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.brushWidget.loadSettings(tag);
        this.maskSurface = VersionUtilsNbt.helperCompoundTagGetBooleanOr(tag, "MaskSurface", true);
        this.gradientShape[0] = VersionUtilsNbt.helperCompoundTagGetIntOr(tag, "GradientShape", 0);
        this.gradientInterpolation[0] = VersionUtilsNbt.helperCompoundTagGetIntOr(tag, "GradientInterpolation", 0);
        this.clampToEdge = VersionUtilsNbt.helperCompoundTagGetBooleanOr(tag, "ClampToEdge", false);
        this.noiseSeed.set(VersionUtilsNbt.helperCompoundTagGetStringOr(tag, "NoiseSeed", String.valueOf(this.defaultRandomValue)), false);
        this.blockPercentages.clear();
        class_2499 blockPercentagesList = NbtHelper.getList(tag, "BlockPercentages", 10);
        for (class_2520 blockPercentageTag : blockPercentagesList) {
            class_2487 blockPercentage = (class_2487)blockPercentageTag;
            String block = VersionUtilsNbt.helperCompoundTagGetString(blockPercentage, "Block").get();
            float percentage = VersionUtilsNbt.helperCompoundTagGetFloat(blockPercentage, "Percentage").get().floatValue();
            this.blockPercentages.add(new BlockWithFloat(Objects.requireNonNullElse(ServerCustomBlocks.deserialize(block), (CustomBlockState)class_2246.field_10340.method_9564()), new float[]{percentage}, null));
        }
        BlockWithFloat.ensureFilledToMinimum(this.blockPercentages, 2);
    }

    public void setBlocks(List<CustomBlockState> blocks) {
        this.blockPercentages.clear();
        for (CustomBlockState block : blocks) {
            this.blockPercentages.add(new BlockWithFloat(block, new float[]{100.0f / (float)blocks.size()}, null));
        }
        BlockWithFloat.ensureFilledToMinimum(this.blockPercentages, 2);
    }

    @Override
    public boolean showToolSmoothing() {
        return true;
    }

    @Override
    public char iconChar() {
        return '\ue91a';
    }

    @Override
    public String keybindId() {
        return "gradient_painter";
    }

    @Override
    public EnumSet<AxiomPermission> requiredPermissions() {
        return EnumSet.of(AxiomPermission.TOOL_GRADIENTPAINTER, AxiomPermission.BUILD_SECTION);
    }
}

