/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.CreateTreadmill.block;

import com.gly091020.CreateTreadmill.CreateTreadmillMod;
import com.gly091020.CreateTreadmill.Part;
import com.gly091020.CreateTreadmill.block.TreadmillBlockEntity;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class TreadmillBlock
extends HorizontalKineticBlock
implements IBE<TreadmillBlockEntity> {
    public static final EnumProperty<Part> PART = EnumProperty.create((String)"part", Part.class);

    public TreadmillBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART});
        super.createBlockStateDefinition(builder);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)Objects.requireNonNull(super.getStateForPlacement(context)).setValue(PART, (Comparable)((Object)Part.BOTTOM_BACK))).setValue(HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection());
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        if (worldIn.isClientSide) {
            return;
        }
        if (state.getValue(PART) == Part.BOTTOM_BACK) {
            BlockPos p1 = BlockPos.ZERO;
            switch ((Direction)state.getValue(HORIZONTAL_FACING)) {
                case NORTH: {
                    p1 = pos.north(1);
                    break;
                }
                case SOUTH: {
                    p1 = pos.south(1);
                    break;
                }
                case WEST: {
                    p1 = pos.west(1);
                    break;
                }
                case EAST: {
                    p1 = pos.east(1);
                }
            }
            BlockPos p2 = pos.above(1);
            BlockPos p3 = p1.above(1);
            worldIn.setBlock(p1, (BlockState)state.setValue(PART, (Comparable)((Object)Part.BOTTOM_FRONT)), 3);
            worldIn.setBlock(p2, (BlockState)state.setValue(PART, (Comparable)((Object)Part.TOP_BACK)), 3);
            worldIn.setBlock(p3, (BlockState)state.setValue(PART, (Comparable)((Object)Part.TOP_FRONT)), 3);
            worldIn.blockUpdated(pos, Blocks.AIR);
            worldIn.blockUpdated(p1, Blocks.AIR);
            worldIn.blockUpdated(p2, Blocks.AIR);
            worldIn.blockUpdated(p3, Blocks.AIR);
        }
    }

    @NotNull
    protected List<ItemStack> getDrops(@NotNull BlockState state, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootParams.Builder params) {
        return Collections.singletonList(new ItemStack((ItemLike)CreateTreadmillMod.TREADMILL_ITEM.get(), 1));
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue(HORIZONTAL_FACING)).getAxis() == Direction.Axis.Z ? Direction.Axis.X : Direction.Axis.Z;
    }

    protected void tick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        this.withBlockEntityDo((BlockGetter)level, pos, TreadmillBlockEntity::lazyTick);
    }

    public Class<TreadmillBlockEntity> getBlockEntityClass() {
        return TreadmillBlockEntity.class;
    }

    public BlockEntityType<? extends TreadmillBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CreateTreadmillMod.TREADMILL_ENTITY.get();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        if (state.getValue(PART) != Part.BOTTOM_FRONT) {
            return false;
        }
        switch ((Direction)state.getValue(HORIZONTAL_FACING)) {
            case WEST: 
            case EAST: {
                return face == Direction.NORTH || face == Direction.SOUTH;
            }
            case NORTH: 
            case SOUTH: {
                return face == Direction.EAST || face == Direction.WEST;
            }
        }
        return false;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult result) {
        BlockEntity entity = level.getBlockEntity(TreadmillBlock.findPart(level, state, pos, Part.BOTTOM_FRONT));
        if (entity instanceof TreadmillBlockEntity) {
            TreadmillBlockEntity blockEntity = (TreadmillBlockEntity)entity;
            if (!this.hasShaftTowards((LevelReader)level, pos, state, result.getDirection())) {
                if (blockEntity.getOnTreadmillEntity() != null) {
                    blockEntity.setOnTreadmillEntity(null);
                    return ItemInteractionResult.SUCCESS;
                }
                for (Entity entity1 : level.getEntities(null, new AABB(pos).inflate(10.0))) {
                    OwnableEntity ownableEntity;
                    Leashable leashable;
                    if (!(entity1 instanceof LivingEntity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity1;
                    if (!(entity1 instanceof Leashable) || (leashable = (Leashable)entity1).getLeashHolder() == null || !leashable.getLeashHolder().is((Entity)player)) continue;
                    blockEntity.setOnTreadmillEntity(livingEntity);
                    leashable.dropLeash(true, true);
                    blockEntity.setEntityTimer(1200);
                    if (entity1 instanceof OwnableEntity && (ownableEntity = (OwnableEntity)entity1).getOwner() != null) {
                        blockEntity.setEntityTimer(12000);
                    }
                    return ItemInteractionResult.SUCCESS;
                }
                blockEntity.setOnTreadmillEntity((LivingEntity)player);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        switch ((Part)((Object)state.getValue(PART))) {
            case TOP_BACK: 
            case TOP_FRONT: {
                return Shapes.create((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.34375, 1.0));
            }
        }
        return Shapes.block();
    }

    public static BlockPos findPart(Level level, BlockState state, BlockPos pos, Part part) {
        BlockPos p1 = BlockPos.ZERO;
        int a = part == Part.BOTTOM_BACK || part == Part.TOP_BACK ? 1 : -1;
        switch ((Direction)state.getValue(HORIZONTAL_FACING)) {
            case NORTH: {
                p1 = pos.south(a);
                break;
            }
            case SOUTH: {
                p1 = pos.north(a);
                break;
            }
            case WEST: {
                p1 = pos.east(a);
                break;
            }
            case EAST: {
                p1 = pos.west(a);
            }
        }
        BlockPos p2 = pos.below(1);
        BlockPos p3 = p1.below(1);
        if (part == Part.TOP_BACK || part == Part.TOP_FRONT) {
            p2 = pos.below(-1);
            p3 = p1.below(-1);
        }
        if (level.getBlockState(p1).is(CreateTreadmillMod.TREADMILL_BLOCK) && level.getBlockState(p1).getValue(PART) == part) {
            return p1;
        }
        if (level.getBlockState(p2).is(CreateTreadmillMod.TREADMILL_BLOCK) && level.getBlockState(p2).getValue(PART) == part) {
            return p2;
        }
        if (level.getBlockState(p3).is(CreateTreadmillMod.TREADMILL_BLOCK) && level.getBlockState(p3).getValue(PART) == part) {
            return p3;
        }
        return pos;
    }

    public void onRemove(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (oldState.getValue(PART) == Part.BOTTOM_FRONT && (blockEntity = level.getBlockEntity(pos)) instanceof TreadmillBlockEntity) {
            TreadmillBlockEntity entity = (TreadmillBlockEntity)blockEntity;
            entity.setOnTreadmillEntity(null);
        }
        super.onRemove(oldState, level, pos, newState, isMoving);
        if (!oldState.hasProperty(PART)) {
            return;
        }
        if (oldState.getValue(PART) == Part.BOTTOM_BACK) {
            BlockPos p1 = BlockPos.ZERO;
            switch ((Direction)oldState.getValue(HORIZONTAL_FACING)) {
                case NORTH: {
                    p1 = pos.north(1);
                    break;
                }
                case SOUTH: {
                    p1 = pos.south(1);
                    break;
                }
                case WEST: {
                    p1 = pos.west(1);
                    break;
                }
                case EAST: {
                    p1 = pos.east(1);
                }
            }
            BlockPos p2 = pos.above(1);
            BlockPos p3 = p1.above(1);
            level.setBlock(p1, Blocks.AIR.defaultBlockState(), 3);
            level.setBlock(p2, Blocks.AIR.defaultBlockState(), 3);
            level.setBlock(p3, Blocks.AIR.defaultBlockState(), 3);
        } else {
            BlockPos p = TreadmillBlock.findPart(level, oldState, pos, Part.BOTTOM_BACK);
            this.destroy((LevelAccessor)level, p, level.getBlockState(p));
            level.setBlock(p, Blocks.AIR.defaultBlockState(), 3);
        }
    }
}

