/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.CreateTreadmill.block;

import com.gly091020.CreateTreadmill.CreateTreadmillMod;
import com.gly091020.CreateTreadmill.Part;
import com.gly091020.CreateTreadmill.block.TreadmillBlock;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class TreadmillBlockEntity
extends GeneratingKineticBlockEntity {
    private LivingEntity onTreadmillEntity;
    private boolean isRunning = false;
    private boolean isRuned = false;
    private int speedUpTimer = 0;
    private int entityTimer = Integer.MAX_VALUE;

    public TreadmillBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setChanged();
    }

    public void tick() {
        if (this.getBlockState().getValue(TreadmillBlock.PART) != Part.BOTTOM_FRONT) {
            return;
        }
        if (this.onTreadmillEntity != null) {
            if (this.onTreadmillEntity.isRemoved()) {
                this.setOnTreadmillEntity(null);
                return;
            }
            if (!this.onTreadmillEntity.position().closerThan((Position)this.getFixedPos(), 1.0)) {
                this.setOnTreadmillEntity(null);
                return;
            }
            this.setPos();
            this.speedUp();
            LivingEntity livingEntity = this.onTreadmillEntity;
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (player.isShiftKeyDown() || player.getPose() == Pose.SITTING) {
                    this.setOnTreadmillEntity(null);
                }
            } else {
                this.onTreadmillEntity.setDeltaMovement(Vec3.atLowerCornerOf((Vec3i)((Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING)).getNormal()).multiply((double)0.3f, 0.0, (double)0.3f));
                this.onTreadmillEntity.lookAt(EntityAnchorArgument.Anchor.EYES, this.onTreadmillEntity.getEyePosition().relative((Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING), 1.0));
                this.onTreadmillEntity.setPose(Pose.STANDING);
                LivingEntity livingEntity2 = this.onTreadmillEntity;
                if (livingEntity2 instanceof TamableAnimal) {
                    TamableAnimal tamableAnimal = (TamableAnimal)livingEntity2;
                    tamableAnimal.setInSittingPose(false);
                }
                this.lazyTick();
            }
            this.dropIt();
        }
        super.tick();
        if (this.speedUpTimer == 0) {
            this.update();
            this.speedUpTimer = -1;
        }
        if (this.speedUpTimer > 0) {
            --this.speedUpTimer;
        }
        if (this.entityTimer <= 0) {
            this.setOnTreadmillEntity(null);
        } else if (this.entityTimer < Integer.MAX_VALUE) {
            --this.entityTimer;
            if (this.speedUpTimer > 0) {
                --this.entityTimer;
            }
        }
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        CompoundTag update = super.getUpdateTag(registries);
        update.putInt("speedup_timer", this.speedUpTimer);
        update.putInt("entity_timer", this.entityTimer);
        update.putInt("entity", this.onTreadmillEntity == null ? -1 : this.onTreadmillEntity.getId());
        return update;
    }

    public void onDataPacket(@NotNull Connection net, @NotNull ClientboundBlockEntityDataPacket pkt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.onDataPacket(net, pkt, registries);
        this.speedUpTimer = pkt.getTag().getInt("speedup_timer");
        this.entityTimer = pkt.getTag().getInt("entity_timer");
        int id = pkt.getTag().getInt("entity");
        if (id != -1) {
            if (this.level != null) {
                Entity entity = this.level.getEntity(id);
                if (entity == null) {
                    return;
                }
                this.setOnTreadmillEntity((LivingEntity)entity);
            }
        } else {
            this.setOnTreadmillEntity(null);
        }
    }

    public void setEntityTimer(int entityTimer) {
        if (!((Boolean)CreateTreadmillMod.CONFIG.TREADMILL_BREAK.get()).booleanValue()) {
            this.entityTimer = Integer.MAX_VALUE;
            return;
        }
        this.entityTimer = entityTimer;
    }

    public void setOnTreadmillEntity(@Nullable LivingEntity onTreadmillEntity) {
        if (onTreadmillEntity == null && this.onTreadmillEntity != null) {
            this.onTreadmillEntity.setDeltaMovement(Vec3.ZERO);
            CreateTreadmillMod.WALKING_ENTITY.remove(this.onTreadmillEntity.getId());
            this.onTreadmillEntity.walkAnimation.setSpeed(0.0f);
        }
        if (onTreadmillEntity != null) {
            CreateTreadmillMod.WALKING_ENTITY.put(onTreadmillEntity.getId(), onTreadmillEntity);
        } else {
            this.speedUpTimer = 0;
            this.entityTimer = Integer.MAX_VALUE;
        }
        this.onTreadmillEntity = onTreadmillEntity;
        this.setPos();
        this.update();
    }

    public Entity getOnTreadmillEntity() {
        return this.onTreadmillEntity;
    }

    public void setPos() {
        if (this.onTreadmillEntity != null) {
            this.onTreadmillEntity.setPos(this.getFixedPos());
            this.onTreadmillEntity.setOnGround(true);
        }
    }

    public void speedUp() {
        DamageSource damageSource;
        if (!((Boolean)CreateTreadmillMod.CONFIG.TREADMILL_SPEED_UP.get()).booleanValue()) {
            return;
        }
        if (this.onTreadmillEntity.hurtTime > 0 && !(this.onTreadmillEntity.getLastHurtMob() instanceof Player) && (damageSource = this.onTreadmillEntity.getLastDamageSource()) != null && damageSource.getWeaponItem() != null) {
            this.speedUpTimer = 1200;
            this.update();
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.getBlockState().getValue(TreadmillBlock.PART) != Part.BOTTOM_FRONT) {
            BlockEntity blockEntity;
            BlockPos p = TreadmillBlock.findPart(this.level, this.getBlockState(), this.getBlockPos(), Part.BOTTOM_FRONT);
            if (this.level != null && this.level.getBlockState(p).getValue(TreadmillBlock.PART) == Part.BOTTOM_FRONT && (blockEntity = this.level.getBlockEntity(p)) instanceof TreadmillBlockEntity) {
                TreadmillBlockEntity treadmillBlockEntity = (TreadmillBlockEntity)blockEntity;
                treadmillBlockEntity.addToGoggleTooltip(tooltip, isPlayerSneaking);
                return true;
            }
        }
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        this.addToolTip(tooltip);
        return true;
    }

    public void addToolTip(List<Component> tooltip) {
        if (this.getBlockState().getValue(TreadmillBlock.PART) != Part.BOTTOM_FRONT) {
            BlockEntity blockEntity;
            BlockPos p = TreadmillBlock.findPart(this.level, this.getBlockState(), this.getBlockPos(), Part.BOTTOM_FRONT);
            if (this.level != null && this.level.getBlockState(p).getValue(TreadmillBlock.PART) == Part.BOTTOM_FRONT && (blockEntity = this.level.getBlockEntity(p)) instanceof TreadmillBlockEntity) {
                TreadmillBlockEntity treadmillBlockEntity = (TreadmillBlockEntity)blockEntity;
                treadmillBlockEntity.addToolTip(tooltip);
                return;
            }
        }
        if (this.speedUpTimer > 0) {
            tooltip.add((Component)Component.translatable((String)"tip.createtreadmill.speedup", (Object[])new Object[]{this.speedUpTimer / 20}));
        }
        if (this.entityTimer > 0 && this.entityTimer < Integer.MAX_VALUE) {
            tooltip.add((Component)Component.translatable((String)"tip.createtreadmill.break", (Object[])new Object[]{this.entityTimer / 20}));
        }
    }

    public int getSpeedUpTimer() {
        return this.speedUpTimer;
    }

    public Vec3 getFixedPos() {
        BlockPos p = this.getBlockPos().above();
        double y = (double)p.getY() + 0.34375;
        switch ((Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING)) {
            case WEST: {
                return new Vec3((double)(p.getX() + 1), y, (double)p.getZ() + 0.5);
            }
            case EAST: {
                return new Vec3((double)p.getX(), y, (double)p.getZ() + 0.5);
            }
            case NORTH: {
                return new Vec3((double)p.getX() + 0.5, y, (double)(p.getZ() + 1));
            }
            case SOUTH: {
                return new Vec3((double)p.getX() + 0.5, y, (double)p.getZ());
            }
        }
        return Vec3.atCenterOf((Vec3i)p);
    }

    public static TreadmillBlockEntity getBlockEntityByEntity(Entity entity) {
        BlockPos part;
        BlockEntity e;
        Level level = entity.level();
        if (level.getBlockState(entity.blockPosition()).is(CreateTreadmillMod.TREADMILL_BLOCK) && (e = level.getBlockEntity(part = TreadmillBlock.findPart(level, level.getBlockState(entity.blockPosition()), entity.blockPosition(), Part.BOTTOM_FRONT))) instanceof TreadmillBlockEntity) {
            TreadmillBlockEntity treadmillBlockEntity = (TreadmillBlockEntity)e;
            return treadmillBlockEntity;
        }
        return null;
    }

    public void initialize() {
        super.initialize();
        if (this.getBlockState().getValue(TreadmillBlock.PART) != Part.BOTTOM_FRONT) {
            return;
        }
        this.updateGeneratedRotation();
        this.setLazyTickRate(10);
        this.setChanged();
    }

    public void lazyTick() {
        LivingEntity livingEntity;
        this.isRunning = this.isMoving();
        if (this.isRunning != this.isRuned) {
            this.isRuned = this.isRunning;
            this.update();
        }
        if (this.isRunning && (livingEntity = this.onTreadmillEntity) instanceof Player) {
            Player player = (Player)livingEntity;
            player.causeFoodExhaustion(this.getSettingSpeed() * 0.01f);
        }
        this.sendData();
    }

    private void update() {
        this.updateGeneratedRotation();
        this.notifyUpdate();
        this.sendData();
    }

    private void dropIt() {
        if (!((Boolean)CreateTreadmillMod.CONFIG.TREADMILL_DROP_IT.get()).booleanValue()) {
            return;
        }
        switch ((Direction)this.getBlockState().getValue(TreadmillBlock.HORIZONTAL_FACING)) {
            case EAST: 
            case NORTH: {
                if (!(this.getSpeed() < 0.0f)) break;
                float m = 3.0f * (Math.abs(this.getSpeed()) / 256.0f);
                this.onTreadmillEntity.setDeltaMovement(Vec3.atLowerCornerOf((Vec3i)((Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING)).getNormal()).multiply((double)m, 0.0, (double)m));
                this.onTreadmillEntity = null;
                break;
            }
            case WEST: 
            case SOUTH: {
                if (!(this.getSpeed() > 0.0f)) break;
                float m = 3.0f * (Math.abs(this.getSpeed()) / 256.0f);
                this.onTreadmillEntity.setDeltaMovement(Vec3.atLowerCornerOf((Vec3i)((Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING)).getNormal()).multiply((double)m, 0.0, (double)m));
                this.onTreadmillEntity = null;
            }
        }
    }

    public float getGeneratedSpeed() {
        int speedUp;
        int n = speedUp = this.speedUpTimer > 0 ? 2 : 1;
        if (this.isRunning) {
            switch ((Direction)this.getBlockState().getValue(TreadmillBlock.HORIZONTAL_FACING)) {
                case EAST: 
                case NORTH: {
                    return this.getSettingSpeed() * (float)speedUp;
                }
                case WEST: 
                case SOUTH: {
                    return -this.getSettingSpeed() * (float)speedUp;
                }
            }
        }
        return 0.0f;
    }

    public float getSettingSpeed() {
        return ((Integer)CreateTreadmillMod.CONFIG.TREADMILL_BASE_SPEED.get()).intValue();
    }

    public boolean isMoving() {
        float min = 0.1f;
        if (this.onTreadmillEntity == null) {
            return false;
        }
        switch ((Direction)this.getBlockState().getValue(TreadmillBlock.HORIZONTAL_FACING)) {
            case EAST: {
                return this.onTreadmillEntity.getKnownMovement().x > (double)min;
            }
            case WEST: {
                return this.onTreadmillEntity.getKnownMovement().x < (double)(-min);
            }
            case SOUTH: {
                return this.onTreadmillEntity.getKnownMovement().z > (double)min;
            }
            case NORTH: {
                return this.onTreadmillEntity.getKnownMovement().z < (double)(-min);
            }
        }
        return false;
    }

    protected Block getStressConfigKey() {
        return super.getStressConfigKey();
    }

    public void destroy() {
        super.destroy();
    }
}

