/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.CreateTreadmill.maid.treadmill;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.gly091020.CreateTreadmill.CreateTreadmillMod;
import com.gly091020.CreateTreadmill.Part;
import com.gly091020.CreateTreadmill.block.TreadmillBlock;
import com.gly091020.CreateTreadmill.block.TreadmillBlockEntity;
import com.gly091020.CreateTreadmill.maid.MaidPlugin;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class TreadmillSensor
extends Sensor<EntityMaid> {
    public TreadmillSensor() {
        super(20);
    }

    protected void doTick(@NotNull ServerLevel serverLevel, @NotNull EntityMaid entityMaid) {
        BlockPos b = TreadmillSensor.findTreadmill(serverLevel, entityMaid.getOnPos());
        if (b != null) {
            entityMaid.getBrain().setMemory((MemoryModuleType)MaidPlugin.TREADMILL_MEMORY.get(), (Object)b);
        }
    }

    @NotNull
    public Set<MemoryModuleType<?>> requires() {
        return Set.of((MemoryModuleType)MaidPlugin.TREADMILL_MEMORY.get());
    }

    public static boolean isEmpty(ServerLevel level, BlockPos pos) {
        TreadmillBlockEntity entity;
        BlockEntity blockEntity = level.getBlockEntity(TreadmillBlock.findPart((Level)level, level.getBlockState(pos), pos, Part.BOTTOM_FRONT));
        return blockEntity instanceof TreadmillBlockEntity && (entity = (TreadmillBlockEntity)blockEntity).getOnTreadmillEntity() == null;
    }

    public static BlockPos findTreadmill(ServerLevel level, BlockPos centerPos) {
        int radius = 10;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int distance = 0; distance <= 10; ++distance) {
            for (int dx = -distance; dx <= distance; ++dx) {
                for (int dy = -distance; dy <= distance; ++dy) {
                    for (int dz = -distance; dz <= distance; ++dz) {
                        if (Math.abs(dx) != distance && Math.abs(dy) != distance && Math.abs(dz) != distance) continue;
                        mutablePos.set(centerPos.getX() + dx, centerPos.getY() + dy, centerPos.getZ() + dz);
                        if (!level.getBlockState((BlockPos)mutablePos).is(CreateTreadmillMod.TREADMILL_BLOCK) || !TreadmillSensor.isEmpty(level, (BlockPos)mutablePos)) continue;
                        return mutablePos.immutable();
                    }
                }
            }
        }
        return null;
    }
}

