/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.CreateTreadmill.maid.treadmill;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.gly091020.CreateTreadmill.CreateTreadmillMod;
import com.gly091020.CreateTreadmill.Part;
import com.gly091020.CreateTreadmill.block.TreadmillBlock;
import com.gly091020.CreateTreadmill.block.TreadmillBlockEntity;
import com.gly091020.CreateTreadmill.maid.MaidPlugin;
import com.gly091020.CreateTreadmill.maid.treadmill.UseTreadmillTask;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class UseTreadmillBehavior
extends Behavior<EntityMaid> {
    private boolean homeMode = false;

    public UseTreadmillBehavior() {
        super(Map.of());
    }

    private boolean isRunning(ServerLevel level, EntityMaid maid) {
        BlockState state = level.getBlockState(maid.blockPosition().below());
        if (!state.is(CreateTreadmillMod.TREADMILL_BLOCK)) {
            return false;
        }
        BlockPos part = TreadmillBlock.findPart((Level)level, state, maid.blockPosition().below(), Part.BOTTOM_FRONT);
        BlockEntity blockEntity = level.getBlockEntity(part);
        if (blockEntity instanceof TreadmillBlockEntity) {
            TreadmillBlockEntity entity = (TreadmillBlockEntity)blockEntity;
            return entity.getOnTreadmillEntity() == maid;
        }
        return false;
    }

    private TreadmillBlockEntity getBlockEntity(ServerLevel level, EntityMaid maid) {
        Optional p = maid.getBrain().getMemory((MemoryModuleType)MaidPlugin.TREADMILL_MEMORY.get());
        if (p.isEmpty()) {
            return null;
        }
        BlockState state = level.getBlockState((BlockPos)p.get());
        if (!state.is(CreateTreadmillMod.TREADMILL_BLOCK)) {
            return null;
        }
        BlockPos part = TreadmillBlock.findPart((Level)level, state, (BlockPos)p.get(), Part.BOTTOM_FRONT);
        BlockEntity blockEntity = level.getBlockEntity(part);
        if (blockEntity instanceof TreadmillBlockEntity) {
            TreadmillBlockEntity entity = (TreadmillBlockEntity)blockEntity;
            return entity;
        }
        return null;
    }

    protected boolean canStillUse(@NotNull ServerLevel level, EntityMaid entity, long gameTime) {
        return entity.getTask() instanceof UseTreadmillTask;
    }

    protected void start(@NotNull ServerLevel level, @NotNull EntityMaid entity, long gameTime) {
        super.start(level, (LivingEntity)entity, gameTime);
        entity.getSchedulePos().setIdlePos(entity.getOnPos());
        this.homeMode = entity.isHomeModeEnable();
    }

    protected void tick(@NotNull ServerLevel level, @NotNull EntityMaid maid, long gameTime) {
        super.tick(level, (LivingEntity)maid, gameTime);
        if (!(maid.getTask() instanceof UseTreadmillTask)) {
            this.stop(level, maid, gameTime);
            return;
        }
        if (this.isRunning(level, maid)) {
            return;
        }
        Optional p = maid.getBrain().getMemory((MemoryModuleType)MaidPlugin.TREADMILL_MEMORY.get());
        if (p.isPresent()) {
            TreadmillBlockEntity blockEntity;
            BlockPos pos = (BlockPos)p.get();
            if (!pos.closerThan((Vec3i)maid.blockPosition(), 30.0)) {
                return;
            }
            maid.restrictTo(maid.getOnPos(), 50);
            maid.getSchedulePos().setWorkPos(maid.getOnPos());
            maid.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(pos, 0.5f, 1));
            if (pos.closerThan((Vec3i)maid.blockPosition(), 2.0) && (blockEntity = this.getBlockEntity(level, maid)) != null) {
                blockEntity.setOnTreadmillEntity((LivingEntity)maid);
                blockEntity.setEntityTimer(Integer.MAX_VALUE);
                maid.setHomeModeEnable(true);
            }
        }
    }

    protected boolean timedOut(long gameTime) {
        return false;
    }

    protected void stop(@NotNull ServerLevel level, EntityMaid maid, long gameTime) {
        TreadmillBlockEntity blockEntity;
        Optional p;
        BlockEntity blockEntity2;
        BlockPos p1;
        if (level.getBlockState(maid.getOnPos()).is(CreateTreadmillMod.TREADMILL_BLOCK) && (p1 = TreadmillBlock.findPart((Level)level, level.getBlockState(maid.getOnPos()), maid.getOnPos(), Part.BOTTOM_FRONT)) != null && (blockEntity2 = level.getBlockEntity(p1)) instanceof TreadmillBlockEntity) {
            TreadmillBlockEntity entity = (TreadmillBlockEntity)blockEntity2;
            entity.setOnTreadmillEntity(null);
        }
        if ((p = maid.getBrain().getMemory((MemoryModuleType)MaidPlugin.TREADMILL_MEMORY.get())).isPresent() && ((BlockPos)p.get()).closerThan((Vec3i)maid.blockPosition(), 2.0) && (blockEntity = this.getBlockEntity(level, maid)) != null) {
            blockEntity.setOnTreadmillEntity(null);
        }
        maid.getBrain().eraseMemory((MemoryModuleType)MaidPlugin.TREADMILL_MEMORY.get());
        maid.setHomeModeEnable(this.homeMode);
    }
}

