/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.CreateTreadmill.renderer;

import com.gly091020.CreateTreadmill.CreateTreadmillMod;
import com.gly091020.CreateTreadmill.Part;
import com.gly091020.CreateTreadmill.block.TreadmillBlock;
import com.gly091020.CreateTreadmill.block.TreadmillBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.SuperByteBufferCache;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class TreadmillRenderer
extends KineticBlockEntityRenderer<TreadmillBlockEntity> {
    public TreadmillRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected SuperByteBuffer getRotatedModel(TreadmillBlockEntity be, BlockState state) {
        return CachedBuffers.block((SuperByteBufferCache.Compartment)KineticBlockEntityRenderer.KINETIC_BLOCK, (BlockState)KineticBlockEntityRenderer.shaft((Direction.Axis)KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)be)));
    }

    public boolean shouldRender(@NotNull TreadmillBlockEntity blockEntity, @NotNull Vec3 cameraPos) {
        return super.shouldRender((BlockEntity)blockEntity, cameraPos) && blockEntity.getBlockState().getValue(TreadmillBlock.PART) == Part.BOTTOM_FRONT;
    }

    protected void renderSafe(TreadmillBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (be.getBlockState().getValue(TreadmillBlock.PART) != Part.BOTTOM_FRONT) {
            return;
        }
        if (be.getLevel() != null) {
            light = LevelRenderer.getLightColor((BlockAndTintGetter)be.getLevel(), (BlockPos)be.getBlockPos().above());
        }
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        if (!VisualizationManager.supportsVisualization((LevelAccessor)be.getLevel())) {
            Direction facing = (Direction)be.getBlockState().getValue(TreadmillBlock.HORIZONTAL_FACING);
            SpriteShiftEntry spriteShift = CreateTreadmillMod.BELT_SHIFT;
            SuperByteBuffer beltBuffer = CachedBuffers.partial((PartialModel)CreateTreadmillMod.BELT_MODEL, (BlockState)be.getBlockState()).light(light);
            PoseStack localTransforms = new PoseStack();
            PoseTransformStack msr = TransformStack.of((PoseStack)localTransforms);
            int d = 0;
            float xp = 0.0f;
            float zp = 0.0f;
            switch (facing) {
                case WEST: {
                    d = 0;
                    xp = 0.0625f;
                    break;
                }
                case EAST: {
                    d = 180;
                    xp = 0.0625f;
                    break;
                }
                case SOUTH: {
                    d = 90;
                    xp = 0.0625f;
                    break;
                }
                case NORTH: {
                    d = 270;
                    xp = 0.0625f;
                }
            }
            ((PoseTransformStack)((PoseTransformStack)msr.center()).rotate((Quaternionfc)new Quaternionf().rotationXYZ(0.0f, (float)d * ((float)Math.PI / 180), 0.0f)).uncenter()).translate(xp, 1.0f, zp);
            VertexConsumer vb = buffer.getBuffer(RenderType.solid());
            float renderTick = AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel());
            Direction.AxisDirection axisDirection = facing.getAxisDirection();
            float speed = be.getSpeed();
            if (facing == Direction.SOUTH || facing == Direction.NORTH) {
                speed = -speed;
            }
            double scroll = (double)(speed * renderTick * (float)axisDirection.getStep()) / 504.0;
            scroll -= Math.floor(scroll);
            beltBuffer.shiftUVScrolling(spriteShift, (float)(scroll *= 0.062));
            ((SuperByteBuffer)beltBuffer.transform(localTransforms)).renderInto(ms, vb);
        }
    }
}

