/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.CreateTreadmill.renderer;

import com.gly091020.CreateTreadmill.CreateTreadmillMod;
import com.gly091020.CreateTreadmill.Part;
import com.gly091020.CreateTreadmill.block.TreadmillBlock;
import com.gly091020.CreateTreadmill.block.TreadmillBlockEntity;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.content.processing.burner.ScrollInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class TreadmillVisual
extends KineticBlockEntityVisual<TreadmillBlockEntity> {
    private final RotatingInstance shaft;
    private final ScrollInstance belt;
    private final Direction opposite;

    public TreadmillVisual(VisualizationContext context, TreadmillBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick);
        this.opposite = (Direction)this.blockState.getValue(TreadmillBlock.HORIZONTAL_FACING);
        if (this.blockState.getValue(TreadmillBlock.PART) != Part.BOTTOM_FRONT) {
            this.shaft = null;
            this.belt = null;
            return;
        }
        this.shaft = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.SHAFT, (Direction)this.opposite)).createInstance();
        Direction.Axis r = this.rotationAxis();
        this.shaft.setup((KineticBlockEntity)blockEntity, r).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(r).setChanged();
        int d = 0;
        float xp = 0.0f;
        float zp = 0.0f;
        switch ((Direction)blockEntity.getBlockState().getValue(TreadmillBlock.HORIZONTAL_FACING)) {
            case WEST: {
                d = 0;
                xp = 0.0625f;
                break;
            }
            case EAST: {
                d = 180;
                xp = -0.0625f;
                break;
            }
            case SOUTH: {
                d = 90;
                zp = -0.0625f;
                break;
            }
            case NORTH: {
                d = 270;
                zp = 0.0625f;
            }
        }
        BlockPos p = this.getVisualPosition().above(1);
        this.belt = (ScrollInstance)this.instancerProvider().instancer(AllInstanceTypes.SCROLLING, Models.partial((PartialModel)CreateTreadmillMod.BELT_MODEL)).createInstance();
        this.belt.setSpriteShift(CreateTreadmillMod.BELT_SHIFT, 1.0f, 4.0f).position((float)p.getX() + xp, (float)p.getY(), (float)p.getZ() + zp).rotation((Quaternionfc)new Quaternionf().rotationXYZ(0.0f, (float)d * ((float)Math.PI / 180), 0.0f)).speed(0.0f, 0.0f).offset(0.0f, 0.0f).setChanged();
        this.update(0.0f);
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        if (this.blockState.getValue(TreadmillBlock.PART) != Part.BOTTOM_FRONT) {
            return;
        }
        consumer.accept((Instance)this.shaft);
        consumer.accept((Instance)this.belt);
    }

    public void updateLight(float partialTick) {
        if (this.blockState.getValue(TreadmillBlock.PART) != Part.BOTTOM_FRONT) {
            return;
        }
        BlockPos top = this.pos.above();
        this.relight(top, new FlatLit[]{this.shaft});
        this.relight(top, new FlatLit[]{this.belt});
    }

    public void update(float partialTick) {
        if (this.blockState.getValue(TreadmillBlock.PART) != Part.BOTTOM_FRONT) {
            return;
        }
        this.shaft.setup((KineticBlockEntity)this.blockEntity).setChanged();
        float speed = 0.0f;
        switch ((Direction)this.blockState.getValue(TreadmillBlock.HORIZONTAL_FACING)) {
            case EAST: 
            case NORTH: {
                speed = ((TreadmillBlockEntity)this.blockEntity).getSpeed();
                break;
            }
            case WEST: 
            case SOUTH: {
                speed = -((TreadmillBlockEntity)this.blockEntity).getSpeed();
            }
        }
        this.belt.speed(0.0f, speed * 0.001984127f).setChanged();
    }

    protected void _delete() {
        if (this.blockState.getValue(TreadmillBlock.PART) != Part.BOTTOM_FRONT) {
            return;
        }
        this.shaft.delete();
        this.belt.delete();
    }
}

