/*
 * Decompiled with CFR 0.152.
 */
package euphy.upo.createnetherindustry.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import euphy.upo.createnetherindustry.client.model.LavaSeaSpeedboatModel;
import euphy.upo.createnetherindustry.entity.LavaSpeedboatEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class LavaSpeedboatRenderer
extends EntityRenderer<LavaSpeedboatEntity> {
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"createnetherindustry", (String)"textures/entity/lava_speedboat.png");
    private final LavaSeaSpeedboatModel<LavaSpeedboatEntity> model;

    public LavaSpeedboatRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.8f;
        this.model = new LavaSeaSpeedboatModel(context.bakeLayer(LavaSeaSpeedboatModel.LAYER_LOCATION));
    }

    public void render(LavaSpeedboatEntity entity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        float bubbleTime;
        poseStack.pushPose();
        poseStack.translate(0.0, 1.5, 0.0);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(entityYaw));
        float hurtTime = (float)entity.getHurtTime() - partialTicks;
        float damage = entity.getDamage() - partialTicks;
        if (damage < 0.0f) {
            damage = 0.0f;
        }
        if (hurtTime > 0.0f) {
            poseStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)hurtTime) * hurtTime * damage / 10.0f * (float)entity.getHurtDir()));
        }
        if (!Mth.equal((float)(bubbleTime = entity.getBubbleAngle(partialTicks)), (float)0.0f)) {
            poseStack.mulPose(Axis.XP.rotationDegrees(entity.getBubbleAngle(partialTicks)));
        }
        VertexConsumer vertexconsumer = buffer.getBuffer(this.model.renderType(this.getTextureLocation(entity)));
        this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY, -1);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull LavaSpeedboatEntity entity) {
        return TEXTURE_LOCATION;
    }
}

