/*
 * Decompiled with CFR 0.152.
 */
package euphy.upo.createnetherindustry.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import euphy.upo.createnetherindustry.content.blockentities.LavaStrokeEngineBlockEntity;
import euphy.upo.createnetherindustry.content.blocks.LavaStrokeEngineBlock;
import euphy.upo.createnetherindustry.registry.CNIPartials;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.SuperByteBufferCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;

public class LavaStrokeEngineRenderer
extends KineticBlockEntityRenderer<LavaStrokeEngineBlockEntity> {
    public LavaStrokeEngineRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(LavaStrokeEngineBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState state = be.getBlockState();
        Direction facing = (Direction)state.getValue(LavaStrokeEngineBlock.HORIZONTAL_FACING);
        Direction.Axis axis = LavaStrokeEngineRenderer.getRotationAxisOf((KineticBlockEntity)be);
        float angleRadians = LavaStrokeEngineRenderer.getAngleForBe((KineticBlockEntity)be, (BlockPos)be.getBlockPos(), (Direction.Axis)axis);
        float seriesPhaseOffset = 0.0f;
        BlockPos pos = be.getBlockPos();
        if (axis == Direction.Axis.X) {
            if (pos.getX() % 2 != 0) {
                seriesPhaseOffset = (float)Math.PI;
            }
        } else if (axis == Direction.Axis.Z && pos.getZ() % 2 != 0) {
            seriesPhaseOffset = (float)Math.PI;
        }
        BlockState shaftState = LavaStrokeEngineRenderer.shaft((Direction.Axis)axis);
        SuperByteBuffer shaft = CachedBuffers.block((SuperByteBufferCache.Compartment)KINETIC_BLOCK, (BlockState)shaftState);
        LavaStrokeEngineRenderer.kineticRotationTransform((SuperByteBuffer)shaft, (KineticBlockEntity)be, (Direction.Axis)axis, (float)angleRadians, (int)light);
        shaft.renderInto(ms, buffer.getBuffer(RenderType.solid()));
        float slantAngleDegrees = 45.0f;
        this.renderVectorMotionRod(be, state, CNIPartials.LAVA_STROKE_ENGINE_ROD, ms, buffer, light, angleRadians, facing, axis, 0.0f + seriesPhaseOffset, slantAngleDegrees, -1.0f);
        this.renderVectorMotionRod(be, state, CNIPartials.LAVA_STROKE_ENGINE_FLYWHEEL, ms, buffer, light, angleRadians, facing, axis, (float)Math.PI + seriesPhaseOffset, -slantAngleDegrees, 1.0f);
        this.renderHorizontalClippedFluid(be, ms, buffer, light);
    }

    protected void renderHorizontalClippedFluid(LavaStrokeEngineBlockEntity be, PoseStack ms, MultiBufferSource buffer, int light) {
        SmartFluidTankBehaviour tank = be.tank;
        if (tank == null) {
            return;
        }
        FluidStack fluidStack = tank.getPrimaryTank().getRenderedFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        float capacity = 3000.0f;
        float amount = fluidStack.getAmount();
        float ratio = Mth.clamp((float)(amount / capacity), (float)0.0f, (float)1.0f);
        if (ratio <= 0.001f) {
            return;
        }
        BlockState state = be.getBlockState();
        Direction facing = (Direction)state.getValue(LavaStrokeEngineBlock.HORIZONTAL_FACING);
        IClientFluidTypeExtensions fluidType = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(fluidType.getStillTexture());
        int color = fluidType.getTintColor(fluidStack);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int a = color >> 24 & 0xFF;
        if (a == 0) {
            a = 255;
        }
        ms.pushPose();
        ms.translate(0.5, 0.5, 0.5);
        ms.mulPose(Axis.YP.rotationDegrees(AngleHelper.horizontalAngle((Direction)facing)));
        ms.translate(-0.5, -0.5, -0.5);
        ms.translate(0.0, -1.0, 0.0);
        float py = 0.90468127f;
        float pz = 0.5f;
        this.renderTankInstance(ms, buffer, sprite, r, g, b, a, light, ratio, 0.9337062f, py, pz, -45.0f);
        this.renderTankInstance(ms, buffer, sprite, r, g, b, a, light, ratio, 0.06629375f, py, pz, 45.0f);
        ms.popPose();
    }

    private void renderTankInstance(PoseStack ms, MultiBufferSource buffer, TextureAtlasSprite sprite, int r, int g, int b, int a, int light, float ratio, float px, float py, float pz, float rotDegrees) {
        ms.pushPose();
        ms.translate(px, py, pz);
        ms.mulPose(Axis.ZP.rotationDegrees(rotDegrees));
        float w = 0.1875f;
        float h = 0.5f;
        float d = 0.375f;
        float halfW = w / 2.0f;
        float halfH = h / 2.0f;
        float halfD = d / 2.0f;
        Vector2f[] rect = new Vector2f[]{new Vector2f(-halfW, -halfH), new Vector2f(halfW, -halfH), new Vector2f(halfW, halfH), new Vector2f(-halfW, halfH)};
        float rotRad = (float)Math.toRadians(rotDegrees);
        float cos = Mth.cos((float)rotRad);
        float sin = Mth.sin((float)rotRad);
        ArrayList<Vector2f> rotatedPoly = new ArrayList<Vector2f>();
        ArrayList<Float> yValues = new ArrayList<Float>();
        for (Vector2f v : rect) {
            float rx = v.x * cos - v.y * sin;
            float ry = v.x * sin + v.y * cos;
            rotatedPoly.add(new Vector2f(rx, ry));
            yValues.add(Float.valueOf(ry));
        }
        ms.popPose();
        ms.pushPose();
        ms.translate(px, py, pz);
        yValues.sort(Float::compareTo);
        float minY = ((Float)yValues.get(0)).floatValue();
        float safeMaxY = ((Float)yValues.get(2)).floatValue();
        float cutY = minY + (safeMaxY - minY) * ratio;
        List<Vector2f> clippedPoly = this.clipPolygonBelowY(rotatedPoly, cutY -= 1.0E-5f);
        List<Vector2f> cleanPoly = this.removeDuplicates(clippedPoly);
        if (cleanPoly.size() >= 3) {
            VertexConsumer builder = buffer.getBuffer(RenderType.translucent());
            PoseStack.Pose pose = ms.last();
            this.drawPolySpatial(builder, pose, cleanPoly, -halfD, sprite, r, g, b, a, light, true, halfW, halfH);
            this.drawPolySpatial(builder, pose, cleanPoly, halfD, sprite, r, g, b, a, light, false, halfW, halfH);
            for (int i = 0; i < cleanPoly.size(); ++i) {
                Vector2f p1 = cleanPoly.get(i);
                Vector2f p2 = cleanPoly.get((i + 1) % cleanPoly.size());
                boolean isTopSurface = (double)Math.abs(p1.y - cutY) < 1.0E-4 && (double)Math.abs(p2.y - cutY) < 1.0E-4;
                this.drawSideQuad(builder, pose, p1, p2, -halfD, halfD, sprite, r, g, b, a, light, isTopSurface);
            }
        }
        ms.popPose();
    }

    private List<Vector2f> clipPolygonBelowY(List<Vector2f> poly, float cutY) {
        ArrayList<Vector2f> output = new ArrayList<Vector2f>();
        for (int i = 0; i < poly.size(); ++i) {
            boolean prevInside;
            Vector2f curr = poly.get(i);
            Vector2f prev = poly.get((i + poly.size() - 1) % poly.size());
            boolean currInside = curr.y <= cutY;
            boolean bl = prevInside = prev.y <= cutY;
            if (currInside) {
                if (!prevInside) {
                    output.add(this.getIntersection(prev, curr, cutY));
                }
                output.add(curr);
                continue;
            }
            if (!prevInside) continue;
            output.add(this.getIntersection(prev, curr, cutY));
        }
        return output;
    }

    private List<Vector2f> removeDuplicates(List<Vector2f> input) {
        if (input.size() < 3) {
            return input;
        }
        ArrayList<Vector2f> result = new ArrayList<Vector2f>();
        for (Vector2f p : input) {
            if (result.isEmpty()) {
                result.add(p);
                continue;
            }
            if (!((double)((Vector2f)result.get(result.size() - 1)).distanceSquared((Vector2fc)p) > 1.0E-8)) continue;
            result.add(p);
        }
        if (result.size() > 1 && (double)((Vector2f)result.get(0)).distanceSquared((Vector2fc)result.get(result.size() - 1)) < 1.0E-8) {
            result.remove(result.size() - 1);
        }
        return result;
    }

    private Vector2f getIntersection(Vector2f p1, Vector2f p2, float y) {
        float dy = p2.y - p1.y;
        if ((double)Math.abs(dy) < 1.0E-6) {
            return p1;
        }
        float t = (y - p1.y) / dy;
        t = Mth.clamp((float)t, (float)0.0f, (float)1.0f);
        return new Vector2f(p1.x + (p2.x - p1.x) * t, y);
    }

    private void drawPolySpatial(VertexConsumer builder, PoseStack.Pose pose, List<Vector2f> poly, float z, TextureAtlasSprite sprite, int r, int g, int b, int a, int light, boolean reverse, float halfW, float halfH) {
        float cx = 0.0f;
        float cy = 0.0f;
        for (Vector2f p : poly) {
            cx += p.x;
            cy += p.y;
        }
        cx /= (float)poly.size();
        cy /= (float)poly.size();
        float minU = sprite.getU0();
        float uRange = sprite.getU1() - minU;
        float minV = sprite.getV0();
        float vRange = sprite.getV1() - minV;
        float nz = reverse ? -1.0f : 1.0f;
        for (int i = 0; i < poly.size(); ++i) {
            Vector2f p1 = poly.get(i);
            Vector2f p2 = poly.get((i + 1) % poly.size());
            float cu = minU + this.getSpatialU(cx, halfW) * uRange;
            float cv = minV + this.getSpatialV(cy, halfH) * vRange;
            float u1 = minU + this.getSpatialU(p1.x, halfW) * uRange;
            float v1 = minV + this.getSpatialV(p1.y, halfH) * vRange;
            float u2 = minU + this.getSpatialU(p2.x, halfW) * uRange;
            float v2 = minV + this.getSpatialV(p2.y, halfH) * vRange;
            if (reverse) {
                this.putVertex(builder, pose, cx, cy, z, cu, cv, r, g, b, a, light, 0.0f, 0.0f, nz);
                this.putVertex(builder, pose, p2.x, p2.y, z, u2, v2, r, g, b, a, light, 0.0f, 0.0f, nz);
                this.putVertex(builder, pose, p1.x, p1.y, z, u1, v1, r, g, b, a, light, 0.0f, 0.0f, nz);
                continue;
            }
            this.putVertex(builder, pose, cx, cy, z, cu, cv, r, g, b, a, light, 0.0f, 0.0f, nz);
            this.putVertex(builder, pose, p1.x, p1.y, z, u1, v1, r, g, b, a, light, 0.0f, 0.0f, nz);
            this.putVertex(builder, pose, p2.x, p2.y, z, u2, v2, r, g, b, a, light, 0.0f, 0.0f, nz);
        }
    }

    private float getSpatialU(float x, float halfSize) {
        return Mth.clamp((float)((x + halfSize) / (halfSize * 2.0f)), (float)0.0f, (float)1.0f);
    }

    private float getSpatialV(float y, float halfSize) {
        return Mth.clamp((float)((y + halfSize) / (halfSize * 2.0f)), (float)0.0f, (float)1.0f);
    }

    private void drawSideQuad(VertexConsumer builder, PoseStack.Pose pose, Vector2f p1, Vector2f p2, float z1, float z2, TextureAtlasSprite sprite, int r, int g, int b, int a, int light, boolean isTop) {
        float dx = p2.x - p1.x;
        float dy = p2.y - p1.y;
        float lenSq = dx * dx + dy * dy;
        if ((double)lenSq < 1.0E-6) {
            return;
        }
        float u0 = sprite.getU0();
        float u1 = sprite.getU1();
        float v0 = sprite.getV0();
        float v1 = sprite.getV1();
        float nx = 0.0f;
        float ny = 0.0f;
        float nz = 0.0f;
        if (isTop) {
            ny = 1.0f;
        } else {
            nx = dy;
            ny = -dx;
            float len = Mth.sqrt((float)lenSq);
            nx /= len;
            ny /= len;
        }
        this.putVertex(builder, pose, p1.x, p1.y, z1, u0, v0, r, g, b, a, light, nx, ny, nz);
        this.putVertex(builder, pose, p2.x, p2.y, z1, u1, v0, r, g, b, a, light, nx, ny, nz);
        this.putVertex(builder, pose, p2.x, p2.y, z2, u1, v1, r, g, b, a, light, nx, ny, nz);
        this.putVertex(builder, pose, p1.x, p1.y, z2, u0, v1, r, g, b, a, light, nx, ny, nz);
    }

    private void putVertex(VertexConsumer builder, PoseStack.Pose pose, float x, float y, float z, float u, float v, int r, int g, int b, int a, int light, float nx, float ny, float nz) {
        builder.addVertex(pose.pose(), x, y, z).setColor(r, g, b, a).setUv(u, v).setLight(light).setNormal(pose, nx, ny, nz).setOverlay(0);
    }

    private void renderVectorMotionRod(LavaStrokeEngineBlockEntity be, BlockState state, PartialModel model, PoseStack ms, MultiBufferSource buffer, int light, float angleRadians, Direction facing, Direction.Axis axis, float phaseOffset, float slantAngleDegrees, float directionMultiplier) {
        SuperByteBuffer part = CachedBuffers.partial((PartialModel)model, (BlockState)state);
        ((SuperByteBuffer)((SuperByteBuffer)part.center()).rotateYDegrees(AngleHelper.horizontalAngle((Direction)facing))).uncenter();
        part.translate(0.0, -1.0, 0.0);
        Vector3f motionAxis = new Vector3f(0.0f, 1.0f, 0.0f);
        float radians = (slantAngleDegrees - 90.0f) * ((float)Math.PI / 180);
        motionAxis.rotate((Quaternionfc)new Quaternionf(new AxisAngle4f(radians, 0.0f, 0.0f, 1.0f)));
        float scalarOffset = 0.0f;
        if (Math.abs(be.getSpeed()) > 0.0f) {
            float currentPhase = angleRadians * 5.0f + phaseOffset;
            float rawOffset = (Mth.sin((float)(currentPhase - 1.5707964f)) + 1.0f) * 0.125f;
            scalarOffset = rawOffset * directionMultiplier;
        }
        part.translate(motionAxis.x * scalarOffset, motionAxis.y * scalarOffset, motionAxis.z * scalarOffset);
        part.light(light).renderInto(ms, buffer.getBuffer(RenderType.solid()));
    }
}

