/*
 * Decompiled with CFR 0.152.
 */
package euphy.upo.createnetherindustry.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import euphy.upo.createnetherindustry.content.blockentities.SoulCondenserBlockEntity;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.platform.NeoForgeCatnipServices;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;

public class SoulCondenserRenderer
extends KineticBlockEntityRenderer<SoulCondenserBlockEntity> {
    public SoulCondenserRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(SoulCondenserBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        this.renderRotatingCogBER(be, partialTicks, ms, buffer, light, overlay);
        this.renderInputFluid(be, partialTicks, ms, buffer, light, overlay);
    }

    protected void renderRotatingCogBER(SoulCondenserBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockState = be.getBlockState();
        SuperByteBuffer cogWheelSbb = CachedBuffers.partial((PartialModel)AllPartialModels.SHAFTLESS_COGWHEEL, (BlockState)blockState);
        Direction.Axis axis = Direction.Axis.Y;
        float angleRadians = KineticBlockEntityRenderer.getAngleForBe((KineticBlockEntity)be, (BlockPos)be.getBlockPos(), (Direction.Axis)axis);
        KineticBlockEntityRenderer.kineticRotationTransform((SuperByteBuffer)cogWheelSbb, (KineticBlockEntity)be, (Direction.Axis)axis, (float)angleRadians, (int)light);
        ms.pushPose();
        ms.translate(0.0f, 0.0f, 0.0f);
        cogWheelSbb.overlay(overlay).renderInto(ms, buffer.getBuffer(RenderType.cutoutMipped()));
        ms.popPose();
    }

    protected void renderInputFluid(SoulCondenserBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        SmartFluidTankBehaviour inputTankBev = be.getInputTankBehaviour();
        if (inputTankBev == null) {
            return;
        }
        SmartFluidTankBehaviour.TankSegment tankSegment = inputTankBev.getPrimaryTank();
        FluidStack fluidStack = tankSegment.getRenderedFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        LerpedFloat fluidLerpedLevel = tankSegment.getFluidLevel();
        if (fluidLerpedLevel == null) {
            return;
        }
        float fluidLevelRatio = fluidLerpedLevel.getValue(partialTicks);
        if (fluidLevelRatio < 1.0E-5f) {
            return;
        }
        float xMin_coord = 0.0625f;
        float xMax_coord = 0.875f;
        float zMin_coord = 0.0625f;
        float zMax_coord = 0.875f;
        float renderAreaMinY_coord = 0.625f;
        float renderAreaMaxY_coord = 0.875f;
        float renderAreaHeight_coord = 0.25f;
        float displayFluidHeight = Mth.clamp((float)(fluidLevelRatio * 0.25f), (float)0.0f, (float)0.25f);
        if (fluidStack.getAmount() > 0 && displayFluidHeight < 0.03125f) {
            displayFluidHeight = 0.03125f;
        }
        if (displayFluidHeight <= 1.0E-5f) {
            return;
        }
        float actualYMin = 0.625f;
        float actualYMax = 0.625f + displayFluidHeight;
        ms.pushPose();
        NeoForgeCatnipServices.FLUID_RENDERER.renderFluidBox((Object)fluidStack, 0.0625f, actualYMin, 0.0625f, 0.875f, actualYMax, 0.875f, buffer, ms, light, true, true);
        ms.popPose();
    }
}

