/*
 * Decompiled with CFR 0.152.
 */
package euphy.upo.createnetherindustry.compat.jei;

import com.google.common.base.Preconditions;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import euphy.upo.createnetherindustry.CreateNetherIndustry;
import euphy.upo.createnetherindustry.compat.jei.JEIInfo;
import euphy.upo.createnetherindustry.compat.jei.SoulCondensingCategory;
import euphy.upo.createnetherindustry.compat.jei.SoulStrippingCategory;
import euphy.upo.createnetherindustry.registry.CNIBlocks;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;

@JeiPlugin
public class CNIJEIPlugin
implements IModPlugin {
    public static final ResourceLocation ID = CreateNetherIndustry.asResource("jei_plugin");
    private final List<IRecipeCategory<?>> categories = new ArrayList();

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        ArrayList<Object> localCategories = new ArrayList<Object>();
        localCategories.add((Object)SoulStrippingCategory.create(guiHelper));
        localCategories.add((Object)SoulCondensingCategory.create(guiHelper));
        registration.addRecipeCategories(localCategories.toArray(new IRecipeCategory[0]));
        this.categories.clear();
        this.categories.addAll(localCategories);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        for (IRecipeCategory<?> category : this.categories) {
            if (!(category instanceof CreateRecipeCategory)) continue;
            ((CreateRecipeCategory)category).registerRecipes(registration);
        }
        JEIInfo.registerInfoPages(registration);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(AllBlocks.ENCASED_FAN.asStack(), new RecipeType[]{SoulStrippingCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)CNIBlocks.SOUL_STRIPPING_MEDIUM.get()), new RecipeType[]{SoulStrippingCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)CNIBlocks.SOUL_CONDENSER.get()), new RecipeType[]{SoulCondensingCategory.TYPE});
    }

    public static Level getLevel() {
        if (FMLLoader.getDist() != Dist.CLIENT) {
            throw new IllegalStateException("Retreiving client level is only supported for client");
        }
        Minecraft minecraft = Minecraft.getInstance();
        Preconditions.checkNotNull((Object)minecraft, (Object)"Minecraft instance was null");
        ClientLevel level = minecraft.level;
        Preconditions.checkNotNull((Object)level, (Object)"Client level was null");
        return level;
    }

    public static RecipeManager getRecipeManager() {
        if (FMLLoader.getDist() != Dist.CLIENT) {
            throw new IllegalStateException("Retreiving recipe manager from client level is only supported for client");
        }
        Minecraft minecraft = Minecraft.getInstance();
        Preconditions.checkNotNull((Object)minecraft, (Object)"Minecraft instance was null");
        ClientLevel level = minecraft.level;
        Preconditions.checkNotNull((Object)level, (Object)"Client level was null");
        return level.getRecipeManager();
    }
}

