/*
 * Decompiled with CFR 0.152.
 */
package euphy.upo.createnetherindustry.content.blockentities;

import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import euphy.upo.createnetherindustry.content.blocks.LavaStrokeEngineBlock;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class LavaStrokeEngineBlockEntity
extends GeneratingKineticBlockEntity {
    public static final int BURN_TIME_CYCLE = 80;
    public static final int FUEL_CONSUMPTION = 100;
    public static final int TANK_CAPACITY = 3000;
    public static final int TRANSFER_RATE = 3000;
    public SmartFluidTankBehaviour tank;
    public int burnTime = 0;

    public LavaStrokeEngineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.tank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 1, 3000, true).allowInsertion().allowExtraction().whenFluidUpdates(() -> {
            this.setChanged();
            this.sendData();
        });
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    public IFluidHandler getFluidHandler() {
        if (this.tank == null) {
            return null;
        }
        return this.tank.getPrimaryHandler();
    }

    public void tick() {
        boolean isRunning;
        FluidStack fluidInTank;
        boolean wasRunning;
        super.tick();
        if (this.level.isClientSide) {
            if (this.burnTime > 0) {
                this.spawnParticles();
            }
            return;
        }
        boolean needsUpdate = false;
        boolean bl = wasRunning = this.burnTime > 0;
        if (this.burnTime > 0) {
            --this.burnTime;
        }
        if (this.burnTime <= 0 && !this.tank.isEmpty() && this.isLava(fluidInTank = this.tank.getPrimaryHandler().getFluid()) && fluidInTank.getAmount() >= 100) {
            this.tank.getPrimaryHandler().drain(100, IFluidHandler.FluidAction.EXECUTE);
            this.burnTime = 80;
        }
        boolean bl2 = isRunning = this.burnTime > 0;
        if (wasRunning != isRunning) {
            this.updateGeneratedRotation();
            needsUpdate = true;
        }
        this.transferFluid();
        if (needsUpdate) {
            this.sendData();
        }
    }

    protected void transferFluid() {
        if (this.tank.isEmpty()) {
            return;
        }
        FluidStack myFluid = this.tank.getPrimaryHandler().getFluid();
        int myAmount = myFluid.getAmount();
        if (myAmount <= 10) {
            return;
        }
        Direction facing = (Direction)this.getBlockState().getValue(LavaStrokeEngineBlock.HORIZONTAL_FACING);
        this.balanceWithNeighbor(facing, myFluid, myAmount);
        myFluid = this.tank.getPrimaryHandler().getFluid();
        if (!myFluid.isEmpty()) {
            this.balanceWithNeighbor(facing.getOpposite(), myFluid, myFluid.getAmount());
        }
    }

    private void balanceWithNeighbor(Direction side, FluidStack myFluid, int myAmount) {
        if (myAmount <= 0) {
            return;
        }
        BlockPos neighborPos = this.worldPosition.relative(side);
        IFluidHandler neighborHandler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, neighborPos, (Object)side.getOpposite());
        if (neighborHandler != null) {
            FluidStack neighborFluid = neighborHandler.getFluidInTank(0);
            int neighborAmount = neighborFluid.getAmount();
            int neighborCapacity = neighborHandler.getTankCapacity(0);
            if (!neighborFluid.isEmpty() && !neighborFluid.is(myFluid.getFluid())) {
                return;
            }
            if (myAmount > neighborAmount) {
                int diff = myAmount - neighborAmount;
                int amountToTransfer = Math.min(3000, diff / 2);
                if (amountToTransfer <= 0) {
                    return;
                }
                FluidStack toPush = myFluid.copy();
                toPush.setAmount(amountToTransfer);
                int filled = neighborHandler.fill(toPush, IFluidHandler.FluidAction.EXECUTE);
                if (filled > 0) {
                    this.tank.getPrimaryHandler().drain(filled, IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }
    }

    private boolean isLava(FluidStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return stack.is(FluidTags.LAVA);
    }

    public float getGeneratedSpeed() {
        return this.burnTime > 0 ? 64.0f : 0.0f;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        return added |= this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getFluidHandler());
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.burnTime = compound.getInt("BurnTime");
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putInt("BurnTime", this.burnTime);
    }

    private void spawnParticles() {
        if (this.level.random.nextInt(3) != 0) {
            return;
        }
        BlockState state = this.getBlockState();
        Direction facing = (Direction)state.getValue(LavaStrokeEngineBlock.HORIZONTAL_FACING);
        double y = -0.0625;
        Vec3[] points = new Vec3[]{new Vec3(0.0, y, 0.0625), new Vec3(0.9375, y, 0.0625), new Vec3(0.9375, y, 0.875), new Vec3(0.0, y, 0.875)};
        Vec3 center = VecHelper.getCenterOf((Vec3i)this.worldPosition);
        for (Vec3 p : points) {
            Vec3 centered = p.subtract(0.5, 0.0, 0.5);
            float angle = facing.toYRot();
            Vec3 rotated = VecHelper.rotate((Vec3)centered, (double)angle, (Direction.Axis)Direction.Axis.Y);
            Vec3 targetPos = center.add(rotated);
            double spreadX = (this.level.random.nextDouble() - 0.5) * 0.05;
            double spreadZ = (this.level.random.nextDouble() - 0.5) * 0.05;
            double velY = 0.08 + this.level.random.nextDouble() * 0.02;
            double velX = (this.level.random.nextDouble() - 0.5) * 0.01;
            double velZ = (this.level.random.nextDouble() - 0.5) * 0.01;
            if (this.level.random.nextInt(70) == 0) {
                this.level.addParticle((ParticleOptions)ParticleTypes.LAVA, targetPos.x + spreadX, targetPos.y - 0.3, targetPos.z + spreadZ, velX, velY * 0.5, velZ);
                continue;
            }
            this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, targetPos.x + spreadX, targetPos.y - 0.3, targetPos.z + spreadZ, velX, velY, velZ);
        }
    }
}

