/*
 * Decompiled with CFR 0.152.
 */
package euphy.upo.createnetherindustry.content.blocks;

import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import euphy.upo.createnetherindustry.content.blockentities.LavaStrokeEngineBlockEntity;
import euphy.upo.createnetherindustry.registry.CNIBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LavaStrokeEngineBlock
extends HorizontalKineticBlock
implements IBE<LavaStrokeEngineBlockEntity> {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final VoxelShape SHAPE_BOTTOM = Block.box((double)0.05, (double)0.0, (double)0.05, (double)15.95, (double)16.0, (double)15.95);
    public static final VoxelShape SHAPE_TOP = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0);

    public LavaStrokeEngineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HALF});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            return SHAPE_TOP;
        }
        return SHAPE_BOTTOM;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (pos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(pos.above()).canBeReplaced(context)) {
            return (BlockState)((BlockState)super.getStateForPlacement(context).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue(HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        level.setBlock(pos.above(), (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        if (direction.getAxis() == Direction.Axis.Y && half == DoubleBlockHalf.LOWER == (direction == Direction.UP)) {
            return neighborState.is((Block)this) && neighborState.getValue(HALF) != half ? state : Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos below;
        BlockState belowState;
        DoubleBlockHalf half;
        if (!level.isClientSide && player.isCreative() && (half = (DoubleBlockHalf)state.getValue(HALF)) == DoubleBlockHalf.UPPER && (belowState = level.getBlockState(below = pos.below())).is((Block)this) && belowState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            level.setBlock(below, Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent(player, 2001, below, Block.getId((BlockState)belowState));
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public Class<LavaStrokeEngineBlockEntity> getBlockEntityClass() {
        return LavaStrokeEngineBlockEntity.class;
    }

    public BlockEntityType<? extends LavaStrokeEngineBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CNIBlockEntities.LAVA_STROKE_ENGINE.get();
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            return CNIBlockEntities.LAVA_STROKE_ENGINE.create(pos, state);
        }
        return CNIBlockEntities.LAVA_STROKE_ENGINE_PROXY.create(pos, state);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue(HORIZONTAL_FACING)).getAxis();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return state.getValue(HALF) == DoubleBlockHalf.UPPER && face.getAxis() == ((Direction)state.getValue(HORIZONTAL_FACING)).getAxis();
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockPos above;
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER && level.getBlockState(above = pos.above()).is((Block)this)) {
            return super.useItemOn(stack, level.getBlockState(above), level, above, player, hand, hitResult);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public boolean skipRendering(BlockState state, BlockState neighbor, Direction side) {
        return false;
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }
}

