/*
 * Decompiled with CFR 0.152.
 */
package euphy.upo.createnetherindustry.content.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public class SoulStrippingBlock
extends Block {
    public SoulStrippingBlock(BlockBehaviour.Properties properties) {
        super(properties.randomTicks());
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return this.handleInteraction(level, pos, player, hand);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        ItemInteractionResult itemInteractionResult = this.handleInteraction(level, pos, player, player.getUsedItemHand());
        return itemInteractionResult.result();
    }

    private ItemInteractionResult handleInteraction(Level level, BlockPos pos, Player player, InteractionHand hand) {
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            boolean clearedEffect = false;
            ArrayList<Holder> effectsToRemove = new ArrayList<Holder>();
            for (MobEffectInstance effectInstance : serverPlayer.getActiveEffects()) {
                Holder effectHolder = effectInstance.getEffect();
                if (!effectHolder.isBound() || ((MobEffect)effectHolder.value()).getCategory() != MobEffectCategory.HARMFUL) continue;
                effectsToRemove.add(effectHolder);
                clearedEffect = true;
            }
            if (clearedEffect) {
                for (Holder effectHolderToRemove : effectsToRemove) {
                    serverPlayer.removeEffect(effectHolderToRemove);
                }
                level.playSound(null, pos, SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SOUL, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 10, 0.3, 0.3, 0.3, 0.05);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.add((Component)Component.literal((String)"\u00a77\u80fd\u591f\u5f15\u5bfc\u6c14\u6d41\u795b\u9664\u7075\u9b42\u675f\u7f1a\u3002\u00a7r"));
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.randomTick(state, level, pos, random);
        double attractionRadius = 16.0;
        AABB searchBox = new AABB(pos).inflate(attractionRadius);
        List nearbyMobs = level.getEntitiesOfClass(Mob.class, searchBox, mob -> !(!mob.getType().is(EntityTypeTags.UNDEAD) || !mob.isAlive() || mob.getTarget() != null && mob.getTarget().isAlive() && !(mob.distanceToSqr((Entity)mob.getTarget()) > attractionRadius * attractionRadius / 4.0) || mob.getNavigation().getTargetPos() != null && mob.getNavigation().getTargetPos().closerThan((Vec3i)pos, 2.0)));
        if (nearbyMobs.isEmpty()) {
            return;
        }
        for (Mob mob2 : nearbyMobs) {
            if (!mob2.getNavigation().isDone() && random.nextInt(3) != 0) continue;
            BlockPos targetPos = pos.above();
            BlockState targetBlockState = level.getBlockState(targetPos);
            if (targetBlockState.isPathfindable(PathComputationType.LAND)) {
                mob2.getNavigation().moveTo((double)targetPos.getX() + 0.5, (double)targetPos.getY(), (double)targetPos.getZ() + 0.5, 1.0);
                continue;
            }
            BlockState currentBlockState = level.getBlockState(pos);
            if (!currentBlockState.isPathfindable(PathComputationType.LAND)) continue;
            mob2.getNavigation().moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 1.0);
        }
    }
}

