/*
 * Decompiled with CFR 0.152.
 */
package euphy.upo.createnetherindustry.content.blocks.corp;

import euphy.upo.createnetherindustry.content.blocks.nylium_farmland.CrimsonNyliumFarmlandBlock;
import euphy.upo.createnetherindustry.registry.CNIBlocks;
import euphy.upo.createnetherindustry.registry.CNIItems;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlazeCropBlock
extends CropBlock {
    public static final int MAX_AGE = 4;
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)4);
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0)};

    public BlazeCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 4;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.getValue((Property)this.getAgeProperty())];
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)CNIItems.BLAZE_TWIG.get();
    }

    protected boolean mayPlaceOn(BlockState groundState, BlockGetter worldIn, BlockPos pos) {
        return groundState.is(CNIBlocks.CRIMSON_NYLIUM_FARMLAND);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        int currentAge = this.getAge(state);
        if (currentAge < this.getMaxAge()) {
            float growthChance = 0.05f;
            BlockState farmlandState = level.getBlockState(pos.below());
            if (farmlandState.hasProperty((Property)CrimsonNyliumFarmlandBlock.MOISTURE) && (Integer)farmlandState.getValue((Property)CrimsonNyliumFarmlandBlock.MOISTURE) == 7) {
                growthChance = 0.1f;
            }
            if (random.nextFloat() < growthChance) {
                level.setBlock(pos, this.getStateForAge(currentAge + 1), 2);
            }
        }
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int maxAge;
        int ageIncrease = ThreadLocalRandom.current().nextInt(10) < 3 ? 1 : 0;
        int newAge = this.getAge(state) + ageIncrease;
        if (newAge > (maxAge = this.getMaxAge())) {
            newAge = maxAge;
        }
        level.setBlock(pos, this.getStateForAge(newAge), 2);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        boolean isMature;
        int currentAge = (Integer)state.getValue((Property)AGE);
        boolean bl = isMature = currentAge == 4;
        if (isMature) {
            if (!level.isClientSide) {
                int amountToDrop = 1 + level.random.nextInt(3);
                ItemStack fruitStack = new ItemStack((ItemLike)CNIItems.BLAZE_FRUIT.get(), amountToDrop);
                BlazeCropBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)fruitStack);
                level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(3)), 2);
                level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }
}

