/*
 * Decompiled with CFR 0.152.
 */
package euphy.upo.createnetherindustry.content.blocks.corp;

import euphy.upo.createnetherindustry.content.blocks.nylium_farmland.CrimsonNyliumFarmlandBlock;
import euphy.upo.createnetherindustry.content.blocks.nylium_farmland.WarpedNyliumFarmlandBlock;
import euphy.upo.createnetherindustry.registry.CNITags;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GoldenCarrotCropBlock
extends CropBlock {
    public static final int MAX_AGE = 7;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_7;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public GoldenCarrotCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 7;
    }

    protected ItemLike getBaseSeedId() {
        return Items.GOLDEN_CARROT;
    }

    protected boolean mayPlaceOn(BlockState groundState, BlockGetter level, BlockPos pos) {
        return groundState.is(CNITags.NYLIUM_FARMLAND);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        int currentAge = this.getAge(state);
        if (currentAge < this.getMaxAge()) {
            float growthChance = 0.05f;
            BlockState farmlandState = level.getBlockState(pos.below());
            if (farmlandState.hasProperty((Property)WarpedNyliumFarmlandBlock.MOISTURE) && (Integer)farmlandState.getValue((Property)WarpedNyliumFarmlandBlock.MOISTURE) == 7) {
                growthChance = 0.1f;
            } else if (farmlandState.hasProperty((Property)CrimsonNyliumFarmlandBlock.MOISTURE) && (Integer)farmlandState.getValue((Property)CrimsonNyliumFarmlandBlock.MOISTURE) == 7) {
                growthChance = 0.1f;
            }
            if (random.nextFloat() < growthChance) {
                level.setBlock(pos, this.getStateForAge(currentAge + 1), 2);
            }
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.getValue((Property)this.getAgeProperty())];
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int maxAge;
        int ageIncrease = ThreadLocalRandom.current().nextInt(10) < 3 ? 1 : 0;
        int newAge = this.getAge(state) + ageIncrease;
        if (newAge > (maxAge = this.getMaxAge())) {
            newAge = maxAge;
        }
        level.setBlock(pos, this.getStateForAge(newAge), 2);
    }
}

