/*
 * Decompiled with CFR 0.152.
 */
package euphy.upo.createnetherindustry.content.blocks.nylium_farmland;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class CrimsonNyliumFarmlandBlock
extends FarmBlock {
    public static final IntegerProperty MOISTURE = BlockStateProperties.MOISTURE;
    public static final int MAX_MOISTURE = 7;

    public CrimsonNyliumFarmlandBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)MOISTURE, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{MOISTURE});
    }

    public static void turnToNetherrack(@Nullable Entity entity, BlockState state, Level level, BlockPos pos) {
        BlockState netherrackState = Blocks.NETHERRACK.defaultBlockState();
        level.setBlockAndUpdate(pos, CrimsonNyliumFarmlandBlock.pushEntitiesUp((BlockState)state, (BlockState)netherrackState, (LevelAccessor)level, (BlockPos)pos));
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)netherrackState));
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!level.isClientSide && entity.canTrample(state, pos, fallDistance)) {
            CrimsonNyliumFarmlandBlock.turnToNetherrack(entity, state, level, pos);
        }
        if (!level.isClientSide) {
            if (entity.canTrample(state, pos, fallDistance)) {
                CrimsonNyliumFarmlandBlock.turnToNetherrack(entity, state, level, pos);
            }
            entity.causeFallDamage(fallDistance, 1.0f, level.damageSources().fall());
        }
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            CrimsonNyliumFarmlandBlock.turnToNetherrack(null, state, (Level)level, pos);
            return;
        }
        int currentMoisture = (Integer)state.getValue((Property)MOISTURE);
        if (CrimsonNyliumFarmlandBlock.isNearLava((LevelReader)level, pos)) {
            if (currentMoisture < 7) {
                level.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
            }
        } else if (CrimsonNyliumFarmlandBlock.isNearWaterInsteadOfLava((LevelReader)level, pos)) {
            if (currentMoisture > 0) {
                level.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(currentMoisture - 1)), 2);
            } else if (!CrimsonNyliumFarmlandBlock.hasCrop((BlockGetter)level, pos)) {
                CrimsonNyliumFarmlandBlock.turnToNetherrack(null, state, (Level)level, pos);
            }
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            CrimsonNyliumFarmlandBlock.turnToNetherrack(null, state, (Level)level, pos);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockStateAbove = level.getBlockState(pos.above());
        return !blockStateAbove.isSolid() || blockStateAbove.getBlock() instanceof FenceGateBlock;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
    }

    private static boolean isNearLava(LevelReader levelReader, BlockPos pos) {
        for (BlockPos checkPos : BlockPos.betweenClosed((int)(pos.getX() - 4), (int)(pos.getY() - 1), (int)(pos.getZ() - 4), (int)(pos.getX() + 4), (int)pos.getY(), (int)(pos.getZ() + 4))) {
            FluidState fluidState = levelReader.getFluidState(checkPos);
            if (!fluidState.is((Fluid)Fluids.LAVA) && !fluidState.is((Fluid)Fluids.FLOWING_LAVA)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNearWaterInsteadOfLava(LevelReader levelReader, BlockPos pos) {
        for (BlockPos checkPos : BlockPos.betweenClosed((int)(pos.getX() - 4), (int)(pos.getY() - 1), (int)(pos.getZ() - 4), (int)(pos.getX() + 4), (int)pos.getY(), (int)(pos.getZ() + 4))) {
            FluidState fluidState = levelReader.getFluidState(checkPos);
            if (!fluidState.is((Fluid)Fluids.WATER) && !fluidState.is((Fluid)Fluids.FLOWING_WATER)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasCrop(BlockGetter level, BlockPos pos) {
        BlockState plant = level.getBlockState(pos.above());
        return !plant.isAir();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return !this.defaultBlockState().canSurvive((LevelReader)context.getLevel(), context.getClickedPos()) ? Blocks.NETHERRACK.defaultBlockState() : super.getStateForPlacement(context);
    }
}

